import cssifyObject from 'css-in-js-utils/lib/cssifyObject';

import minifyCSSString from './minifyCSSString';
import processStyleWithPlugins from './processStyleWithPlugins';

import { STATIC_TYPE } from './styleTypes';

export default function cssifyStaticStyle(staticStyle, renderer) {
  if (typeof staticStyle === 'string') {
    return minifyCSSString(staticStyle);
  }

  var processedStaticStyle = processStyleWithPlugins(renderer, staticStyle, STATIC_TYPE);
  return cssifyObject(processedStaticStyle);
}