'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.themeListener = exports.ThemeProvider = exports.withTheme = exports.channel = undefined;
exports.createTheming = createTheming;

var _createThemeProvider = require('./create-theme-provider');

var _createThemeProvider2 = _interopRequireDefault(_createThemeProvider);

var _createWithTheme = require('./create-with-theme');

var _createWithTheme2 = _interopRequireDefault(_createWithTheme);

var _createThemeListener = require('./create-theme-listener');

var _createThemeListener2 = _interopRequireDefault(_createThemeListener);

var _channel = require('./channel');

var _channel2 = _interopRequireDefault(_channel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var channel = exports.channel = _channel2.default;
var withTheme = exports.withTheme = (0, _createWithTheme2.default)();
var ThemeProvider = exports.ThemeProvider = (0, _createThemeProvider2.default)();
var themeListener = exports.themeListener = (0, _createThemeListener2.default)();
function createTheming() {
  var customChannel = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _channel2.default;

  return {
    channel: customChannel,
    withTheme: (0, _createWithTheme2.default)(customChannel),
    ThemeProvider: (0, _createThemeProvider2.default)(customChannel),
    themeListener: (0, _createThemeListener2.default)(customChannel)
  };
}

exports.default = {
  channel: _channel2.default,
  withTheme: withTheme,
  ThemeProvider: ThemeProvider,
  themeListener: themeListener,
  createTheming: createTheming
};