import React from 'react';
import { Link } from 'react-router-dom';
import Grid from '../Grid/Grid';
import Icon from '../Icon/Icon';
import './Footer.scss';

const { Col, Row } = Grid;
const year = new Date().getFullYear();

const Footer = () => (
  <div className="footer">
    <Grid valign="top">
      <Row>
        <Col xl={5} md={5}>
          <div className="footer__logo">
            <img src="/img/logo bw.png"></img>
          </div>
          <div className="footer__copy">
            <p>
            Copyright 2022. Todos os direitos reservados a Solucionática {' '}

            </p>
          </div>
        </Col>
        <Col className="footer__menus" xl={6} xlOffset={1} md={7}>
          <ul className="footer__menu">
            <li>
              <Link to="/terms-of-services">Termos e Condições</Link>
            </li>
            <li>
              <Link to="/privacy-policy">Política de Privacidade</Link>
            </li>
            <li>
              <Link to="/cookie-policy">Política de Cookies</Link>
            </li>
          </ul>
          <ul className="footer__menu">
            <li>
              <a
                href="https://www.linkedin.com/company/solucionati-ca/"
                target="_blank"
                rel="noopener noreferrer"
              >
                Linkedin
              </a>
            </li>
            <li>
              <a href="mailto:borafazer@solucionati.ca">Email</a>
            </li>
            <li>
              <a
                href="https://www.instagram.com/solucionati.ca/"
                target="_blank"
                rel="noopener noreferrer"
              >
                Instagram
              </a>
            </li>
          </ul>
        </Col>
      </Row>
    </Grid>
  </div>
);

export default Footer;
