import { __extends as t, __awaiter as e, __generator as n, __spreadArrays as r } from "tslib";

import i from "@firebase/app";

import { Logger as o, LogLevel as s } from "@firebase/logger";

import { getUA as u, isMobileCordova as a, isReactNative as c, isElectron as h, isIE as f, isUWP as l, isBrowserExtension as p } from "@firebase/util";

import { XhrIo as d, EventType as y, ErrorCode as v, createWebChannelTransport as m, WebChannel as g } from "@firebase/webchannel-wrapper";

import { Component as w } from "@firebase/component";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var b = new o("@firebase/firestore");

// Helper methods are needed because variables can't be exported as read/write
function I() {
    return b.logLevel;
}

function E(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    if (b.logLevel <= s.DEBUG) {
        var i = e.map(N);
        b.debug.apply(b, r([ "Firestore (7.17.1): " + t ], i));
    }
}

function T(t) {
    for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
    if (b.logLevel <= s.ERROR) {
        var i = e.map(N);
        b.error.apply(b, r([ "Firestore (7.17.1): " + t ], i));
    }
}

/**
 * Converts an additional log parameter to a string representation.
 */ function N(t) {
    if ("string" == typeof t) return t;
    try {
        return e = t, JSON.stringify(e);
    } catch (e) {
        // Converting to JSON failed, just log the object directly
        return t;
    }
    /**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** Formats an object as a JSON string, suitable for logging. */    var e;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Unconditionally fails, throwing an Error with the given message.
 * Messages are stripped in production builds.
 *
 * Returns `never` and can be used in expressions:
 * @example
 * let futureVar = fail('not implemented yet');
 */ function A(t) {
    void 0 === t && (t = "Unexpected state");
    // Log the failure in addition to throw an exception, just in case the
    // exception is swallowed.
        var e = "FIRESTORE (7.17.1) INTERNAL ASSERTION FAILED: " + t;
    // NOTE: We don't use FirestoreError here because these are internal failures
    // that cannot be handled by the user. (Also it would create a circular
    // dependency between the error and assert modules which doesn't work.)
        throw T(e), new Error(e)
    /**
 * Fails if the given assertion condition is false, throwing an Error with the
 * given message if it did.
 *
 * Messages are stripped in production builds.
 */;
}

function _(t, e) {
    t || A();
}

/**
 * Casts `obj` to `T`. In non-production builds, verifies that `obj` is an
 * instance of `T` before casting.
 */ function D(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Generates `nBytes` of random bytes.
 *
 * If `nBytes < 0` , an error will be thrown.
 */ function S(t) {
    // Polyfills for IE and WebWorker by using `self` and `msCrypto` when `crypto` is not available.
    var e = 
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    "undefined" != typeof self && (self.crypto || self.msCrypto), n = new Uint8Array(t);
    if (e) e.getRandomValues(n); else 
    // Falls back to Math.random
    for (var r = 0; r < t; r++) n[r] = Math.floor(256 * Math.random());
    return n;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var x = /** @class */ function() {
    function t() {}
    return t.t = function() {
        for (
        // Alphanumeric characters
        var t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789", e = Math.floor(256 / t.length) * t.length, n = ""
        // The largest byte value that is a multiple of `char.length`.
        ; n.length < 20; ) for (var r = S(40), i = 0; i < r.length; ++i) 
        // Only accept values that are [0, maxMultiple), this ensures they can
        // be evenly mapped to indices of `chars` via a modulo operation.
        n.length < 20 && r[i] < e && (n += t.charAt(r[i] % t.length));
        return n;
    }, t;
}();

function k(t, e) {
    return t < e ? -1 : t > e ? 1 : 0;
}

/** Helper to compare arrays using isEqual(). */ function P(t, e, n) {
    return t.length === e.length && t.every((function(t, r) {
        return n(t, e[r]);
    }));
}

/**
 * Returns the immediate lexicographically-following string. This is useful to
 * construct an inclusive range for indexeddb iterators.
 */ function L(t) {
    // Return the input string, with an additional NUL byte appended.
    return t + "\0";
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var O = 
/**
     * Constructs a DatabaseInfo using the provided host, databaseId and
     * persistenceKey.
     *
     * @param databaseId The database to use.
     * @param persistenceKey A unique identifier for this Firestore's local
     * storage (used in conjunction with the databaseId).
     * @param host The Firestore backend host to connect to.
     * @param ssl Whether to use SSL when connecting.
     * @param forceLongPolling Whether to use the forceLongPolling option
     * when using WebChannel as the network transport.
     */
function(t, e, n, r, i) {
    this.s = t, this.persistenceKey = e, this.host = n, this.ssl = r, this.forceLongPolling = i;
}, R = /** @class */ function() {
    function t(t, e) {
        this.projectId = t, this.database = e || "(default)";
    }
    return Object.defineProperty(t.prototype, "i", {
        get: function() {
            return "(default)" === this.database;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return e instanceof t && e.projectId === this.projectId && e.database === this.database;
    }, t.prototype.o = function(t) {
        return k(this.projectId, t.projectId) || k(this.database, t.database);
    }, t;
}();

/** The default database name for a project. */
/** Represents the database ID a Firestore client is associated with. */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function V(t) {
    var e = 0;
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e++;
    return e;
}

function U(t, e) {
    for (var n in t) Object.prototype.hasOwnProperty.call(t, n) && e(n, t[n]);
}

function C(t) {
    for (var e in t) if (Object.prototype.hasOwnProperty.call(t, e)) return !1;
    return !0;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A map implementation that uses objects as keys. Objects must have an
 * associated equals function and must be immutable. Entries in the map are
 * stored together with the key being produced from the mapKeyFn. This map
 * automatically handles collisions of keys.
 */ var M = /** @class */ function() {
    function t(t, e) {
        this.h = t, this.u = e, 
        /**
             * The inner map for a key -> value pair. Due to the possibility of
             * collisions we keep a list of entries that we do a linear search through
             * to find an actual match. Note that collisions should be rare, so we still
             * expect near constant time lookups in practice.
             */
        this.l = {}
        /** Get a value for this key, or undefined if it does not exist. */;
    }
    return t.prototype.get = function(t) {
        var e = this.h(t), n = this.l[e];
        if (void 0 !== n) for (var r = 0, i = n; r < i.length; r++) {
            var o = i[r], s = o[0], u = o[1];
            if (this.u(s, t)) return u;
        }
    }, t.prototype.has = function(t) {
        return void 0 !== this.get(t);
    }, 
    /** Put this key and value in the map. */ t.prototype.set = function(t, e) {
        var n = this.h(t), r = this.l[n];
        if (void 0 !== r) {
            for (var i = 0; i < r.length; i++) if (this.u(r[i][0], t)) return void (r[i] = [ t, e ]);
            r.push([ t, e ]);
        } else this.l[n] = [ [ t, e ] ];
    }, 
    /**
     * Remove this key from the map. Returns a boolean if anything was deleted.
     */
    t.prototype.delete = function(t) {
        var e = this.h(t), n = this.l[e];
        if (void 0 === n) return !1;
        for (var r = 0; r < n.length; r++) if (this.u(n[r][0], t)) return 1 === n.length ? delete this.l[e] : n.splice(r, 1), 
        !0;
        return !1;
    }, t.prototype.forEach = function(t) {
        U(this.l, (function(e, n) {
            for (var r = 0, i = n; r < i.length; r++) {
                var o = i[r], s = o[0], u = o[1];
                t(s, u);
            }
        }));
    }, t.prototype._ = function() {
        return C(this.l);
    }, t;
}(), q = {
    // Causes are copied from:
    // https://github.com/grpc/grpc/blob/bceec94ea4fc5f0085d81235d8e1c06798dc341a/include/grpc%2B%2B/impl/codegen/status_code_enum.h
    /** Not an error; returned on success. */
    OK: "ok",
    /** The operation was cancelled (typically by the caller). */
    CANCELLED: "cancelled",
    /** Unknown error or an error from a different error domain. */
    UNKNOWN: "unknown",
    /**
     * Client specified an invalid argument. Note that this differs from
     * FAILED_PRECONDITION. INVALID_ARGUMENT indicates arguments that are
     * problematic regardless of the state of the system (e.g., a malformed file
     * name).
     */
    INVALID_ARGUMENT: "invalid-argument",
    /**
     * Deadline expired before operation could complete. For operations that
     * change the state of the system, this error may be returned even if the
     * operation has completed successfully. For example, a successful response
     * from a server could have been delayed long enough for the deadline to
     * expire.
     */
    DEADLINE_EXCEEDED: "deadline-exceeded",
    /** Some requested entity (e.g., file or directory) was not found. */
    NOT_FOUND: "not-found",
    /**
     * Some entity that we attempted to create (e.g., file or directory) already
     * exists.
     */
    ALREADY_EXISTS: "already-exists",
    /**
     * The caller does not have permission to execute the specified operation.
     * PERMISSION_DENIED must not be used for rejections caused by exhausting
     * some resource (use RESOURCE_EXHAUSTED instead for those errors).
     * PERMISSION_DENIED must not be used if the caller can not be identified
     * (use UNAUTHENTICATED instead for those errors).
     */
    PERMISSION_DENIED: "permission-denied",
    /**
     * The request does not have valid authentication credentials for the
     * operation.
     */
    UNAUTHENTICATED: "unauthenticated",
    /**
     * Some resource has been exhausted, perhaps a per-user quota, or perhaps the
     * entire file system is out of space.
     */
    RESOURCE_EXHAUSTED: "resource-exhausted",
    /**
     * Operation was rejected because the system is not in a state required for
     * the operation's execution. For example, directory to be deleted may be
     * non-empty, an rmdir operation is applied to a non-directory, etc.
     *
     * A litmus test that may help a service implementor in deciding
     * between FAILED_PRECONDITION, ABORTED, and UNAVAILABLE:
     *  (a) Use UNAVAILABLE if the client can retry just the failing call.
     *  (b) Use ABORTED if the client should retry at a higher-level
     *      (e.g., restarting a read-modify-write sequence).
     *  (c) Use FAILED_PRECONDITION if the client should not retry until
     *      the system state has been explicitly fixed. E.g., if an "rmdir"
     *      fails because the directory is non-empty, FAILED_PRECONDITION
     *      should be returned since the client should not retry unless
     *      they have first fixed up the directory by deleting files from it.
     *  (d) Use FAILED_PRECONDITION if the client performs conditional
     *      REST Get/Update/Delete on a resource and the resource on the
     *      server does not match the condition. E.g., conflicting
     *      read-modify-write on the same resource.
     */
    FAILED_PRECONDITION: "failed-precondition",
    /**
     * The operation was aborted, typically due to a concurrency issue like
     * sequencer check failures, transaction aborts, etc.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    ABORTED: "aborted",
    /**
     * Operation was attempted past the valid range. E.g., seeking or reading
     * past end of file.
     *
     * Unlike INVALID_ARGUMENT, this error indicates a problem that may be fixed
     * if the system state changes. For example, a 32-bit file system will
     * generate INVALID_ARGUMENT if asked to read at an offset that is not in the
     * range [0,2^32-1], but it will generate OUT_OF_RANGE if asked to read from
     * an offset past the current file size.
     *
     * There is a fair bit of overlap between FAILED_PRECONDITION and
     * OUT_OF_RANGE. We recommend using OUT_OF_RANGE (the more specific error)
     * when it applies so that callers who are iterating through a space can
     * easily look for an OUT_OF_RANGE error to detect when they are done.
     */
    OUT_OF_RANGE: "out-of-range",
    /** Operation is not implemented or not supported/enabled in this service. */
    UNIMPLEMENTED: "unimplemented",
    /**
     * Internal errors. Means some invariants expected by underlying System has
     * been broken. If you see one of these errors, Something is very broken.
     */
    INTERNAL: "internal",
    /**
     * The service is currently unavailable. This is a most likely a transient
     * condition and may be corrected by retrying with a backoff.
     *
     * See litmus test above for deciding between FAILED_PRECONDITION, ABORTED,
     * and UNAVAILABLE.
     */
    UNAVAILABLE: "unavailable",
    /** Unrecoverable data loss or corruption. */
    DATA_LOSS: "data-loss"
}, F = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, n) || this).code = t, r.message = n, r.name = "FirebaseError", 
        // HACK: We write a toString property directly because Error is not a real
        // class and so inheritance does not work correctly. We could alternatively
        // do the same "back-door inheritance" trick that FirebaseError does.
        r.toString = function() {
            return r.name + ": [code=" + r.code + "]: " + r.message;
        }, r;
    }
    return t(n, e), n;
}(Error), j = /** @class */ function() {
    function t(t, e) {
        if (this.seconds = t, this.nanoseconds = e, e < 0) throw new F(q.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (e >= 1e9) throw new F(q.INVALID_ARGUMENT, "Timestamp nanoseconds out of range: " + e);
        if (t < -62135596800) throw new F(q.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
        // This will break in the year 10,000.
                if (t >= 253402300800) throw new F(q.INVALID_ARGUMENT, "Timestamp seconds out of range: " + t);
    }
    return t.now = function() {
        return t.fromMillis(Date.now());
    }, t.fromDate = function(e) {
        return t.fromMillis(e.getTime());
    }, t.fromMillis = function(e) {
        var n = Math.floor(e / 1e3);
        return new t(n, 1e6 * (e - 1e3 * n));
    }, t.prototype.toDate = function() {
        return new Date(this.toMillis());
    }, t.prototype.toMillis = function() {
        return 1e3 * this.seconds + this.nanoseconds / 1e6;
    }, t.prototype.T = function(t) {
        return this.seconds === t.seconds ? k(this.nanoseconds, t.nanoseconds) : k(this.seconds, t.seconds);
    }, t.prototype.isEqual = function(t) {
        return t.seconds === this.seconds && t.nanoseconds === this.nanoseconds;
    }, t.prototype.toString = function() {
        return "Timestamp(seconds=" + this.seconds + ", nanoseconds=" + this.nanoseconds + ")";
    }, t.prototype.valueOf = function() {
        // This method returns a string of the form <seconds>.<nanoseconds> where <seconds> is
        // translated to have a non-negative value and both <seconds> and <nanoseconds> are left-padded
        // with zeroes to be a consistent length. Strings with this format then have a lexiographical
        // ordering that matches the expected ordering. The <seconds> translation is done to avoid
        // having a leading negative sign (i.e. a leading '-' character) in its string representation,
        // which would affect its lexiographical ordering.
        var t = this.seconds - -62135596800;
        // Note: Up to 12 decimal digits are required to represent all valid 'seconds' values.
                return String(t).padStart(12, "0") + "." + String(this.nanoseconds).padStart(9, "0");
    }, t;
}(), G = /** @class */ function() {
    function t(t) {
        this.timestamp = t;
    }
    return t.I = function(e) {
        return new t(e);
    }, t.min = function() {
        return new t(new j(0, 0));
    }, t.prototype.o = function(t) {
        return this.timestamp.T(t.timestamp);
    }, t.prototype.isEqual = function(t) {
        return this.timestamp.isEqual(t.timestamp);
    }, 
    /** Returns a number representation of the version for use in spec tests. */ t.prototype.m = function() {
        // Convert to microseconds.
        return 1e6 * this.timestamp.seconds + this.timestamp.nanoseconds / 1e3;
    }, t.prototype.toString = function() {
        return "SnapshotVersion(" + this.timestamp.toString() + ")";
    }, t.prototype.A = function() {
        return this.timestamp;
    }, t;
}(), B = /** @class */ function() {
    function t(t, e, n) {
        void 0 === e ? e = 0 : e > t.length && A(), void 0 === n ? n = t.length - e : n > t.length - e && A(), 
        this.segments = t, this.offset = e, this.R = n;
    }
    return Object.defineProperty(t.prototype, "length", {
        get: function() {
            return this.R;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        return 0 === t.P(this, e);
    }, t.prototype.child = function(e) {
        var n = this.segments.slice(this.offset, this.limit());
        return e instanceof t ? e.forEach((function(t) {
            n.push(t);
        })) : n.push(e), this.g(n);
    }, 
    /** The index of one past the last segment of the path. */ t.prototype.limit = function() {
        return this.offset + this.length;
    }, t.prototype.V = function(t) {
        return t = void 0 === t ? 1 : t, this.g(this.segments, this.offset + t, this.length - t);
    }, t.prototype.p = function() {
        return this.g(this.segments, this.offset, this.length - 1);
    }, t.prototype.v = function() {
        return this.segments[this.offset];
    }, t.prototype.S = function() {
        return this.get(this.length - 1);
    }, t.prototype.get = function(t) {
        return this.segments[this.offset + t];
    }, t.prototype._ = function() {
        return 0 === this.length;
    }, t.prototype.D = function(t) {
        if (t.length < this.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.C = function(t) {
        if (this.length + 1 !== t.length) return !1;
        for (var e = 0; e < this.length; e++) if (this.get(e) !== t.get(e)) return !1;
        return !0;
    }, t.prototype.forEach = function(t) {
        for (var e = this.offset, n = this.limit(); e < n; e++) t(this.segments[e]);
    }, t.prototype.F = function() {
        return this.segments.slice(this.offset, this.limit());
    }, t.P = function(t, e) {
        for (var n = Math.min(t.length, e.length), r = 0; r < n; r++) {
            var i = t.get(r), o = e.get(r);
            if (i < o) return -1;
            if (i > o) return 1;
        }
        return t.length < e.length ? -1 : t.length > e.length ? 1 : 0;
    }, t;
}(), z = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.g = function(t, e, r) {
        return new n(t, e, r);
    }, n.prototype.$ = function() {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        return this.F().join("/");
    }, n.prototype.toString = function() {
        return this.$();
    }, 
    /**
     * Creates a resource path from the given slash-delimited string.
     */
    n.N = function(t) {
        // NOTE: The client is ignorant of any path segments containing escape
        // sequences (e.g. __id123__) and just passes them through raw (they exist
        // for legacy reasons and should not be used frequently).
        if (t.indexOf("//") >= 0) throw new F(q.INVALID_ARGUMENT, "Invalid path (" + t + "). Paths must not contain // in them.");
        // We may still have an empty segment at the beginning or end if they had a
        // leading or trailing slash (which we allow).
                return new n(t.split("/").filter((function(t) {
            return t.length > 0;
        })));
    }, n.k = function() {
        return new n([]);
    }, n;
}(B), W = /^[_a-zA-Z][_a-zA-Z0-9]*$/, K = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.g = function(t, e, r) {
        return new n(t, e, r);
    }, 
    /**
     * Returns true if the string could be used as a segment in a field path
     * without escaping.
     */
    n.M = function(t) {
        return W.test(t);
    }, n.prototype.$ = function() {
        return this.F().map((function(t) {
            return t = t.replace("\\", "\\\\").replace("`", "\\`"), n.M(t) || (t = "`" + t + "`"), 
            t;
        })).join(".");
    }, n.prototype.toString = function() {
        return this.$();
    }, 
    /**
     * Returns true if this field references the key of a document.
     */
    n.prototype.O = function() {
        return 1 === this.length && "__name__" === this.get(0);
    }, 
    /**
     * The field designating the key of a document.
     */
    n.L = function() {
        return new n([ "__name__" ]);
    }, 
    /**
     * Parses a field string from the given server-formatted string.
     *
     * - Splitting the empty string is not allowed (for now at least).
     * - Empty segments within the string (e.g. if there are two consecutive
     *   separators) are not allowed.
     *
     * TODO(b/37244157): we should make this more strict. Right now, it allows
     * non-identifier path components, even if they aren't escaped.
     */
    n.q = function(t) {
        for (var e = [], r = "", i = 0, o = function() {
            if (0 === r.length) throw new F(q.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            e.push(r), r = "";
        }, s = !1; i < t.length; ) {
            var u = t[i];
            if ("\\" === u) {
                if (i + 1 === t.length) throw new F(q.INVALID_ARGUMENT, "Path has trailing escape character: " + t);
                var a = t[i + 1];
                if ("\\" !== a && "." !== a && "`" !== a) throw new F(q.INVALID_ARGUMENT, "Path has invalid escape sequence: " + t);
                r += a, i += 2;
            } else "`" === u ? (s = !s, i++) : "." !== u || s ? (r += u, i++) : (o(), i++);
        }
        if (o(), s) throw new F(q.INVALID_ARGUMENT, "Unterminated ` in path: " + t);
        return new n(e);
    }, n.k = function() {
        return new n([]);
    }, n;
}(B), Q = /** @class */ function() {
    function t(t) {
        this.path = t;
    }
    return t.B = function(e) {
        return new t(z.N(e).V(5));
    }, 
    /** Returns true if the document is in the specified collectionId. */ t.prototype.U = function(t) {
        return this.path.length >= 2 && this.path.get(this.path.length - 2) === t;
    }, t.prototype.isEqual = function(t) {
        return null !== t && 0 === z.P(this.path, t.path);
    }, t.prototype.toString = function() {
        return this.path.toString();
    }, t.P = function(t, e) {
        return z.P(t.path, e.path);
    }, t.W = function(t) {
        return t.length % 2 == 0;
    }, 
    /**
     * Creates and returns a new document key with the given segments.
     *
     * @param segments The segments of the path to the document
     * @return A new instance of DocumentKey
     */
    t.j = function(e) {
        return new t(new z(e.slice()));
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns whether a variable is either undefined or null.
 */
function $(t) {
    return null == t;
}

/** Returns whether the value represents -0. */ function H(t) {
    // Detect if the value is -0.0. Based on polyfill from
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is
    return -0 === t && 1 / t == -1 / 0;
}

/**
 * Returns whether a value is an integer and in the safe integer range
 * @param value The value to test for being an integer and in the safe range
 */ function X(t) {
    return "number" == typeof t && Number.isInteger(t) && !H(t) && t <= Number.MAX_SAFE_INTEGER && t >= Number.MIN_SAFE_INTEGER;
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Visible for testing
var Y = function(t, e, n, r, i, o, s) {
    void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    this.path = t, this.collectionGroup = e, this.orderBy = n, this.filters = r, this.limit = i, 
    this.startAt = o, this.endAt = s, this.K = null;
};

/**
 * Initializes a Target with a path and optional additional query constraints.
 * Path must currently be empty if this is a collection group query.
 *
 * NOTE: you should always construct `Target` from `Query.toTarget` instead of
 * using this factory method, because `Query` provides an implicit `orderBy`
 * property.
 */ function Z(t, e, n, r, i, o, s) {
    return void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
    void 0 === i && (i = null), void 0 === o && (o = null), void 0 === s && (s = null), 
    new Y(t, e, n, r, i, o, s);
}

function J(t) {
    var e = D(t);
    if (null === e.K) {
        var n = e.path.$();
        null !== e.collectionGroup && (n += "|cg:" + e.collectionGroup), n += "|f:", n += e.filters.map((function(t) {
            return function(t) {
                // TODO(b/29183165): Technically, this won't be unique if two values have
                // the same description, such as the int 3 and the string "3". So we should
                // add the types in here somehow, too.
                return t.field.$() + t.op.toString() + zt(t.value);
            }(t);
        })).join(","), n += "|ob:", n += e.orderBy.map((function(t) {
            return (e = t).field.$() + e.dir;
            var e;
        })).join(","), $(e.limit) || (n += "|l:", n += e.limit), e.startAt && (n += "|lb:", 
        n += Mn(e.startAt)), e.endAt && (n += "|ub:", n += Mn(e.endAt)), e.K = n;
    }
    return e.K;
}

function tt(t, e) {
    if (t.limit !== e.limit) return !1;
    if (t.orderBy.length !== e.orderBy.length) return !1;
    for (var n = 0; n < t.orderBy.length; n++) if (!Bn(t.orderBy[n], e.orderBy[n])) return !1;
    if (t.filters.length !== e.filters.length) return !1;
    for (var r = 0; r < t.filters.length; r++) if (i = t.filters[r], o = e.filters[r], 
    !(i instanceof Pn && o instanceof Pn && i.op === o.op && i.field.isEqual(o.field) && Ft(i.value, o.value))) return !1;
    var i, o;
    return t.collectionGroup === e.collectionGroup && !!t.path.isEqual(e.path) && !!Fn(t.startAt, e.startAt) && Fn(t.endAt, e.endAt);
}

function et(t) {
    return Q.W(t.path) && null === t.collectionGroup && 0 === t.filters.length;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Converts a Base64 encoded string to a binary string. */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Immutable class that represents a "proto" byte string.
 *
 * Proto byte strings can either be Base64-encoded strings or Uint8Arrays when
 * sent on the wire. This class abstracts away this differentiation by holding
 * the proto byte string in a common class that must be converted into a string
 * before being sent as a proto.
 */ var nt = /** @class */ function() {
    function t(t) {
        this.G = t;
    }
    return t.fromBase64String = function(e) {
        return new t(atob(e));
    }, t.fromUint8Array = function(e) {
        return new t(
        /**
 * Helper function to convert an Uint8array to a binary string.
 */
        function(t) {
            for (var e = "", n = 0; n < t.length; ++n) e += String.fromCharCode(t[n]);
            return e;
        }(e));
    }, t.prototype.toBase64 = function() {
        return t = this.G, btoa(t);
        /** Converts a binary string to a Base64 encoded string. */        var t;
        /** True if and only if the Base64 conversion functions are available. */    }, 
    t.prototype.toUint8Array = function() {
        return function(t) {
            for (var e = new Uint8Array(t.length), n = 0; n < t.length; n++) e[n] = t.charCodeAt(n);
            return e;
        }(this.G);
    }, t.prototype.H = function() {
        return 2 * this.G.length;
    }, t.prototype.o = function(t) {
        return k(this.G, t.G);
    }, t.prototype.isEqual = function(t) {
        return this.G === t.G;
    }, t;
}();

nt.Y = new nt("");

var rt, it, ot = /** @class */ function() {
    function t(
    /** The target being listened to. */
    t, 
    /**
     * The target ID to which the target corresponds; Assigned by the
     * LocalStore for user listens and by the SyncEngine for limbo watches.
     */
    e, 
    /** The purpose of the target. */
    n, 
    /**
     * The sequence number of the last transaction during which this target data
     * was modified.
     */
    r, 
    /** The latest snapshot version seen for this target. */
    i
    /**
     * The maximum snapshot version at which the associated view
     * contained no limbo documents.
     */ , o
    /**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */ , s) {
        void 0 === i && (i = G.min()), void 0 === o && (o = G.min()), void 0 === s && (s = nt.Y), 
        this.target = t, this.targetId = e, this.J = n, this.sequenceNumber = r, this.X = i, 
        this.lastLimboFreeSnapshotVersion = o, this.resumeToken = s;
    }
    /** Creates a new target data instance with an updated sequence number. */    return t.prototype.Z = function(e) {
        return new t(this.target, this.targetId, this.J, e, this.X, this.lastLimboFreeSnapshotVersion, this.resumeToken);
    }, 
    /**
     * Creates a new target data instance with an updated resume token and
     * snapshot version.
     */
    t.prototype.tt = function(e, n) {
        return new t(this.target, this.targetId, this.J, this.sequenceNumber, n, this.lastLimboFreeSnapshotVersion, e);
    }, 
    /**
     * Creates a new target data instance with an updated last limbo free
     * snapshot version number.
     */
    t.prototype.et = function(e) {
        return new t(this.target, this.targetId, this.J, this.sequenceNumber, this.X, e, this.resumeToken);
    }, t;
}(), st = 
// TODO(b/33078163): just use simplest form of existence filter for now
function(t) {
    this.count = t;
};

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Determines whether an error code represents a permanent error when received
 * in response to a non-write operation.
 *
 * See isPermanentWriteError for classifying write errors.
 */
function ut(t) {
    switch (t) {
      case q.OK:
        return A();

      case q.CANCELLED:
      case q.UNKNOWN:
      case q.DEADLINE_EXCEEDED:
      case q.RESOURCE_EXHAUSTED:
      case q.INTERNAL:
      case q.UNAVAILABLE:
 // Unauthenticated means something went wrong with our token and we need
        // to retry with new credentials which will happen automatically.
              case q.UNAUTHENTICATED:
        return !1;

      case q.INVALID_ARGUMENT:
      case q.NOT_FOUND:
      case q.ALREADY_EXISTS:
      case q.PERMISSION_DENIED:
      case q.FAILED_PRECONDITION:
 // Aborted might be retried in some scenarios, but that is dependant on
        // the context and should handled individually by the calling code.
        // See https://cloud.google.com/apis/design/errors.
              case q.ABORTED:
      case q.OUT_OF_RANGE:
      case q.UNIMPLEMENTED:
      case q.DATA_LOSS:
        return !0;

      default:
        return A();
    }
}

/**
 * Determines whether an error code represents a permanent error when received
 * in response to a write operation.
 *
 * Write operations must be handled specially because as of b/119437764, ABORTED
 * errors on the write stream should be retried too (even though ABORTED errors
 * are not generally retryable).
 *
 * Note that during the initial handshake on the write stream an ABORTED error
 * signals that we should discard our stream token (i.e. it is permanent). This
 * means a handshake error should be classified with isPermanentError, above.
 */
/**
 * Maps an error Code from GRPC status code number, like 0, 1, or 14. These
 * are not the same as HTTP status codes.
 *
 * @returns The Code equivalent to the given GRPC status code. Fails if there
 *     is no match.
 */ function at(t) {
    if (void 0 === t) 
    // This shouldn't normally happen, but in certain error cases (like trying
    // to send invalid proto messages) we may get an error with no GRPC code.
    return T("GRPC error has no .code"), q.UNKNOWN;
    switch (t) {
      case rt.OK:
        return q.OK;

      case rt.CANCELLED:
        return q.CANCELLED;

      case rt.UNKNOWN:
        return q.UNKNOWN;

      case rt.DEADLINE_EXCEEDED:
        return q.DEADLINE_EXCEEDED;

      case rt.RESOURCE_EXHAUSTED:
        return q.RESOURCE_EXHAUSTED;

      case rt.INTERNAL:
        return q.INTERNAL;

      case rt.UNAVAILABLE:
        return q.UNAVAILABLE;

      case rt.UNAUTHENTICATED:
        return q.UNAUTHENTICATED;

      case rt.INVALID_ARGUMENT:
        return q.INVALID_ARGUMENT;

      case rt.NOT_FOUND:
        return q.NOT_FOUND;

      case rt.ALREADY_EXISTS:
        return q.ALREADY_EXISTS;

      case rt.PERMISSION_DENIED:
        return q.PERMISSION_DENIED;

      case rt.FAILED_PRECONDITION:
        return q.FAILED_PRECONDITION;

      case rt.ABORTED:
        return q.ABORTED;

      case rt.OUT_OF_RANGE:
        return q.OUT_OF_RANGE;

      case rt.UNIMPLEMENTED:
        return q.UNIMPLEMENTED;

      case rt.DATA_LOSS:
        return q.DATA_LOSS;

      default:
        return A();
    }
}

/**
 * Converts an HTTP response's error status to the equivalent error code.
 *
 * @param status An HTTP error response status ("FAILED_PRECONDITION",
 * "UNKNOWN", etc.)
 * @returns The equivalent Code. Non-matching responses are mapped to
 *     Code.UNKNOWN.
 */ (it = rt || (rt = {}))[it.OK = 0] = "OK", it[it.CANCELLED = 1] = "CANCELLED", 
it[it.UNKNOWN = 2] = "UNKNOWN", it[it.INVALID_ARGUMENT = 3] = "INVALID_ARGUMENT", 
it[it.DEADLINE_EXCEEDED = 4] = "DEADLINE_EXCEEDED", it[it.NOT_FOUND = 5] = "NOT_FOUND", 
it[it.ALREADY_EXISTS = 6] = "ALREADY_EXISTS", it[it.PERMISSION_DENIED = 7] = "PERMISSION_DENIED", 
it[it.UNAUTHENTICATED = 16] = "UNAUTHENTICATED", it[it.RESOURCE_EXHAUSTED = 8] = "RESOURCE_EXHAUSTED", 
it[it.FAILED_PRECONDITION = 9] = "FAILED_PRECONDITION", it[it.ABORTED = 10] = "ABORTED", 
it[it.OUT_OF_RANGE = 11] = "OUT_OF_RANGE", it[it.UNIMPLEMENTED = 12] = "UNIMPLEMENTED", 
it[it.INTERNAL = 13] = "INTERNAL", it[it.UNAVAILABLE = 14] = "UNAVAILABLE", it[it.DATA_LOSS = 15] = "DATA_LOSS";

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// An immutable sorted map implementation, based on a Left-leaning Red-Black
// tree.
var ct = /** @class */ function() {
    function t(t, e) {
        this.P = t, this.root = e || ft.EMPTY;
    }
    // Returns a copy of the map, with the specified key/value added or replaced.
        return t.prototype.nt = function(e, n) {
        return new t(this.P, this.root.nt(e, n, this.P).copy(null, null, ft.st, null, null));
    }, 
    // Returns a copy of the map, with the specified key removed.
    t.prototype.remove = function(e) {
        return new t(this.P, this.root.remove(e, this.P).copy(null, null, ft.st, null, null));
    }, 
    // Returns the value of the node with the given key, or null.
    t.prototype.get = function(t) {
        for (var e = this.root; !e._(); ) {
            var n = this.P(t, e.key);
            if (0 === n) return e.value;
            n < 0 ? e = e.left : n > 0 && (e = e.right);
        }
        return null;
    }, 
    // Returns the index of the element in this sorted map, or -1 if it doesn't
    // exist.
    t.prototype.indexOf = function(t) {
        for (
        // Number of nodes that were pruned when descending right
        var e = 0, n = this.root; !n._(); ) {
            var r = this.P(t, n.key);
            if (0 === r) return e + n.left.size;
            r < 0 ? n = n.left : (
            // Count all nodes left of the node plus the node itself
            e += n.left.size + 1, n = n.right);
        }
        // Node not found
                return -1;
    }, t.prototype._ = function() {
        return this.root._();
    }, Object.defineProperty(t.prototype, "size", {
        // Returns the total number of nodes in the map.
        get: function() {
            return this.root.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns the minimum key in the map.
    t.prototype.it = function() {
        return this.root.it();
    }, 
    // Returns the maximum key in the map.
    t.prototype.rt = function() {
        return this.root.rt();
    }, 
    // Traverses the map in key order and calls the specified action function
    // for each key/value pair. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ot = function(t) {
        return this.root.ot(t);
    }, t.prototype.forEach = function(t) {
        this.ot((function(e, n) {
            return t(e, n), !1;
        }));
    }, t.prototype.toString = function() {
        var t = [];
        return this.ot((function(e, n) {
            return t.push(e + ":" + n), !1;
        })), "{" + t.join(", ") + "}";
    }, 
    // Traverses the map in reverse key order and calls the specified action
    // function for each key/value pair. If action returns true, traversal is
    // aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.root.ht(t);
    }, 
    // Returns an iterator over the SortedMap.
    t.prototype.at = function() {
        return new ht(this.root, null, this.P, !1);
    }, t.prototype.ut = function(t) {
        return new ht(this.root, t, this.P, !1);
    }, t.prototype.ct = function() {
        return new ht(this.root, null, this.P, !0);
    }, t.prototype.lt = function(t) {
        return new ht(this.root, t, this.P, !0);
    }, t;
}(), ht = /** @class */ function() {
    function t(t, e, n, r) {
        this._t = r, this.ft = [];
        for (var i = 1; !t._(); ) if (i = e ? n(t.key, e) : 1, 
        // flip the comparison if we're going in reverse
        r && (i *= -1), i < 0) 
        // This node is less than our start key. ignore it
        t = this._t ? t.left : t.right; else {
            if (0 === i) {
                // This node is exactly equal to our start key. Push it on the stack,
                // but stop iterating;
                this.ft.push(t);
                break;
            }
            // This node is greater than our start key, add it to the stack and move
            // to the next one
                        this.ft.push(t), t = this._t ? t.right : t.left;
        }
    }
    return t.prototype.dt = function() {
        var t = this.ft.pop(), e = {
            key: t.key,
            value: t.value
        };
        if (this._t) for (t = t.left; !t._(); ) this.ft.push(t), t = t.right; else for (t = t.right; !t._(); ) this.ft.push(t), 
        t = t.left;
        return e;
    }, t.prototype.wt = function() {
        return this.ft.length > 0;
    }, t.prototype.Tt = function() {
        if (0 === this.ft.length) return null;
        var t = this.ft[this.ft.length - 1];
        return {
            key: t.key,
            value: t.value
        };
    }, t;
}(), ft = /** @class */ function() {
    function t(e, n, r, i, o) {
        this.key = e, this.value = n, this.color = null != r ? r : t.RED, this.left = null != i ? i : t.EMPTY, 
        this.right = null != o ? o : t.EMPTY, this.size = this.left.size + 1 + this.right.size;
    }
    // Returns a copy of the current node, optionally replacing pieces of it.
        return t.prototype.copy = function(e, n, r, i, o) {
        return new t(null != e ? e : this.key, null != n ? n : this.value, null != r ? r : this.color, null != i ? i : this.left, null != o ? o : this.right);
    }, t.prototype._ = function() {
        return !1;
    }, 
    // Traverses the tree in key order and calls the specified action function
    // for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ot = function(t) {
        return this.left.ot(t) || t(this.key, this.value) || this.right.ot(t);
    }, 
    // Traverses the tree in reverse key order and calls the specified action
    // function for each node. If action returns true, traversal is aborted.
    // Returns the first truthy value returned by action, or the last falsey
    // value returned by action.
    t.prototype.ht = function(t) {
        return this.right.ht(t) || t(this.key, this.value) || this.left.ht(t);
    }, 
    // Returns the minimum node in the tree.
    t.prototype.min = function() {
        return this.left._() ? this : this.left.min();
    }, 
    // Returns the maximum key in the tree.
    t.prototype.it = function() {
        return this.min().key;
    }, 
    // Returns the maximum key in the tree.
    t.prototype.rt = function() {
        return this.right._() ? this.key : this.right.rt();
    }, 
    // Returns new tree, with the key/value added.
    t.prototype.nt = function(t, e, n) {
        var r = this, i = n(t, r.key);
        return (r = i < 0 ? r.copy(null, null, null, r.left.nt(t, e, n), null) : 0 === i ? r.copy(null, e, null, null, null) : r.copy(null, null, null, null, r.right.nt(t, e, n))).Et();
    }, t.prototype.It = function() {
        if (this.left._()) return t.EMPTY;
        var e = this;
        return e.left.At() || e.left.left.At() || (e = e.Rt()), (e = e.copy(null, null, null, e.left.It(), null)).Et();
    }, 
    // Returns new tree, with the specified item removed.
    t.prototype.remove = function(e, n) {
        var r, i = this;
        if (n(e, i.key) < 0) i.left._() || i.left.At() || i.left.left.At() || (i = i.Rt()), 
        i = i.copy(null, null, null, i.left.remove(e, n), null); else {
            if (i.left.At() && (i = i.Pt()), i.right._() || i.right.At() || i.right.left.At() || (i = i.gt()), 
            0 === n(e, i.key)) {
                if (i.right._()) return t.EMPTY;
                r = i.right.min(), i = i.copy(r.key, r.value, null, null, i.right.It());
            }
            i = i.copy(null, null, null, null, i.right.remove(e, n));
        }
        return i.Et();
    }, t.prototype.At = function() {
        return this.color;
    }, 
    // Returns new tree after performing any needed rotations.
    t.prototype.Et = function() {
        var t = this;
        return t.right.At() && !t.left.At() && (t = t.Vt()), t.left.At() && t.left.left.At() && (t = t.Pt()), 
        t.left.At() && t.right.At() && (t = t.yt()), t;
    }, t.prototype.Rt = function() {
        var t = this.yt();
        return t.right.left.At() && (t = (t = (t = t.copy(null, null, null, null, t.right.Pt())).Vt()).yt()), 
        t;
    }, t.prototype.gt = function() {
        var t = this.yt();
        return t.left.left.At() && (t = (t = t.Pt()).yt()), t;
    }, t.prototype.Vt = function() {
        var e = this.copy(null, null, t.RED, null, this.right.left);
        return this.right.copy(null, null, this.color, e, null);
    }, t.prototype.Pt = function() {
        var e = this.copy(null, null, t.RED, this.left.right, null);
        return this.left.copy(null, null, this.color, null, e);
    }, t.prototype.yt = function() {
        var t = this.left.copy(null, null, !this.left.color, null, null), e = this.right.copy(null, null, !this.right.color, null, null);
        return this.copy(null, null, !this.color, t, e);
    }, 
    // For testing.
    t.prototype.pt = function() {
        var t = this.bt();
        return Math.pow(2, t) <= this.size + 1;
    }, 
    // In a balanced RB tree, the black-depth (number of black nodes) from root to
    // leaves is equal on both sides.  This function verifies that or asserts.
    t.prototype.bt = function() {
        if (this.At() && this.left.At()) throw A();
        if (this.right.At()) throw A();
        var t = this.left.bt();
        if (t !== this.right.bt()) throw A();
        return t + (this.At() ? 0 : 1);
    }, t;
}();

// end SortedMap
// An iterator over an LLRBNode.
// end LLRBNode
// Empty node is shared between all LLRB trees.
// eslint-disable-next-line @typescript-eslint/no-explicit-any
ft.EMPTY = null, ft.RED = !0, ft.st = !1, 
// end LLRBEmptyNode
ft.EMPTY = new (/** @class */ function() {
    function t() {
        this.size = 0;
    }
    return Object.defineProperty(t.prototype, "key", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "value", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "color", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "left", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "right", {
        get: function() {
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Returns a copy of the current node.
    t.prototype.copy = function(t, e, n, r, i) {
        return this;
    }, 
    // Returns a copy of the tree, with the specified key/value added.
    t.prototype.nt = function(t, e, n) {
        return new ft(t, e);
    }, 
    // Returns a copy of the tree, with the specified key removed.
    t.prototype.remove = function(t, e) {
        return this;
    }, t.prototype._ = function() {
        return !0;
    }, t.prototype.ot = function(t) {
        return !1;
    }, t.prototype.ht = function(t) {
        return !1;
    }, t.prototype.it = function() {
        return null;
    }, t.prototype.rt = function() {
        return null;
    }, t.prototype.At = function() {
        return !1;
    }, 
    // For testing.
    t.prototype.pt = function() {
        return !0;
    }, t.prototype.bt = function() {
        return 0;
    }, t;
}());

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * SortedSet is an immutable (copy-on-write) collection that holds elements
 * in order specified by the provided comparator.
 *
 * NOTE: if provided comparator returns 0 for two elements, we consider them to
 * be equal!
 */
var lt = /** @class */ function() {
    function t(t) {
        this.P = t, this.data = new ct(this.P);
    }
    return t.prototype.has = function(t) {
        return null !== this.data.get(t);
    }, t.prototype.first = function() {
        return this.data.it();
    }, t.prototype.last = function() {
        return this.data.rt();
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.data.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.indexOf = function(t) {
        return this.data.indexOf(t);
    }, 
    /** Iterates elements in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.data.ot((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Iterates over `elem`s such that: range[0] <= elem < range[1]. */ t.prototype.vt = function(t, e) {
        for (var n = this.data.ut(t[0]); n.wt(); ) {
            var r = n.dt();
            if (this.P(r.key, t[1]) >= 0) return;
            e(r.key);
        }
    }, 
    /**
     * Iterates over `elem`s such that: start <= elem until false is returned.
     */
    t.prototype.St = function(t, e) {
        var n;
        for (n = void 0 !== e ? this.data.ut(e) : this.data.at(); n.wt(); ) if (!t(n.dt().key)) return;
    }, 
    /** Finds the least element greater than or equal to `elem`. */ t.prototype.Dt = function(t) {
        var e = this.data.ut(t);
        return e.wt() ? e.dt().key : null;
    }, t.prototype.at = function() {
        return new pt(this.data.at());
    }, t.prototype.ut = function(t) {
        return new pt(this.data.ut(t));
    }, 
    /** Inserts or updates an element */ t.prototype.add = function(t) {
        return this.copy(this.data.remove(t).nt(t, !0));
    }, 
    /** Deletes an element */ t.prototype.delete = function(t) {
        return this.has(t) ? this.copy(this.data.remove(t)) : this;
    }, t.prototype._ = function() {
        return this.data._();
    }, t.prototype.Ct = function(t) {
        var e = this;
        // Make sure `result` always refers to the larger one of the two sets.
                return e.size < t.size && (e = t, t = this), t.forEach((function(t) {
            e = e.add(t);
        })), e;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.data.at(), r = e.data.at(); n.wt(); ) {
            var i = n.dt().key, o = r.dt().key;
            if (0 !== this.P(i, o)) return !1;
        }
        return !0;
    }, t.prototype.F = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e);
        })), t;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            return t.push(e);
        })), "SortedSet(" + t.toString() + ")";
    }, t.prototype.copy = function(e) {
        var n = new t(this.P);
        return n.data = e, n;
    }, t;
}(), pt = /** @class */ function() {
    function t(t) {
        this.Ft = t;
    }
    return t.prototype.dt = function() {
        return this.Ft.dt().key;
    }, t.prototype.wt = function() {
        return this.Ft.wt();
    }, t;
}(), dt = new ct(Q.P);

function yt() {
    return dt;
}

function vt() {
    return yt();
}

var mt = new ct(Q.P);

function gt() {
    return mt;
}

var wt = new ct(Q.P), bt = new lt(Q.P);

function It() {
    for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
    for (var n = bt, r = 0, i = t; r < i.length; r++) {
        var o = i[r];
        n = n.add(o);
    }
    return n;
}

var Et = new lt(k);

function Tt() {
    return Et;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentSet is an immutable (copy-on-write) collection that holds documents
 * in order specified by the provided comparator. We always add a document key
 * comparator on top of what is provided to guarantee document equality based on
 * the key.
 */ var Nt = /** @class */ function() {
    /** The default ordering is by key if the comparator is omitted */
    function t(t) {
        // We are adding document key comparator to the end as it's the only
        // guaranteed unique property of a document.
        this.P = t ? function(e, n) {
            return t(e, n) || Q.P(e.key, n.key);
        } : function(t, e) {
            return Q.P(t.key, e.key);
        }, this.$t = gt(), this.Nt = new ct(this.P)
        /**
     * Returns an empty copy of the existing DocumentSet, using the same
     * comparator.
     */;
    }
    return t.kt = function(e) {
        return new t(e.P);
    }, t.prototype.has = function(t) {
        return null != this.$t.get(t);
    }, t.prototype.get = function(t) {
        return this.$t.get(t);
    }, t.prototype.first = function() {
        return this.Nt.it();
    }, t.prototype.last = function() {
        return this.Nt.rt();
    }, t.prototype._ = function() {
        return this.Nt._();
    }, 
    /**
     * Returns the index of the provided key in the document set, or -1 if the
     * document key is not present in the set;
     */
    t.prototype.indexOf = function(t) {
        var e = this.$t.get(t);
        return e ? this.Nt.indexOf(e) : -1;
    }, Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.Nt.size;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Iterates documents in order defined by "comparator" */ t.prototype.forEach = function(t) {
        this.Nt.ot((function(e, n) {
            return t(e), !1;
        }));
    }, 
    /** Inserts or updates a document with the same key */ t.prototype.add = function(t) {
        // First remove the element if we have it.
        var e = this.delete(t.key);
        return e.copy(e.$t.nt(t.key, t), e.Nt.nt(t, null));
    }, 
    /** Deletes a document with a given key */ t.prototype.delete = function(t) {
        var e = this.get(t);
        return e ? this.copy(this.$t.remove(t), this.Nt.remove(e)) : this;
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) return !1;
        if (this.size !== e.size) return !1;
        for (var n = this.Nt.at(), r = e.Nt.at(); n.wt(); ) {
            var i = n.dt().key, o = r.dt().key;
            if (!i.isEqual(o)) return !1;
        }
        return !0;
    }, t.prototype.toString = function() {
        var t = [];
        return this.forEach((function(e) {
            t.push(e.toString());
        })), 0 === t.length ? "DocumentSet ()" : "DocumentSet (\n  " + t.join("  \n") + "\n)";
    }, t.prototype.copy = function(e, n) {
        var r = new t;
        return r.P = this.P, r.$t = e, r.Nt = n, r;
    }, t;
}(), At = /** @class */ function() {
    function t() {
        this.xt = new ct(Q.P);
    }
    return t.prototype.track = function(t) {
        var e = t.doc.key, n = this.xt.get(e);
        n ? 
        // Merge the new change with the existing change.
        0 /* Added */ !== t.type && 3 /* Metadata */ === n.type ? this.xt = this.xt.nt(e, t) : 3 /* Metadata */ === t.type && 1 /* Removed */ !== n.type ? this.xt = this.xt.nt(e, {
            type: n.type,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 2 /* Modified */ === n.type ? this.xt = this.xt.nt(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 2 /* Modified */ === t.type && 0 /* Added */ === n.type ? this.xt = this.xt.nt(e, {
            type: 0 /* Added */ ,
            doc: t.doc
        }) : 1 /* Removed */ === t.type && 0 /* Added */ === n.type ? this.xt = this.xt.remove(e) : 1 /* Removed */ === t.type && 2 /* Modified */ === n.type ? this.xt = this.xt.nt(e, {
            type: 1 /* Removed */ ,
            doc: n.doc
        }) : 0 /* Added */ === t.type && 1 /* Removed */ === n.type ? this.xt = this.xt.nt(e, {
            type: 2 /* Modified */ ,
            doc: t.doc
        }) : 
        // This includes these cases, which don't make sense:
        // Added->Added
        // Removed->Removed
        // Modified->Added
        // Removed->Modified
        // Metadata->Added
        // Removed->Metadata
        A() : this.xt = this.xt.nt(e, t);
    }, t.prototype.Mt = function() {
        var t = [];
        return this.xt.ot((function(e, n) {
            t.push(n);
        })), t;
    }, t;
}(), _t = /** @class */ function() {
    function t(t, e, n, r, i, o, s, u) {
        this.query = t, this.docs = e, this.Ot = n, this.docChanges = r, this.Lt = i, this.fromCache = o, 
        this.qt = s, this.Bt = u
        /** Returns a view snapshot as if all documents in the snapshot were added. */;
    }
    return t.Ut = function(e, n, r, i) {
        var o = [];
        return n.forEach((function(t) {
            o.push({
                type: 0 /* Added */ ,
                doc: t
            });
        })), new t(e, n, Nt.kt(n), o, r, i, 
        /* syncStateChanged= */ !0, 
        /* excludesMetadataChanges= */ !1);
    }, Object.defineProperty(t.prototype, "hasPendingWrites", {
        get: function() {
            return !this.Lt._();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        if (!(this.fromCache === t.fromCache && this.qt === t.qt && this.Lt.isEqual(t.Lt) && _n(this.query, t.query) && this.docs.isEqual(t.docs) && this.Ot.isEqual(t.Ot))) return !1;
        var e = this.docChanges, n = t.docChanges;
        if (e.length !== n.length) return !1;
        for (var r = 0; r < e.length; r++) if (e[r].type !== n[r].type || !e[r].doc.isEqual(n[r].doc)) return !1;
        return !0;
    }, t;
}(), Dt = /** @class */ function() {
    function t(
    /**
     * The snapshot version this event brings us up to, or MIN if not set.
     */
    t, 
    /**
     * A map from target to changes to the target. See TargetChange.
     */
    e, 
    /**
     * A set of targets that is known to be inconsistent. Listens for these
     * targets should be re-established without resume tokens.
     */
    n, 
    /**
     * A set of which documents have changed or been deleted, along with the
     * doc's new values (if not deleted).
     */
    r, 
    /**
     * A set of which document updates are due only to limbo resolution targets.
     */
    i) {
        this.X = t, this.Wt = e, this.Qt = n, this.jt = r, this.Kt = i;
    }
    /**
     * HACK: Views require RemoteEvents in order to determine whether the view is
     * CURRENT, but secondary tabs don't receive remote events. So this method is
     * used to create a synthesized RemoteEvent that can be used to apply a
     * CURRENT status change to a View, for queries executed in a different tab.
     */
    // PORTING NOTE: Multi-tab only
        return t.Gt = function(e, n) {
        var r = new Map;
        return r.set(e, St.zt(e, n)), new t(G.min(), r, Tt(), yt(), It());
    }, t;
}(), St = /** @class */ function() {
    function t(
    /**
     * An opaque, server-assigned token that allows watching a query to be resumed
     * after disconnecting without retransmitting all the data that matches the
     * query. The resume token essentially identifies a point in time from which
     * the server should resume sending results.
     */
    t, 
    /**
     * The "current" (synced) status of this target. Note that "current"
     * has special meaning in the RPC protocol that implies that a target is
     * both up-to-date and consistent with the rest of the watch stream.
     */
    e, 
    /**
     * The set of documents that were newly assigned to this target as part of
     * this remote event.
     */
    n, 
    /**
     * The set of documents that were already assigned to this target but received
     * an update during this remote event.
     */
    r, 
    /**
     * The set of documents that were removed from this target as part of this
     * remote event.
     */
    i) {
        this.resumeToken = t, this.Ht = e, this.Yt = n, this.Jt = r, this.Xt = i
        /**
     * This method is used to create a synthesized TargetChanges that can be used to
     * apply a CURRENT status change to a View (for queries executed in a different
     * tab) or for new queries (to raise snapshots with correct CURRENT status).
     */;
    }
    return t.zt = function(e, n) {
        return new t(nt.Y, n, It(), It(), It());
    }, t;
}(), xt = function(
/** The new document applies to all of these targets. */
t, 
/** The new document is removed from all of these targets. */
e, 
/** The key of the document for this change. */
n, 
/**
     * The new document or NoDocument if it was deleted. Is null if the
     * document went out of view without the server sending a new document.
     */
r) {
    this.Zt = t, this.removedTargetIds = e, this.key = n, this.te = r;
}, kt = function(t, e) {
    this.targetId = t, this.ee = e;
}, Pt = function(
/** What kind of change occurred to the watch target. */
t, 
/** The target IDs that were added/removed/set. */
e, 
/**
     * An opaque, server-assigned token that allows watching a target to be
     * resumed after disconnecting without retransmitting all the data that
     * matches the target. The resume token essentially identifies a point in
     * time from which the server should resume sending results.
     */
n
/** An RPC error indicating why the watch failed. */ , r) {
    void 0 === n && (n = nt.Y), void 0 === r && (r = null), this.state = t, this.targetIds = e, 
    this.resumeToken = n, this.cause = r;
}, Lt = /** @class */ function() {
    function t() {
        /**
         * The number of pending responses (adds or removes) that we are waiting on.
         * We only consider targets active that have no pending responses.
         */
        this.ne = 0, 
        /**
             * Keeps track of the document changes since the last raised snapshot.
             *
             * These changes are continuously updated as we receive document updates and
             * always reflect the current set of changes against the last issued snapshot.
             */
        this.se = Vt(), 
        /** See public getters for explanations of these fields. */
        this.ie = nt.Y, this.re = !1, 
        /**
             * Whether this target state should be included in the next snapshot. We
             * initialize to true so that newly-added targets are included in the next
             * RemoteEvent.
             */
        this.oe = !0;
    }
    return Object.defineProperty(t.prototype, "Ht", {
        /**
         * Whether this target has been marked 'current'.
         *
         * 'Current' has special meaning in the RPC protocol: It implies that the
         * Watch backend has sent us all changes up to the point at which the target
         * was added and that the target is consistent with the rest of the watch
         * stream.
         */
        get: function() {
            return this.re;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "resumeToken", {
        /** The last resume token sent to us for this target. */ get: function() {
            return this.ie;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "he", {
        /** Whether this target has pending target adds or target removes. */ get: function() {
            return 0 !== this.ne;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ae", {
        /** Whether we have modified any state that should trigger a snapshot. */ get: function() {
            return this.oe;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Applies the resume token to the TargetChange, but only when it has a new
     * value. Empty resumeTokens are discarded.
     */
    t.prototype.ue = function(t) {
        t.H() > 0 && (this.oe = !0, this.ie = t);
    }, 
    /**
     * Creates a target change from the current set of changes.
     *
     * To reset the document changes after raising this snapshot, call
     * `clearPendingChanges()`.
     */
    t.prototype.ce = function() {
        var t = It(), e = It(), n = It();
        return this.se.forEach((function(r, i) {
            switch (i) {
              case 0 /* Added */ :
                t = t.add(r);
                break;

              case 2 /* Modified */ :
                e = e.add(r);
                break;

              case 1 /* Removed */ :
                n = n.add(r);
                break;

              default:
                A();
            }
        })), new St(this.ie, this.re, t, e, n);
    }, 
    /**
     * Resets the document changes and sets `hasPendingChanges` to false.
     */
    t.prototype.le = function() {
        this.oe = !1, this.se = Vt();
    }, t.prototype._e = function(t, e) {
        this.oe = !0, this.se = this.se.nt(t, e);
    }, t.prototype.fe = function(t) {
        this.oe = !0, this.se = this.se.remove(t);
    }, t.prototype.de = function() {
        this.ne += 1;
    }, t.prototype.we = function() {
        this.ne -= 1;
    }, t.prototype.Te = function() {
        this.oe = !0, this.re = !0;
    }, t;
}(), Ot = /** @class */ function() {
    function t(t) {
        this.Ee = t, 
        /** The internal state of all tracked targets. */
        this.Ie = new Map, 
        /** Keeps track of the documents to update since the last raised snapshot. */
        this.me = yt(), 
        /** A mapping of document keys to their set of target IDs. */
        this.Ae = Rt(), 
        /**
             * A list of targets with existence filter mismatches. These targets are
             * known to be inconsistent and their listens needs to be re-established by
             * RemoteStore.
             */
        this.Re = new lt(k)
        /**
     * Processes and adds the DocumentWatchChange to the current set of changes.
     */;
    }
    return t.prototype.Pe = function(t) {
        for (var e = 0, n = t.Zt; e < n.length; e++) {
            var r = n[e];
            t.te instanceof pn ? this.ge(r, t.te) : t.te instanceof dn && this.Ve(r, t.key, t.te);
        }
        for (var i = 0, o = t.removedTargetIds; i < o.length; i++) {
            var s = o[i];
            this.Ve(s, t.key, t.te);
        }
    }, 
    /** Processes and adds the WatchTargetChange to the current set of changes. */ t.prototype.ye = function(t) {
        var e = this;
        this.pe(t, (function(n) {
            var r = e.be(n);
            switch (t.state) {
              case 0 /* NoChange */ :
                e.ve(n) && r.ue(t.resumeToken);
                break;

              case 1 /* Added */ :
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.we(), r.he || 
                // We have a freshly added target, so we need to reset any state
                // that we had previously. This can happen e.g. when remove and add
                // back a target for existence filter mismatches.
                r.le(), r.ue(t.resumeToken);
                break;

              case 2 /* Removed */ :
                // We need to keep track of removed targets to we can post-filter and
                // remove any target changes.
                // We need to decrement the number of pending acks needed from watch
                // for this targetId.
                r.we(), r.he || e.removeTarget(n);
                break;

              case 3 /* Current */ :
                e.ve(n) && (r.Te(), r.ue(t.resumeToken));
                break;

              case 4 /* Reset */ :
                e.ve(n) && (
                // Reset the target and synthesizes removes for all existing
                // documents. The backend will re-add any documents that still
                // match the target before it sends the next global snapshot.
                e.Se(n), r.ue(t.resumeToken));
                break;

              default:
                A();
            }
        }));
    }, 
    /**
     * Iterates over all targetIds that the watch change applies to: either the
     * targetIds explicitly listed in the change or the targetIds of all currently
     * active targets.
     */
    t.prototype.pe = function(t, e) {
        var n = this;
        t.targetIds.length > 0 ? t.targetIds.forEach(e) : this.Ie.forEach((function(t, r) {
            n.ve(r) && e(r);
        }));
    }, 
    /**
     * Handles existence filters and synthesizes deletes for filter mismatches.
     * Targets that are invalidated by filter mismatches are added to
     * `pendingTargetResets`.
     */
    t.prototype.De = function(t) {
        var e = t.targetId, n = t.ee.count, r = this.Ce(e);
        if (r) {
            var i = r.target;
            if (et(i)) if (0 === n) {
                // The existence filter told us the document does not exist. We deduce
                // that this document does not exist and apply a deleted document to
                // our updates. Without applying this deleted document there might be
                // another query that will raise this document as part of a snapshot
                // until it is resolved, essentially exposing inconsistency between
                // queries.
                var o = new Q(i.path);
                this.Ve(e, o, new dn(o, G.min()));
            } else _(1 === n); else this.Fe(e) !== n && (
            // Existence filter mismatch: We reset the mapping and raise a new
            // snapshot with `isFromCache:true`.
            this.Se(e), this.Re = this.Re.add(e));
        }
    }, 
    /**
     * Converts the currently accumulated state into a remote event at the
     * provided snapshot version. Resets the accumulated changes before returning.
     */
    t.prototype.$e = function(t) {
        var e = this, n = new Map;
        this.Ie.forEach((function(r, i) {
            var o = e.Ce(i);
            if (o) {
                if (r.Ht && et(o.target)) {
                    // Document queries for document that don't exist can produce an empty
                    // result set. To update our local cache, we synthesize a document
                    // delete if we have not previously received the document. This
                    // resolves the limbo state of the document, removing it from
                    // limboDocumentRefs.
                    // TODO(dimond): Ideally we would have an explicit lookup target
                    // instead resulting in an explicit delete message and we could
                    // remove this special logic.
                    var s = new Q(o.target.path);
                    null !== e.me.get(s) || e.Ne(i, s) || e.Ve(i, s, new dn(s, t));
                }
                r.ae && (n.set(i, r.ce()), r.le());
            }
        }));
        var r = It();
        // We extract the set of limbo-only document updates as the GC logic
        // special-cases documents that do not appear in the target cache.
        // TODO(gsoltis): Expand on this comment once GC is available in the JS
        // client.
                this.Ae.forEach((function(t, n) {
            var i = !0;
            n.St((function(t) {
                var n = e.Ce(t);
                return !n || 2 /* LimboResolution */ === n.J || (i = !1, !1);
            })), i && (r = r.add(t));
        }));
        var i = new Dt(t, n, this.Re, this.me, r);
        return this.me = yt(), this.Ae = Rt(), this.Re = new lt(k), i;
    }, 
    /**
     * Adds the provided document to the internal list of document updates and
     * its document key to the given target's mapping.
     */
    // Visible for testing.
    t.prototype.ge = function(t, e) {
        if (this.ve(t)) {
            var n = this.Ne(t, e.key) ? 2 /* Modified */ : 0 /* Added */;
            this.be(t)._e(e.key, n), this.me = this.me.nt(e.key, e), this.Ae = this.Ae.nt(e.key, this.ke(e.key).add(t));
        }
    }, 
    /**
     * Removes the provided document from the target mapping. If the
     * document no longer matches the target, but the document's state is still
     * known (e.g. we know that the document was deleted or we received the change
     * that caused the filter mismatch), the new document can be provided
     * to update the remote document cache.
     */
    // Visible for testing.
    t.prototype.Ve = function(t, e, n) {
        if (this.ve(t)) {
            var r = this.be(t);
            this.Ne(t, e) ? r._e(e, 1 /* Removed */) : 
            // The document may have entered and left the target before we raised a
            // snapshot, so we can just ignore the change.
            r.fe(e), this.Ae = this.Ae.nt(e, this.ke(e).delete(t)), n && (this.me = this.me.nt(e, n));
        }
    }, t.prototype.removeTarget = function(t) {
        this.Ie.delete(t);
    }, 
    /**
     * Returns the current count of documents in the target. This includes both
     * the number of documents that the LocalStore considers to be part of the
     * target as well as any accumulated changes.
     */
    t.prototype.Fe = function(t) {
        var e = this.be(t).ce();
        return this.Ee.xe(t).size + e.Yt.size - e.Xt.size;
    }, 
    /**
     * Increment the number of acks needed from watch before we can consider the
     * server to be 'in-sync' with the client's active targets.
     */
    t.prototype.de = function(t) {
        this.be(t).de();
    }, t.prototype.be = function(t) {
        var e = this.Ie.get(t);
        return e || (e = new Lt, this.Ie.set(t, e)), e;
    }, t.prototype.ke = function(t) {
        var e = this.Ae.get(t);
        return e || (e = new lt(k), this.Ae = this.Ae.nt(t, e)), e;
    }, 
    /**
     * Verifies that the user is still interested in this target (by calling
     * `getTargetDataForTarget()`) and that we are not waiting for pending ADDs
     * from watch.
     */
    t.prototype.ve = function(t) {
        var e = null !== this.Ce(t);
        return e || E("WatchChangeAggregator", "Detected inactive target", t), e;
    }, 
    /**
     * Returns the TargetData for an active target (i.e. a target that the user
     * is still interested in that has no outstanding target change requests).
     */
    t.prototype.Ce = function(t) {
        var e = this.Ie.get(t);
        return e && e.he ? null : this.Ee.Me(t);
    }, 
    /**
     * Resets the state of a Watch target to its initial state (e.g. sets
     * 'current' to false, clears the resume token and removes its target mapping
     * from all documents).
     */
    t.prototype.Se = function(t) {
        var e = this;
        this.Ie.set(t, new Lt), this.Ee.xe(t).forEach((function(n) {
            e.Ve(t, n, /*updatedDocument=*/ null);
        }));
    }, 
    /**
     * Returns whether the LocalStore considers the document to be part of the
     * specified target.
     */
    t.prototype.Ne = function(t, e) {
        return this.Ee.xe(t).has(e);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * DocumentChangeSet keeps track of a set of changes to docs in a query, merging
 * duplicate events for the same doc.
 */ function Rt() {
    return new ct(Q.P);
}

function Vt() {
    return new ct(Q.P);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Represents a locally-applied ServerTimestamp.
 *
 * Server Timestamps are backed by MapValues that contain an internal field
 * `__type__` with a value of `server_timestamp`. The previous value and local
 * write time are stored in its `__previous_value__` and `__local_write_time__`
 * fields respectively.
 *
 * Notes:
 * - ServerTimestampValue instances are created as the result of applying a
 *   TransformMutation (see TransformMutation.applyTo()). They can only exist in
 *   the local view of a document. Therefore they do not need to be parsed or
 *   serialized.
 * - When evaluated locally (e.g. for snapshot.data()), they by default
 *   evaluate to `null`. This behavior can be configured by passing custom
 *   FieldValueOptions to value().
 * - With respect to other ServerTimestampValues, they sort by their
 *   localWriteTime.
 */ function Ut(t) {
    var e, n;
    return "server_timestamp" === (null === (n = ((null === (e = null == t ? void 0 : t.mapValue) || void 0 === e ? void 0 : e.fields) || {}).__type__) || void 0 === n ? void 0 : n.stringValue);
}

/**
 * Creates a new ServerTimestamp proto value (using the internal format).
 */
/**
 * Returns the local time at which this timestamp was first set.
 */ function Ct(t) {
    var e = Wt(t.mapValue.fields.__local_write_time__.timestampValue);
    return new j(e.seconds, e.nanos);
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// A RegExp matching ISO 8601 UTC timestamps with optional fraction.
var Mt = new RegExp(/^\d{4}-\d\d-\d\dT\d\d:\d\d:\d\d(?:\.(\d+))?Z$/);

/** Extracts the backend's type order for the provided value. */ function qt(t) {
    return "nullValue" in t ? 0 /* NullValue */ : "booleanValue" in t ? 1 /* BooleanValue */ : "integerValue" in t || "doubleValue" in t ? 2 /* NumberValue */ : "timestampValue" in t ? 3 /* TimestampValue */ : "stringValue" in t ? 5 /* StringValue */ : "bytesValue" in t ? 6 /* BlobValue */ : "referenceValue" in t ? 7 /* RefValue */ : "geoPointValue" in t ? 8 /* GeoPointValue */ : "arrayValue" in t ? 9 /* ArrayValue */ : "mapValue" in t ? Ut(t) ? 4 /* ServerTimestampValue */ : 10 /* ObjectValue */ : A();
}

/** Tests `left` and `right` for equality based on the backend semantics. */ function Ft(t, e) {
    var n = qt(t);
    if (n !== qt(e)) return !1;
    switch (n) {
      case 0 /* NullValue */ :
        return !0;

      case 1 /* BooleanValue */ :
        return t.booleanValue === e.booleanValue;

      case 4 /* ServerTimestampValue */ :
        return Ct(t).isEqual(Ct(e));

      case 3 /* TimestampValue */ :
        return function(t, e) {
            if ("string" == typeof t.timestampValue && "string" == typeof e.timestampValue && t.timestampValue.length === e.timestampValue.length) 
            // Use string equality for ISO 8601 timestamps
            return t.timestampValue === e.timestampValue;
            var n = Wt(t.timestampValue), r = Wt(e.timestampValue);
            return n.seconds === r.seconds && n.nanos === r.nanos;
        }(t, e);

      case 5 /* StringValue */ :
        return t.stringValue === e.stringValue;

      case 6 /* BlobValue */ :
        return function(t, e) {
            return Qt(t.bytesValue).isEqual(Qt(e.bytesValue));
        }(t, e);

      case 7 /* RefValue */ :
        return t.referenceValue === e.referenceValue;

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            return Kt(t.geoPointValue.latitude) === Kt(e.geoPointValue.latitude) && Kt(t.geoPointValue.longitude) === Kt(e.geoPointValue.longitude);
        }(t, e);

      case 2 /* NumberValue */ :
        return function(t, e) {
            if ("integerValue" in t && "integerValue" in e) return Kt(t.integerValue) === Kt(e.integerValue);
            if ("doubleValue" in t && "doubleValue" in e) {
                var n = Kt(t.doubleValue), r = Kt(e.doubleValue);
                return n === r ? H(n) === H(r) : isNaN(n) && isNaN(r);
            }
            return !1;
        }(t, e);

      case 9 /* ArrayValue */ :
        return P(t.arrayValue.values || [], e.arrayValue.values || [], Ft);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.mapValue.fields || {}, r = e.mapValue.fields || {};
            if (V(n) !== V(r)) return !1;
            for (var i in n) if (n.hasOwnProperty(i) && (void 0 === r[i] || !Ft(n[i], r[i]))) return !1;
            return !0;
        }(t, e);

      default:
        return A();
    }
}

function jt(t, e) {
    return void 0 !== (t.values || []).find((function(t) {
        return Ft(t, e);
    }));
}

function Gt(t, e) {
    var n = qt(t), r = qt(e);
    if (n !== r) return k(n, r);
    switch (n) {
      case 0 /* NullValue */ :
        return 0;

      case 1 /* BooleanValue */ :
        return k(t.booleanValue, e.booleanValue);

      case 2 /* NumberValue */ :
        return function(t, e) {
            var n = Kt(t.integerValue || t.doubleValue), r = Kt(e.integerValue || e.doubleValue);
            return n < r ? -1 : n > r ? 1 : n === r ? 0 : 
            // one or both are NaN.
            isNaN(n) ? isNaN(r) ? 0 : -1 : 1;
        }(t, e);

      case 3 /* TimestampValue */ :
        return Bt(t.timestampValue, e.timestampValue);

      case 4 /* ServerTimestampValue */ :
        return Bt(Ct(t), Ct(e));

      case 5 /* StringValue */ :
        return k(t.stringValue, e.stringValue);

      case 6 /* BlobValue */ :
        return function(t, e) {
            var n = Qt(t), r = Qt(e);
            return n.o(r);
        }(t.bytesValue, e.bytesValue);

      case 7 /* RefValue */ :
        return function(t, e) {
            for (var n = t.split("/"), r = e.split("/"), i = 0; i < n.length && i < r.length; i++) {
                var o = k(n[i], r[i]);
                if (0 !== o) return o;
            }
            return k(n.length, r.length);
        }(t.referenceValue, e.referenceValue);

      case 8 /* GeoPointValue */ :
        return function(t, e) {
            var n = k(Kt(t.latitude), Kt(e.latitude));
            return 0 !== n ? n : k(Kt(t.longitude), Kt(e.longitude));
        }(t.geoPointValue, e.geoPointValue);

      case 9 /* ArrayValue */ :
        return function(t, e) {
            for (var n = t.values || [], r = e.values || [], i = 0; i < n.length && i < r.length; ++i) {
                var o = Gt(n[i], r[i]);
                if (o) return o;
            }
            return k(n.length, r.length);
        }(t.arrayValue, e.arrayValue);

      case 10 /* ObjectValue */ :
        return function(t, e) {
            var n = t.fields || {}, r = Object.keys(n), i = e.fields || {}, o = Object.keys(i);
            // Even though MapValues are likely sorted correctly based on their insertion
            // order (e.g. when received from the backend), local modifications can bring
            // elements out of order. We need to re-sort the elements to ensure that
            // canonical IDs are independent of insertion order.
                        r.sort(), o.sort();
            for (var s = 0; s < r.length && s < o.length; ++s) {
                var u = k(r[s], o[s]);
                if (0 !== u) return u;
                var a = Gt(n[r[s]], i[o[s]]);
                if (0 !== a) return a;
            }
            return k(r.length, o.length);
        }(t.mapValue, e.mapValue);

      default:
        throw A();
    }
}

function Bt(t, e) {
    if ("string" == typeof t && "string" == typeof e && t.length === e.length) return k(t, e);
    var n = Wt(t), r = Wt(e), i = k(n.seconds, r.seconds);
    return 0 !== i ? i : k(n.nanos, r.nanos);
}

function zt(t) {
    return function t(e) {
        return "nullValue" in e ? "null" : "booleanValue" in e ? "" + e.booleanValue : "integerValue" in e ? "" + e.integerValue : "doubleValue" in e ? "" + e.doubleValue : "timestampValue" in e ? function(t) {
            var e = Wt(t);
            return "time(" + e.seconds + "," + e.nanos + ")";
        }(e.timestampValue) : "stringValue" in e ? e.stringValue : "bytesValue" in e ? Qt(e.bytesValue).toBase64() : "referenceValue" in e ? (r = e.referenceValue, 
        Q.B(r).toString()) : "geoPointValue" in e ? "geo(" + (n = e.geoPointValue).latitude + "," + n.longitude + ")" : "arrayValue" in e ? function(e) {
            for (var n = "[", r = !0, i = 0, o = e.values || []; i < o.length; i++) {
                var s = o[i];
                r ? r = !1 : n += ",", n += t(s);
            }
            return n + "]";
        }(e.arrayValue) : "mapValue" in e ? function(e) {
            for (
            // Iteration order in JavaScript is not guaranteed. To ensure that we generate
            // matching canonical IDs for identical maps, we need to sort the keys.
            var n = "{", r = !0, i = 0, o = Object.keys(e.fields || {}).sort(); i < o.length; i++) {
                var s = o[i];
                r ? r = !1 : n += ",", n += s + ":" + t(e.fields[s]);
            }
            return n + "}";
        }(e.mapValue) : A();
        var n, r;
    }(t);
}

function Wt(t) {
    // The json interface (for the browser) will return an iso timestamp string,
    // while the proto js library (for node) will return a
    // google.protobuf.Timestamp instance.
    if (_(!!t), "string" == typeof t) {
        // The date string can have higher precision (nanos) than the Date class
        // (millis), so we do some custom parsing here.
        // Parse the nanos right out of the string.
        var e = 0, n = Mt.exec(t);
        if (_(!!n), n[1]) {
            // Pad the fraction out to 9 digits (nanos).
            var r = n[1];
            r = (r + "000000000").substr(0, 9), e = Number(r);
        }
        // Parse the date to get the seconds.
                var i = new Date(t);
        return {
            seconds: Math.floor(i.getTime() / 1e3),
            nanos: e
        };
    }
    return {
        seconds: Kt(t.seconds),
        nanos: Kt(t.nanos)
    };
}

/**
 * Converts the possible Proto types for numbers into a JavaScript number.
 * Returns 0 if the value is not numeric.
 */ function Kt(t) {
    // TODO(bjornick): Handle int64 greater than 53 bits.
    return "number" == typeof t ? t : "string" == typeof t ? Number(t) : 0;
}

/** Converts the possible Proto types for Blobs into a ByteString. */ function Qt(t) {
    return "string" == typeof t ? nt.fromBase64String(t) : nt.fromUint8Array(t);
}

/** Returns a reference value for the provided database and key. */ function $t(t, e) {
    return {
        referenceValue: "projects/" + t.projectId + "/databases/" + t.database + "/documents/" + e.path.$()
    };
}

/** Returns true if `value` is an IntegerValue . */ function Ht(t) {
    return !!t && "integerValue" in t;
}

/** Returns true if `value` is a DoubleValue. */
/** Returns true if `value` is an ArrayValue. */ function Xt(t) {
    return !!t && "arrayValue" in t;
}

/** Returns true if `value` is a NullValue. */ function Yt(t) {
    return !!t && "nullValue" in t;
}

/** Returns true if `value` is NaN. */ function Zt(t) {
    return !!t && "doubleValue" in t && isNaN(Number(t.doubleValue));
}

/** Returns true if `value` is a MapValue. */ function Jt(t) {
    return !!t && "mapValue" in t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var te = {
    asc: "ASCENDING",
    desc: "DESCENDING"
}, ee = {
    "<": "LESS_THAN",
    "<=": "LESS_THAN_OR_EQUAL",
    ">": "GREATER_THAN",
    ">=": "GREATER_THAN_OR_EQUAL",
    "==": "EQUAL",
    "array-contains": "ARRAY_CONTAINS",
    in: "IN",
    "array-contains-any": "ARRAY_CONTAINS_ANY"
}, ne = function(t, e) {
    this.s = t, this.Oe = e;
};

/**
 * This class generates JsonObject values for the Datastore API suitable for
 * sending to either GRPC stub methods or via the JSON/HTTP REST API.
 *
 * The serializer supports both Protobuf.js and Proto3 JSON formats. By
 * setting `useProto3Json` to true, the serializer will use the Proto3 JSON
 * format.
 *
 * For a description of the Proto3 JSON format check
 * https://developers.google.com/protocol-buffers/docs/proto3#json
 *
 * TODO(klimt): We can remove the databaseId argument if we keep the full
 * resource name in documents.
 */
/**
 * Returns an IntegerValue for `value`.
 */
function re(t) {
    return {
        integerValue: "" + t
    };
}

/**
 * Returns an DoubleValue for `value` that is encoded based the serializer's
 * `useProto3Json` setting.
 */ function ie(t, e) {
    if (t.Oe) {
        if (isNaN(e)) return {
            doubleValue: "NaN"
        };
        if (e === 1 / 0) return {
            doubleValue: "Infinity"
        };
        if (e === -1 / 0) return {
            doubleValue: "-Infinity"
        };
    }
    return {
        doubleValue: H(e) ? "-0" : e
    };
}

/**
 * Returns a value for a number that's appropriate to put into a proto.
 * The return value is an IntegerValue if it can safely represent the value,
 * otherwise a DoubleValue is returned.
 */ function oe(t, e) {
    return X(e) ? re(e) : ie(t, e);
}

/**
 * Returns a value for a Date that's appropriate to put into a proto.
 */ function se(t, e) {
    return t.Oe ? new Date(1e3 * e.seconds).toISOString().replace(/\.\d*/, "").replace("Z", "") + "." + ("000000000" + e.nanoseconds).slice(-9) + "Z" : {
        seconds: "" + e.seconds,
        nanos: e.nanoseconds
    };
}

/**
 * Returns a value for bytes that's appropriate to put in a proto.
 *
 * Visible for testing.
 */ function ue(t, e) {
    return t.Oe ? e.toBase64() : e.toUint8Array();
}

/**
 * Returns a ByteString based on the proto string value.
 */ function ae(t, e) {
    return se(t, e.A());
}

function ce(t) {
    return _(!!t), G.I(function(t) {
        var e = Wt(t);
        return new j(e.seconds, e.nanos);
    }(t));
}

function he(t, e) {
    return function(t) {
        return new z([ "projects", t.projectId, "databases", t.database ]);
    }(t).child("documents").child(e).$();
}

function fe(t) {
    var e = z.N(t);
    return _(ke(e)), e;
}

function le(t, e) {
    return he(t.s, e.path);
}

function pe(t, e) {
    var n = fe(e);
    return _(n.get(1) === t.s.projectId), _(!n.get(3) && !t.s.database || n.get(3) === t.s.database), 
    new Q(me(n));
}

function de(t, e) {
    return he(t.s, e);
}

function ye(t) {
    var e = fe(t);
    // In v1beta1 queries for collections at the root did not have a trailing
    // "/documents". In v1 all resource paths contain "/documents". Preserve the
    // ability to read the v1beta1 form for compatibility with queries persisted
    // in the local target cache.
        return 4 === e.length ? z.k() : me(e);
}

function ve(t) {
    return new z([ "projects", t.s.projectId, "databases", t.s.database ]).$();
}

function me(t) {
    return _(t.length > 4 && "documents" === t.get(4)), t.V(5)
    /** Creates an api.Document from key and fields (but no create/update time) */;
}

function ge(t, e, n) {
    return {
        name: le(t, e),
        fields: n.proto.mapValue.fields
    };
}

function we(t, e) {
    var n;
    if (e instanceof tn) n = {
        update: ge(t, e.key, e.value)
    }; else if (e instanceof un) n = {
        delete: le(t, e.key)
    }; else if (e instanceof en) n = {
        update: ge(t, e.key, e.data),
        updateMask: xe(e.Le)
    }; else if (e instanceof rn) n = {
        transform: {
            document: le(t, e.key),
            fieldTransforms: e.fieldTransforms.map((function(t) {
                return function(t, e) {
                    var n = e.transform;
                    if (n instanceof Ve) return {
                        fieldPath: e.field.$(),
                        setToServerValue: "REQUEST_TIME"
                    };
                    if (n instanceof Ue) return {
                        fieldPath: e.field.$(),
                        appendMissingElements: {
                            values: n.elements
                        }
                    };
                    if (n instanceof Me) return {
                        fieldPath: e.field.$(),
                        removeAllFromArray: {
                            values: n.elements
                        }
                    };
                    if (n instanceof Fe) return {
                        fieldPath: e.field.$(),
                        increment: n.qe
                    };
                    throw A();
                }(0, t);
            }))
        }
    }; else {
        if (!(e instanceof an)) return A();
        n = {
            verify: le(t, e.key)
        };
    }
    return e.Ue.Be || (n.currentDocument = function(t, e) {
        return void 0 !== e.updateTime ? {
            updateTime: ae(t, e.updateTime)
        } : void 0 !== e.exists ? {
            exists: e.exists
        } : A();
    }(t, e.Ue)), n;
}

function be(t, e) {
    var n = e.currentDocument ? function(t) {
        return void 0 !== t.updateTime ? Ke.updateTime(ce(t.updateTime)) : void 0 !== t.exists ? Ke.exists(t.exists) : Ke.We();
    }(e.currentDocument) : Ke.We();
    if (e.update) {
        e.update.name;
        var r = pe(t, e.update.name), i = new cn({
            mapValue: {
                fields: e.update.fields
            }
        });
        if (e.updateMask) {
            var o = function(t) {
                var e = t.fieldPaths || [];
                return new Be(e.map((function(t) {
                    return K.q(t);
                })));
            }(e.updateMask);
            return new en(r, i, o, n);
        }
        return new tn(r, i, n);
    }
    if (e.delete) {
        var s = pe(t, e.delete);
        return new un(s, n);
    }
    if (e.transform) {
        var u = pe(t, e.transform.document), a = e.transform.fieldTransforms.map((function(e) {
            return function(t, e) {
                var n = null;
                if ("setToServerValue" in e) _("REQUEST_TIME" === e.setToServerValue), n = new Ve; else if ("appendMissingElements" in e) {
                    var r = e.appendMissingElements.values || [];
                    n = new Ue(r);
                } else if ("removeAllFromArray" in e) {
                    var i = e.removeAllFromArray.values || [];
                    n = new Me(i);
                } else "increment" in e ? n = new Fe(t, e.increment) : A();
                var o = K.q(e.fieldPath);
                return new ze(o, n);
            }(t, e);
        }));
        return _(!0 === n.exists), new rn(u, a);
    }
    if (e.verify) {
        var c = pe(t, e.verify);
        return new an(c, n);
    }
    return A();
}

function Ie(t, e) {
    return {
        documents: [ de(t, e.path) ]
    };
}

function Ee(t, e) {
    // Dissect the path into parent, collectionId, and optional key filter.
    var n = {
        structuredQuery: {}
    }, r = e.path;
    null !== e.collectionGroup ? (n.parent = de(t, r), n.structuredQuery.from = [ {
        collectionId: e.collectionGroup,
        allDescendants: !0
    } ]) : (n.parent = de(t, r.p()), n.structuredQuery.from = [ {
        collectionId: r.S()
    } ]);
    var i = function(t) {
        if (0 !== t.length) {
            var e = t.map((function(t) {
                return t instanceof Pn ? 
                // visible for testing
                function(t) {
                    if ("==" /* EQUAL */ === t.op) {
                        if (Zt(t.value)) return {
                            unaryFilter: {
                                field: Ae(t.field),
                                op: "IS_NAN"
                            }
                        };
                        if (Yt(t.value)) return {
                            unaryFilter: {
                                field: Ae(t.field),
                                op: "IS_NULL"
                            }
                        };
                    }
                    return {
                        fieldFilter: {
                            field: Ae(t.field),
                            op: (e = t.op, ee[e]),
                            value: t.value
                        }
                    };
                    // visible for testing
                                        var e;
                }(t) : A();
            }));
            return 1 === e.length ? e[0] : {
                compositeFilter: {
                    op: "AND",
                    filters: e
                }
            };
        }
    }(e.filters);
    i && (n.structuredQuery.where = i);
    var o = function(t) {
        if (0 !== t.length) return t.map((function(t) {
            return {
                field: Ae((e = t).field),
                direction: (n = e.dir, te[n])
            };
            // visible for testing
                        var e, n;
        }));
    }(e.orderBy);
    o && (n.structuredQuery.orderBy = o);
    var s = function(t, e) {
        return t.Oe || $(e) ? e : {
            value: e
        };
    }(t, e.limit);
    return null !== s && (n.structuredQuery.limit = s), e.startAt && (n.structuredQuery.startAt = Te(e.startAt)), 
    e.endAt && (n.structuredQuery.endAt = Te(e.endAt)), n;
}

function Te(t) {
    return {
        before: t.before,
        values: t.position
    };
}

function Ne(t) {
    var e = !!t.before, n = t.values || [];
    return new Cn(n, e);
}

// visible for testing
function Ae(t) {
    return {
        fieldPath: t.$()
    };
}

function _e(t) {
    return K.q(t.fieldPath);
}

function De(t) {
    return Pn.create(_e(t.fieldFilter.field), function(t) {
        switch (t) {
          case "EQUAL":
            return "==" /* EQUAL */;

          case "GREATER_THAN":
            return ">" /* GREATER_THAN */;

          case "GREATER_THAN_OR_EQUAL":
            return ">=" /* GREATER_THAN_OR_EQUAL */;

          case "LESS_THAN":
            return "<" /* LESS_THAN */;

          case "LESS_THAN_OR_EQUAL":
            return "<=" /* LESS_THAN_OR_EQUAL */;

          case "ARRAY_CONTAINS":
            return "array-contains" /* ARRAY_CONTAINS */;

          case "IN":
            return "in" /* IN */;

          case "ARRAY_CONTAINS_ANY":
            return "array-contains-any" /* ARRAY_CONTAINS_ANY */;

          case "OPERATOR_UNSPECIFIED":
          default:
            return A();
        }
    }(t.fieldFilter.op), t.fieldFilter.value);
}

function Se(t) {
    switch (t.unaryFilter.op) {
      case "IS_NAN":
        var e = _e(t.unaryFilter.field);
        return Pn.create(e, "==" /* EQUAL */ , {
            doubleValue: NaN
        });

      case "IS_NULL":
        var n = _e(t.unaryFilter.field);
        return Pn.create(n, "==" /* EQUAL */ , {
            nullValue: "NULL_VALUE"
        });

      case "OPERATOR_UNSPECIFIED":
      default:
        return A();
    }
}

function xe(t) {
    var e = [];
    return t.fields.forEach((function(t) {
        return e.push(t.$());
    })), {
        fieldPaths: e
    };
}

function ke(t) {
    // Resource names have at least 4 components (project ID, database ID)
    return t.length >= 4 && "projects" === t.get(0) && "databases" === t.get(2);
}

/**
 * @license
 * Copyright 2018 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Represents a transform within a TransformMutation. */ var Pe = function() {
    // Make sure that the structural type of `TransformOperation` is unique.
    // See https://github.com/microsoft/TypeScript/issues/5451
    this.Qe = void 0;
};

/**
 * Computes the local transform result against the provided `previousValue`,
 * optionally using the provided localWriteTime.
 */ function Le(t, e, n) {
    return t instanceof Ve ? function(t, e) {
        var n = {
            fields: {
                __type__: {
                    stringValue: "server_timestamp"
                },
                __local_write_time__: {
                    timestampValue: {
                        seconds: t.seconds,
                        nanos: t.nanoseconds
                    }
                }
            }
        };
        return e && (n.fields.__previous_value__ = e), {
            mapValue: n
        };
    }(n, e) : t instanceof Ue ? Ce(t, e) : t instanceof Me ? qe(t, e) : function(t, e) {
        // PORTING NOTE: Since JavaScript's integer arithmetic is limited to 53 bit
        // precision and resolves overflows by reducing precision, we do not
        // manually cap overflows at 2^63.
        var n = Re(t, e), r = je(n) + je(t.qe);
        return Ht(n) && Ht(t.qe) ? re(r) : ie(t.serializer, r);
    }(t, e);
}

/**
 * Computes a final transform result after the transform has been acknowledged
 * by the server, potentially using the server-provided transformResult.
 */ function Oe(t, e, n) {
    // The server just sends null as the transform result for array operations,
    // so we have to calculate a result the same as we do for local
    // applications.
    return t instanceof Ue ? Ce(t, e) : t instanceof Me ? qe(t, e) : n;
}

/**
 * If this transform operation is not idempotent, returns the base value to
 * persist for this transform. If a base value is returned, the transform
 * operation is always applied to this base value, even if document has
 * already been updated.
 *
 * Base values provide consistent behavior for non-idempotent transforms and
 * allow us to return the same latency-compensated value even if the backend
 * has already applied the transform operation. The base value is null for
 * idempotent transforms, as they can be re-played even if the backend has
 * already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent transforms.
 */ function Re(t, e) {
    return t instanceof Fe ? Ht(n = e) || function(t) {
        return !!t && "doubleValue" in t;
    }(n) ? e : {
        integerValue: 0
    } : null;
    var n;
}

/** Transforms a value into a server-generated timestamp. */ var Ve = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n;
}(Pe), Ue = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t(n, e), n;
}(Pe);

/** Transforms an array value via a union operation. */ function Ce(t, e) {
    for (var n = Ge(e), r = function(t) {
        n.some((function(e) {
            return Ft(e, t);
        })) || n.push(t);
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/** Transforms an array value via a remove operation. */ var Me = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).elements = t, n;
    }
    return t(n, e), n;
}(Pe);

function qe(t, e) {
    for (var n = Ge(e), r = function(t) {
        n = n.filter((function(e) {
            return !Ft(e, t);
        }));
    }, i = 0, o = t.elements; i < o.length; i++) {
        r(o[i]);
    }
    return {
        arrayValue: {
            values: n
        }
    };
}

/**
 * Implements the backend semantics for locally computed NUMERIC_ADD (increment)
 * transforms. Converts all field values to integers or doubles, but unlike the
 * backend does not cap integer values at 2^63. Instead, JavaScript number
 * arithmetic is used and precision loss can occur for values greater than 2^53.
 */ var Fe = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).serializer = t, r.qe = n, r;
    }
    return t(n, e), n;
}(Pe);

function je(t) {
    return Kt(t.integerValue || t.doubleValue);
}

function Ge(t) {
    return Xt(t) && t.arrayValue.values ? t.arrayValue.values.slice() : [];
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides a set of fields that can be used to partially patch a document.
 * FieldMask is used in conjunction with ObjectValue.
 * Examples:
 *   foo - Overwrites foo entirely with the provided value. If foo is not
 *         present in the companion ObjectValue, the field is deleted.
 *   foo.bar - Overwrites only the field bar of the object foo.
 *             If foo is not an object, foo is replaced with an object
 *             containing foo
 */ var Be = /** @class */ function() {
    function t(t) {
        this.fields = t, 
        // TODO(dimond): validation of FieldMask
        // Sort the field mask to support `FieldMask.isEqual()` and assert below.
        t.sort(K.P)
        /**
     * Verifies that `fieldPath` is included by at least one field in this field
     * mask.
     *
     * This is an O(n) operation, where `n` is the size of the field mask.
     */;
    }
    return t.prototype.je = function(t) {
        for (var e = 0, n = this.fields; e < n.length; e++) {
            if (n[e].D(t)) return !0;
        }
        return !1;
    }, t.prototype.isEqual = function(t) {
        return P(this.fields, t.fields, (function(t, e) {
            return t.isEqual(e);
        }));
    }, t;
}(), ze = function(t, e) {
    this.field = t, this.transform = e;
};

/** A field path and the TransformOperation to perform upon it. */
/** The result of successfully applying a mutation to the backend. */ var We = function(
/**
     * The version at which the mutation was committed:
     *
     * - For most operations, this is the updateTime in the WriteResult.
     * - For deletes, the commitTime of the WriteResponse (because deletes are
     *   not stored and have no updateTime).
     *
     * Note that these versions can be different: No-op writes will not change
     * the updateTime even though the commitTime advances.
     */
t, 
/**
     * The resulting fields returned from the backend after a
     * TransformMutation has been committed. Contains one FieldValue for each
     * FieldTransform that was in the mutation.
     *
     * Will be null if the mutation was not a TransformMutation.
     */
e) {
    this.version = t, this.transformResults = e;
}, Ke = /** @class */ function() {
    function t(t, e) {
        this.updateTime = t, this.exists = e
        /** Creates a new empty Precondition. */;
    }
    return t.We = function() {
        return new t;
    }, 
    /** Creates a new Precondition with an exists flag. */ t.exists = function(e) {
        return new t(void 0, e);
    }, 
    /** Creates a new Precondition based on a version a document exists at. */ t.updateTime = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "Be", {
        /** Returns whether this Precondition is empty. */ get: function() {
            return void 0 === this.updateTime && void 0 === this.exists;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        return this.exists === t.exists && (this.updateTime ? !!t.updateTime && this.updateTime.isEqual(t.updateTime) : !t.updateTime);
    }, t;
}();

/**
 * Encodes a precondition for a mutation. This follows the model that the
 * backend accepts with the special case of an explicit "empty" precondition
 * (meaning no precondition).
 */
/**
 * Returns true if the preconditions is valid for the given document
 * (or null if no document is available).
 */
function Qe(t, e) {
    return void 0 !== t.updateTime ? e instanceof pn && e.version.isEqual(t.updateTime) : void 0 === t.exists || t.exists === e instanceof pn;
}

/**
 * A mutation describes a self-contained change to a document. Mutations can
 * create, replace, delete, and update subsets of documents.
 *
 * Mutations not only act on the value of the document but also its version.
 *
 * For local mutations (mutations that haven't been committed yet), we preserve
 * the existing version for Set, Patch, and Transform mutations. For Delete
 * mutations, we reset the version to 0.
 *
 * Here's the expected transition table.
 *
 * MUTATION           APPLIED TO            RESULTS IN
 *
 * SetMutation        Document(v3)          Document(v3)
 * SetMutation        NoDocument(v3)        Document(v0)
 * SetMutation        null                  Document(v0)
 * PatchMutation      Document(v3)          Document(v3)
 * PatchMutation      NoDocument(v3)        NoDocument(v3)
 * PatchMutation      null                  null
 * TransformMutation  Document(v3)          Document(v3)
 * TransformMutation  NoDocument(v3)        NoDocument(v3)
 * TransformMutation  null                  null
 * DeleteMutation     Document(v3)          NoDocument(v0)
 * DeleteMutation     NoDocument(v3)        NoDocument(v0)
 * DeleteMutation     null                  NoDocument(v0)
 *
 * For acknowledged mutations, we use the updateTime of the WriteResponse as
 * the resulting version for Set, Patch, and Transform mutations. As deletes
 * have no explicit update time, we use the commitTime of the WriteResponse for
 * Delete mutations.
 *
 * If a mutation is acknowledged by the backend but fails the precondition check
 * locally, we return an `UnknownDocument` and rely on Watch to send us the
 * updated version.
 *
 * Note that TransformMutations don't create Documents (in the case of being
 * applied to a NoDocument), even though they would on the backend. This is
 * because the client always combines the TransformMutation with a SetMutation
 * or PatchMutation and we only want to apply the transform if the prior
 * mutation resulted in a Document (always true for a SetMutation, but not
 * necessarily for a PatchMutation).
 *
 * ## Subclassing Notes
 *
 * Subclasses of Mutation need to implement applyToRemoteDocument() and
 * applyToLocalView() to implement the actual behavior of applying the mutation
 * to some source document.
 */ var $e = function() {};

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing a new remote document. If the input document doesn't match the
 * expected state (e.g. it is null or outdated), an `UnknownDocument` can be
 * returned.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param mutationResult The result of applying the mutation from the backend.
 * @return The mutated document. The returned document may be an
 *     UnknownDocument if the mutation could not be applied to the locally
 *     cached base document.
 */ function He(t, e, n) {
    return t instanceof tn ? function(t, e, n) {
        // Unlike applySetMutationToLocalView, if we're applying a mutation to a
        // remote document the server has accepted the mutation so the precondition
        // must have held.
        return new pn(t.key, n.version, t.value, {
            hasCommittedMutations: !0
        });
    }(t, 0, n) : t instanceof en ? function(t, e, n) {
        if (!Qe(t.Ue, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new yn(t.key, n.version);
        var r = nn(t, e);
        return new pn(t.key, n.version, r, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : t instanceof rn ? function(t, e, n) {
        if (_(null != n.transformResults), !Qe(t.Ue, e)) 
        // Since the mutation was not rejected, we know that the  precondition
        // matched on the backend. We therefore must not have the expected version
        // of the document in our cache and return an UnknownDocument with the
        // known updateTime.
        return new yn(t.key, n.version);
        var r = on(t, e), i = 
        /**
 * Creates a list of "transform results" (a transform result is a field value
 * representing the result of applying a transform) for use after a
 * TransformMutation has been acknowledged by the server.
 *
 * @param fieldTransforms The field transforms to apply the result to.
 * @param baseDoc The document prior to applying this mutation batch.
 * @param serverTransformResults The transform results received by the server.
 * @return The transform results list.
 */
        function(t, e, n) {
            var r = [];
            _(t.length === n.length);
            for (var i = 0; i < n.length; i++) {
                var o = t[i], s = o.transform, u = null;
                e instanceof pn && (u = e.field(o.field)), r.push(Oe(s, u, n[i]));
            }
            return r;
        }(t.fieldTransforms, e, n.transformResults), o = n.version, s = sn(t, r.data(), i);
        return new pn(t.key, o, s, {
            hasCommittedMutations: !0
        });
    }(t, e, n) : function(t, e, n) {
        // Unlike applyToLocalView, if we're applying a mutation to a remote
        // document the server has accepted the mutation so the precondition must
        // have held.
        return new dn(t.key, n.version, {
            hasCommittedMutations: !0
        });
    }(t, 0, n);
}

/**
 * Applies this mutation to the given MaybeDocument or null for the purposes
 * of computing the new local view of a document. Both the input and returned
 * documents can be null.
 *
 * @param mutation The mutation to apply.
 * @param maybeDoc The document to mutate. The input document can be null if
 *     the client has no knowledge of the pre-mutation state of the document.
 * @param baseDoc The state of the document prior to this mutation batch. The
 *     input document can be null if the client has no knowledge of the
 *     pre-mutation state of the document.
 * @param localWriteTime A timestamp indicating the local write time of the
 *     batch this mutation is a part of.
 * @return The mutated document. The returned document may be null, but only
 *     if maybeDoc was null and the mutation would not create a new document.
 */ function Xe(t, e, n, r) {
    return t instanceof tn ? function(t, e) {
        if (!Qe(t.Ue, e)) return e;
        var n = Je(e);
        return new pn(t.key, n, t.value, {
            Ke: !0
        });
    }(t, e) : t instanceof en ? function(t, e) {
        if (!Qe(t.Ue, e)) return e;
        var n = Je(e), r = nn(t, e);
        return new pn(t.key, n, r, {
            Ke: !0
        });
    }(t, e) : t instanceof rn ? function(t, e, n, r) {
        if (!Qe(t.Ue, e)) return e;
        var i = on(t, e), o = function(t, e, n, r) {
            for (var i = [], o = 0, s = t; o < s.length; o++) {
                var u = s[o], a = u.transform, c = null;
                n instanceof pn && (c = n.field(u.field)), null === c && r instanceof pn && (
                // If the current document does not contain a value for the mutated
                // field, use the value that existed before applying this mutation
                // batch. This solves an edge case where a PatchMutation clears the
                // values in a nested map before the TransformMutation is applied.
                c = r.field(u.field)), i.push(Le(a, c, e));
            }
            return i;
        }(t.fieldTransforms, n, e, r), s = sn(t, i.data(), o);
        return new pn(t.key, i.version, s, {
            Ke: !0
        });
    }(t, e, r, n) : function(t, e) {
        return Qe(t.Ue, e) ? new dn(t.key, G.min()) : e;
    }(t, e);
}

/**
 * If this mutation is not idempotent, returns the base value to persist with
 * this mutation. If a base value is returned, the mutation is always applied
 * to this base value, even if document has already been updated.
 *
 * The base value is a sparse object that consists of only the document
 * fields for which this mutation contains a non-idempotent transformation
 * (e.g. a numeric increment). The provided value guarantees consistent
 * behavior for non-idempotent transforms and allow us to return the same
 * latency-compensated value even if the backend has already applied the
 * mutation. The base value is null for idempotent mutations, as they can be
 * re-played even if the backend has already applied them.
 *
 * @return a base value to store along with the mutation, or null for
 * idempotent mutations.
 */ function Ye(t, e) {
    return t instanceof rn ? function(t, e) {
        for (var n = null, r = 0, i = t.fieldTransforms; r < i.length; r++) {
            var o = i[r], s = e instanceof pn ? e.field(o.field) : void 0, u = Re(o.transform, s || null);
            null != u && (n = null == n ? (new hn).set(o.field, u) : n.set(o.field, u));
        }
        return n ? n.Ge() : null;
    }(t, e) : null;
}

function Ze(t, e) {
    return t.type === e.type && !!t.key.isEqual(e.key) && !!t.Ue.isEqual(e.Ue) && (0 /* Set */ === t.type ? t.value.isEqual(e.value) : 1 /* Patch */ === t.type ? t.data.isEqual(e.data) && t.Le.isEqual(e.Le) : 2 /* Transform */ !== t.type || P(t.fieldTransforms, t.fieldTransforms, (function(t, e) {
        return function(t, e) {
            return t.field.isEqual(e.field) && function(t, e) {
                return t instanceof Ue && e instanceof Ue || t instanceof Me && e instanceof Me ? P(t.elements, e.elements, Ft) : t instanceof Fe && e instanceof Fe ? Ft(t.qe, e.qe) : t instanceof Ve && e instanceof Ve;
            }(t.transform, e.transform);
        }(t, e);
    })));
}

/**
 * Returns the version from the given document for use as the result of a
 * mutation. Mutations are defined to return the version of the base document
 * only if it is an existing document. Deleted and unknown documents have a
 * post-mutation version of SnapshotVersion.min().
 */ function Je(t) {
    return t instanceof pn ? t.version : G.min();
}

/**
 * A mutation that creates or replaces the document at the given key with the
 * object value contents.
 */ var tn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).key = t, i.value = n, i.Ue = r, i.type = 0 /* Set */ , 
        i;
    }
    return t(n, e), n;
}($e), en = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this) || this).key = t, o.data = n, o.Le = r, o.Ue = i, o.type = 1 /* Patch */ , 
        o;
    }
    return t(n, e), n;
}($e);

function nn(t, e) {
    return function(t, e) {
        var n = new hn(e);
        return t.Le.fields.forEach((function(e) {
            if (!e._()) {
                var r = t.data.field(e);
                null !== r ? n.set(e, r) : n.delete(e);
            }
        })), n.Ge();
    }(t, e instanceof pn ? e.data() : cn.empty());
}

var rn = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.fieldTransforms = n, r.type = 2 /* Transform */ , 
        // NOTE: We set a precondition of exists: true as a safety-check, since we
        // always combine TransformMutations with a SetMutation or PatchMutation which
        // (if successful) should end up with an existing document.
        r.Ue = Ke.exists(!0), r;
    }
    return t(n, e), n;
}($e);

function on(t, e) {
    return e;
}

function sn(t, e, n) {
    for (var r = new hn(e), i = 0; i < t.fieldTransforms.length; i++) {
        var o = t.fieldTransforms[i];
        r.set(o.field, n[i]);
    }
    return r.Ge();
}

/** A mutation that deletes the document at the given key. */ var un = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.Ue = n, r.type = 3 /* Delete */ , r;
    }
    return t(n, e), n;
}($e), an = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).key = t, r.Ue = n, r.type = 4 /* Verify */ , r;
    }
    return t(n, e), n;
}($e), cn = /** @class */ function() {
    function t(t) {
        this.proto = t;
    }
    return t.empty = function() {
        return new t({
            mapValue: {}
        });
    }, 
    /**
     * Returns the value at the given path or null.
     *
     * @param path the path to search
     * @return The value at the path or if there it doesn't exist.
     */
    t.prototype.field = function(t) {
        if (t._()) return this.proto;
        for (var e = this.proto, n = 0; n < t.length - 1; ++n) {
            if (!e.mapValue.fields) return null;
            if (!Jt(e = e.mapValue.fields[t.get(n)])) return null;
        }
        return (e = (e.mapValue.fields || {})[t.S()]) || null;
    }, t.prototype.isEqual = function(t) {
        return Ft(this.proto, t.proto);
    }, t;
}(), hn = /** @class */ function() {
    /**
     * @param baseObject The object to mutate.
     */
    function t(t) {
        void 0 === t && (t = cn.empty()), this.ze = t, 
        /** A map that contains the accumulated changes in this builder. */
        this.He = new Map;
    }
    /**
     * Sets the field to the provided value.
     *
     * @param path The field path to set.
     * @param value The value to set.
     * @return The current Builder instance.
     */    return t.prototype.set = function(t, e) {
        return this.Ye(t, e), this;
    }, 
    /**
     * Removes the field at the specified path. If there is no field at the
     * specified path, nothing is changed.
     *
     * @param path The field path to remove.
     * @return The current Builder instance.
     */
    t.prototype.delete = function(t) {
        return this.Ye(t, null), this;
    }, 
    /**
     * Adds `value` to the overlay map at `path`. Creates nested map entries if
     * needed.
     */
    t.prototype.Ye = function(t, e) {
        for (var n = this.He, r = 0; r < t.length - 1; ++r) {
            var i = t.get(r), o = n.get(i);
            o instanceof Map ? 
            // Re-use a previously created map
            n = o : o && 10 /* ObjectValue */ === qt(o) ? (
            // Convert the existing Protobuf MapValue into a map
            o = new Map(Object.entries(o.mapValue.fields || {})), n.set(i, o), n = o) : (
            // Create an empty map to represent the current nesting level
            o = new Map, n.set(i, o), n = o);
        }
        n.set(t.S(), e);
    }, 
    /** Returns an ObjectValue with all mutations applied. */ t.prototype.Ge = function() {
        var t = this.Je(K.k(), this.He);
        return null != t ? new cn(t) : this.ze;
    }, 
    /**
     * Applies any overlays from `currentOverlays` that exist at `currentPath`
     * and returns the merged data at `currentPath` (or null if there were no
     * changes).
     *
     * @param currentPath The path at the current nesting level. Can be set to
     * FieldValue.emptyPath() to represent the root.
     * @param currentOverlays The overlays at the current nesting level in the
     * same format as `overlayMap`.
     * @return The merged data at `currentPath` or null if no modifications
     * were applied.
     */
    t.prototype.Je = function(t, e) {
        var n = this, r = !1, i = this.ze.field(t), o = Jt(i) ? // If there is already data at the current path, base our
        Object.assign({}, i.mapValue.fields) : {};
        return e.forEach((function(e, i) {
            if (e instanceof Map) {
                var s = n.Je(t.child(i), e);
                null != s && (o[i] = s, r = !0);
            } else null !== e ? (o[i] = e, r = !0) : o.hasOwnProperty(i) && (delete o[i], r = !0);
        })), r ? {
            mapValue: {
                fields: o
            }
        } : null;
    }, t;
}();

/**
 * Returns a FieldMask built from all fields in a MapValue.
 */
function fn(t) {
    var e = [];
    return U(t.fields || {}, (function(t, n) {
        var r = new K([ t ]);
        if (Jt(n)) {
            var i = fn(n.mapValue).fields;
            if (0 === i.length) 
            // Preserve the empty map by adding it to the FieldMask.
            e.push(r); else 
            // For nested and non-empty ObjectValues, add the FieldPath of the
            // leaf nodes.
            for (var o = 0, s = i; o < s.length; o++) {
                var u = s[o];
                e.push(r.child(u));
            }
        } else 
        // For nested and non-empty ObjectValues, add the FieldPath of the leaf
        // nodes.
        e.push(r);
    })), new Be(e)
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /**
 * The result of a lookup for a given path may be an existing document or a
 * marker that this document does not exist at a given version.
 */;
}

var ln = function(t, e) {
    this.key = t, this.version = e;
}, pn = /** @class */ function(e) {
    function n(t, n, r, i) {
        var o = this;
        return (o = e.call(this, t, n) || this).Xe = r, o.Ke = !!i.Ke, o.hasCommittedMutations = !!i.hasCommittedMutations, 
        o;
    }
    return t(n, e), n.prototype.field = function(t) {
        return this.Xe.field(t);
    }, n.prototype.data = function() {
        return this.Xe;
    }, n.prototype.Ze = function() {
        return this.Xe.proto;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n && this.key.isEqual(t.key) && this.version.isEqual(t.version) && this.Ke === t.Ke && this.hasCommittedMutations === t.hasCommittedMutations && this.Xe.isEqual(t.Xe);
    }, n.prototype.toString = function() {
        return "Document(" + this.key + ", " + this.version + ", " + this.Xe.toString() + ", {hasLocalMutations: " + this.Ke + "}), {hasCommittedMutations: " + this.hasCommittedMutations + "})";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.Ke || this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n;
}(ln), dn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n) || this).hasCommittedMutations = !(!r || !r.hasCommittedMutations), 
        i;
    }
    return t(n, e), n.prototype.toString = function() {
        return "NoDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return this.hasCommittedMutations;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.hasCommittedMutations === this.hasCommittedMutations && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(ln), yn = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.toString = function() {
        return "UnknownDocument(" + this.key + ", " + this.version + ")";
    }, Object.defineProperty(n.prototype, "hasPendingWrites", {
        get: function() {
            return !0;
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.isEqual = function(t) {
        return t instanceof n && t.version.isEqual(this.version) && t.key.isEqual(this.key);
    }, n;
}(ln);

/**
 * Represents a document in Firestore with a key, version, data and whether the
 * data has local mutations applied to it.
 */
/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Casts `obj` to `T`. Throws if  `obj` is not an instance of `T`.
 *
 * This cast is used in the Lite and Full SDK to verify instance types for
 * arguments passed to the public API.
 */
function vn(t, 
// eslint-disable-next-line @typescript-eslint/no-explicit-any
e) {
    if (!(t instanceof e)) throw e.name === t.constructor.name ? new F(q.INVALID_ARGUMENT, "Type does not match the expected instance. Did you pass '" + e.name + "' from a different Firestore SDK?") : new F(q.INVALID_ARGUMENT, "Expected type '" + e.name + "', but was '" + t.constructor.name + "'");
    return t;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Query encapsulates all the query attributes we support in the SDK. It can
 * be run against the LocalStore, as well as be converted to a `Target` to
 * query the RemoteStore results.
 *
 * Visible for testing.
 */ var mn = /** @class */ function() {
    /**
     * Initializes a Query with a path and optional additional query constraints.
     * Path must currently be empty if this is a collection group query.
     */
    function t(t, e, n, r, i, o /* First */ , s, u) {
        void 0 === e && (e = null), void 0 === n && (n = []), void 0 === r && (r = []), 
        void 0 === i && (i = null), void 0 === o && (o = "F"), void 0 === s && (s = null), 
        void 0 === u && (u = null), this.path = t, this.collectionGroup = e, this.tn = n, 
        this.filters = r, this.limit = i, this.en = o, this.startAt = s, this.endAt = u, 
        this.nn = null, 
        // The corresponding `Target` of this `Query` instance.
        this.sn = null, this.startAt, this.endAt;
    }
    /**
     * Helper to convert a collection group query into a collection query at a
     * specific path. This is used when executing collection group queries, since
     * we have to split the query into a set of collection queries at multiple
     * paths.
     */    return t.prototype.rn = function(e) {
        return new t(e, 
        /*collectionGroup=*/ null, this.tn.slice(), this.filters.slice(), this.limit, this.en, this.startAt, this.endAt);
    }, t.prototype.on = function() {
        return 0 === this.filters.length && null === this.limit && null == this.startAt && null == this.endAt && (0 === this.tn.length || 1 === this.tn.length && this.tn[0].field.O());
    }, t.prototype.hn = function() {
        return !$(this.limit) && "F" /* First */ === this.en;
    }, t.prototype.an = function() {
        return !$(this.limit) && "L" /* Last */ === this.en;
    }, t.prototype.un = function() {
        return this.tn.length > 0 ? this.tn[0].field : null;
    }, t.prototype.cn = function() {
        for (var t = 0, e = this.filters; t < e.length; t++) {
            var n = e[t];
            if (n.ln()) return n.field;
        }
        return null;
    }, t.prototype._n = function(t) {
        for (var e = 0, n = this.filters; e < n.length; e++) {
            var r = n[e];
            if (t.indexOf(r.op) >= 0) return r.op;
        }
        return null;
    }, t;
}();

/** Creates a new Query instance with the options provided. */ function gn(t, e, n, r, i, o, s, u) {
    return new mn(t, e, n, r, i, o, s, u);
}

/** Creates a new Query for a query that matches all documents at `path` */ function wn(t) {
    return new mn(t);
}

/**
 * Creates a new Query for a collection group query that matches all documents
 * within the provided collection group.
 */
/**
 * Returns whether the query matches a collection group rather than a specific
 * collection.
 */ function bn(t) {
    return null !== t.collectionGroup;
}

/**
 * Returns the implicit order by constraint that is used to execute the Query,
 * which can be different from the order by constraints the user provided (e.g.
 * the SDK and backend always orders by `__name__`).
 */ function In(t) {
    var e = vn(t, mn);
    if (null === e.nn) {
        e.nn = [];
        var n = e.cn(), r = e.un();
        if (null !== n && null === r) 
        // In order to implicitly add key ordering, we must also add the
        // inequality filter field for it to be a valid query.
        // Note that the default inequality field and key ordering is ascending.
        n.O() || e.nn.push(new jn(n)), e.nn.push(new jn(K.L(), "asc" /* ASCENDING */)); else {
            for (var i = !1, o = 0, s = e.tn; o < s.length; o++) {
                var u = s[o];
                e.nn.push(u), u.field.O() && (i = !0);
            }
            if (!i) {
                // The order of the implicit key ordering always matches the last
                // explicit order by
                var a = e.tn.length > 0 ? e.tn[e.tn.length - 1].dir : "asc" /* ASCENDING */;
                e.nn.push(new jn(K.L(), a));
            }
        }
    }
    return e.nn;
}

/**
 * Converts this `Query` instance to it's corresponding `Target` representation.
 */ function En(t) {
    var e = vn(t, mn);
    if (!e.sn) if ("F" /* First */ === e.en) e.sn = Z(e.path, e.collectionGroup, In(e), e.filters, e.limit, e.startAt, e.endAt); else {
        for (
        // Flip the orderBy directions since we want the last results
        var n = [], r = 0, i = In(e); r < i.length; r++) {
            var o = i[r], s = "desc" /* DESCENDING */ === o.dir ? "asc" /* ASCENDING */ : "desc" /* DESCENDING */;
            n.push(new jn(o.field, s));
        }
        // We need to swap the cursors to match the now-flipped query ordering.
                var u = e.endAt ? new Cn(e.endAt.position, !e.endAt.before) : null, a = e.startAt ? new Cn(e.startAt.position, !e.startAt.before) : null;
        // Now return as a LimitType.First query.
                e.sn = Z(e.path, e.collectionGroup, n, e.filters, e.limit, u, a);
    }
    return e.sn;
}

function Tn(t, e, n) {
    return new mn(t.path, t.collectionGroup, t.tn.slice(), t.filters.slice(), e, n, t.startAt, t.endAt);
}

function Nn(t, e) {
    return new mn(t.path, t.collectionGroup, t.tn.slice(), t.filters.slice(), t.limit, t.en, e, t.endAt);
}

function An(t, e) {
    return new mn(t.path, t.collectionGroup, t.tn.slice(), t.filters.slice(), t.limit, t.en, t.startAt, e);
}

function _n(t, e) {
    return tt(En(t), En(e)) && t.en === e.en;
}

// TODO(b/29183165): This is used to get a unique string from a query to, for
// example, use as a dictionary key, but the implementation is subject to
// collisions. Make it collision-free.
function Dn(t) {
    return J(En(t)) + "|lt:" + t.en;
}

function Sn(t) {
    return "Query(target=" + function(t) {
        var e = t.path.$();
        return null !== t.collectionGroup && (e += " collectionGroup=" + t.collectionGroup), 
        t.filters.length > 0 && (e += ", filters: [" + t.filters.map((function(t) {
            return (e = t).field.$() + " " + e.op + " " + zt(e.value);
            /** Returns a debug description for `filter`. */            var e;
            /** Filter that matches on key fields (i.e. '__name__'). */        })).join(", ") + "]"), 
        $(t.limit) || (e += ", limit: " + t.limit), t.orderBy.length > 0 && (e += ", orderBy: [" + t.orderBy.map((function(t) {
            return (e = t).field.$() + " (" + e.dir + ")";
            var e;
        })).join(", ") + "]"), t.startAt && (e += ", startAt: " + Mn(t.startAt)), t.endAt && (e += ", endAt: " + Mn(t.endAt)), 
        "Target(" + e + ")";
    }(En(t)) + "; limitType=" + t.en + ")";
}

/** Returns whether `doc` matches the constraints of `query`. */ function xn(t, e) {
    return function(t, e) {
        var n = e.key.path;
        return null !== t.collectionGroup ? e.key.U(t.collectionGroup) && t.path.D(n) : Q.W(t.path) ? t.path.isEqual(n) : t.path.C(n);
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.tn; n < r.length; n++) {
            var i = r[n];
            // order by key always matches
                        if (!i.field.O() && null === e.field(i.field)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        for (var n = 0, r = t.filters; n < r.length; n++) {
            if (!r[n].matches(e)) return !1;
        }
        return !0;
    }(t, e) && function(t, e) {
        return !(t.startAt && !qn(t.startAt, In(t), e)) && (!t.endAt || !qn(t.endAt, In(t), e));
    }(t, e);
}

function kn(t) {
    return function(e, n) {
        for (var r = !1, i = 0, o = In(t); i < o.length; i++) {
            var s = o[i], u = Gn(s, e, n);
            if (0 !== u) return u;
            r = r || s.field.O();
        }
        return 0;
    };
}

var Pn = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this) || this).field = t, i.op = n, i.value = r, i;
    }
    /**
     * Creates a filter based on the provided arguments.
     */    return t(n, e), n.create = function(t, e, r) {
        if (t.O()) return "in" /* IN */ === e ? new On(t, r) : new Ln(t, e, r);
        if (Yt(r)) {
            if ("==" /* EQUAL */ !== e) throw new F(q.INVALID_ARGUMENT, "Invalid query. Null supports only equality comparisons.");
            return new n(t, e, r);
        }
        if (Zt(r)) {
            if ("==" /* EQUAL */ !== e) throw new F(q.INVALID_ARGUMENT, "Invalid query. NaN supports only equality comparisons.");
            return new n(t, e, r);
        }
        return "array-contains" /* ARRAY_CONTAINS */ === e ? new Rn(t, r) : "in" /* IN */ === e ? new Vn(t, r) : "array-contains-any" /* ARRAY_CONTAINS_ANY */ === e ? new Un(t, r) : new n(t, e, r);
    }, n.prototype.matches = function(t) {
        var e = t.field(this.field);
        // Only compare types with matching backend order (such as double and int).
                return null !== e && qt(this.value) === qt(e) && this.fn(Gt(e, this.value));
    }, n.prototype.fn = function(t) {
        switch (this.op) {
          case "<" /* LESS_THAN */ :
            return t < 0;

          case "<=" /* LESS_THAN_OR_EQUAL */ :
            return t <= 0;

          case "==" /* EQUAL */ :
            return 0 === t;

          case ">" /* GREATER_THAN */ :
            return t > 0;

          case ">=" /* GREATER_THAN_OR_EQUAL */ :
            return t >= 0;

          default:
            return A();
        }
    }, n.prototype.ln = function() {
        return [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , ">=" /* GREATER_THAN_OR_EQUAL */ ].indexOf(this.op) >= 0;
    }, n;
}((function() {}));

var Ln = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, t, n, r) || this).key = Q.B(r.referenceValue), i;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = Q.P(t.key, this.key);
        return this.fn(e);
    }, n;
}(Pn), On = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this, t, "in" /* IN */ , n) || this).keys = (n.arrayValue.values || []).map((function(t) {
            return Q.B(t.referenceValue);
        })), r;
    }
    return t(n, e), n.prototype.matches = function(t) {
        return this.keys.some((function(e) {
            return e.isEqual(t.key);
        }));
    }, n;
}(Pn), Rn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains" /* ARRAY_CONTAINS */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return Xt(e) && jt(e.arrayValue, this.value);
    }, n;
}(Pn), Vn = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "in" /* IN */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = t.field(this.field);
        return null !== e && jt(this.value.arrayValue, e);
    }, n;
}(Pn), Un = /** @class */ function(e) {
    function n(t, n) {
        return e.call(this, t, "array-contains-any" /* ARRAY_CONTAINS_ANY */ , n) || this;
    }
    return t(n, e), n.prototype.matches = function(t) {
        var e = this, n = t.field(this.field);
        return !(!Xt(n) || !n.arrayValue.values) && n.arrayValue.values.some((function(t) {
            return jt(e.value.arrayValue, t);
        }));
    }, n;
}(Pn), Cn = function(t, e) {
    this.position = t, this.before = e;
};

/** Filter that matches on key fields within an array. */ function Mn(t) {
    // TODO(b/29183165): Make this collision robust.
    return (t.before ? "b" : "a") + ":" + t.position.map((function(t) {
        return zt(t);
    })).join(",");
}

/**
 * Returns true if a document sorts before a bound using the provided sort
 * order.
 */ function qn(t, e, n) {
    for (var r = 0, i = 0; i < t.position.length; i++) {
        var o = e[i], s = t.position[i];
        if (r = o.field.O() ? Q.P(Q.B(s.referenceValue), n.key) : Gt(s, n.field(o.field)), 
        "desc" /* DESCENDING */ === o.dir && (r *= -1), 0 !== r) break;
    }
    return t.before ? r <= 0 : r < 0;
}

function Fn(t, e) {
    if (null === t) return null === e;
    if (null === e) return !1;
    if (t.before !== e.before || t.position.length !== e.position.length) return !1;
    for (var n = 0; n < t.position.length; n++) if (!Ft(t.position[n], e.position[n])) return !1;
    return !0;
}

/**
 * An ordering on a field, in some Direction. Direction defaults to ASCENDING.
 */ var jn = function(t, e /* ASCENDING */) {
    void 0 === e && (e = "asc"), this.field = t, this.dir = e;
};

function Gn(t, e, n) {
    var r = t.field.O() ? Q.P(e.key, n.key) : function(t, e, n) {
        var r = e.field(t), i = n.field(t);
        return null !== r && null !== i ? Gt(r, i) : A();
    }(t.field, e, n);
    switch (t.dir) {
      case "asc" /* ASCENDING */ :
        return r;

      case "desc" /* DESCENDING */ :
        return -1 * r;

      default:
        return A();
    }
}

function Bn(t, e) {
    return t.dir === e.dir && t.field.isEqual(e.field);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A batch of mutations that will be sent as one unit to the backend.
 */ var zn = /** @class */ function() {
    /**
     * @param batchId The unique ID of this mutation batch.
     * @param localWriteTime The original write time of this mutation.
     * @param baseMutations Mutations that are used to populate the base
     * values when this mutation is applied locally. This can be used to locally
     * overwrite values that are persisted in the remote document cache. Base
     * mutations are never sent to the backend.
     * @param mutations The user-provided mutations in this mutation batch.
     * User-provided mutations are applied both locally and remotely on the
     * backend.
     */
    function t(t, e, n, r) {
        this.batchId = t, this.dn = e, this.baseMutations = n, this.mutations = r
        /**
     * Applies all the mutations in this MutationBatch to the specified document
     * to create a new remote document
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     * @param batchResult The result of applying the MutationBatch to the
     * backend.
     */;
    }
    return t.prototype.wn = function(t, e, n) {
        for (var r = n.Tn, i = 0; i < this.mutations.length; i++) {
            var o = this.mutations[i];
            o.key.isEqual(t) && (e = He(o, e, r[i]));
        }
        return e;
    }, 
    /**
     * Computes the local view of a document given all the mutations in this
     * batch.
     *
     * @param docKey The key of the document to apply mutations to.
     * @param maybeDoc The document to apply mutations to.
     */
    t.prototype.En = function(t, e) {
        // First, apply the base state. This allows us to apply non-idempotent
        // transform against a consistent set of values.
        for (var n = 0, r = this.baseMutations; n < r.length; n++) {
            var i = r[n];
            i.key.isEqual(t) && (e = Xe(i, e, e, this.dn));
        }
        // Second, apply all user-provided mutations.
        for (var o = e, s = 0, u = this.mutations; s < u.length; s++) {
            var a = u[s];
            a.key.isEqual(t) && (e = Xe(a, e, o, this.dn));
        }
        return e;
    }, 
    /**
     * Computes the local view for all provided documents given the mutations in
     * this batch.
     */
    t.prototype.In = function(t) {
        var e = this, n = t;
        // TODO(mrschmidt): This implementation is O(n^2). If we apply the mutations
        // directly (as done in `applyToLocalView()`), we can reduce the complexity
        // to O(n).
                return this.mutations.forEach((function(r) {
            var i = e.En(r.key, t.get(r.key));
            i && (n = n.nt(r.key, i));
        })), n;
    }, t.prototype.keys = function() {
        return this.mutations.reduce((function(t, e) {
            return t.add(e.key);
        }), It());
    }, t.prototype.isEqual = function(t) {
        return this.batchId === t.batchId && P(this.mutations, t.mutations, (function(t, e) {
            return Ze(t, e);
        })) && P(this.baseMutations, t.baseMutations, (function(t, e) {
            return Ze(t, e);
        }));
    }, t;
}(), Wn = /** @class */ function() {
    function t(t, e, n, 
    /**
     * A pre-computed mapping from each mutated document to the resulting
     * version.
     */
    r) {
        this.batch = t, this.mn = e, this.Tn = n, this.An = r
        /**
     * Creates a new MutationBatchResult for the given batch and results. There
     * must be one result for each mutation in the batch. This static factory
     * caches a document=>version mapping (docVersions).
     */;
    }
    return t.from = function(e, n, r) {
        _(e.mutations.length === r.length);
        for (var i = wt, o = e.mutations, s = 0; s < o.length; s++) i = i.nt(o[s].key, r[s].version);
        return new t(e, n, r, i);
    }, t;
}(), Kn = /** @class */ function() {
    function t(t) {
        var e = this;
        // NOTE: next/catchCallback will always point to our own wrapper functions,
        // not the user's raw next() or catch() callbacks.
                this.Rn = null, this.Pn = null, 
        // When the operation resolves, we'll set result or error and mark isDone.
        this.result = void 0, this.error = void 0, this.gn = !1, 
        // Set to true when .then() or .catch() are called and prevents additional
        // chaining.
        this.Vn = !1, t((function(t) {
            e.gn = !0, e.result = t, e.Rn && 
            // value should be defined unless T is Void, but we can't express
            // that in the type system.
            e.Rn(t);
        }), (function(t) {
            e.gn = !0, e.error = t, e.Pn && e.Pn(t);
        }));
    }
    return t.prototype.catch = function(t) {
        return this.next(void 0, t);
    }, t.prototype.next = function(e, n) {
        var r = this;
        return this.Vn && A(), this.Vn = !0, this.gn ? this.error ? this.yn(n, this.error) : this.pn(e, this.result) : new t((function(t, i) {
            r.Rn = function(n) {
                r.pn(e, n).next(t, i);
            }, r.Pn = function(e) {
                r.yn(n, e).next(t, i);
            };
        }));
    }, t.prototype.bn = function() {
        var t = this;
        return new Promise((function(e, n) {
            t.next(e, n);
        }));
    }, t.prototype.vn = function(e) {
        try {
            var n = e();
            return n instanceof t ? n : t.resolve(n);
        } catch (e) {
            return t.reject(e);
        }
    }, t.prototype.pn = function(e, n) {
        return e ? this.vn((function() {
            return e(n);
        })) : t.resolve(n);
    }, t.prototype.yn = function(e, n) {
        return e ? this.vn((function() {
            return e(n);
        })) : t.reject(n);
    }, t.resolve = function(e) {
        return new t((function(t, n) {
            t(e);
        }));
    }, t.reject = function(e) {
        return new t((function(t, n) {
            n(e);
        }));
    }, t.Sn = function(
    // Accept all Promise types in waitFor().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    e) {
        return new t((function(t, n) {
            var r = 0, i = 0, o = !1;
            e.forEach((function(e) {
                ++r, e.next((function() {
                    ++i, o && i === r && t();
                }), (function(t) {
                    return n(t);
                }));
            })), o = !0, i === r && t();
        }));
    }, 
    /**
     * Given an array of predicate functions that asynchronously evaluate to a
     * boolean, implements a short-circuiting `or` between the results. Predicates
     * will be evaluated until one of them returns `true`, then stop. The final
     * result will be whether any of them returned `true`.
     */
    t.Dn = function(e) {
        for (var n = t.resolve(!1), r = function(e) {
            n = n.next((function(n) {
                return n ? t.resolve(n) : e();
            }));
        }, i = 0, o = e; i < o.length; i++) {
            r(o[i]);
        }
        return n;
    }, t.forEach = function(t, e) {
        var n = this, r = [];
        return t.forEach((function(t, i) {
            r.push(e.call(n, t, i));
        })), this.Sn(r);
    }, t;
}(), Qn = /** @class */ function() {
    function t() {
        // A mapping of document key to the new cache entry that should be written (or null if any
        // existing cache entry should be removed).
        this.Cn = new M((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), this.Fn = !1;
    }
    return Object.defineProperty(t.prototype, "readTime", {
        get: function() {
            return this.$n;
        },
        set: function(t) {
            this.$n = t;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Buffers a `RemoteDocumentCache.addEntry()` call.
     *
     * You can only modify documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.Nn = function(t, e) {
        this.kn(), this.readTime = e, this.Cn.set(t.key, t);
    }, 
    /**
     * Buffers a `RemoteDocumentCache.removeEntry()` call.
     *
     * You can only remove documents that have already been retrieved via
     * `getEntry()/getEntries()` (enforced via IndexedDbs `apply()`).
     */
    t.prototype.xn = function(t, e) {
        this.kn(), e && (this.readTime = e), this.Cn.set(t, null);
    }, 
    /**
     * Looks up an entry in the cache. The buffered changes will first be checked,
     * and if no buffered change applies, this will forward to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKey The key of the entry to look up.
     * @return The cached Document or NoDocument entry, or null if we have nothing
     * cached.
     */
    t.prototype.Mn = function(t, e) {
        this.kn();
        var n = this.Cn.get(e);
        return void 0 !== n ? Kn.resolve(n) : this.On(t, e);
    }, 
    /**
     * Looks up several entries in the cache, forwarding to
     * `RemoteDocumentCache.getEntry()`.
     *
     * @param transaction The transaction in which to perform any persistence
     *     operations.
     * @param documentKeys The keys of the entries to look up.
     * @return A map of cached `Document`s or `NoDocument`s, indexed by key. If an
     *     entry cannot be found, the corresponding key will be mapped to a null
     *     value.
     */
    t.prototype.getEntries = function(t, e) {
        return this.Ln(t, e);
    }, 
    /**
     * Applies buffered changes to the underlying RemoteDocumentCache, using
     * the provided transaction.
     */
    t.prototype.apply = function(t) {
        return this.kn(), this.Fn = !0, this.qn(t);
    }, 
    /** Helper to assert this.changes is not null  */ t.prototype.kn = function() {}, 
    t;
}(), $n = "The current tab is not in the required state to perform this operation. It might be necessary to refresh the browser tab.", Hn = /** @class */ function() {
    function t() {
        this.Bn = [];
    }
    return t.prototype.Un = function(t) {
        this.Bn.push(t);
    }, t.prototype.Wn = function() {
        this.Bn.forEach((function(t) {
            return t();
        }));
    }, t;
}(), Xn = /** @class */ function() {
    function t(t, e, n) {
        this.Qn = t, this.jn = e, this.Kn = n
        /**
     * Get the local view of the document identified by `key`.
     *
     * @return Local view of the document or null if we don't have any cached
     * state for it.
     */;
    }
    return t.prototype.Gn = function(t, e) {
        var n = this;
        return this.jn.zn(t, e).next((function(r) {
            return n.Hn(t, e, r);
        }));
    }, 
    /** Internal version of `getDocument` that allows reusing batches. */ t.prototype.Hn = function(t, e, n) {
        return this.Qn.Mn(t, e).next((function(t) {
            for (var r = 0, i = n; r < i.length; r++) {
                t = i[r].En(e, t);
            }
            return t;
        }));
    }, 
    // Returns the view of the given `docs` as they would appear after applying
    // all mutations in the given `batches`.
    t.prototype.Yn = function(t, e, n) {
        var r = vt();
        return e.forEach((function(t, e) {
            for (var i = 0, o = n; i < o.length; i++) {
                e = o[i].En(t, e);
            }
            r = r.nt(t, e);
        })), r;
    }, 
    /**
     * Gets the local view of the documents identified by `keys`.
     *
     * If we don't have cached state for a document in `keys`, a NoDocument will
     * be stored for that key in the resulting set.
     */
    t.prototype.Jn = function(t, e) {
        var n = this;
        return this.Qn.getEntries(t, e).next((function(e) {
            return n.Xn(t, e);
        }));
    }, 
    /**
     * Similar to `getDocuments`, but creates the local view from the given
     * `baseDocs` without retrieving documents from the local store.
     */
    t.prototype.Xn = function(t, e) {
        var n = this;
        return this.jn.Zn(t, e).next((function(r) {
            var i = n.Yn(t, e, r), o = yt();
            return i.forEach((function(t, e) {
                // TODO(http://b/32275378): Don't conflate missing / deleted.
                e || (e = new dn(t, G.min())), o = o.nt(t, e);
            })), o;
        }));
    }, 
    /**
     * Performs a query against the local view of all documents.
     *
     * @param transaction The persistence transaction.
     * @param query The query to match documents against.
     * @param sinceReadTime If not set to SnapshotVersion.min(), return only
     *     documents that have been read since this snapshot version (exclusive).
     */
    t.prototype.ts = function(t, e, n) {
        /**
 * Returns whether the query matches a single document by path (rather than a
 * collection).
 */
        return function(t) {
            return Q.W(t.path) && null === t.collectionGroup && 0 === t.filters.length;
        }(e) ? this.es(t, e.path) : bn(e) ? this.ns(t, e, n) : this.ss(t, e, n);
    }, t.prototype.es = function(t, e) {
        // Just do a simple document lookup.
        return this.Gn(t, new Q(e)).next((function(t) {
            var e = gt();
            return t instanceof pn && (e = e.nt(t.key, t)), e;
        }));
    }, t.prototype.ns = function(t, e, n) {
        var r = this, i = e.collectionGroup, o = gt();
        return this.Kn.rs(t, i).next((function(s) {
            return Kn.forEach(s, (function(s) {
                var u = e.rn(s.child(i));
                return r.ss(t, u, n).next((function(t) {
                    t.forEach((function(t, e) {
                        o = o.nt(t, e);
                    }));
                }));
            })).next((function() {
                return o;
            }));
        }));
    }, t.prototype.ss = function(t, e, n) {
        var r, i, o = this;
        // Query the remote documents and overlay mutations.
                return this.Qn.ts(t, e, n).next((function(n) {
            return r = n, o.jn.os(t, e);
        })).next((function(e) {
            return i = e, o.hs(t, i, r).next((function(t) {
                r = t;
                for (var e = 0, n = i; e < n.length; e++) for (var o = n[e], s = 0, u = o.mutations; s < u.length; s++) {
                    var a = u[s], c = a.key, h = r.get(c), f = Xe(a, h, h, o.dn);
                    r = f instanceof pn ? r.nt(c, f) : r.remove(c);
                }
            }));
        })).next((function() {
            // Finally, filter out any documents that don't actually match
            // the query.
            return r.forEach((function(t, n) {
                xn(e, n) || (r = r.remove(t));
            })), r;
        }));
    }, t.prototype.hs = function(t, e, n) {
        for (var r = It(), i = 0, o = e; i < o.length; i++) for (var s = 0, u = o[i].mutations; s < u.length; s++) {
            var a = u[s];
            a instanceof en && null === n.get(a.key) && (r = r.add(a.key));
        }
        var c = n;
        return this.Qn.getEntries(t, r).next((function(t) {
            return t.forEach((function(t, e) {
                null !== e && e instanceof pn && (c = c.nt(t, e));
            })), c;
        }));
    }, t;
}(), Yn = /** @class */ function() {
    function t(t, e, n, r) {
        this.targetId = t, this.fromCache = e, this.as = n, this.us = r;
    }
    return t.cs = function(e, n) {
        for (var r = It(), i = It(), o = 0, s = n.docChanges; o < s.length; o++) {
            var u = s[o];
            switch (u.type) {
              case 0 /* Added */ :
                r = r.add(u.doc.key);
                break;

              case 1 /* Removed */ :
                i = i.add(u.doc.key);
                // do nothing
                        }
        }
        return new t(e, n.fromCache, r, i);
    }, t;
}(), Zn = /** @class */ function() {
    function t(t, e) {
        var n = this;
        this.previousValue = t, e && (e.ls = function(t) {
            return n._s(t);
        }, this.fs = function(t) {
            return e.ds(t);
        });
    }
    return t.prototype._s = function(t) {
        return this.previousValue = Math.max(t, this.previousValue), this.previousValue;
    }, t.prototype.next = function() {
        var t = ++this.previousValue;
        return this.fs && this.fs(t), t;
    }, t;
}();

/** The result of applying a mutation batch to the backend. */ Zn.ws = -1;

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Jn = function() {
    var t = this;
    this.promise = new Promise((function(e, n) {
        t.resolve = e, t.reject = n;
    }));
}, tr = /** @class */ function() {
    function t(
    /**
     * The AsyncQueue to run backoff operations on.
     */
    t, 
    /**
     * The ID to use when scheduling backoff operations on the AsyncQueue.
     */
    e, 
    /**
     * The initial delay (used as the base delay on the first retry attempt).
     * Note that jitter will still be applied, so the actual delay could be as
     * little as 0.5*initialDelayMs.
     */
    n
    /**
     * The multiplier to use to determine the extended base delay after each
     * attempt.
     */ , r
    /**
     * The maximum base delay after which no further backoff is performed.
     * Note that jitter will still be applied, so the actual delay could be as
     * much as 1.5*maxDelayMs.
     */ , i) {
        void 0 === n && (n = 1e3), void 0 === r && (r = 1.5), void 0 === i && (i = 6e4), 
        this.Ts = t, this.Es = e, this.Is = n, this.ms = r, this.As = i, this.Rs = 0, this.Ps = null, 
        /** The last backoff attempt, as epoch milliseconds. */
        this.gs = Date.now(), this.reset();
    }
    /**
     * Resets the backoff delay.
     *
     * The very next backoffAndWait() will have no delay. If it is called again
     * (i.e. due to an error), initialDelayMs (plus jitter) will be used, and
     * subsequent ones will increase according to the backoffFactor.
     */    return t.prototype.reset = function() {
        this.Rs = 0;
    }, 
    /**
     * Resets the backoff delay to the maximum delay (e.g. for use after a
     * RESOURCE_EXHAUSTED error).
     */
    t.prototype.Vs = function() {
        this.Rs = this.As;
    }, 
    /**
     * Returns a promise that resolves after currentDelayMs, and increases the
     * delay for any subsequent attempts. If there was a pending backoff operation
     * already, it will be canceled.
     */
    t.prototype.ys = function(t) {
        var e = this;
        // Cancel any pending backoff operation.
                this.cancel();
        // First schedule using the current base (which may be 0 and should be
        // honored as such).
        var n = Math.floor(this.Rs + this.ps()), r = Math.max(0, Date.now() - this.gs), i = Math.max(0, n - r);
        // Guard against lastAttemptTime being in the future due to a clock change.
                i > 0 && E("ExponentialBackoff", "Backing off for " + i + " ms (base delay: " + this.Rs + " ms, delay with jitter: " + n + " ms, last attempt: " + r + " ms ago)"), 
        this.Ps = this.Ts.bs(this.Es, i, (function() {
            return e.gs = Date.now(), t();
        })), 
        // Apply backoff factor to determine next delay and ensure it is within
        // bounds.
        this.Rs *= this.ms, this.Rs < this.Is && (this.Rs = this.Is), this.Rs > this.As && (this.Rs = this.As);
    }, t.prototype.vs = function() {
        null !== this.Ps && (this.Ps.Ss(), this.Ps = null);
    }, t.prototype.cancel = function() {
        null !== this.Ps && (this.Ps.cancel(), this.Ps = null);
    }, 
    /** Returns a random value in the range [-currentBaseMs/2, currentBaseMs/2] */ t.prototype.ps = function() {
        return (Math.random() - .5) * this.Rs;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A helper for running delayed tasks following an exponential backoff curve
 * between attempts.
 *
 * Each delay is made up of a "base" delay which follows the exponential
 * backoff curve, and a +/- 50% "jitter" that is calculated and added to the
 * base delay. This prevents clients from accidentally synchronizing their
 * delays causing spikes of load to the backend.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Encodes a resource path into a IndexedDb-compatible string form.
 */
function er(t) {
    for (var e = "", n = 0; n < t.length; n++) e.length > 0 && (e = rr(e)), e = nr(t.get(n), e);
    return rr(e);
}

/** Encodes a single segment of a resource path into the given result */ function nr(t, e) {
    for (var n = e, r = t.length, i = 0; i < r; i++) {
        var o = t.charAt(i);
        switch (o) {
          case "\0":
            n += "";
            break;

          case "":
            n += "";
            break;

          default:
            n += o;
        }
    }
    return n;
}

/** Encodes a path separator into the given result */ function rr(t) {
    return t + "";
}

/**
 * Decodes the given IndexedDb-compatible string form of a resource path into
 * a ResourcePath instance. Note that this method is not suitable for use with
 * decoding resource names from the server; those are One Platform format
 * strings.
 */ function ir(t) {
    // Event the empty path must encode as a path of at least length 2. A path
    // with exactly 2 must be the empty path.
    var e = t.length;
    if (_(e >= 2), 2 === e) return _("" === t.charAt(0) && "" === t.charAt(1)), z.k();
    // Escape characters cannot exist past the second-to-last position in the
    // source value.
        for (var n = e - 2, r = [], i = "", o = 0; o < e; ) {
        // The last two characters of a valid encoded path must be a separator, so
        // there must be an end to this segment.
        var s = t.indexOf("", o);
        switch ((s < 0 || s > n) && A(), t.charAt(s + 1)) {
          case "":
            var u = t.substring(o, s), a = void 0;
            0 === i.length ? 
            // Avoid copying for the common case of a segment that excludes \0
            // and \001
            a = u : (a = i += u, i = ""), r.push(a);
            break;

          case "":
            i += t.substring(o, s), i += "\0";
            break;

          case "":
            // The escape character can be used in the output to encode itself.
            i += t.substring(o, s + 1);
            break;

          default:
            A();
        }
        o = s + 2;
    }
    return new z(r);
}

/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * An in-memory implementation of IndexManager.
 */ var or = /** @class */ function() {
    function t() {
        this.Ds = new sr;
    }
    return t.prototype.Cs = function(t, e) {
        return this.Ds.add(e), Kn.resolve();
    }, t.prototype.rs = function(t, e) {
        return Kn.resolve(this.Ds.getEntries(e));
    }, t;
}(), sr = /** @class */ function() {
    function t() {
        this.index = {};
    }
    // Returns false if the entry already existed.
        return t.prototype.add = function(t) {
        var e = t.S(), n = t.p(), r = this.index[e] || new lt(z.P), i = !r.has(n);
        return this.index[e] = r.add(n), i;
    }, t.prototype.has = function(t) {
        var e = t.S(), n = t.p(), r = this.index[e];
        return r && r.has(n);
    }, t.prototype.getEntries = function(t) {
        return (this.index[t] || new lt(z.P)).F();
    }, t;
}(), ur = /** @class */ function() {
    function t() {
        /**
         * An in-memory copy of the index entries we've already written since the SDK
         * launched. Used to avoid re-writing the same entry repeatedly.
         *
         * This is *NOT* a complete cache of what's in persistence and so can never be used to
         * satisfy reads.
         */
        this.Fs = new sr;
    }
    /**
     * Adds a new entry to the collection parent index.
     *
     * Repeated calls for the same collectionPath should be avoided within a
     * transaction as IndexedDbIndexManager only caches writes once a transaction
     * has been committed.
     */    return t.prototype.Cs = function(t, e) {
        var n = this;
        if (!this.Fs.has(e)) {
            var r = e.S(), i = e.p();
            t.Un((function() {
                // Add the collection to the in memory cache only if the transaction was
                // successfully committed.
                n.Fs.add(e);
            }));
            var o = {
                collectionId: r,
                parent: er(i)
            };
            return ar(t).put(o);
        }
        return Kn.resolve();
    }, t.prototype.rs = function(t, e) {
        var n = [], r = IDBKeyRange.bound([ e, "" ], [ L(e), "" ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return ar(t).$s(r).next((function(t) {
            for (var r = 0, i = t; r < i.length; r++) {
                var o = i[r];
                // This collectionId guard shouldn't be necessary (and isn't as long
                // as we're running in a real browser), but there's a bug in
                // indexeddbshim that breaks our range in our tests running in node:
                // https://github.com/axemclion/IndexedDBShim/issues/334
                                if (o.collectionId !== e) break;
                n.push(ir(o.parent));
            }
            return n;
        }));
    }, t;
}();

/**
 * Internal implementation of the collection-parent index exposed by MemoryIndexManager.
 * Also used for in-memory caching by IndexedDbIndexManager and initial index population
 * in indexeddb_schema.ts
 */
/**
 * Helper to get a typed SimpleDbStore for the collectionParents
 * document store.
 */
function ar(t) {
    return Pr.Ns(t, ri.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Serializer for values stored in the LocalStore. */ var cr = function(t) {
    this.ks = t;
};

/** Decodes a remote document from storage locally to a Document. */ function hr(t, e) {
    if (e.document) return function(t, e, n) {
        var r = pe(t, e.name), i = ce(e.updateTime), o = new cn({
            mapValue: {
                fields: e.fields
            }
        });
        return new pn(r, i, o, {
            hasCommittedMutations: !!n
        });
    }(t.ks, e.document, !!e.hasCommittedMutations);
    if (e.noDocument) {
        var n = Q.j(e.noDocument.path), r = yr(e.noDocument.readTime);
        return new dn(n, r, {
            hasCommittedMutations: !!e.hasCommittedMutations
        });
    }
    if (e.unknownDocument) {
        var i = Q.j(e.unknownDocument.path), o = yr(e.unknownDocument.version);
        return new yn(i, o);
    }
    return A();
}

/** Encodes a document for storage locally. */ function fr(t, e, n) {
    var r = lr(n), i = e.key.path.p().F();
    if (e instanceof pn) {
        var o = function(t, e) {
            return {
                name: le(t, e.key),
                fields: e.Ze().mapValue.fields,
                updateTime: se(t, e.version.A())
            };
        }(t.ks, e), s = e.hasCommittedMutations;
        return new Zr(
        /* unknownDocument= */ null, 
        /* noDocument= */ null, o, s, r, i);
    }
    if (e instanceof dn) {
        var u = e.key.path.F(), a = dr(e.version), c = e.hasCommittedMutations;
        return new Zr(
        /* unknownDocument= */ null, new Xr(u, a), 
        /* document= */ null, c, r, i);
    }
    if (e instanceof yn) {
        var h = e.key.path.F(), f = dr(e.version);
        return new Zr(new Yr(h, f), 
        /* noDocument= */ null, 
        /* document= */ null, 
        /* hasCommittedMutations= */ !0, r, i);
    }
    return A();
}

function lr(t) {
    var e = t.A();
    return [ e.seconds, e.nanoseconds ];
}

function pr(t) {
    var e = new j(t[0], t[1]);
    return G.I(e);
}

function dr(t) {
    var e = t.A();
    return new Wr(e.seconds, e.nanoseconds);
}

function yr(t) {
    var e = new j(t.seconds, t.nanoseconds);
    return G.I(e);
}

/** Encodes a batch of mutations into a DbMutationBatch for local storage. */
/** Decodes a DbMutationBatch into a MutationBatch */ function vr(t, e) {
    var n = (e.baseMutations || []).map((function(e) {
        return be(t.ks, e);
    })), r = e.mutations.map((function(e) {
        return be(t.ks, e);
    })), i = j.fromMillis(e.localWriteTimeMs);
    return new zn(e.batchId, i, n, r);
}

/** Decodes a DbTarget into TargetData */ function mr(t) {
    var e, n, r = yr(t.readTime), i = void 0 !== t.lastLimboFreeSnapshotVersion ? yr(t.lastLimboFreeSnapshotVersion) : G.min();
    return void 0 !== t.query.documents ? (_(1 === (n = t.query).documents.length), 
    e = En(wn(ye(n.documents[0])))) : e = function(t) {
        var e = ye(t.parent), n = t.structuredQuery, r = n.from ? n.from.length : 0, i = null;
        if (r > 0) {
            _(1 === r);
            var o = n.from[0];
            o.allDescendants ? i = o.collectionId : e = e.child(o.collectionId);
        }
        var s = [];
        n.where && (s = function t(e) {
            return e ? void 0 !== e.unaryFilter ? [ Se(e) ] : void 0 !== e.fieldFilter ? [ De(e) ] : void 0 !== e.compositeFilter ? e.compositeFilter.filters.map((function(e) {
                return t(e);
            })).reduce((function(t, e) {
                return t.concat(e);
            })) : A() : [];
        }(n.where));
        var u = [];
        n.orderBy && (u = n.orderBy.map((function(t) {
            return new jn(_e((e = t).field), 
            // visible for testing
            function(t) {
                switch (t) {
                  case "ASCENDING":
                    return "asc" /* ASCENDING */;

                  case "DESCENDING":
                    return "desc" /* DESCENDING */;

                  default:
                    return;
                }
            }(e.direction));
            var e;
        })));
        var a = null;
        n.limit && (a = function(t) {
            var e;
            return $(e = "object" == typeof t ? t.value : t) ? null : e;
        }(n.limit));
        var c = null;
        n.startAt && (c = Ne(n.startAt));
        var h = null;
        return n.endAt && (h = Ne(n.endAt)), En(gn(e, i, u, s, a, "F" /* First */ , c, h));
    }(t.query), new ot(e, t.targetId, 0 /* Listen */ , t.lastListenSequenceNumber, r, i, nt.fromBase64String(t.resumeToken))
    /** Encodes TargetData into a DbTarget for storage locally. */;
}

function gr(t, e) {
    var n, r = dr(e.X), i = dr(e.lastLimboFreeSnapshotVersion);
    n = et(e.target) ? Ie(t.ks, e.target) : Ee(t.ks, e.target);
    // We can't store the resumeToken as a ByteString in IndexedDb, so we
    // convert it to a base64 string for storage.
    var o = e.resumeToken.toBase64();
    // lastListenSequenceNumber is always 0 until we do real GC.
        return new ti(e.targetId, J(e.target), r, o, e.sequenceNumber, i, n);
}

/**
 * A helper function for figuring out what kind of query has been stored.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var wr = /** @class */ function() {
    /**
     * @param {LocalSerializer} serializer The document serializer.
     * @param {IndexManager} indexManager The query indexes that need to be maintained.
     */
    function t(t, e) {
        this.serializer = t, this.Kn = e
        /**
     * Adds the supplied entries to the cache.
     *
     * All calls of `addEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */;
    }
    return t.prototype.Nn = function(t, e, n) {
        return Ir(t).put(Er(e), n);
    }, 
    /**
     * Removes a document from the cache.
     *
     * All calls of `removeEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()` to ensure proper accounting of metadata.
     */
    t.prototype.xn = function(t, e) {
        var n = Ir(t), r = Er(e);
        return n.delete(r);
    }, 
    /**
     * Updates the current cache size.
     *
     * Callers to `addEntry()` and `removeEntry()` *must* call this afterwards to update the
     * cache's metadata.
     */
    t.prototype.updateMetadata = function(t, e) {
        var n = this;
        return this.getMetadata(t).next((function(r) {
            return r.byteSize += e, n.xs(t, r);
        }));
    }, t.prototype.Mn = function(t, e) {
        var n = this;
        return Ir(t).get(Er(e)).next((function(t) {
            return n.Ms(t);
        }));
    }, 
    /**
     * Looks up an entry in the cache.
     *
     * @param documentKey The key of the entry to look up.
     * @return The cached MaybeDocument entry and its size, or null if we have nothing cached.
     */
    t.prototype.Os = function(t, e) {
        var n = this;
        return Ir(t).get(Er(e)).next((function(t) {
            var e = n.Ms(t);
            return e ? {
                Ls: e,
                size: Tr(t)
            } : null;
        }));
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = vt();
        return this.qs(t, e, (function(t, e) {
            var i = n.Ms(e);
            r = r.nt(t, i);
        })).next((function() {
            return r;
        }));
    }, 
    /**
     * Looks up several entries in the cache.
     *
     * @param documentKeys The set of keys entries to look up.
     * @return A map of MaybeDocuments indexed by key (if a document cannot be
     *     found, the key will be mapped to null) and a map of sizes indexed by
     *     key (zero if the key cannot be found).
     */
    t.prototype.Bs = function(t, e) {
        var n = this, r = vt(), i = new ct(Q.P);
        return this.qs(t, e, (function(t, e) {
            var o = n.Ms(e);
            o ? (r = r.nt(t, o), i = i.nt(t, Tr(e))) : (r = r.nt(t, null), i = i.nt(t, 0));
        })).next((function() {
            return {
                Us: r,
                Ws: i
            };
        }));
    }, t.prototype.qs = function(t, e, n) {
        if (e._()) return Kn.resolve();
        var r = IDBKeyRange.bound(e.first().path.F(), e.last().path.F()), i = e.at(), o = i.dt();
        return Ir(t).Qs({
            range: r
        }, (function(t, e, r) {
            // Go through keys not found in cache.
            for (var s = Q.j(t); o && Q.P(o, s) < 0; ) n(o, null), o = i.dt();
            o && o.isEqual(s) && (
            // Key found in cache.
            n(o, e), o = i.wt() ? i.dt() : null), 
            // Skip to the next key (if there is one).
            o ? r.js(o.path.F()) : r.done();
        })).next((function() {
            // The rest of the keys are not in the cache. One case where `iterate`
            // above won't go through them is when the cache is empty.
            for (;o; ) n(o, null), o = i.wt() ? i.dt() : null;
        }));
    }, t.prototype.ts = function(t, e, n) {
        var r = this, i = gt(), o = e.path.length + 1, s = {};
        if (n.isEqual(G.min())) {
            // Documents are ordered by key, so we can use a prefix scan to narrow
            // down the documents we need to match the query against.
            var u = e.path.F();
            s.range = IDBKeyRange.lowerBound(u);
        } else {
            // Execute an index-free query and filter by read time. This is safe
            // since all document changes to queries that have a
            // lastLimboFreeSnapshotVersion (`sinceReadTime`) have a read time set.
            var a = e.path.F(), c = lr(n);
            s.range = IDBKeyRange.lowerBound([ a, c ], 
            /* open= */ !0), s.index = Zr.collectionReadTimeIndex;
        }
        return Ir(t).Qs(s, (function(t, n, s) {
            // The query is actually returning any path that starts with the query
            // path prefix which may include documents in subcollections. For
            // example, a query on 'rooms' will return rooms/abc/messages/xyx but we
            // shouldn't match it. Fix this by discarding rows with document keys
            // more than one segment longer than the query path.
            if (t.length === o) {
                var u = hr(r.serializer, n);
                e.path.D(u.key.path) ? u instanceof pn && xn(e, u) && (i = i.nt(u.key, u)) : s.done();
            }
        })).next((function() {
            return i;
        }));
    }, 
    /**
     * Returns the set of documents that have changed since the specified read
     * time.
     */
    // PORTING NOTE: This is only used for multi-tab synchronization.
    t.prototype.Ks = function(t, e) {
        var n = this, r = yt(), i = lr(e), o = Ir(t), s = IDBKeyRange.lowerBound(i, !0);
        return o.Qs({
            index: Zr.readTimeIndex,
            range: s
        }, (function(t, e) {
            // Unlike `getEntry()` and others, `getNewDocumentChanges()` parses
            // the documents directly since we want to keep sentinel deletes.
            var o = hr(n.serializer, e);
            r = r.nt(o.key, o), i = e.readTime;
        })).next((function() {
            return {
                Gs: r,
                readTime: pr(i)
            };
        }));
    }, 
    /**
     * Returns the read time of the most recently read document in the cache, or
     * SnapshotVersion.min() if not available.
     */
    // PORTING NOTE: This is only used for multi-tab synchronization.
    t.prototype.zs = function(t) {
        var e = Ir(t), n = G.min();
        // If there are no existing entries, we return SnapshotVersion.min().
                return e.Qs({
            index: Zr.readTimeIndex,
            reverse: !0
        }, (function(t, e, r) {
            e.readTime && (n = pr(e.readTime)), r.done();
        })).next((function() {
            return n;
        }));
    }, t.prototype.Hs = function(e) {
        return new t.Ys(this, !!e && e.Js);
    }, t.prototype.Xs = function(t) {
        return this.getMetadata(t).next((function(t) {
            return t.byteSize;
        }));
    }, t.prototype.getMetadata = function(t) {
        return br(t).get(Jr.key).next((function(t) {
            return _(!!t), t;
        }));
    }, t.prototype.xs = function(t, e) {
        return br(t).put(Jr.key, e);
    }, 
    /**
     * Decodes `remoteDoc` and returns the document (or null, if the document
     * corresponds to the format used for sentinel deletes).
     */
    t.prototype.Ms = function(t) {
        if (t) {
            var e = hr(this.serializer, t);
            return e instanceof dn && e.version.isEqual(G.min()) ? null : e;
        }
        return null;
    }, t;
}();

/**
 * Handles the details of adding and updating documents in the IndexedDbRemoteDocumentCache.
 *
 * Unlike the MemoryRemoteDocumentChangeBuffer, the IndexedDb implementation computes the size
 * delta for all submitted changes. This avoids having to re-read all documents from IndexedDb
 * when we apply the changes.
 */ function br(t) {
    return Pr.Ns(t, Jr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the remoteDocuments object store.
 */ function Ir(t) {
    return Pr.Ns(t, Zr.store);
}

function Er(t) {
    return t.path.F();
}

/**
 * Retrusn an approximate size for the given document.
 */ function Tr(t) {
    var e;
    if (t.document) e = t.document; else if (t.unknownDocument) e = t.unknownDocument; else {
        if (!t.noDocument) throw A();
        e = t.noDocument;
    }
    return JSON.stringify(e).length;
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Offset to ensure non-overlapping target ids. */ wr.Ys = /** @class */ function(e) {
    /**
     * @param documentCache The IndexedDbRemoteDocumentCache to apply the changes to.
     * @param trackRemovals Whether to create sentinel deletes that can be tracked by
     * `getNewDocumentChanges()`.
     */
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).Zs = t, r.Js = n, 
        // A map of document sizes prior to applying the changes in this buffer.
        r.ti = new M((function(t) {
            return t.toString();
        }), (function(t, e) {
            return t.isEqual(e);
        })), r;
    }
    return t(n, e), n.prototype.qn = function(t) {
        var e = this, n = [], r = 0, i = new lt((function(t, e) {
            return k(t.$(), e.$());
        }));
        return this.Cn.forEach((function(o, s) {
            var u = e.ti.get(o);
            if (s) {
                var a = fr(e.Zs.serializer, s, e.readTime);
                i = i.add(o.path.p());
                var c = Tr(a);
                r += c - u, n.push(e.Zs.Nn(t, o, a));
            } else if (r -= u, e.Js) {
                // In order to track removals, we store a "sentinel delete" in the
                // RemoteDocumentCache. This entry is represented by a NoDocument
                // with a version of 0 and ignored by `maybeDecodeDocument()` but
                // preserved in `getNewDocumentChanges()`.
                var h = fr(e.Zs.serializer, new dn(o, G.min()), e.readTime);
                n.push(e.Zs.Nn(t, o, h));
            } else n.push(e.Zs.xn(t, o));
        })), i.forEach((function(r) {
            n.push(e.Zs.Kn.Cs(t, r));
        })), n.push(this.Zs.updateMetadata(t, r)), Kn.Sn(n);
    }, n.prototype.On = function(t, e) {
        var n = this;
        // Record the size of everything we load from the cache so we can compute a delta later.
                return this.Zs.Os(t, e).next((function(t) {
            return null === t ? (n.ti.set(e, 0), null) : (n.ti.set(e, t.size), t.Ls);
        }));
    }, n.prototype.Ln = function(t, e) {
        var n = this;
        // Record the size of everything we load from the cache so we can compute
        // a delta later.
                return this.Zs.Bs(t, e).next((function(t) {
            var e = t.Us;
            // Note: `getAllFromCache` returns two maps instead of a single map from
            // keys to `DocumentSizeEntry`s. This is to allow returning the
            // `NullableMaybeDocumentMap` directly, without a conversion.
            return t.Ws.forEach((function(t, e) {
                n.ti.set(t, e);
            })), e;
        }));
    }, n;
}(Qn);

/**
 * Generates monotonically increasing target IDs for sending targets to the
 * watch stream.
 *
 * The client constructs two generators, one for the target cache, and one for
 * for the sync engine (to generate limbo documents targets). These
 * generators produce non-overlapping IDs (by using even and odd IDs
 * respectively).
 *
 * By separating the target ID space, the query cache can generate target IDs
 * that persist across client restarts, while sync engine can independently
 * generate in-memory target IDs that are transient and can be reused after a
 * restart.
 */
var Nr = /** @class */ function() {
    function t(t) {
        this.ei = t;
    }
    return t.prototype.next = function() {
        return this.ei += 2, this.ei;
    }, t.ni = function() {
        // The target cache generator must return '2' in its first call to `next()`
        // as there is no differentiation in the protocol layer between an unset
        // number and the number '0'. If we were to sent a target with target ID
        // '0', the backend would consider it unset and replace it with its own ID.
        return new t(0);
    }, t.si = function() {
        // Sync engine assigns target IDs for limbo document detection.
        return new t(-1);
    }, t;
}(), Ar = /** @class */ function() {
    function t(t, e) {
        this.ii = t, this.serializer = e;
    }
    // PORTING NOTE: We don't cache global metadata for the target cache, since
    // some of it (in particular `highestTargetId`) can be modified by secondary
    // tabs. We could perhaps be more granular (and e.g. still cache
    // `lastRemoteSnapshotVersion` in memory) but for simplicity we currently go
    // to IndexedDb whenever we need to read metadata. We can revisit if it turns
    // out to have a meaningful performance impact.
        return t.prototype.ri = function(t) {
        var e = this;
        return this.oi(t).next((function(n) {
            var r = new Nr(n.highestTargetId);
            return n.highestTargetId = r.next(), e.hi(t, n).next((function() {
                return n.highestTargetId;
            }));
        }));
    }, t.prototype.ai = function(t) {
        return this.oi(t).next((function(t) {
            return G.I(new j(t.lastRemoteSnapshotVersion.seconds, t.lastRemoteSnapshotVersion.nanoseconds));
        }));
    }, t.prototype.ui = function(t) {
        return this.oi(t).next((function(t) {
            return t.highestListenSequenceNumber;
        }));
    }, t.prototype.ci = function(t, e, n) {
        var r = this;
        return this.oi(t).next((function(i) {
            return i.highestListenSequenceNumber = e, n && (i.lastRemoteSnapshotVersion = n.A()), 
            e > i.highestListenSequenceNumber && (i.highestListenSequenceNumber = e), r.hi(t, i);
        }));
    }, t.prototype.li = function(t, e) {
        var n = this;
        return this._i(t, e).next((function() {
            return n.oi(t).next((function(r) {
                return r.targetCount += 1, n.fi(e, r), n.hi(t, r);
            }));
        }));
    }, t.prototype.di = function(t, e) {
        return this._i(t, e);
    }, t.prototype.wi = function(t, e) {
        var n = this;
        return this.Ti(t, e.targetId).next((function() {
            return _r(t).delete(e.targetId);
        })).next((function() {
            return n.oi(t);
        })).next((function(e) {
            return _(e.targetCount > 0), e.targetCount -= 1, n.hi(t, e);
        }));
    }, 
    /**
     * Drops any targets with sequence number less than or equal to the upper bound, excepting those
     * present in `activeTargetIds`. Document associations for the removed targets are also removed.
     * Returns the number of targets removed.
     */
    t.prototype.Ei = function(t, e, n) {
        var r = this, i = 0, o = [];
        return _r(t).Qs((function(s, u) {
            var a = mr(u);
            a.sequenceNumber <= e && null === n.get(a.targetId) && (i++, o.push(r.wi(t, a)));
        })).next((function() {
            return Kn.Sn(o);
        })).next((function() {
            return i;
        }));
    }, 
    /**
     * Call provided function with each `TargetData` that we have cached.
     */
    t.prototype.pe = function(t, e) {
        return _r(t).Qs((function(t, n) {
            var r = mr(n);
            e(r);
        }));
    }, t.prototype.oi = function(t) {
        return Dr(t).get(ni.key).next((function(t) {
            return _(null !== t), t;
        }));
    }, t.prototype.hi = function(t, e) {
        return Dr(t).put(ni.key, e);
    }, t.prototype._i = function(t, e) {
        return _r(t).put(gr(this.serializer, e));
    }, 
    /**
     * In-place updates the provided metadata to account for values in the given
     * TargetData. Saving is done separately. Returns true if there were any
     * changes to the metadata.
     */
    t.prototype.fi = function(t, e) {
        var n = !1;
        return t.targetId > e.highestTargetId && (e.highestTargetId = t.targetId, n = !0), 
        t.sequenceNumber > e.highestListenSequenceNumber && (e.highestListenSequenceNumber = t.sequenceNumber, 
        n = !0), n;
    }, t.prototype.Ii = function(t) {
        return this.oi(t).next((function(t) {
            return t.targetCount;
        }));
    }, t.prototype.mi = function(t, e) {
        // Iterating by the canonicalId may yield more than one result because
        // canonicalId values are not required to be unique per target. This query
        // depends on the queryTargets index to be efficient.
        var n = J(e), r = IDBKeyRange.bound([ n, Number.NEGATIVE_INFINITY ], [ n, Number.POSITIVE_INFINITY ]), i = null;
        return _r(t).Qs({
            range: r,
            index: ti.queryTargetsIndexName
        }, (function(t, n, r) {
            var o = mr(n);
            // After finding a potential match, check that the target is
            // actually equal to the requested target.
                        tt(e, o.target) && (i = o, r.done());
        })).next((function() {
            return i;
        }));
    }, t.prototype.Ai = function(t, e, n) {
        var r = this, i = [], o = Sr(t);
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
                return e.forEach((function(e) {
            var s = er(e.path);
            i.push(o.put(new ei(n, s))), i.push(r.ii.Ri(t, n, e));
        })), Kn.Sn(i);
    }, t.prototype.Pi = function(t, e, n) {
        var r = this, i = Sr(t);
        // PORTING NOTE: The reverse index (documentsTargets) is maintained by
        // IndexedDb.
                return Kn.forEach(e, (function(e) {
            var o = er(e.path);
            return Kn.Sn([ i.delete([ n, o ]), r.ii.gi(t, n, e) ]);
        }));
    }, t.prototype.Ti = function(t, e) {
        var n = Sr(t), r = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0);
        return n.delete(r);
    }, t.prototype.Vi = function(t, e) {
        var n = IDBKeyRange.bound([ e ], [ e + 1 ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0), r = Sr(t), i = It();
        return r.Qs({
            range: n,
            yi: !0
        }, (function(t, e, n) {
            var r = ir(t[1]), o = new Q(r);
            i = i.add(o);
        })).next((function() {
            return i;
        }));
    }, t.prototype.pi = function(t, e) {
        var n = er(e.path), r = IDBKeyRange.bound([ n ], [ L(n) ], 
        /*lowerOpen=*/ !1, 
        /*upperOpen=*/ !0), i = 0;
        return Sr(t).Qs({
            index: ei.documentTargetsIndex,
            yi: !0,
            range: r
        }, (function(t, e, n) {
            var r = t[0];
            // Having a sentinel row for a document does not count as containing that document;
            // For the target cache, containing the document means the document is part of some
            // target.
                        t[1];
            0 !== r && (i++, n.done());
        })).next((function() {
            return i > 0;
        }));
    }, 
    /**
     * Looks up a TargetData entry by target ID.
     *
     * @param targetId The target ID of the TargetData entry to look up.
     * @return The cached TargetData entry, or null if the cache has no entry for
     * the target.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Me = function(t, e) {
        return _r(t).get(e).next((function(t) {
            return t ? mr(t) : null;
        }));
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Helper to get a typed SimpleDbStore for the queries object store.
 */
function _r(t) {
    return Pr.Ns(t, ti.store);
}

/**
 * Helper to get a typed SimpleDbStore for the target globals object store.
 */ function Dr(t) {
    return Pr.Ns(t, ni.store);
}

/**
 * Helper to get a typed SimpleDbStore for the document target object store.
 */ function Sr(t) {
    return Pr.Ns(t, ei.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var xr = "Failed to obtain exclusive access to the persistence layer. To allow shared access, make sure to invoke `enablePersistence()` with `synchronizeTabs:true` in all tabs. If you are using `experimentalForceOwningTab:true`, make sure that only one tab has persistence enabled at any given time.", kr = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).bi = t, r.vi = n, r;
    }
    return t(n, e), n;
}(Hn), Pr = /** @class */ function() {
    function t(
    /**
     * Whether to synchronize the in-memory state of multiple tabs and share
     * access to local persistence.
     */
    e, n, r, i, o, s, u, a, c, 
    /**
     * If set to true, forcefully obtains database access. Existing tabs will
     * no longer be able to access IndexedDB.
     */
    h) {
        if (this.allowTabSynchronization = e, this.persistenceKey = n, this.clientId = r, 
        this.Ts = o, this.window = s, this.document = u, this.Si = c, this.Di = h, this.Ci = null, 
        this.Fi = !1, this.isPrimary = !1, this.networkEnabled = !0, 
        /** Our window.unload handler, if registered. */
        this.$i = null, this.inForeground = !1, 
        /** Our 'visibilitychange' listener if registered. */
        this.Ni = null, 
        /** The client metadata refresh task. */
        this.ki = null, 
        /** The last time we garbage collected the client metadata object store. */
        this.xi = Number.NEGATIVE_INFINITY, 
        /** A listener to notify on primary state changes. */
        this.Mi = function(t) {
            return Promise.resolve();
        }, !t.Oi()) throw new F(q.UNIMPLEMENTED, "This platform is either missing IndexedDB or is known to have an incomplete implementation. Offline persistence has been disabled.");
        this.ii = new Rr(this, i), this.Li = n + "main", this.serializer = new cr(a), this.qi = new Ar(this.ii, this.serializer), 
        this.Kn = new ur, this.Qn = new wr(this.serializer, this.Kn), this.window && this.window.localStorage ? this.Bi = this.window.localStorage : (this.Bi = null, 
        !1 === h && T("IndexedDbPersistence", "LocalStorage is unavailable. As a result, persistence may not work reliably. In particular enablePersistence() could fail immediately after refreshing the page."));
    }
    return t.Ns = function(t, e) {
        if (t instanceof kr) return ui.Ns(t.bi, e);
        throw A();
    }, 
    /**
     * Attempt to start IndexedDb persistence.
     *
     * @return {Promise<void>} Whether persistence was enabled.
     */
    t.prototype.start = function() {
        var t = this;
        return ui.Ui(this.Li, Br, new zr(this.serializer)).then((function(e) {
            return t.Wi = e, t.Qi();
        })).then((function() {
            if (!t.isPrimary && !t.allowTabSynchronization) 
            // Fail `start()` if `synchronizeTabs` is disabled and we cannot
            // obtain the primary lease.
            throw new F(q.FAILED_PRECONDITION, xr);
            return t.ji(), t.Ki(), t.Gi(), t.runTransaction("getHighestListenSequenceNumber", "readonly", (function(e) {
                return t.qi.ui(e);
            }));
        })).then((function(e) {
            t.Ci = new Zn(e, t.Si);
        })).then((function() {
            t.Fi = !0;
        })).catch((function(e) {
            return t.Wi && t.Wi.close(), Promise.reject(e);
        }));
    }, 
    /**
     * Registers a listener that gets called when the primary state of the
     * instance changes. Upon registering, this listener is invoked immediately
     * with the current primary state.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.zi = function(t) {
        var r = this;
        return this.Mi = function(i) {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(e) {
                    return this.Hi ? [ 2 /*return*/ , t(i) ] : [ 2 /*return*/ ];
                }));
            }));
        }, t(this.isPrimary);
    }, 
    /**
     * Registers a listener that gets called when the database receives a
     * version change event indicating that it has deleted.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.Yi = function(t) {
        var r = this;
        this.Wi.Ji((function(i) {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(e) {
                    switch (e.label) {
                      case 0:
                        return null === i.newVersion ? [ 4 /*yield*/ , t() ] : [ 3 /*break*/ , 2 ];

                      case 1:
                        e.sent(), e.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }, 
    /**
     * Adjusts the current network state in the client's metadata, potentially
     * affecting the primary lease.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.Xi = function(t) {
        var r = this;
        this.networkEnabled !== t && (this.networkEnabled = t, 
        // Schedule a primary lease refresh for immediate execution. The eventual
        // lease update will be propagated via `primaryStateListener`.
        this.Ts.Zi((function() {
            return e(r, void 0, void 0, (function() {
                return n(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        return this.Hi ? [ 4 /*yield*/ , this.Qi() ] : [ 3 /*break*/ , 2 ];

                      case 1:
                        t.sent(), t.label = 2;

                      case 2:
                        return [ 2 /*return*/ ];
                    }
                }));
            }));
        })));
    }, 
    /**
     * Updates the client metadata in IndexedDb and attempts to either obtain or
     * extend the primary lease for the local client. Asynchronously notifies the
     * primary state listener if the client either newly obtained or released its
     * primary lease.
     */
    t.prototype.Qi = function() {
        var t = this;
        return this.runTransaction("updateClientMetadataAndTryBecomePrimary", "readwrite", (function(e) {
            return Or(e).put(new oi(t.clientId, Date.now(), t.networkEnabled, t.inForeground)).next((function() {
                if (t.isPrimary) return t.tr(e).next((function(e) {
                    e || (t.isPrimary = !1, t.Ts.er((function() {
                        return t.Mi(!1);
                    })));
                }));
            })).next((function() {
                return t.nr(e);
            })).next((function(n) {
                return t.isPrimary && !n ? t.sr(e).next((function() {
                    return !1;
                })) : !!n && t.ir(e).next((function() {
                    return !0;
                }));
            }));
        })).catch((function(e) {
            if (hi(e)) 
            // Proceed with the existing state. Any subsequent access to
            // IndexedDB will verify the lease.
            return E("IndexedDbPersistence", "Failed to extend owner lease: ", e), t.isPrimary;
            if (!t.allowTabSynchronization) throw e;
            return E("IndexedDbPersistence", "Releasing owner lease after error during lease refresh", e), 
            /* isPrimary= */ !1;
        })).then((function(e) {
            t.isPrimary !== e && t.Ts.er((function() {
                return t.Mi(e);
            })), t.isPrimary = e;
        }));
    }, t.prototype.tr = function(t) {
        var e = this;
        return Lr(t).get(Kr.key).next((function(t) {
            return Kn.resolve(e.rr(t));
        }));
    }, t.prototype.or = function(t) {
        return Or(t).delete(this.clientId);
    }, 
    /**
     * If the garbage collection threshold has passed, prunes the
     * RemoteDocumentChanges and the ClientMetadata store based on the last update
     * time of all clients.
     */
    t.prototype.hr = function() {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o, s = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return !this.isPrimary || this.ar(this.xi, 18e5) ? [ 3 /*break*/ , 2 ] : (this.xi = Date.now(), 
                    [ 4 /*yield*/ , this.runTransaction("maybeGarbageCollectMultiClientState", "readwrite-primary", (function(e) {
                        var n = t.Ns(e, oi.store);
                        return n.$s().next((function(t) {
                            var e = s.ur(t, 18e5), r = t.filter((function(t) {
                                return -1 === e.indexOf(t);
                            }));
                            // Delete metadata for clients that are no longer considered active.
                                                        return Kn.forEach(r, (function(t) {
                                return n.delete(t.clientId);
                            })).next((function() {
                                return r;
                            }));
                        }));
                    })).catch((function() {
                        return [];
                    })) ]);

                  case 1:
                    // Delete potential leftover entries that may continue to mark the
                    // inactive clients as zombied in LocalStorage.
                    // Ideally we'd delete the IndexedDb and LocalStorage zombie entries for
                    // the client atomically, but we can't. So we opt to delete the IndexedDb
                    // entries first to avoid potentially reviving a zombied client.
                    if (e = n.sent(), this.Bi) for (r = 0, i = e; r < i.length; r++) o = i[r], this.Bi.removeItem(this.cr(o.clientId));
                    n.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Schedules a recurring timer to update the client metadata and to either
     * extend or acquire the primary lease if the client is eligible.
     */
    t.prototype.Gi = function() {
        var t = this;
        this.ki = this.Ts.bs("client_metadata_refresh" /* ClientMetadataRefresh */ , 4e3, (function() {
            return t.Qi().then((function() {
                return t.hr();
            })).then((function() {
                return t.Gi();
            }));
        }));
    }, 
    /** Checks whether `client` is the local client. */ t.prototype.rr = function(t) {
        return !!t && t.ownerId === this.clientId;
    }, 
    /**
     * Evaluate the state of all active clients and determine whether the local
     * client is or can act as the holder of the primary lease. Returns whether
     * the client is eligible for the lease, but does not actually acquire it.
     * May return 'false' even if there is no active leaseholder and another
     * (foreground) client should become leaseholder instead.
     */
    t.prototype.nr = function(t) {
        var e = this;
        return this.Di ? Kn.resolve(!0) : Lr(t).get(Kr.key).next((function(n) {
            // A client is eligible for the primary lease if:
            // - its network is enabled and the client's tab is in the foreground.
            // - its network is enabled and no other client's tab is in the
            //   foreground.
            // - every clients network is disabled and the client's tab is in the
            //   foreground.
            // - every clients network is disabled and no other client's tab is in
            //   the foreground.
            // - the `forceOwningTab` setting was passed in.
            if (null !== n && e.ar(n.leaseTimestampMs, 5e3) && !e.lr(n.ownerId)) {
                if (e.rr(n) && e.networkEnabled) return !0;
                if (!e.rr(n)) {
                    if (!n.allowTabSynchronization) 
                    // Fail the `canActAsPrimary` check if the current leaseholder has
                    // not opted into multi-tab synchronization. If this happens at
                    // client startup, we reject the Promise returned by
                    // `enablePersistence()` and the user can continue to use Firestore
                    // with in-memory persistence.
                    // If this fails during a lease refresh, we will instead block the
                    // AsyncQueue from executing further operations. Note that this is
                    // acceptable since mixing & matching different `synchronizeTabs`
                    // settings is not supported.
                    // TODO(b/114226234): Remove this check when `synchronizeTabs` can
                    // no longer be turned off.
                    throw new F(q.FAILED_PRECONDITION, xr);
                    return !1;
                }
            }
            return !(!e.networkEnabled || !e.inForeground) || Or(t).$s().next((function(t) {
                return void 0 === e.ur(t, 5e3).find((function(t) {
                    if (e.clientId !== t.clientId) {
                        var n = !e.networkEnabled && t.networkEnabled, r = !e.inForeground && t.inForeground, i = e.networkEnabled === t.networkEnabled;
                        if (n || r && i) return !0;
                    }
                    return !1;
                }));
            }));
        })).next((function(t) {
            return e.isPrimary !== t && E("IndexedDbPersistence", "Client " + (t ? "is" : "is not") + " eligible for a primary lease."), 
            t;
        }));
    }, t.prototype._r = function() {
        return e(this, void 0, void 0, (function() {
            var t = this;
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    // The shutdown() operations are idempotent and can be called even when
                    // start() aborted (e.g. because it couldn't acquire the persistence lease).
                    return this.Fi = !1, this.dr(), this.ki && (this.ki.cancel(), this.ki = null), this.wr(), 
                    this.Tr(), [ 4 /*yield*/ , this.runTransaction("shutdown", "readwrite", (function(e) {
                        return t.sr(e).next((function() {
                            return t.or(e);
                        }));
                    })).catch((function(t) {
                        E("IndexedDbPersistence", "Proceeding with shutdown despite failure: ", t);
                    })) ];

                  case 1:
                    // The shutdown() operations are idempotent and can be called even when
                    // start() aborted (e.g. because it couldn't acquire the persistence lease).
                    return e.sent(), this.Wi.close(), 
                    // Remove the entry marking the client as zombied from LocalStorage since
                    // we successfully deleted its metadata from IndexedDb.
                    this.Er(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Returns clients that are not zombied and have an updateTime within the
     * provided threshold.
     */
    t.prototype.ur = function(t, e) {
        var n = this;
        return t.filter((function(t) {
            return n.ar(t.updateTimeMs, e) && !n.lr(t.clientId);
        }));
    }, 
    /**
     * Returns the IDs of the clients that are currently active. If multi-tab
     * is not supported, returns an array that only contains the local client's
     * ID.
     *
     * PORTING NOTE: This is only used for Web multi-tab.
     */
    t.prototype.Ir = function() {
        var t = this;
        return this.runTransaction("getActiveClients", "readonly", (function(e) {
            return Or(e).$s().next((function(e) {
                return t.ur(e, 18e5).map((function(t) {
                    return t.clientId;
                }));
            }));
        }));
    }, Object.defineProperty(t.prototype, "Hi", {
        get: function() {
            return this.Fi;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.mr = function(t) {
        return Cr.Ar(t, this.serializer, this.Kn, this.ii);
    }, t.prototype.Rr = function() {
        return this.qi;
    }, t.prototype.Pr = function() {
        return this.Qn;
    }, t.prototype.gr = function() {
        return this.Kn;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        E("IndexedDbPersistence", "Starting transaction:", t);
        var i, o = "readonly" === e ? "readonly" : "readwrite";
        // Do all transactions as readwrite against all object stores, since we
        // are the only reader/writer.
        return this.Wi.runTransaction(o, si, (function(o) {
            return i = new kr(o, r.Ci ? r.Ci.next() : Zn.ws), "readwrite-primary" === e ? r.tr(i).next((function(t) {
                return !!t || r.nr(i);
            })).next((function(e) {
                if (!e) throw T("Failed to obtain primary lease for action '" + t + "'."), r.isPrimary = !1, 
                r.Ts.er((function() {
                    return r.Mi(!1);
                })), new F(q.FAILED_PRECONDITION, $n);
                return n(i);
            })).next((function(t) {
                return r.ir(i).next((function() {
                    return t;
                }));
            })) : r.Vr(i).next((function() {
                return n(i);
            }));
        })).then((function(t) {
            return i.Wn(), t;
        }));
    }, 
    /**
     * Verifies that the current tab is the primary leaseholder or alternatively
     * that the leaseholder has opted into multi-tab synchronization.
     */
    // TODO(b/114226234): Remove this check when `synchronizeTabs` can no longer
    // be turned off.
    t.prototype.Vr = function(t) {
        var e = this;
        return Lr(t).get(Kr.key).next((function(t) {
            if (null !== t && e.ar(t.leaseTimestampMs, 5e3) && !e.lr(t.ownerId) && !e.rr(t) && !(e.Di || e.allowTabSynchronization && t.allowTabSynchronization)) throw new F(q.FAILED_PRECONDITION, xr);
        }));
    }, 
    /**
     * Obtains or extends the new primary lease for the local client. This
     * method does not verify that the client is eligible for this lease.
     */
    t.prototype.ir = function(t) {
        var e = new Kr(this.clientId, this.allowTabSynchronization, Date.now());
        return Lr(t).put(Kr.key, e);
    }, t.Oi = function() {
        return ui.Oi();
    }, 
    /** Checks the primary lease and removes it if we are the current primary. */ t.prototype.sr = function(t) {
        var e = this, n = Lr(t);
        return n.get(Kr.key).next((function(t) {
            return e.rr(t) ? (E("IndexedDbPersistence", "Releasing primary lease."), n.delete(Kr.key)) : Kn.resolve();
        }));
    }, 
    /** Verifies that `updateTimeMs` is within `maxAgeMs`. */ t.prototype.ar = function(t, e) {
        var n = Date.now();
        return !(t < n - e || t > n && (T("Detected an update time that is in the future: " + t + " > " + n), 
        1));
    }, t.prototype.ji = function() {
        var t = this;
        null !== this.document && "function" == typeof this.document.addEventListener && (this.Ni = function() {
            t.Ts.Zi((function() {
                return t.inForeground = "visible" === t.document.visibilityState, t.Qi();
            }));
        }, this.document.addEventListener("visibilitychange", this.Ni), this.inForeground = "visible" === this.document.visibilityState);
    }, t.prototype.wr = function() {
        this.Ni && (this.document.removeEventListener("visibilitychange", this.Ni), this.Ni = null);
    }, 
    /**
     * Attaches a window.unload handler that will synchronously write our
     * clientId to a "zombie client id" location in LocalStorage. This can be used
     * by tabs trying to acquire the primary lease to determine that the lease
     * is no longer valid even if the timestamp is recent. This is particularly
     * important for the refresh case (so the tab correctly re-acquires the
     * primary lease). LocalStorage is used for this rather than IndexedDb because
     * it is a synchronous API and so can be used reliably from  an unload
     * handler.
     */
    t.prototype.Ki = function() {
        var t, e = this;
        "function" == typeof (null === (t = this.window) || void 0 === t ? void 0 : t.addEventListener) && (this.$i = function() {
            // Note: In theory, this should be scheduled on the AsyncQueue since it
            // accesses internal state. We execute this code directly during shutdown
            // to make sure it gets a chance to run.
            e.dr(), e.Ts.Zi((function() {
                return e._r();
            }));
        }, this.window.addEventListener("unload", this.$i));
    }, t.prototype.Tr = function() {
        this.$i && (this.window.removeEventListener("unload", this.$i), this.$i = null);
    }, 
    /**
     * Returns whether a client is "zombied" based on its LocalStorage entry.
     * Clients become zombied when their tab closes without running all of the
     * cleanup logic in `shutdown()`.
     */
    t.prototype.lr = function(t) {
        var e;
        try {
            var n = null !== (null === (e = this.Bi) || void 0 === e ? void 0 : e.getItem(this.cr(t)));
            return E("IndexedDbPersistence", "Client '" + t + "' " + (n ? "is" : "is not") + " zombied in LocalStorage"), 
            n;
        } catch (t) {
            // Gracefully handle if LocalStorage isn't working.
            return T("IndexedDbPersistence", "Failed to get zombied client id.", t), !1;
        }
    }, 
    /**
     * Record client as zombied (a client that had its tab closed). Zombied
     * clients are ignored during primary tab selection.
     */
    t.prototype.dr = function() {
        if (this.Bi) try {
            this.Bi.setItem(this.cr(this.clientId), String(Date.now()));
        } catch (t) {
            // Gracefully handle if LocalStorage isn't available / working.
            T("Failed to set zombie client id.", t);
        }
    }, 
    /** Removes the zombied client entry if it exists. */ t.prototype.Er = function() {
        if (this.Bi) try {
            this.Bi.removeItem(this.cr(this.clientId));
        } catch (t) {
            // Ignore
        }
    }, t.prototype.cr = function(t) {
        return "firestore_zombie_" + this.persistenceKey + "_" + t;
    }, t;
}();

/**
 * Oldest acceptable age in milliseconds for client metadata before the client
 * is considered inactive and its associated data is garbage collected.
 */
/**
 * Helper to get a typed SimpleDbStore for the primary client object store.
 */
function Lr(t) {
    return Pr.Ns(t, Kr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the client metadata object store.
 */ function Or(t) {
    return Pr.Ns(t, oi.store);
}

/** Provides LRU functionality for IndexedDB persistence. */ var Rr = /** @class */ function() {
    function t(t, e) {
        this.db = t, this.yr = new Ai(this, e);
    }
    return t.prototype.pr = function(t) {
        var e = this.br(t);
        return this.db.Rr().Ii(t).next((function(t) {
            return e.next((function(e) {
                return t + e;
            }));
        }));
    }, t.prototype.br = function(t) {
        var e = 0;
        return this.vr(t, (function(t) {
            e++;
        })).next((function() {
            return e;
        }));
    }, t.prototype.pe = function(t, e) {
        return this.db.Rr().pe(t, e);
    }, t.prototype.vr = function(t, e) {
        return this.Sr(t, (function(t, n) {
            return e(n);
        }));
    }, t.prototype.Ri = function(t, e, n) {
        return Vr(t, n);
    }, t.prototype.gi = function(t, e, n) {
        return Vr(t, n);
    }, t.prototype.Ei = function(t, e, n) {
        return this.db.Rr().Ei(t, e, n);
    }, t.prototype.Dr = function(t, e) {
        return Vr(t, e);
    }, 
    /**
     * Returns true if anything would prevent this document from being garbage
     * collected, given that the document in question is not present in any
     * targets and has a sequence number less than or equal to the upper bound for
     * the collection run.
     */
    t.prototype.Cr = function(t, e) {
        /** Returns true if any mutation queue contains the given document. */
        return function(t, e) {
            var n = !1;
            return Gr(t).Fr((function(r) {
                return Mr(t, r, e).next((function(t) {
                    return t && (n = !0), Kn.resolve(!t);
                }));
            })).next((function() {
                return n;
            }));
        }(t, e);
    }, t.prototype.$r = function(t, e) {
        var n = this, r = this.db.Pr().Hs(), i = [], o = 0;
        return this.Sr(t, (function(s, u) {
            if (u <= e) {
                var a = n.Cr(t, s).next((function(e) {
                    if (!e) 
                    // Our size accounting requires us to read all documents before
                    // removing them.
                    return o++, r.Mn(t, s).next((function() {
                        return r.xn(s), Sr(t).delete([ 0, er(s.path) ]);
                    }));
                }));
                i.push(a);
            }
        })).next((function() {
            return Kn.Sn(i);
        })).next((function() {
            return r.apply(t);
        })).next((function() {
            return o;
        }));
    }, t.prototype.removeTarget = function(t, e) {
        var n = e.Z(t.vi);
        return this.db.Rr().di(t, n);
    }, t.prototype.Nr = function(t, e) {
        return Vr(t, e);
    }, 
    /**
     * Call provided function for each document in the cache that is 'orphaned'. Orphaned
     * means not a part of any target, so the only entry in the target-document index for
     * that document will be the sentinel row (targetId 0), which will also have the sequence
     * number for the last time the document was accessed.
     */
    t.prototype.Sr = function(t, e) {
        var n, r = Sr(t), i = Zn.ws;
        return r.Qs({
            index: ei.documentTargetsIndex
        }, (function(t, r) {
            var o = t[0], s = (t[1], r.path), u = r.sequenceNumber;
            0 === o ? (
            // if nextToReport is valid, report it, this is a new key so the
            // last one must not be a member of any targets.
            i !== Zn.ws && e(new Q(ir(n)), i), 
            // set nextToReport to be this sequence number. It's the next one we
            // might report, if we don't find any targets for this document.
            // Note that the sequence number must be defined when the targetId
            // is 0.
            i = u, n = s) : 
            // set nextToReport to be invalid, we know we don't need to report
            // this one since we found a target for it.
            i = Zn.ws;
        })).next((function() {
            // Since we report sequence numbers after getting to the next key, we
            // need to check if the last key we iterated over was an orphaned
            // document and report it.
            i !== Zn.ws && e(new Q(ir(n)), i);
        }));
    }, t.prototype.kr = function(t) {
        return this.db.Pr().Xs(t);
    }, t;
}();

function Vr(t, e) {
    return Sr(t).put(
    /**
 * @return A value suitable for writing a sentinel row in the target-document
 * store.
 */
    function(t, e) {
        return new ei(0, er(t.path), e);
    }(e, t.vi));
}

/**
 * Generates a string used as a prefix when storing data in IndexedDB and
 * LocalStorage.
 */ function Ur(t, e) {
    // Use two different prefix formats:
    //   * firestore / persistenceKey / projectID . databaseID / ...
    //   * firestore / persistenceKey / projectID / ...
    // projectIDs are DNS-compatible names and cannot contain dots
    // so there's no danger of collisions.
    var n = t.projectId;
    return t.i || (n += "." + t.database), "firestore/" + e + "/" + n + "/"
    /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
    /** A mutation queue for a specific user, backed by IndexedDB. */;
}

var Cr = /** @class */ function() {
    function t(
    /**
     * The normalized userId (e.g. null UID => "" userId) used to store /
     * retrieve mutations.
     */
    t, e, n, r) {
        this.userId = t, this.serializer = e, this.Kn = n, this.ii = r, 
        /**
             * Caches the document keys for pending mutation batches. If the mutation
             * has been removed from IndexedDb, the cached value may continue to
             * be used to retrieve the batch's document keys. To remove a cached value
             * locally, `removeCachedMutationKeys()` should be invoked either directly
             * or through `removeMutationBatches()`.
             *
             * With multi-tab, when the primary client acknowledges or rejects a mutation,
             * this cache is used by secondary clients to invalidate the local
             * view of the documents that were previously affected by the mutation.
             */
        // PORTING NOTE: Multi-tab only.
        this.xr = {}
        /**
     * Creates a new mutation queue for the given user.
     * @param user The user for which to create a mutation queue.
     * @param serializer The serializer to use when persisting to IndexedDb.
     */;
    }
    return t.Ar = function(e, n, r, i) {
        // TODO(mcg): Figure out what constraints there are on userIDs
        // In particular, are there any reserved characters? are empty ids allowed?
        // For the moment store these together in the same mutations table assuming
        // that empty userIDs aren't allowed.
        return _("" !== e.uid), new t(e.Mr() ? e.uid : "", n, r, i);
    }, t.prototype.Or = function(t) {
        var e = !0, n = IDBKeyRange.bound([ this.userId, Number.NEGATIVE_INFINITY ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Fr(t).Qs({
            index: $r.userMutationsIndex,
            range: n
        }, (function(t, n, r) {
            e = !1, r.done();
        })).next((function() {
            return e;
        }));
    }, t.prototype.Lr = function(t, e, n, r) {
        var i = this, o = jr(t), s = Fr(t);
        // The IndexedDb implementation in Chrome (and Firefox) does not handle
        // compound indices that include auto-generated keys correctly. To ensure
        // that the index entry is added correctly in all browsers, we perform two
        // writes: The first write is used to retrieve the next auto-generated Batch
        // ID, and the second write populates the index and stores the actual
        // mutation batch.
        // See: https://bugs.chromium.org/p/chromium/issues/detail?id=701972
        // We write an empty object to obtain key
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return s.add({}).next((function(u) {
            _("number" == typeof u);
            for (var a = new zn(u, e, n, r), c = function(t, e, n) {
                var r = n.baseMutations.map((function(e) {
                    return we(t.ks, e);
                })), i = n.mutations.map((function(e) {
                    return we(t.ks, e);
                }));
                return new $r(e, n.batchId, n.dn.toMillis(), r, i);
            }(i.serializer, i.userId, a), h = [], f = new lt((function(t, e) {
                return k(t.$(), e.$());
            })), l = 0, p = r; l < p.length; l++) {
                var d = p[l], y = Hr.key(i.userId, d.key.path, u);
                f = f.add(d.key.path.p()), h.push(s.put(c)), h.push(o.put(y, Hr.PLACEHOLDER));
            }
            return f.forEach((function(e) {
                h.push(i.Kn.Cs(t, e));
            })), t.Un((function() {
                i.xr[u] = a.keys();
            })), Kn.Sn(h).next((function() {
                return a;
            }));
        }));
    }, t.prototype.qr = function(t, e) {
        var n = this;
        return Fr(t).get(e).next((function(t) {
            return t ? (_(t.userId === n.userId), vr(n.serializer, t)) : null;
        }));
    }, 
    /**
     * Returns the document keys for the mutation batch with the given batchId.
     * For primary clients, this method returns `null` after
     * `removeMutationBatches()` has been called. Secondary clients return a
     * cached result until `removeCachedMutationKeys()` is invoked.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Br = function(t, e) {
        var n = this;
        return this.xr[e] ? Kn.resolve(this.xr[e]) : this.qr(t, e).next((function(t) {
            if (t) {
                var r = t.keys();
                return n.xr[e] = r, r;
            }
            return null;
        }));
    }, t.prototype.Ur = function(t, e) {
        var n = this, r = e + 1, i = IDBKeyRange.lowerBound([ this.userId, r ]), o = null;
        return Fr(t).Qs({
            index: $r.userMutationsIndex,
            range: i
        }, (function(t, e, i) {
            e.userId === n.userId && (_(e.batchId >= r), o = vr(n.serializer, e)), i.done();
        })).next((function() {
            return o;
        }));
    }, t.prototype.Wr = function(t) {
        var e = IDBKeyRange.upperBound([ this.userId, Number.POSITIVE_INFINITY ]), n = -1;
        return Fr(t).Qs({
            index: $r.userMutationsIndex,
            range: e,
            reverse: !0
        }, (function(t, e, r) {
            n = e.batchId, r.done();
        })).next((function() {
            return n;
        }));
    }, t.prototype.Qr = function(t) {
        var e = this, n = IDBKeyRange.bound([ this.userId, -1 ], [ this.userId, Number.POSITIVE_INFINITY ]);
        return Fr(t).$s($r.userMutationsIndex, n).next((function(t) {
            return t.map((function(t) {
                return vr(e.serializer, t);
            }));
        }));
    }, t.prototype.zn = function(t, e) {
        var n = this, r = Hr.prefixForPath(this.userId, e.path), i = IDBKeyRange.lowerBound(r), o = [];
        // Scan the document-mutation index starting with a prefix starting with
        // the given documentKey.
                return jr(t).Qs({
            range: i
        }, (function(r, i, s) {
            var u = r[0], a = r[1], c = r[2], h = ir(a);
            // Only consider rows matching exactly the specific key of
            // interest. Note that because we order by path first, and we
            // order terminators before path separators, we'll encounter all
            // the index rows for documentKey contiguously. In particular, all
            // the rows for documentKey will occur before any rows for
            // documents nested in a subcollection beneath documentKey so we
            // can stop as soon as we hit any such row.
                        if (u === n.userId && e.path.isEqual(h)) 
            // Look up the mutation batch in the store.
            return Fr(t).get(c).next((function(t) {
                if (!t) throw A();
                _(t.userId === n.userId), o.push(vr(n.serializer, t));
            }));
            s.done();
        })).next((function() {
            return o;
        }));
    }, t.prototype.Zn = function(t, e) {
        var n = this, r = new lt(k), i = [];
        return e.forEach((function(e) {
            var o = Hr.prefixForPath(n.userId, e.path), s = IDBKeyRange.lowerBound(o), u = jr(t).Qs({
                range: s
            }, (function(t, i, o) {
                var s = t[0], u = t[1], a = t[2], c = ir(u);
                // Only consider rows matching exactly the specific key of
                // interest. Note that because we order by path first, and we
                // order terminators before path separators, we'll encounter all
                // the index rows for documentKey contiguously. In particular, all
                // the rows for documentKey will occur before any rows for
                // documents nested in a subcollection beneath documentKey so we
                // can stop as soon as we hit any such row.
                                s === n.userId && e.path.isEqual(c) ? r = r.add(a) : o.done();
            }));
            i.push(u);
        })), Kn.Sn(i).next((function() {
            return n.jr(t, r);
        }));
    }, t.prototype.os = function(t, e) {
        var n = this, r = e.path, i = r.length + 1, o = Hr.prefixForPath(this.userId, r), s = IDBKeyRange.lowerBound(o), u = new lt(k);
        return jr(t).Qs({
            range: s
        }, (function(t, e, o) {
            var s = t[0], a = t[1], c = t[2], h = ir(a);
            s === n.userId && r.D(h) ? 
            // Rows with document keys more than one segment longer than the
            // query path can't be matches. For example, a query on 'rooms'
            // can't match the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            h.length === i && (u = u.add(c)) : o.done();
        })).next((function() {
            return n.jr(t, u);
        }));
    }, t.prototype.jr = function(t, e) {
        var n = this, r = [], i = [];
        // TODO(rockwood): Implement this using iterate.
        return e.forEach((function(e) {
            i.push(Fr(t).get(e).next((function(t) {
                if (null === t) throw A();
                _(t.userId === n.userId), r.push(vr(n.serializer, t));
            })));
        })), Kn.Sn(i).next((function() {
            return r;
        }));
    }, t.prototype.Kr = function(t, e) {
        var n = this;
        return qr(t.bi, this.userId, e).next((function(r) {
            return t.Un((function() {
                n.Gr(e.batchId);
            })), Kn.forEach(r, (function(e) {
                return n.ii.Dr(t, e);
            }));
        }));
    }, 
    /**
     * Clears the cached keys for a mutation batch. This method should be
     * called by secondary clients after they process mutation updates.
     *
     * Note that this method does not have to be called from primary clients as
     * the corresponding cache entries are cleared when an acknowledged or
     * rejected batch is removed from the mutation queue.
     */
    // PORTING NOTE: Multi-tab only
    t.prototype.Gr = function(t) {
        delete this.xr[t];
    }, t.prototype.zr = function(t) {
        var e = this;
        return this.Or(t).next((function(n) {
            if (!n) return Kn.resolve();
            // Verify that there are no entries in the documentMutations index if
            // the queue is empty.
                        var r = IDBKeyRange.lowerBound(Hr.prefixForUser(e.userId)), i = [];
            return jr(t).Qs({
                range: r
            }, (function(t, n, r) {
                if (t[0] === e.userId) {
                    var o = ir(t[1]);
                    i.push(o);
                } else r.done();
            })).next((function() {
                _(0 === i.length);
            }));
        }));
    }, t.prototype.pi = function(t, e) {
        return Mr(t, this.userId, e);
    }, 
    // PORTING NOTE: Multi-tab only (state is held in memory in other clients).
    /** Returns the mutation queue's metadata from IndexedDb. */
    t.prototype.Hr = function(t) {
        var e = this;
        return Gr(t).get(this.userId).next((function(t) {
            return t || new Qr(e.userId, -1, 
            /*lastStreamToken=*/ "");
        }));
    }, t;
}();

/**
 * @return true if the mutation queue for the given user contains a pending
 *         mutation for the given key.
 */ function Mr(t, e, n) {
    var r = Hr.prefixForPath(e, n.path), i = r[1], o = IDBKeyRange.lowerBound(r), s = !1;
    return jr(t).Qs({
        range: o,
        yi: !0
    }, (function(t, n, r) {
        var o = t[0], u = t[1];
        t[2];
        o === e && u === i && (s = !0), r.done();
    })).next((function() {
        return s;
    }));
}

function qr(t, e, n) {
    var r = t.store($r.store), i = t.store(Hr.store), o = [], s = IDBKeyRange.only(n.batchId), u = 0, a = r.Qs({
        range: s
    }, (function(t, e, n) {
        return u++, n.delete();
    }));
    o.push(a.next((function() {
        _(1 === u);
    })));
    for (var c = [], h = 0, f = n.mutations; h < f.length; h++) {
        var l = f[h], p = Hr.key(e, l.key.path, n.batchId);
        o.push(i.delete(p)), c.push(l.key);
    }
    return Kn.Sn(o).next((function() {
        return c;
    }));
}

/**
 * Helper to get a typed SimpleDbStore for the mutations object store.
 */ function Fr(t) {
    return Pr.Ns(t, $r.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function jr(t) {
    return Pr.Ns(t, Hr.store);
}

/**
 * Helper to get a typed SimpleDbStore for the mutationQueues object store.
 */ function Gr(t) {
    return Pr.Ns(t, Qr.store);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Schema Version for the Web client:
 * 1.  Initial version including Mutation Queue, Query Cache, and Remote
 *     Document Cache
 * 2.  Used to ensure a targetGlobal object exists and add targetCount to it. No
 *     longer required because migration 3 unconditionally clears it.
 * 3.  Dropped and re-created Query Cache to deal with cache corruption related
 *     to limbo resolution. Addresses
 *     https://github.com/firebase/firebase-ios-sdk/issues/1548
 * 4.  Multi-Tab Support.
 * 5.  Removal of held write acks.
 * 6.  Create document global for tracking document cache size.
 * 7.  Ensure every cached document has a sentinel row with a sequence number.
 * 8.  Add collection-parent index for Collection Group queries.
 * 9.  Change RemoteDocumentChanges store to be keyed by readTime rather than
 *     an auto-incrementing ID. This is required for Index-Free queries.
 * 10. Rewrite the canonical IDs to the explicit Protobuf-based format.
 */ var Br = 10, zr = /** @class */ function() {
    function t(t) {
        this.serializer = t;
    }
    /**
     * Performs database creation and schema upgrades.
     *
     * Note that in production, this method is only ever used to upgrade the schema
     * to SCHEMA_VERSION. Different values of toVersion are only used for testing
     * and local feature development.
     */    return t.prototype.createOrUpgrade = function(t, e, n, r) {
        var i = this;
        _(n < r && n >= 0 && r <= Br);
        var o = new fi(e);
        n < 1 && r >= 1 && (function(t) {
            t.createObjectStore(Kr.store);
        }(t), function(t) {
            t.createObjectStore(Qr.store, {
                keyPath: Qr.keyPath
            }), t.createObjectStore($r.store, {
                keyPath: $r.keyPath,
                autoIncrement: !0
            }).createIndex($r.userMutationsIndex, $r.userMutationsKeyPath, {
                unique: !0
            }), t.createObjectStore(Hr.store);
        }(t), ii(t), function(t) {
            t.createObjectStore(Zr.store);
        }(t));
        // Migration 2 to populate the targetGlobal object no longer needed since
        // migration 3 unconditionally clears it.
        var s = Kn.resolve();
        return n < 3 && r >= 3 && (
        // Brand new clients don't need to drop and recreate--only clients that
        // potentially have corrupt data.
        0 !== n && (function(t) {
            t.deleteObjectStore(ei.store), t.deleteObjectStore(ti.store), t.deleteObjectStore(ni.store);
        }(t), ii(t)), s = s.next((function() {
            /**
     * Creates the target global singleton row.
     *
     * @param {IDBTransaction} txn The version upgrade transaction for indexeddb
     */
            return function(t) {
                var e = t.store(ni.store), n = new ni(
                /*highestTargetId=*/ 0, 
                /*lastListenSequenceNumber=*/ 0, G.min().A(), 
                /*targetCount=*/ 0);
                return e.put(ni.key, n);
            }(o);
        }))), n < 4 && r >= 4 && (0 !== n && (
        // Schema version 3 uses auto-generated keys to generate globally unique
        // mutation batch IDs (this was previously ensured internally by the
        // client). To migrate to the new schema, we have to read all mutations
        // and write them back out. We preserve the existing batch IDs to guarantee
        // consistency with other object stores. Any further mutation batch IDs will
        // be auto-generated.
        s = s.next((function() {
            return function(t, e) {
                return e.store($r.store).$s().next((function(n) {
                    t.deleteObjectStore($r.store), t.createObjectStore($r.store, {
                        keyPath: $r.keyPath,
                        autoIncrement: !0
                    }).createIndex($r.userMutationsIndex, $r.userMutationsKeyPath, {
                        unique: !0
                    });
                    var r = e.store($r.store), i = n.map((function(t) {
                        return r.put(t);
                    }));
                    return Kn.Sn(i);
                }));
            }(t, o);
        }))), s = s.next((function() {
            !function(t) {
                t.createObjectStore(oi.store, {
                    keyPath: oi.keyPath
                });
            }(t);
        }))), n < 5 && r >= 5 && (s = s.next((function() {
            return i.removeAcknowledgedMutations(o);
        }))), n < 6 && r >= 6 && (s = s.next((function() {
            return function(t) {
                t.createObjectStore(Jr.store);
            }(t), i.addDocumentGlobal(o);
        }))), n < 7 && r >= 7 && (s = s.next((function() {
            return i.ensureSequenceNumbers(o);
        }))), n < 8 && r >= 8 && (s = s.next((function() {
            return i.createCollectionParentIndex(t, o);
        }))), n < 9 && r >= 9 && (s = s.next((function() {
            // Multi-Tab used to manage its own changelog, but this has been moved
            // to the DbRemoteDocument object store itself. Since the previous change
            // log only contained transient data, we can drop its object store.
            !function(t) {
                t.objectStoreNames.contains("remoteDocumentChanges") && t.deleteObjectStore("remoteDocumentChanges");
            }(t), function(t) {
                var e = t.objectStore(Zr.store);
                e.createIndex(Zr.readTimeIndex, Zr.readTimeIndexPath, {
                    unique: !1
                }), e.createIndex(Zr.collectionReadTimeIndex, Zr.collectionReadTimeIndexPath, {
                    unique: !1
                });
            }(e);
        }))), n < 10 && r >= 10 && (s = s.next((function() {
            return i.rewriteCanonicalIds(o);
        }))), s;
    }, t.prototype.addDocumentGlobal = function(t) {
        var e = 0;
        return t.store(Zr.store).Qs((function(t, n) {
            e += Tr(n);
        })).next((function() {
            var n = new Jr(e);
            return t.store(Jr.store).put(Jr.key, n);
        }));
    }, t.prototype.removeAcknowledgedMutations = function(t) {
        var e = this, n = t.store(Qr.store), r = t.store($r.store);
        return n.$s().next((function(n) {
            return Kn.forEach(n, (function(n) {
                var i = IDBKeyRange.bound([ n.userId, -1 ], [ n.userId, n.lastAcknowledgedBatchId ]);
                return r.$s($r.userMutationsIndex, i).next((function(r) {
                    return Kn.forEach(r, (function(r) {
                        _(r.userId === n.userId);
                        var i = vr(e.serializer, r);
                        return qr(t, n.userId, i).next((function() {}));
                    }));
                }));
            }));
        }));
    }, 
    /**
     * Ensures that every document in the remote document cache has a corresponding sentinel row
     * with a sequence number. Missing rows are given the most recently used sequence number.
     */
    t.prototype.ensureSequenceNumbers = function(t) {
        var e = t.store(ei.store), n = t.store(Zr.store);
        return t.store(ni.store).get(ni.key).next((function(t) {
            var r = [];
            return n.Qs((function(n, i) {
                var o = new z(n), s = function(t) {
                    return [ 0, er(t) ];
                }(o);
                r.push(e.get(s).next((function(n) {
                    return n ? Kn.resolve() : function(n) {
                        return e.put(new ei(0, er(n), t.highestListenSequenceNumber));
                    }(o);
                })));
            })).next((function() {
                return Kn.Sn(r);
            }));
        }));
    }, t.prototype.createCollectionParentIndex = function(t, e) {
        // Create the index.
        t.createObjectStore(ri.store, {
            keyPath: ri.keyPath
        });
        var n = e.store(ri.store), r = new sr, i = function(t) {
            if (r.add(t)) {
                var e = t.S(), i = t.p();
                return n.put({
                    collectionId: e,
                    parent: er(i)
                });
            }
        };
        // Helper to add an index entry iff we haven't already written it.
        // Index existing remote documents.
                return e.store(Zr.store).Qs({
            yi: !0
        }, (function(t, e) {
            var n = new z(t);
            return i(n.p());
        })).next((function() {
            return e.store(Hr.store).Qs({
                yi: !0
            }, (function(t, e) {
                t[0];
                var n = t[1], r = (t[2], ir(n));
                return i(r.p());
            }));
        }));
    }, t.prototype.rewriteCanonicalIds = function(t) {
        var e = this, n = t.store(ti.store);
        return n.Qs((function(t, r) {
            var i = mr(r), o = gr(e.serializer, i);
            return n.put(o);
        }));
    }, t;
}(), Wr = function(t, e) {
    this.seconds = t, this.nanoseconds = e;
}, Kr = function(t, 
/** Whether to allow shared access from multiple tabs. */
e, n) {
    this.ownerId = t, this.allowTabSynchronization = e, this.leaseTimestampMs = n;
};

/** Performs database creation and schema upgrades. */
/**
 * Name of the IndexedDb object store.
 *
 * Note that the name 'owner' is chosen to ensure backwards compatibility with
 * older clients that only supported single locked access to the persistence
 * layer.
 */
Kr.store = "owner", 
/**
     * The key string used for the single object that exists in the
     * DbPrimaryClient store.
     */
Kr.key = "owner";

var Qr = function(
/**
     * The normalized user ID to which this queue belongs.
     */
t, 
/**
     * An identifier for the highest numbered batch that has been acknowledged
     * by the server. All MutationBatches in this queue with batchIds less
     * than or equal to this value are considered to have been acknowledged by
     * the server.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
e, 
/**
     * A stream token that was previously sent by the server.
     *
     * See StreamingWriteRequest in datastore.proto for more details about
     * usage.
     *
     * After sending this token, earlier tokens may not be used anymore so
     * only a single stream token is retained.
     *
     * NOTE: this is deprecated and no longer used by the code.
     */
n) {
    this.userId = t, this.lastAcknowledgedBatchId = e, this.lastStreamToken = n;
};

/** Name of the IndexedDb object store.  */ Qr.store = "mutationQueues", 
/** Keys are automatically assigned via the userId property. */
Qr.keyPath = "userId";

/**
 * An object to be stored in the 'mutations' store in IndexedDb.
 *
 * Represents a batch of user-level mutations intended to be sent to the server
 * in a single write. Each user-level batch gets a separate DbMutationBatch
 * with a new batchId.
 */
var $r = function(
/**
     * The normalized user ID to which this batch belongs.
     */
t, 
/**
     * An identifier for this batch, allocated using an auto-generated key.
     */
e, 
/**
     * The local write time of the batch, stored as milliseconds since the
     * epoch.
     */
n, 
/**
     * A list of "mutations" that represent a partial base state from when this
     * write batch was initially created. During local application of the write
     * batch, these baseMutations are applied prior to the real writes in order
     * to override certain document fields from the remote document cache. This
     * is necessary in the case of non-idempotent writes (e.g. `increment()`
     * transforms) to make sure that the local view of the modified documents
     * doesn't flicker if the remote document cache receives the result of the
     * non-idempotent write before the write is removed from the queue.
     *
     * These mutations are never sent to the backend.
     */
r, 
/**
     * A list of mutations to apply. All mutations will be applied atomically.
     *
     * Mutations are serialized via toMutation().
     */
i) {
    this.userId = t, this.batchId = e, this.localWriteTimeMs = n, this.baseMutations = r, 
    this.mutations = i;
};

/** Name of the IndexedDb object store.  */ $r.store = "mutations", 
/** Keys are automatically assigned via the userId, batchId properties. */
$r.keyPath = "batchId", 
/** The index name for lookup of mutations by user. */
$r.userMutationsIndex = "userMutationsIndex", 
/** The user mutations index is keyed by [userId, batchId] pairs. */
$r.userMutationsKeyPath = [ "userId", "batchId" ];

var Hr = /** @class */ function() {
    function t() {}
    /**
     * Creates a [userId] key for use in the DbDocumentMutations index to iterate
     * over all of a user's document mutations.
     */    return t.prefixForUser = function(t) {
        return [ t ];
    }, 
    /**
     * Creates a [userId, encodedPath] key for use in the DbDocumentMutations
     * index to iterate over all at document mutations for a given path or lower.
     */
    t.prefixForPath = function(t, e) {
        return [ t, er(e) ];
    }, 
    /**
     * Creates a full index key of [userId, encodedPath, batchId] for inserting
     * and deleting into the DbDocumentMutations index.
     */
    t.key = function(t, e, n) {
        return [ t, er(e), n ];
    }, t;
}();

Hr.store = "documentMutations", 
/**
     * Because we store all the useful information for this store in the key,
     * there is no useful information to store as the value. The raw (unencoded)
     * path cannot be stored because IndexedDb doesn't store prototype
     * information.
     */
Hr.PLACEHOLDER = new Hr;

var Xr = function(t, e) {
    this.path = t, this.readTime = e;
}, Yr = function(t, e) {
    this.path = t, this.version = e;
}, Zr = 
// TODO: We are currently storing full document keys almost three times
// (once as part of the primary key, once - partly - as `parentPath` and once
// inside the encoded documents). During our next migration, we should
// rewrite the primary key as parentPath + document ID which would allow us
// to drop one value.
function(
/**
     * Set to an instance of DbUnknownDocument if the data for a document is
     * not known, but it is known that a document exists at the specified
     * version (e.g. it had a successful update applied to it)
     */
t, 
/**
     * Set to an instance of a DbNoDocument if it is known that no document
     * exists.
     */
e, 
/**
     * Set to an instance of a Document if there's a cached version of the
     * document.
     */
n, 
/**
     * Documents that were written to the remote document store based on
     * a write acknowledgment are marked with `hasCommittedMutations`. These
     * documents are potentially inconsistent with the backend's copy and use
     * the write's commit version as their document version.
     */
r, 
/**
     * When the document was read from the backend. Undefined for data written
     * prior to schema version 9.
     */
i, 
/**
     * The path of the collection this document is part of. Undefined for data
     * written prior to schema version 9.
     */
o) {
    this.unknownDocument = t, this.noDocument = e, this.document = n, this.hasCommittedMutations = r, 
    this.readTime = i, this.parentPath = o;
};

/**
 * Represents a document that is known to exist but whose data is unknown.
 * Stored in IndexedDb as part of a DbRemoteDocument object.
 */ Zr.store = "remoteDocuments", 
/**
     * An index that provides access to all entries sorted by read time (which
     * corresponds to the last modification time of each row).
     *
     * This index is used to provide a changelog for Multi-Tab.
     */
Zr.readTimeIndex = "readTimeIndex", Zr.readTimeIndexPath = "readTime", 
/**
     * An index that provides access to documents in a collection sorted by read
     * time.
     *
     * This index is used to allow the RemoteDocumentCache to fetch newly changed
     * documents in a collection.
     */
Zr.collectionReadTimeIndex = "collectionReadTimeIndex", Zr.collectionReadTimeIndexPath = [ "parentPath", "readTime" ];

/**
 * Contains a single entry that has metadata about the remote document cache.
 */
var Jr = 
/**
     * @param byteSize Approximately the total size in bytes of all the documents in the document
     * cache.
     */
function(t) {
    this.byteSize = t;
};

Jr.store = "remoteDocumentGlobal", Jr.key = "remoteDocumentGlobalKey";

var ti = function(
/**
     * An auto-generated sequential numeric identifier for the query.
     *
     * Queries are stored using their canonicalId as the key, but these
     * canonicalIds can be quite long so we additionally assign a unique
     * queryId which can be used by referenced data structures (e.g.
     * indexes) to minimize the on-disk cost.
     */
t, 
/**
     * The canonical string representing this query. This is not unique.
     */
e, 
/**
     * The last readTime received from the Watch Service for this query.
     *
     * This is the same value as TargetChange.read_time in the protos.
     */
n, 
/**
     * An opaque, server-assigned token that allows watching a query to be
     * resumed after disconnecting without retransmitting all the data
     * that matches the query. The resume token essentially identifies a
     * point in time from which the server should resume sending results.
     *
     * This is related to the snapshotVersion in that the resumeToken
     * effectively also encodes that value, but the resumeToken is opaque
     * and sometimes encodes additional information.
     *
     * A consequence of this is that the resumeToken should be used when
     * asking the server to reason about where this client is in the watch
     * stream, but the client should use the snapshotVersion for its own
     * purposes.
     *
     * This is the same value as TargetChange.resume_token in the protos.
     */
r, 
/**
     * A sequence number representing the last time this query was
     * listened to, used for garbage collection purposes.
     *
     * Conventionally this would be a timestamp value, but device-local
     * clocks are unreliable and they must be able to create new listens
     * even while disconnected. Instead this should be a monotonically
     * increasing number that's incremented on each listen call.
     *
     * This is different from the queryId since the queryId is an
     * immutable identifier assigned to the Query on first use while
     * lastListenSequenceNumber is updated every time the query is
     * listened to.
     */
i, 
/**
     * Denotes the maximum snapshot version at which the associated query view
     * contained no limbo documents.  Undefined for data written prior to
     * schema version 9.
     */
o, 
/**
     * The query for this target.
     *
     * Because canonical ids are not unique we must store the actual query. We
     * use the proto to have an object we can persist without having to
     * duplicate translation logic to and from a `Query` object.
     */
s) {
    this.targetId = t, this.canonicalId = e, this.readTime = n, this.resumeToken = r, 
    this.lastListenSequenceNumber = i, this.lastLimboFreeSnapshotVersion = o, this.query = s;
};

ti.store = "targets", 
/** Keys are automatically assigned via the targetId property. */
ti.keyPath = "targetId", 
/** The name of the queryTargets index. */
ti.queryTargetsIndexName = "queryTargetsIndex", 
/**
     * The index of all canonicalIds to the targets that they match. This is not
     * a unique mapping because canonicalId does not promise a unique name for all
     * possible queries, so we append the targetId to make the mapping unique.
     */
ti.queryTargetsKeyPath = [ "canonicalId", "targetId" ];

/**
 * An object representing an association between a target and a document, or a
 * sentinel row marking the last sequence number at which a document was used.
 * Each document cached must have a corresponding sentinel row before lru
 * garbage collection is enabled.
 *
 * The target associations and sentinel rows are co-located so that orphaned
 * documents and their sequence numbers can be identified efficiently via a scan
 * of this store.
 */
var ei = function(
/**
     * The targetId identifying a target or 0 for a sentinel row.
     */
t, 
/**
     * The path to the document, as encoded in the key.
     */
e, 
/**
     * If this is a sentinel row, this should be the sequence number of the last
     * time the document specified by `path` was used. Otherwise, it should be
     * `undefined`.
     */
n) {
    this.targetId = t, this.path = e, this.sequenceNumber = n;
};

/** Name of the IndexedDb object store.  */ ei.store = "targetDocuments", 
/** Keys are automatically assigned via the targetId, path properties. */
ei.keyPath = [ "targetId", "path" ], 
/** The index name for the reverse index. */
ei.documentTargetsIndex = "documentTargetsIndex", 
/** We also need to create the reverse index for these properties. */
ei.documentTargetsKeyPath = [ "path", "targetId" ];

/**
 * A record of global state tracked across all Targets, tracked separately
 * to avoid the need for extra indexes.
 *
 * This should be kept in-sync with the proto used in the iOS client.
 */
var ni = function(
/**
     * The highest numbered target id across all targets.
     *
     * See DbTarget.targetId.
     */
t, 
/**
     * The highest numbered lastListenSequenceNumber across all targets.
     *
     * See DbTarget.lastListenSequenceNumber.
     */
e, 
/**
     * A global snapshot version representing the last consistent snapshot we
     * received from the backend. This is monotonically increasing and any
     * snapshots received from the backend prior to this version (e.g. for
     * targets resumed with a resumeToken) should be suppressed (buffered)
     * until the backend has caught up to this snapshot version again. This
     * prevents our cache from ever going backwards in time.
     */
n, 
/**
     * The number of targets persisted.
     */
r) {
    this.highestTargetId = t, this.highestListenSequenceNumber = e, this.lastRemoteSnapshotVersion = n, 
    this.targetCount = r;
};

/**
 * The key string used for the single object that exists in the
 * DbTargetGlobal store.
 */ ni.key = "targetGlobalKey", ni.store = "targetGlobal";

/**
 * An object representing an association between a Collection id (e.g. 'messages')
 * to a parent path (e.g. '/chats/123') that contains it as a (sub)collection.
 * This is used to efficiently find all collections to query when performing
 * a Collection Group query.
 */
var ri = function(
/**
     * The collectionId (e.g. 'messages')
     */
t, 
/**
     * The path to the parent (either a document location or an empty path for
     * a root-level collection).
     */
e) {
    this.collectionId = t, this.parent = e;
};

/** Name of the IndexedDb object store. */ function ii(t) {
    t.createObjectStore(ei.store, {
        keyPath: ei.keyPath
    }).createIndex(ei.documentTargetsIndex, ei.documentTargetsKeyPath, {
        unique: !0
    }), 
    // NOTE: This is unique only because the TargetId is the suffix.
    t.createObjectStore(ti.store, {
        keyPath: ti.keyPath
    }).createIndex(ti.queryTargetsIndexName, ti.queryTargetsKeyPath, {
        unique: !0
    }), t.createObjectStore(ni.store);
}

ri.store = "collectionParents", 
/** Keys are automatically assigned via the collectionId, parent properties. */
ri.keyPath = [ "collectionId", "parent" ];

var oi = function(
// Note: Previous schema versions included a field
// "lastProcessedDocumentChangeId". Don't use anymore.
/** The auto-generated client id assigned at client startup. */
t, 
/** The last time this state was updated. */
e, 
/** Whether the client's network connection is enabled. */
n, 
/** Whether this client is running in a foreground tab. */
r) {
    this.clientId = t, this.updateTimeMs = e, this.networkEnabled = n, this.inForeground = r;
};

/** Name of the IndexedDb object store. */ oi.store = "clientMetadata", 
/** Keys are automatically assigned via the clientId properties. */
oi.keyPath = "clientId";

var si = r(r(r([ Qr.store, $r.store, Hr.store, Zr.store, ti.store, Kr.store, ni.store, ei.store ], [ oi.store ]), [ Jr.store ]), [ ri.store ]), ui = /** @class */ function() {
    function t(e) {
        this.db = e, 
        // NOTE: According to https://bugs.webkit.org/show_bug.cgi?id=197050, the
        // bug we're checking for should exist in iOS >= 12.2 and < 13, but for
        // whatever reason it's much harder to hit after 12.2 so we only proactively
        // log on 12.2.
        12.2 === t.Yr(u()) && T("Firestore persistence suffers from a bug in iOS 12.2 Safari that may cause your app to stop working. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.")
        /**
     * Opens the specified database, creating or upgrading it if necessary.
     *
     * Note that `version` must not be a downgrade. IndexedDB does not support downgrading the schema
     * version. We currently do not support any way to do versioning outside of IndexedDB's versioning
     * mechanism, as only version-upgrade transactions are allowed to do things like create
     * objectstores.
     */;
    }
    return t.Ui = function(e, n, r) {
        return E("SimpleDb", "Opening database:", e), new Kn((function(i, o) {
            // TODO(mikelehen): Investigate browser compatibility.
            // https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API/Using_IndexedDB
            // suggests IE9 and older WebKit browsers handle upgrade
            // differently. They expect setVersion, as described here:
            // https://developer.mozilla.org/en-US/docs/Web/API/IDBVersionChangeRequest/setVersion
            var s = indexedDB.open(e, n);
            s.onsuccess = function(e) {
                var n = e.target.result;
                i(new t(n));
            }, s.onblocked = function() {
                o(new F(q.FAILED_PRECONDITION, "Cannot upgrade IndexedDB schema while another tab is open. Close all tabs that access Firestore and reload this page to proceed."));
            }, s.onerror = function(t) {
                var e = t.target.error;
                "VersionError" === e.name ? o(new F(q.FAILED_PRECONDITION, "A newer version of the Firestore SDK was previously used and so the persisted data is not compatible with the version of the SDK you are now using. The SDK will operate with persistence disabled. If you need persistence, please re-upgrade to a newer version of the SDK or else clear the persisted IndexedDB data for your app to start fresh.")) : o(e);
            }, s.onupgradeneeded = function(t) {
                E("SimpleDb", 'Database "' + e + '" requires upgrade from version:', t.oldVersion);
                var n = t.target.result;
                r.createOrUpgrade(n, s.transaction, t.oldVersion, Br).next((function() {
                    E("SimpleDb", "Database upgrade to version " + Br + " complete");
                }));
            };
        })).bn();
    }, 
    /** Deletes the specified database. */ t.delete = function(t) {
        return E("SimpleDb", "Removing database:", t), pi(window.indexedDB.deleteDatabase(t)).bn();
    }, 
    /** Returns true if IndexedDB is available in the current environment. */ t.Oi = function() {
        if ("undefined" == typeof indexedDB) return !1;
        if (t.Jr()) return !0;
        // We extensively use indexed array values and compound keys,
        // which IE and Edge do not support. However, they still have indexedDB
        // defined on the window, so we need to check for them here and make sure
        // to return that persistence is not enabled for those browsers.
        // For tracking support of this feature, see here:
        // https://developer.microsoft.com/en-us/microsoft-edge/platform/status/indexeddbarraysandmultientrysupport/
        // Check the UA string to find out the browser.
                var e = u(), n = t.Yr(e), r = 0 < n && n < 10, i = t.Xr(e), o = 0 < i && i < 4.5;
        // IE 10
        // ua = 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.2; Trident/6.0)';
        // IE 11
        // ua = 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; rv:11.0) like Gecko';
        // Edge
        // ua = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML,
        // like Gecko) Chrome/39.0.2171.71 Safari/537.36 Edge/12.0';
        // iOS Safari: Disable for users running iOS version < 10.
                return !(e.indexOf("MSIE ") > 0 || e.indexOf("Trident/") > 0 || e.indexOf("Edge/") > 0 || r || o);
    }, 
    /**
     * Returns true if the backing IndexedDB store is the Node IndexedDBShim
     * (see https://github.com/axemclion/IndexedDBShim).
     */
    t.Jr = function() {
        var t;
        return "undefined" != typeof process && "YES" === (null === (t = process.env) || void 0 === t ? void 0 : t.Zr);
    }, 
    /** Helper to get a typed SimpleDbStore from a transaction. */ t.Ns = function(t, e) {
        return t.store(e);
    }, 
    // visible for testing
    /** Parse User Agent to determine iOS version. Returns -1 if not found. */
    t.Yr = function(t) {
        var e = t.match(/i(?:phone|pad|pod) os ([\d_]+)/i), n = e ? e[1].split("_").slice(0, 2).join(".") : "-1";
        return Number(n);
    }, 
    // visible for testing
    /** Parse User Agent to determine Android version. Returns -1 if not found. */
    t.Xr = function(t) {
        var e = t.match(/Android ([\d.]+)/i), n = e ? e[1].split(".").slice(0, 2).join(".") : "-1";
        return Number(n);
    }, t.prototype.Ji = function(t) {
        this.db.onversionchange = function(e) {
            return t(e);
        };
    }, t.prototype.runTransaction = function(t, r, i) {
        return e(this, void 0, void 0, (function() {
            var e, o, s, u, a;
            return n(this, (function(c) {
                switch (c.label) {
                  case 0:
                    e = "readonly" === t, o = 0, s = function() {
                        var t, s, a, c, h;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                ++o, t = fi.open(u.db, e ? "readonly" : "readwrite", r), n.label = 1;

                              case 1:
                                // Wait for the transaction to complete (i.e. IndexedDb's onsuccess event to
                                // fire), but still return the original transactionFnResult back to the
                                // caller.
                                return n.trys.push([ 1, 3, , 4 ]), s = i(t).catch((function(e) {
                                    // Abort the transaction if there was an error.
                                    return t.abort(e), Kn.reject(e);
                                })).bn(), a = {}, s.catch((function() {})), [ 4 /*yield*/ , t.to ];

                              case 2:
                                return [ 2 /*return*/ , (a.value = (
                                // Wait for the transaction to complete (i.e. IndexedDb's onsuccess event to
                                // fire), but still return the original transactionFnResult back to the
                                // caller.
                                n.sent(), s), a) ];

                              case 3:
                                return c = n.sent(), h = "FirebaseError" !== c.name && o < 3, E("SimpleDb", "Transaction failed with error: %s. Retrying: %s.", c.message, h), 
                                h ? [ 3 /*break*/ , 4 ] : [ 2 /*return*/ , {
                                    value: Promise.reject(c)
                                } ];

                              case 4:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }, u = this, c.label = 1;

                  case 1:
                    return [ 5 /*yield**/ , s() ];

                  case 2:
                    if ("object" == typeof (a = c.sent())) return [ 2 /*return*/ , a.value ];
                    c.label = 3;

                  case 3:
                    return [ 3 /*break*/ , 1 ];

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.close = function() {
        this.db.close();
    }, t;
}(), ai = /** @class */ function() {
    function t(t) {
        this.eo = t, this.no = !1, this.so = null;
    }
    return Object.defineProperty(t.prototype, "gn", {
        get: function() {
            return this.no;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "io", {
        get: function() {
            return this.so;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "cursor", {
        set: function(t) {
            this.eo = t;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * This function can be called to stop iteration at any point.
     */
    t.prototype.done = function() {
        this.no = !0;
    }, 
    /**
     * This function can be called to skip to that next key, which could be
     * an index or a primary key.
     */
    t.prototype.js = function(t) {
        this.so = t;
    }, 
    /**
     * Delete the current cursor value from the object store.
     *
     * NOTE: You CANNOT do this with a keysOnly query.
     */
    t.prototype.delete = function() {
        return pi(this.eo.delete());
    }, t;
}(), ci = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this, q.UNAVAILABLE, "IndexedDB transaction failed: " + t) || this).name = "IndexedDbTransactionError", 
        n;
    }
    return t(n, e), n;
}(F);

// V2 is no longer usable (see comment at top of file)
// Visible for testing
/**
 * Provides a wrapper around IndexedDb with a simplified interface that uses
 * Promise-like return values to chain operations. Real promises cannot be used
 * since .then() continuations are executed asynchronously (e.g. via
 * .setImmediate), which would cause IndexedDB to end the transaction.
 * See PersistencePromise for more details.
 */
/** Verifies whether `e` is an IndexedDbTransactionError. */ function hi(t) {
    // Use name equality, as instanceof checks on errors don't work with errors
    // that wrap other errors.
    return "IndexedDbTransactionError" === t.name;
}

/**
 * Wraps an IDBTransaction and exposes a store() method to get a handle to a
 * specific object store.
 */ var fi = /** @class */ function() {
    function t(t) {
        var e = this;
        this.transaction = t, this.aborted = !1, 
        /**
             * A promise that resolves with the result of the IndexedDb transaction.
             */
        this.ro = new Jn, this.transaction.oncomplete = function() {
            e.ro.resolve();
        }, this.transaction.onabort = function() {
            t.error ? e.ro.reject(new ci(t.error)) : e.ro.resolve();
        }, this.transaction.onerror = function(t) {
            var n = yi(t.target.error);
            e.ro.reject(new ci(n));
        };
    }
    return t.open = function(e, n, r) {
        return new t(e.transaction(r, n));
    }, Object.defineProperty(t.prototype, "to", {
        get: function() {
            return this.ro.promise;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.abort = function(t) {
        t && this.ro.reject(t), this.aborted || (E("SimpleDb", "Aborting transaction:", t ? t.message : "Client-initiated abort"), 
        this.aborted = !0, this.transaction.abort());
    }, 
    /**
     * Returns a SimpleDbStore<KeyType, ValueType> for the specified store. All
     * operations performed on the SimpleDbStore happen within the context of this
     * transaction and it cannot be used anymore once the transaction is
     * completed.
     *
     * Note that we can't actually enforce that the KeyType and ValueType are
     * correct, but they allow type safety through the rest of the consuming code.
     */
    t.prototype.store = function(t) {
        var e = this.transaction.objectStore(t);
        return new li(e);
    }, t;
}(), li = /** @class */ function() {
    function t(t) {
        this.store = t;
    }
    return t.prototype.put = function(t, e) {
        var n;
        return void 0 !== e ? (E("SimpleDb", "PUT", this.store.name, t, e), n = this.store.put(e, t)) : (E("SimpleDb", "PUT", this.store.name, "<auto-key>", t), 
        n = this.store.put(t)), pi(n);
    }, 
    /**
     * Adds a new value into an Object Store and returns the new key. Similar to
     * IndexedDb's `add()`, this method will fail on primary key collisions.
     *
     * @param value The object to write.
     * @return The key of the value to add.
     */
    t.prototype.add = function(t) {
        return E("SimpleDb", "ADD", this.store.name, t, t), pi(this.store.add(t));
    }, 
    /**
     * Gets the object with the specified key from the specified store, or null
     * if no object exists with the specified key.
     *
     * @key The key of the object to get.
     * @return The object with the specified key or null if no object exists.
     */
    t.prototype.get = function(t) {
        var e = this;
        // We're doing an unsafe cast to ValueType.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                return pi(this.store.get(t)).next((function(n) {
            // Normalize nonexistence to null.
            return void 0 === n && (n = null), E("SimpleDb", "GET", e.store.name, t, n), n;
        }));
    }, t.prototype.delete = function(t) {
        return E("SimpleDb", "DELETE", this.store.name, t), pi(this.store.delete(t));
    }, 
    /**
     * If we ever need more of the count variants, we can add overloads. For now,
     * all we need is to count everything in a store.
     *
     * Returns the number of rows in the store.
     */
    t.prototype.count = function() {
        return E("SimpleDb", "COUNT", this.store.name), pi(this.store.count());
    }, t.prototype.$s = function(t, e) {
        var n = this.cursor(this.options(t, e)), r = [];
        return this.oo(n, (function(t, e) {
            r.push(e);
        })).next((function() {
            return r;
        }));
    }, t.prototype.ho = function(t, e) {
        E("SimpleDb", "DELETE ALL", this.store.name);
        var n = this.options(t, e);
        n.yi = !1;
        var r = this.cursor(n);
        return this.oo(r, (function(t, e, n) {
            return n.delete();
        }));
    }, t.prototype.Qs = function(t, e) {
        var n;
        e ? n = t : (n = {}, e = t);
        var r = this.cursor(n);
        return this.oo(r, e);
    }, 
    /**
     * Iterates over a store, but waits for the given callback to complete for
     * each entry before iterating the next entry. This allows the callback to do
     * asynchronous work to determine if this iteration should continue.
     *
     * The provided callback should return `true` to continue iteration, and
     * `false` otherwise.
     */
    t.prototype.Fr = function(t) {
        var e = this.cursor({});
        return new Kn((function(n, r) {
            e.onerror = function(t) {
                var e = yi(t.target.error);
                r(e);
            }, e.onsuccess = function(e) {
                var r = e.target.result;
                r ? t(r.primaryKey, r.value).next((function(t) {
                    t ? r.continue() : n();
                })) : n();
            };
        }));
    }, t.prototype.oo = function(t, e) {
        var n = [];
        return new Kn((function(r, i) {
            t.onerror = function(t) {
                i(t.target.error);
            }, t.onsuccess = function(t) {
                var i = t.target.result;
                if (i) {
                    var o = new ai(i), s = e(i.primaryKey, i.value, o);
                    if (s instanceof Kn) {
                        var u = s.catch((function(t) {
                            return o.done(), Kn.reject(t);
                        }));
                        n.push(u);
                    }
                    o.gn ? r() : null === o.io ? i.continue() : i.continue(o.io);
                } else r();
            };
        })).next((function() {
            return Kn.Sn(n);
        }));
    }, t.prototype.options = function(t, e) {
        var n = void 0;
        return void 0 !== t && ("string" == typeof t ? n = t : e = t), {
            index: n,
            range: e
        };
    }, t.prototype.cursor = function(t) {
        var e = "next";
        if (t.reverse && (e = "prev"), t.index) {
            var n = this.store.index(t.index);
            return t.yi ? n.openKeyCursor(t.range, e) : n.openCursor(t.range, e);
        }
        return this.store.openCursor(t.range, e);
    }, t;
}();

/**
 * A wrapper around an IDBObjectStore providing an API that:
 *
 * 1) Has generic KeyType / ValueType parameters to provide strongly-typed
 * methods for acting against the object store.
 * 2) Deals with IndexedDB's onsuccess / onerror event callbacks, making every
 * method return a PersistencePromise instead.
 * 3) Provides a higher-level API to avoid needing to do excessive wrapping of
 * intermediate IndexedDB types (IDBCursorWithValue, etc.)
 */
/**
 * Wraps an IDBRequest in a PersistencePromise, using the onsuccess / onerror
 * handlers to resolve / reject the PersistencePromise as appropriate.
 */
function pi(t) {
    return new Kn((function(e, n) {
        t.onsuccess = function(t) {
            var n = t.target.result;
            e(n);
        }, t.onerror = function(t) {
            var e = yi(t.target.error);
            n(e);
        };
    }));
}

// Guard so we only report the error once.
var di = !1;

function yi(t) {
    var e = ui.Yr(u());
    if (e >= 12.2 && e < 13) {
        var n = "An internal error was encountered in the Indexed Database server";
        if (t.message.indexOf(n) >= 0) {
            // Wrap error in a more descriptive one.
            var r = new F("internal", "IOS_INDEXEDDB_BUG1: IndexedDb has thrown '" + n + "'. This is likely due to an unavoidable bug in iOS. See https://stackoverflow.com/q/56496296/110915 for details and a potential workaround.");
            return di || (di = !0, 
            // Throw a global exception outside of this promise chain, for the user to
            // potentially catch.
            setTimeout((function() {
                throw r;
            }), 0)), r;
        }
    }
    return t;
}

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** The Platform's 'window' implementation or null if not available. */ function vi() {
    // `window` is not always available, e.g. in ReactNative and WebWorkers.
    // eslint-disable-next-line no-restricted-globals
    return "undefined" != typeof window ? window : null;
}

/** The Platform's 'document' implementation or null if not available. */
/**
 * Represents an operation scheduled to be run in the future on an AsyncQueue.
 *
 * It is created via DelayedOperation.createAndSchedule().
 *
 * Supports cancellation (via cancel()) and early execution (via skipDelay()).
 *
 * Note: We implement `PromiseLike` instead of `Promise`, as the `Promise` type
 * in newer versions of TypeScript defines `finally`, which is not available in
 * IE.
 */ var mi = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.ao = t, this.Es = e, this.uo = n, this.op = r, this.co = i, this.lo = new Jn, 
        this.then = this.lo.promise.then.bind(this.lo.promise), 
        // It's normal for the deferred promise to be canceled (due to cancellation)
        // and so we attach a dummy catch callback to avoid
        // 'UnhandledPromiseRejectionWarning' log spam.
        this.lo.promise.catch((function(t) {}))
        /**
     * Creates and returns a DelayedOperation that has been scheduled to be
     * executed on the provided asyncQueue after the provided delayMs.
     *
     * @param asyncQueue The queue to schedule the operation on.
     * @param id A Timer ID identifying the type of operation this is.
     * @param delayMs The delay (ms) before the operation should be scheduled.
     * @param op The operation to run.
     * @param removalCallback A callback to be called synchronously once the
     *   operation is executed or canceled, notifying the AsyncQueue to remove it
     *   from its delayedOperations list.
     *   PORTING NOTE: This exists to prevent making removeDelayedOperation() and
     *   the DelayedOperation class public.
     */;
    }
    return t._o = function(e, n, r, i, o) {
        var s = new t(e, n, Date.now() + r, i, o);
        return s.start(r), s;
    }, 
    /**
     * Starts the timer. This is called immediately after construction by
     * createAndSchedule().
     */
    t.prototype.start = function(t) {
        var e = this;
        this.fo = setTimeout((function() {
            return e.do();
        }), t);
    }, 
    /**
     * Queues the operation to run immediately (if it hasn't already been run or
     * canceled).
     */
    t.prototype.Ss = function() {
        return this.do();
    }, 
    /**
     * Cancels the operation if it hasn't already been executed or canceled. The
     * promise will be rejected.
     *
     * As long as the operation has not yet been run, calling cancel() provides a
     * guarantee that the operation will not be run.
     */
    t.prototype.cancel = function(t) {
        null !== this.fo && (this.clearTimeout(), this.lo.reject(new F(q.CANCELLED, "Operation cancelled" + (t ? ": " + t : ""))));
    }, t.prototype.do = function() {
        var t = this;
        this.ao.Zi((function() {
            return null !== t.fo ? (t.clearTimeout(), t.op().then((function(e) {
                return t.lo.resolve(e);
            }))) : Promise.resolve();
        }));
    }, t.prototype.clearTimeout = function() {
        null !== this.fo && (this.co(this), clearTimeout(this.fo), this.fo = null);
    }, t;
}(), gi = /** @class */ function() {
    function t() {
        var t = this;
        // The last promise in the queue.
                this.wo = Promise.resolve(), 
        // A list of retryable operations. Retryable operations are run in order and
        // retried with backoff.
        this.To = [], 
        // Is this AsyncQueue being shut down? Once it is set to true, it will not
        // be changed again.
        this.Eo = !1, 
        // Operations scheduled to be queued in the future. Operations are
        // automatically removed after they are run or canceled.
        this.Io = [], 
        // visible for testing
        this.mo = null, 
        // Flag set while there's an outstanding AsyncQueue operation, used for
        // assertion sanity-checks.
        this.Ao = !1, 
        // List of TimerIds to fast-forward delays for.
        this.Ro = [], 
        // Backoff timer used to schedule retries for retryable operations
        this.Po = new tr(this, "async_queue_retry" /* AsyncQueueRetry */), 
        // Visibility handler that triggers an immediate retry of all retryable
        // operations. Meant to speed up recovery when we regain file system access
        // after page comes into foreground.
        this.Vo = function() {
            return t.Po.vs();
        };
        var e = vi();
        e && "function" == typeof e.addEventListener && e.addEventListener("visibilitychange", this.Vo);
    }
    return Object.defineProperty(t.prototype, "yo", {
        // Is this AsyncQueue being shut down? If true, this instance will not enqueue
        // any new operations, Promises from enqueue requests will not resolve.
        get: function() {
            return this.Eo;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Adds a new operation to the queue without waiting for it to complete (i.e.
     * we ignore the Promise result).
     */
    t.prototype.Zi = function(t) {
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.enqueue(t);
    }, 
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue without waiting for it to complete (i.e. we ignore the Promise result).
     */
    t.prototype.po = function(t) {
        this.bo(), 
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.vo(t);
    }, 
    /**
     * Regardless if the queue has initialized shutdown, adds a new operation to the
     * queue.
     */
    t.prototype.So = function(t) {
        return this.bo(), this.vo(t);
    }, 
    /**
     * Adds a new operation to the queue and initialize the shut down of this queue.
     * Returns a promise that will be resolved when the promise returned by the new
     * operation is (with its value).
     * Once this method is called, the only possible way to request running an operation
     * is through `enqueueAndForgetEvenAfterShutdown`.
     */
    t.prototype.Do = function(t) {
        return e(this, void 0, void 0, (function() {
            var e;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.bo(), this.Eo ? [ 3 /*break*/ , 2 ] : (this.Eo = !0, (e = vi()) && e.removeEventListener("visibilitychange", this.Vo), 
                    [ 4 /*yield*/ , this.So(t) ]);

                  case 1:
                    n.sent(), n.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Adds a new operation to the queue. Returns a promise that will be resolved
     * when the promise returned by the new operation is (with its value).
     */
    t.prototype.enqueue = function(t) {
        return this.bo(), this.Eo ? new Promise((function(t) {})) : this.vo(t);
    }, 
    /**
     * Enqueue a retryable operation.
     *
     * A retryable operation is rescheduled with backoff if it fails with a
     * IndexedDbTransactionError (the error type used by SimpleDb). All
     * retryable operations are executed in order and only run if all prior
     * operations were retried successfully.
     */
    t.prototype.er = function(t) {
        var e = this;
        this.To.push(t), this.Zi((function() {
            return e.Co();
        }));
    }, 
    /**
     * Runs the next operation from the retryable queue. If the operation fails,
     * reschedules with backoff.
     */
    t.prototype.Co = function() {
        return e(this, void 0, void 0, (function() {
            var t, e = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (0 === this.To.length) return [ 3 /*break*/ , 5 ];
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , this.To[0]() ];

                  case 2:
                    return n.sent(), this.To.shift(), this.Po.reset(), [ 3 /*break*/ , 4 ];

                  case 3:
                    if (!hi(t = n.sent())) throw t;
                    // Failure will be handled by AsyncQueue
                                        return E("AsyncQueue", "Operation failed with retryable error: " + t), 
                    [ 3 /*break*/ , 4 ];

                  case 4:
                    this.To.length > 0 && 
                    // If there are additional operations, we re-schedule `retryNextOp()`.
                    // This is necessary to run retryable operations that failed during
                    // their initial attempt since we don't know whether they are already
                    // enqueued. If, for example, `op1`, `op2`, `op3` are enqueued and `op1`
                    // needs to  be re-run, we will run `op1`, `op1`, `op2` using the
                    // already enqueued calls to `retryNextOp()`. `op3()` will then run in the
                    // call scheduled here.
                    // Since `backoffAndRun()` cancels an existing backoff and schedules a
                    // new backoff on every call, there is only ever a single additional
                    // operation in the queue.
                    this.Po.ys((function() {
                        return e.Co();
                    })), n.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.vo = function(t) {
        var e = this, n = this.wo.then((function() {
            return e.Ao = !0, t().catch((function(t) {
                // Re-throw the error so that this.tail becomes a rejected Promise and
                // all further attempts to chain (via .then) will just short-circuit
                // and return the rejected Promise.
                throw e.mo = t, e.Ao = !1, T("INTERNAL UNHANDLED ERROR: ", 
                /**
 * Chrome includes Error.message in Error.stack. Other browsers do not.
 * This returns expected output of message + stack when available.
 * @param error Error or FirestoreError
 */
                function(t) {
                    var e = t.message || "";
                    return t.stack && (e = t.stack.includes(t.message) ? t.stack : t.message + "\n" + t.stack), 
                    e;
                }(t)), t;
            })).then((function(t) {
                return e.Ao = !1, t;
            }));
        }));
        return this.wo = n, n;
    }, 
    /**
     * Schedules an operation to be queued on the AsyncQueue once the specified
     * `delayMs` has elapsed. The returned DelayedOperation can be used to cancel
     * or fast-forward the operation prior to its running.
     */
    t.prototype.bs = function(t, e, n) {
        var r = this;
        this.bo(), 
        // Fast-forward delays for timerIds that have been overriden.
        this.Ro.indexOf(t) > -1 && (e = 0);
        var i = mi._o(this, t, e, n, (function(t) {
            return r.Fo(t);
        }));
        return this.Io.push(i), i;
    }, t.prototype.bo = function() {
        this.mo && A();
    }, 
    /**
     * Verifies there's an operation currently in-progress on the AsyncQueue.
     * Unfortunately we can't verify that the running code is in the promise chain
     * of that operation, so this isn't a foolproof check, but it should be enough
     * to catch some bugs.
     */
    t.prototype.$o = function() {}, 
    /**
     * Waits until all currently queued tasks are finished executing. Delayed
     * operations are not run.
     */
    t.prototype.No = function() {
        return e(this, void 0, void 0, (function() {
            var t;
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return [ 4 /*yield*/ , t = this.wo ];

                  case 1:
                    e.sent(), e.label = 2;

                  case 2:
                    if (t !== this.wo) return [ 3 /*break*/ , 0 ];
                    e.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * For Tests: Determine if a delayed operation with a particular TimerId
     * exists.
     */
    t.prototype.ko = function(t) {
        for (var e = 0, n = this.Io; e < n.length; e++) {
            if (n[e].Es === t) return !0;
        }
        return !1;
    }, 
    /**
     * For Tests: Runs some or all delayed operations early.
     *
     * @param lastTimerId Delayed operations up to and including this TimerId will
     *  be drained. Pass TimerId.All to run all delayed operations.
     * @returns a Promise that resolves once all operations have been run.
     */
    t.prototype.xo = function(t) {
        var e = this;
        // Note that draining may generate more delayed ops, so we do that first.
                return this.No().then((function() {
            // Run ops in the same order they'd run if they ran naturally.
            e.Io.sort((function(t, e) {
                return t.uo - e.uo;
            }));
            for (var n = 0, r = e.Io; n < r.length; n++) {
                var i = r[n];
                if (i.Ss(), "all" /* All */ !== t && i.Es === t) break;
            }
            return e.No();
        }));
    }, 
    /**
     * For Tests: Skip all subsequent delays for a timer id.
     */
    t.prototype.Mo = function(t) {
        this.Ro.push(t);
    }, 
    /** Called once a DelayedOperation is run or canceled. */ t.prototype.Fo = function(t) {
        // NOTE: indexOf / slice are O(n), but delayedOperations is expected to be small.
        var e = this.Io.indexOf(t);
        this.Io.splice(e, 1);
    }, t;
}();

/**
 * Returns a FirestoreError that can be surfaced to the user if the provided
 * error is an IndexedDbTransactionError. Re-throws the error otherwise.
 */
function wi(t, e) {
    if (T("AsyncQueue", e + ": " + t), hi(t)) return new F(q.UNAVAILABLE, e + ": " + t);
    throw t;
}

function bi(t, e) {
    var n = t[0], r = t[1], i = e[0], o = e[1], s = k(n, i);
    return 0 === s ? k(r, o) : s;
}

/**
 * Used to calculate the nth sequence number. Keeps a rolling buffer of the
 * lowest n values passed to `addElement`, and finally reports the largest of
 * them in `maxValue`.
 */ var Ii = /** @class */ function() {
    function t(t) {
        this.Oo = t, this.buffer = new lt(bi), this.Lo = 0;
    }
    return t.prototype.qo = function() {
        return ++this.Lo;
    }, t.prototype.Bo = function(t) {
        var e = [ t, this.qo() ];
        if (this.buffer.size < this.Oo) this.buffer = this.buffer.add(e); else {
            var n = this.buffer.last();
            bi(e, n) < 0 && (this.buffer = this.buffer.delete(n).add(e));
        }
    }, Object.defineProperty(t.prototype, "maxValue", {
        get: function() {
            // Guaranteed to be non-empty. If we decide we are not collecting any
            // sequence numbers, nthSequenceNumber below short-circuits. If we have
            // decided that we are collecting n sequence numbers, it's because n is some
            // percentage of the existing sequence numbers. That means we should never
            // be in a situation where we are collecting sequence numbers but don't
            // actually have any.
            return this.buffer.last()[0];
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), Ei = {
    Uo: !1,
    Wo: 0,
    Qo: 0,
    jo: 0
}, Ti = /** @class */ function() {
    function t(
    // When we attempt to collect, we will only do so if the cache size is greater than this
    // threshold. Passing `COLLECTION_DISABLED` here will cause collection to always be skipped.
    t, 
    // The percentage of sequence numbers that we will attempt to collect
    e, 
    // A cap on the total number of sequence numbers that will be collected. This prevents
    // us from collecting a huge number of sequence numbers if the cache has grown very large.
    n) {
        this.Ko = t, this.Go = e, this.zo = n;
    }
    return t.Ho = function(e) {
        return new t(e, t.Yo, t.Jo);
    }, t;
}();

Ti.Xo = -1, Ti.Zo = 1048576, Ti.th = 41943040, Ti.Yo = 10, Ti.Jo = 1e3, Ti.eh = new Ti(Ti.th, Ti.Yo, Ti.Jo), 
Ti.nh = new Ti(Ti.Xo, 0, 0);

/**
 * This class is responsible for the scheduling of LRU garbage collection. It handles checking
 * whether or not GC is enabled, as well as which delay to use before the next run.
 */
var Ni = /** @class */ function() {
    function t(t, e) {
        this.yr = t, this.ao = e, this.sh = !1, this.ih = null;
    }
    return t.prototype.start = function(t) {
        this.yr.params.Ko !== Ti.Xo && this.rh(t);
    }, t.prototype.stop = function() {
        this.ih && (this.ih.cancel(), this.ih = null);
    }, Object.defineProperty(t.prototype, "Hi", {
        get: function() {
            return null !== this.ih;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.rh = function(t) {
        var r = this, i = this.sh ? 3e5 : 6e4;
        E("LruGarbageCollector", "Garbage collection scheduled in " + i + "ms"), this.ih = this.ao.bs("lru_garbage_collection" /* LruGarbageCollection */ , i, (function() {
            return e(r, void 0, void 0, (function() {
                var e;
                return n(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        this.ih = null, this.sh = !0, n.label = 1;

                      case 1:
                        return n.trys.push([ 1, 3, , 7 ]), [ 4 /*yield*/ , t.oh(this.yr) ];

                      case 2:
                        return n.sent(), [ 3 /*break*/ , 7 ];

                      case 3:
                        return hi(e = n.sent()) ? (E("LruGarbageCollector", "Ignoring IndexedDB error during garbage collection: ", e), 
                        [ 3 /*break*/ , 6 ]) : [ 3 /*break*/ , 4 ];

                      case 4:
                        return [ 4 /*yield*/ , xi(e) ];

                      case 5:
                        n.sent(), n.label = 6;

                      case 6:
                        return [ 3 /*break*/ , 7 ];

                      case 7:
                        return [ 4 /*yield*/ , this.rh(t) ];

                      case 8:
                        return n.sent(), [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }, t;
}(), Ai = /** @class */ function() {
    function t(t, e) {
        this.hh = t, this.params = e
        /** Given a percentile of target to collect, returns the number of targets to collect. */;
    }
    return t.prototype.ah = function(t, e) {
        return this.hh.pr(t).next((function(t) {
            return Math.floor(e / 100 * t);
        }));
    }, 
    /** Returns the nth sequence number, counting in order from the smallest. */ t.prototype.uh = function(t, e) {
        var n = this;
        if (0 === e) return Kn.resolve(Zn.ws);
        var r = new Ii(e);
        return this.hh.pe(t, (function(t) {
            return r.Bo(t.sequenceNumber);
        })).next((function() {
            return n.hh.vr(t, (function(t) {
                return r.Bo(t);
            }));
        })).next((function() {
            return r.maxValue;
        }));
    }, 
    /**
     * Removes targets with a sequence number equal to or less than the given upper bound, and removes
     * document associations with those targets.
     */
    t.prototype.Ei = function(t, e, n) {
        return this.hh.Ei(t, e, n);
    }, 
    /**
     * Removes documents that have a sequence number equal to or less than the upper bound and are not
     * otherwise pinned.
     */
    t.prototype.$r = function(t, e) {
        return this.hh.$r(t, e);
    }, t.prototype.lh = function(t, e) {
        var n = this;
        return this.params.Ko === Ti.Xo ? (E("LruGarbageCollector", "Garbage collection skipped; disabled"), 
        Kn.resolve(Ei)) : this.kr(t).next((function(r) {
            return r < n.params.Ko ? (E("LruGarbageCollector", "Garbage collection skipped; Cache size " + r + " is lower than threshold " + n.params.Ko), 
            Ei) : n._h(t, e);
        }));
    }, t.prototype.kr = function(t) {
        return this.hh.kr(t);
    }, t.prototype._h = function(t, e) {
        var n, r, i, o, u, a, c, h = this, f = Date.now();
        return this.ah(t, this.params.Go).next((function(e) {
            // Cap at the configured max
            return e > h.params.zo ? (E("LruGarbageCollector", "Capping sequence numbers to collect down to the maximum of " + h.params.zo + " from " + e), 
            r = h.params.zo) : r = e, o = Date.now(), h.uh(t, r);
        })).next((function(r) {
            return n = r, u = Date.now(), h.Ei(t, n, e);
        })).next((function(e) {
            return i = e, a = Date.now(), h.$r(t, n);
        })).next((function(t) {
            return c = Date.now(), I() <= s.DEBUG && E("LruGarbageCollector", "LRU Garbage Collection\n\tCounted targets in " + (o - f) + "ms\n\tDetermined least recently used " + r + " in " + (u - o) + "ms\n\tRemoved " + i + " targets in " + (a - u) + "ms\n\tRemoved " + t + " documents in " + (c - a) + "ms\nTotal Duration: " + (c - f) + "ms"), 
            Kn.resolve({
                Uo: !0,
                Wo: r,
                Qo: i,
                jo: t
            });
        }));
    }, t;
}(), _i = /** @class */ function() {
    function t(
    /** Manages our in-memory or durable persistence. */
    t, e, n) {
        this.persistence = t, this.fh = e, 
        /**
             * Maps a targetID to data about its target.
             *
             * PORTING NOTE: We are using an immutable data structure on Web to make re-runs
             * of `applyRemoteEvent()` idempotent.
             */
        this.dh = new ct(k), 
        /** Maps a target to its targetID. */
        // TODO(wuandy): Evaluate if TargetId can be part of Target.
        this.wh = new M((function(t) {
            return J(t);
        }), tt), 
        /**
             * The read time of the last entry processed by `getNewDocumentChanges()`.
             *
             * PORTING NOTE: This is only used for multi-tab synchronization.
             */
        this.Th = G.min(), this.jn = t.mr(n), this.Eh = t.Pr(), this.qi = t.Rr(), this.Ih = new Xn(this.Eh, this.jn, this.persistence.gr()), 
        this.fh.mh(this.Ih);
    }
    return t.prototype.Ah = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return e = this.jn, r = this.Ih, [ 4 /*yield*/ , this.persistence.runTransaction("Handle user change", "readonly", (function(n) {
                        // Swap out the mutation queue, grabbing the pending mutation batches
                        // before and after.
                        var i;
                        return o.jn.Qr(n).next((function(s) {
                            return i = s, e = o.persistence.mr(t), 
                            // Recreate our LocalDocumentsView using the new
                            // MutationQueue.
                            r = new Xn(o.Eh, e, o.persistence.gr()), e.Qr(n);
                        })).next((function(t) {
                            for (var e = [], o = [], s = It(), u = 0, a = i
                            // Union the old/new changed keys.
                            ; u < a.length; u++) {
                                var c = a[u];
                                e.push(c.batchId);
                                for (var h = 0, f = c.mutations; h < f.length; h++) {
                                    var l = f[h];
                                    s = s.add(l.key);
                                }
                            }
                            for (var p = 0, d = t; p < d.length; p++) {
                                var y = d[p];
                                o.push(y.batchId);
                                for (var v = 0, m = y.mutations; v < m.length; v++) {
                                    var g = m[v];
                                    s = s.add(g.key);
                                }
                            }
                            // Return the set of all (potentially) changed documents and the list
                            // of mutation batch IDs that were affected by change.
                                                        return r.Jn(n, s).next((function(t) {
                                return {
                                    Rh: t,
                                    Ph: e,
                                    gh: o
                                };
                            }));
                        }));
                    })) ];

                  case 1:
                    return i = n.sent(), [ 2 /*return*/ , (this.jn = e, this.Ih = r, this.fh.mh(this.Ih), 
                    i) ];
                }
            }));
        }));
    }, t.prototype.Vh = function(t) {
        var e, n = this, r = j.now(), i = t.reduce((function(t, e) {
            return t.add(e.key);
        }), It());
        return this.persistence.runTransaction("Locally write mutations", "readwrite", (function(o) {
            return n.Ih.Jn(o, i).next((function(i) {
                e = i;
                for (
                // For non-idempotent mutations (such as `FieldValue.increment()`),
                // we record the base state in a separate patch mutation. This is
                // later used to guarantee consistent values and prevents flicker
                // even if the backend sends us an update that already includes our
                // transform.
                var s = [], u = 0, a = t; u < a.length; u++) {
                    var c = a[u], h = Ye(c, e.get(c.key));
                    null != h && 
                    // NOTE: The base state should only be applied if there's some
                    // existing document to override, so use a Precondition of
                    // exists=true
                    s.push(new en(c.key, h, fn(h.proto.mapValue), Ke.exists(!0)));
                }
                return n.jn.Lr(o, r, s, t);
            }));
        })).then((function(t) {
            var n = t.In(e);
            return {
                batchId: t.batchId,
                Cn: n
            };
        }));
    }, t.prototype.yh = function(t) {
        var e = this;
        return this.persistence.runTransaction("Acknowledge batch", "readwrite-primary", (function(n) {
            var r = t.batch.keys(), i = e.Eh.Hs({
                Js: !0
            });
            return e.ph(n, t, i).next((function() {
                return i.apply(n);
            })).next((function() {
                return e.jn.zr(n);
            })).next((function() {
                return e.Ih.Jn(n, r);
            }));
        }));
    }, t.prototype.bh = function(t) {
        var e = this;
        return this.persistence.runTransaction("Reject batch", "readwrite-primary", (function(n) {
            var r;
            return e.jn.qr(n, t).next((function(t) {
                return _(null !== t), r = t.keys(), e.jn.Kr(n, t);
            })).next((function() {
                return e.jn.zr(n);
            })).next((function() {
                return e.Ih.Jn(n, r);
            }));
        }));
    }, t.prototype.Wr = function() {
        var t = this;
        return this.persistence.runTransaction("Get highest unacknowledged batch id", "readonly", (function(e) {
            return t.jn.Wr(e);
        }));
    }, t.prototype.ai = function() {
        var t = this;
        return this.persistence.runTransaction("Get last remote snapshot version", "readonly", (function(e) {
            return t.qi.ai(e);
        }));
    }, t.prototype.vh = function(e) {
        var n = this, r = e.X, i = this.dh;
        return this.persistence.runTransaction("Apply remote event", "readwrite-primary", (function(o) {
            var s = n.Eh.Hs({
                Js: !0
            });
            // Reset newTargetDataByTargetMap in case this transaction gets re-run.
                        i = n.dh;
            var u = [];
            e.Wt.forEach((function(e, s) {
                var a = i.get(s);
                if (a) {
                    // Only update the remote keys if the target is still active. This
                    // ensures that we can persist the updated target data along with
                    // the updated assignment.
                    u.push(n.qi.Pi(o, e.Xt, s).next((function() {
                        return n.qi.Ai(o, e.Yt, s);
                    })));
                    var c = e.resumeToken;
                    // Update the resume token if the change includes one.
                                        if (c.H() > 0) {
                        var h = a.tt(c, r).Z(o.vi);
                        i = i.nt(s, h), 
                        // Update the target data if there are target changes (or if
                        // sufficient time has passed since the last update).
                        t.Sh(a, h, e) && u.push(n.qi.di(o, h));
                    }
                }
            }));
            var a = yt(), c = It();
            // HACK: The only reason we allow a null snapshot version is so that we
            // can synthesize remote events when we get permission denied errors while
            // trying to resolve the state of a locally cached document that is in
            // limbo.
                        if (e.jt.forEach((function(t, e) {
                c = c.add(t);
            })), 
            // Each loop iteration only affects its "own" doc, so it's safe to get all the remote
            // documents in advance in a single call.
            u.push(s.getEntries(o, c).next((function(t) {
                e.jt.forEach((function(i, c) {
                    var h = t.get(i);
                    // Note: The order of the steps below is important, since we want
                    // to ensure that rejected limbo resolutions (which fabricate
                    // NoDocuments with SnapshotVersion.min()) never add documents to
                    // cache.
                                        c instanceof dn && c.version.isEqual(G.min()) ? (
                    // NoDocuments with SnapshotVersion.min() are used in manufactured
                    // events. We remove these documents from cache since we lost
                    // access.
                    s.xn(i, r), a = a.nt(i, c)) : null == h || c.version.o(h.version) > 0 || 0 === c.version.o(h.version) && h.hasPendingWrites ? (s.Nn(c, r), 
                    a = a.nt(i, c)) : E("LocalStore", "Ignoring outdated watch update for ", i, ". Current version:", h.version, " Watch version:", c.version), 
                    e.Kt.has(i) && u.push(n.persistence.ii.Nr(o, i));
                }));
            }))), !r.isEqual(G.min())) {
                var h = n.qi.ai(o).next((function(t) {
                    return n.qi.ci(o, o.vi, r);
                }));
                u.push(h);
            }
            return Kn.Sn(u).next((function() {
                return s.apply(o);
            })).next((function() {
                return n.Ih.Xn(o, a);
            }));
        })).then((function(t) {
            return n.dh = i, t;
        }));
    }, 
    /**
     * Returns true if the newTargetData should be persisted during an update of
     * an active target. TargetData should always be persisted when a target is
     * being released and should not call this function.
     *
     * While the target is active, TargetData updates can be omitted when nothing
     * about the target has changed except metadata like the resume token or
     * snapshot version. Occasionally it's worth the extra write to prevent these
     * values from getting too stale after a crash, but this doesn't have to be
     * too frequent.
     */
    t.Sh = function(t, e, n) {
        // Always persist target data if we don't already have a resume token.
        return _(e.resumeToken.H() > 0), 0 === t.resumeToken.H() || (e.X.m() - t.X.m() >= this.Dh || n.Yt.size + n.Jt.size + n.Xt.size > 0);
        // Don't allow resume token changes to be buffered indefinitely. This
        // allows us to be reasonably up-to-date after a crash and avoids needing
        // to loop over all active queries on shutdown. Especially in the browser
        // we may not get time to do anything interesting while the current tab is
        // closing.
        }, t.prototype.Ch = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o, s, u, a, c, h = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.persistence.runTransaction("notifyLocalViewChanges", "readwrite", (function(e) {
                        return Kn.forEach(t, (function(t) {
                            return Kn.forEach(t.as, (function(n) {
                                return h.persistence.ii.Ri(e, t.targetId, n);
                            })).next((function() {
                                return Kn.forEach(t.us, (function(n) {
                                    return h.persistence.ii.gi(e, t.targetId, n);
                                }));
                            }));
                        }));
                    })) ];

                  case 1:
                    return n.sent(), [ 3 /*break*/ , 3 ];

                  case 2:
                    if (!hi(e = n.sent())) throw e;
                    // If `notifyLocalViewChanges` fails, we did not advance the sequence
                    // number for the documents that were included in this transaction.
                    // This might trigger them to be deleted earlier than they otherwise
                    // would have, but it should not invalidate the integrity of the data.
                                        return E("LocalStore", "Failed to update sequence numbers: " + e), 
                    [ 3 /*break*/ , 3 ];

                  case 3:
                    for (r = 0, i = t; r < i.length; r++) o = i[r], s = o.targetId, o.fromCache || (u = this.dh.get(s), 
                    a = u.X, c = u.et(a), 
                    // Advance the last limbo free snapshot version
                    this.dh = this.dh.nt(s, c));
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Fh = function(t) {
        var e = this;
        return this.persistence.runTransaction("Get next mutation batch", "readonly", (function(n) {
            return void 0 === t && (t = -1), e.jn.Ur(n, t);
        }));
    }, t.prototype.$h = function(t) {
        var e = this;
        return this.persistence.runTransaction("read document", "readonly", (function(n) {
            return e.Ih.Gn(n, t);
        }));
    }, t.prototype.Nh = function(t) {
        var e = this;
        return this.persistence.runTransaction("Allocate target", "readwrite", (function(n) {
            var r;
            return e.qi.mi(n, t).next((function(i) {
                return i ? (
                // This target has been listened to previously, so reuse the
                // previous targetID.
                // TODO(mcg): freshen last accessed date?
                r = i, Kn.resolve(r)) : e.qi.ri(n).next((function(i) {
                    return r = new ot(t, i, 0 /* Listen */ , n.vi), e.qi.li(n, r).next((function() {
                        return r;
                    }));
                }));
            }));
        })).then((function(n) {
            // If Multi-Tab is enabled, the existing target data may be newer than
            // the in-memory data
            var r = e.dh.get(n.targetId);
            return (null === r || n.X.o(r.X) > 0) && (e.dh = e.dh.nt(n.targetId, n), e.wh.set(t, n.targetId)), 
            n;
        }));
    }, t.prototype.mi = function(t, e) {
        var n = this.wh.get(e);
        return void 0 !== n ? Kn.resolve(this.dh.get(n)) : this.qi.mi(t, e);
    }, t.prototype.kh = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o, s = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    e = this.dh.get(t), i = r ? "readwrite" : "readwrite-primary", n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 4, , 5 ]), r ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , this.persistence.runTransaction("Release target", i, (function(t) {
                        return s.persistence.ii.removeTarget(t, e);
                    })) ];

                  case 2:
                    n.sent(), n.label = 3;

                  case 3:
                    return [ 3 /*break*/ , 5 ];

                  case 4:
                    if (!hi(o = n.sent())) throw o;
                    // All `releaseTarget` does is record the final metadata state for the
                    // target, but we've been recording this periodically during target
                    // activity. If we lose this write this could cause a very slight
                    // difference in the order of target deletion during GC, but we
                    // don't define exact LRU semantics so this is acceptable.
                                        return E("LocalStore", "Failed to update sequence numbers for target " + t + ": " + o), 
                    [ 3 /*break*/ , 5 ];

                  case 5:
                    return this.dh = this.dh.remove(t), this.wh.delete(e.target), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.xh = function(t, e) {
        var n = this, r = G.min(), i = It();
        return this.persistence.runTransaction("Execute query", "readonly", (function(o) {
            return n.mi(o, En(t)).next((function(t) {
                if (t) return r = t.lastLimboFreeSnapshotVersion, n.qi.Vi(o, t.targetId).next((function(t) {
                    i = t;
                }));
            })).next((function() {
                return n.fh.ts(o, t, e ? r : G.min(), e ? i : It());
            })).next((function(t) {
                return {
                    documents: t,
                    Mh: i
                };
            }));
        }));
    }, t.prototype.ph = function(t, e, n) {
        var r = this, i = e.batch, o = i.keys(), s = Kn.resolve();
        return o.forEach((function(r) {
            s = s.next((function() {
                return n.Mn(t, r);
            })).next((function(t) {
                var o = t, s = e.An.get(r);
                _(null !== s), (!o || o.version.o(s) < 0) && ((o = i.wn(r, o, e)) && 
                // We use the commitVersion as the readTime rather than the
                // document's updateTime since the updateTime is not advanced
                // for updates that do not modify the underlying document.
                n.Nn(o, e.mn));
            }));
        })), s.next((function() {
            return r.jn.Kr(t, i);
        }));
    }, t.prototype.oh = function(t) {
        var e = this;
        return this.persistence.runTransaction("Collect garbage", "readwrite-primary", (function(n) {
            return t.lh(n, e.dh);
        }));
    }, t;
}();

/** Implements the steps for LRU garbage collection. */
/**
 * The maximum time to leave a resume token buffered without writing it out.
 * This value is arbitrary: it's long enough to avoid several writes
 * (possibly indefinitely if updates come more frequently than this) but
 * short enough that restarting after crashing will still have a pretty
 * recent resume token.
 */
function Di(
/** Manages our in-memory or durable persistence. */
t, e, n) {
    return new _i(t, e, n);
}

/** Returns the local view of the documents affected by a mutation batch. */
// PORTING NOTE: Multi-Tab only.
// PORTING NOTE: Multi-Tab only.
function Si(t, e) {
    var n = D(t), r = D(n.qi), i = n.dh.get(e);
    return i ? Promise.resolve(i.target) : n.persistence.runTransaction("Get target data", "readonly", (function(t) {
        return r.Me(t, e).next((function(t) {
            return t ? t.target : null;
        }));
    }));
}

/**
 * Returns the set of documents that have been updated since the last call.
 * If this is the first call, returns the set of changes since client
 * initialization. Further invocations will return document that have changed
 * since the prior call.
 */
// PORTING NOTE: Multi-Tab only.
/**
 * Verifies the error thrown by a LocalStore operation. If a LocalStore
 * operation fails because the primary lease has been taken by another client,
 * we ignore the error (the persistence layer will immediately call
 * `applyPrimaryLease` to propagate the primary state change). All other errors
 * are re-thrown.
 *
 * @param err An error returned by a LocalStore operation.
 * @return A Promise that resolves after we recovered, or the original error.
 */ function xi(t) {
    return e(this, void 0, void 0, (function() {
        return n(this, (function(e) {
            if (t.code !== q.FAILED_PRECONDITION || t.message !== $n) throw t;
            return E("LocalStore", "Unexpectedly lost primary lease"), [ 2 /*return*/ ];
        }));
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A collection of references to a document from some kind of numbered entity
 * (either a target ID or batch ID). As references are added to or removed from
 * the set corresponding events are emitted to a registered garbage collector.
 *
 * Each reference is represented by a DocumentReference object. Each of them
 * contains enough information to uniquely identify the reference. They are all
 * stored primarily in a set sorted by key. A document is considered garbage if
 * there's no references in that set (this can be efficiently checked thanks to
 * sorting by key).
 *
 * ReferenceSet also keeps a secondary set that contains references sorted by
 * IDs. This one is used to efficiently implement removal of all references by
 * some target ID.
 */ _i.Dh = 3e8;

var ki = /** @class */ function() {
    function t() {
        // A set of outstanding references to a document sorted by key.
        this.Oh = new lt(Pi.Lh), 
        // A set of outstanding references to a document sorted by target id.
        this.qh = new lt(Pi.Bh)
        /** Returns true if the reference set contains no references. */;
    }
    return t.prototype._ = function() {
        return this.Oh._();
    }, 
    /** Adds a reference to the given document key for the given ID. */ t.prototype.Ri = function(t, e) {
        var n = new Pi(t, e);
        this.Oh = this.Oh.add(n), this.qh = this.qh.add(n);
    }, 
    /** Add references to the given document keys for the given ID. */ t.prototype.Uh = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.Ri(t, e);
        }));
    }, 
    /**
     * Removes a reference to the given document key for the given
     * ID.
     */
    t.prototype.gi = function(t, e) {
        this.Wh(new Pi(t, e));
    }, t.prototype.Qh = function(t, e) {
        var n = this;
        t.forEach((function(t) {
            return n.gi(t, e);
        }));
    }, 
    /**
     * Clears all references with a given ID. Calls removeRef() for each key
     * removed.
     */
    t.prototype.jh = function(t) {
        var e = this, n = new Q(new z([])), r = new Pi(n, t), i = new Pi(n, t + 1), o = [];
        return this.qh.vt([ r, i ], (function(t) {
            e.Wh(t), o.push(t.key);
        })), o;
    }, t.prototype.Kh = function() {
        var t = this;
        this.Oh.forEach((function(e) {
            return t.Wh(e);
        }));
    }, t.prototype.Wh = function(t) {
        this.Oh = this.Oh.delete(t), this.qh = this.qh.delete(t);
    }, t.prototype.Gh = function(t) {
        var e = new Q(new z([])), n = new Pi(e, t), r = new Pi(e, t + 1), i = It();
        return this.qh.vt([ n, r ], (function(t) {
            i = i.add(t.key);
        })), i;
    }, t.prototype.pi = function(t) {
        var e = new Pi(t, 0), n = this.Oh.Dt(e);
        return null !== n && t.isEqual(n.key);
    }, t;
}(), Pi = /** @class */ function() {
    function t(t, e) {
        this.key = t, this.zh = e
        /** Compare by key then by ID */;
    }
    return t.Lh = function(t, e) {
        return Q.P(t.key, e.key) || k(t.zh, e.zh);
    }, 
    /** Compare by ID then by key */ t.Bh = function(t, e) {
        return k(t.zh, e.zh) || Q.P(t.key, e.key);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Validates that no arguments were passed in the invocation of functionName.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateNoArgs('myFunction', arguments);
 */
function Li(t, e) {
    if (0 !== e.length) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() does not support arguments, but was called with " + Xi(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has the exact number of arguments.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateExactNumberOfArgs('myFunction', arguments, 2);
 */ function Oi(t, e, n) {
    if (e.length !== n) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires " + Xi(n, "argument") + ", but was called with " + Xi(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has at least the provided number of
 * arguments (but can have many more).
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateAtLeastNumberOfArgs('myFunction', arguments, 2);
 */ function Ri(t, e, n) {
    if (e.length < n) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires at least " + Xi(n, "argument") + ", but was called with " + Xi(e.length, "argument") + ".");
}

/**
 * Validates the invocation of functionName has number of arguments between
 * the values provided.
 *
 * Forward the magic "arguments" variable as second parameter on which the
 * parameter validation is performed:
 * validateBetweenNumberOfArgs('myFunction', arguments, 2, 3);
 */ function Vi(t, e, n, r) {
    if (e.length < n || e.length > r) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires between " + n + " and " + r + " arguments, but was called with " + Xi(e.length, "argument") + ".");
}

/**
 * Validates the provided argument is an array and has as least the expected
 * number of elements.
 */
/**
 * Validates the provided positional argument has the native JavaScript type
 * using typeof checks.
 */ function Ui(t, e, n, r) {
    Gi(t, e, Hi(n) + " argument", r);
}

/**
 * Validates the provided argument has the native JavaScript type using
 * typeof checks or is undefined.
 */ function Ci(t, e, n, r) {
    void 0 !== r && Ui(t, e, n, r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks.
 */ function Mi(t, e, n, r) {
    Gi(t, e, n + " option", r);
}

/**
 * Validates the provided named option has the native JavaScript type using
 * typeof checks or is undefined.
 */ function qi(t, e, n, r) {
    void 0 !== r && Mi(t, e, n, r);
}

/**
 * Validates that the provided named option equals one of the expected values.
 */
/**
 * Validates that the provided named option equals one of the expected values or
 * is undefined.
 */
function Fi(t, e, n, r, i) {
    void 0 !== r && function(t, e, n, r, i) {
        for (var o = [], s = 0, u = i; s < u.length; s++) {
            var a = u[s];
            if (a === r) return;
            o.push(zi(a));
        }
        var c = zi(r);
        throw new F(q.INVALID_ARGUMENT, "Invalid value " + c + " provided to function " + t + '() for option "' + n + '". Acceptable values: ' + o.join(", "));
    }(t, 0, n, r, i);
}

/**
 * Validates that the provided argument is a valid enum.
 *
 * @param functionName Function making the validation call.
 * @param enums Array containing all possible values for the enum.
 * @param position Position of the argument in `functionName`.
 * @param argument Argument to validate.
 * @return The value as T if the argument can be converted.
 */ function ji(t, e, n, r) {
    if (!e.some((function(t) {
        return t === r;
    }))) throw new F(q.INVALID_ARGUMENT, "Invalid value " + zi(r) + " provided to function " + t + "() for its " + Hi(n) + " argument. Acceptable values: " + e.join(", "));
    return r;
}

/** Helper to validate the type of a provided input. */ function Gi(t, e, n, r) {
    if (!("object" === e ? Bi(r) : "non-empty string" === e ? "string" == typeof r && "" !== r : typeof r === e)) {
        var i = zi(r);
        throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires its " + n + " to be of type " + e + ", but it was: " + i);
    }
}

/**
 * Returns true if it's a non-null object without a custom prototype
 * (i.e. excludes Array, Date, etc.).
 */ function Bi(t) {
    return "object" == typeof t && null !== t && (Object.getPrototypeOf(t) === Object.prototype || null === Object.getPrototypeOf(t));
}

/** Returns a string describing the type / value of the provided input. */ function zi(t) {
    if (void 0 === t) return "undefined";
    if (null === t) return "null";
    if ("string" == typeof t) return t.length > 20 && (t = t.substring(0, 20) + "..."), 
    JSON.stringify(t);
    if ("number" == typeof t || "boolean" == typeof t) return "" + t;
    if ("object" == typeof t) {
        if (t instanceof Array) return "an array";
        var e = 
        /** Hacky method to try to get the constructor name for an object. */
        function(t) {
            if (t.constructor) {
                var e = /function\s+([^\s(]+)\s*\(/.exec(t.constructor.toString());
                if (e && e.length > 1) return e[1];
            }
            return null;
        }(t);
        return e ? "a custom " + e + " object" : "an object";
    }
    return "function" == typeof t ? "a function" : A();
}

function Wi(t, e, n) {
    if (void 0 === n) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires a valid " + Hi(e) + " argument, but it was undefined.");
}

/**
 * Validates the provided positional argument is an object, and its keys and
 * values match the expected keys and types provided in optionTypes.
 */ function Ki(t, e, n) {
    U(e, (function(e, r) {
        if (n.indexOf(e) < 0) throw new F(q.INVALID_ARGUMENT, "Unknown option '" + e + "' passed to function " + t + "(). Available options: " + n.join(", "));
    }));
}

/**
 * Helper method to throw an error that the provided argument did not pass
 * an instanceof check.
 */ function Qi(t, e, n, r) {
    var i = zi(r);
    return new F(q.INVALID_ARGUMENT, "Function " + t + "() requires its " + Hi(n) + " argument to be a " + e + ", but it was: " + i);
}

function $i(t, e, n) {
    if (n <= 0) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires its " + Hi(e) + " argument to be a positive number, but it was: " + n + ".");
}

/** Converts a number to its english word representation */ function Hi(t) {
    switch (t) {
      case 1:
        return "first";

      case 2:
        return "second";

      case 3:
        return "third";

      default:
        return t + "th";
    }
}

/**
 * Formats the given word as plural conditionally given the preceding number.
 */ function Xi(t, e) {
    return t + " " + e + (1 === t ? "" : "s");
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Helper function to assert Uint8Array is available at runtime. */ function Yi() {
    if ("undefined" == typeof Uint8Array) throw new F(q.UNIMPLEMENTED, "Uint8Arrays are not available in this environment.");
}

/** Helper function to assert Base64 functions are available at runtime. */ function Zi() {
    if ("undefined" == typeof atob) throw new F(q.UNIMPLEMENTED, "Blobs are unavailable in Firestore in this environment.");
}

/**
 * Immutable class holding a blob (binary data).
 * This class is directly exposed in the public API.
 *
 * Note that while you can't hide the constructor in JavaScript code, we are
 * using the hack above to make sure no-one outside this module can call it.
 */ var Ji = /** @class */ function() {
    function t(t) {
        Zi(), this.Hh = t;
    }
    return t.fromBase64String = function(e) {
        Oi("Blob.fromBase64String", arguments, 1), Ui("Blob.fromBase64String", "string", 1, e), 
        Zi();
        try {
            return new t(nt.fromBase64String(e));
        } catch (e) {
            throw new F(q.INVALID_ARGUMENT, "Failed to construct Blob from Base64 string: " + e);
        }
    }, t.fromUint8Array = function(e) {
        if (Oi("Blob.fromUint8Array", arguments, 1), Yi(), !(e instanceof Uint8Array)) throw Qi("Blob.fromUint8Array", "Uint8Array", 1, e);
        return new t(nt.fromUint8Array(e));
    }, t.prototype.toBase64 = function() {
        return Oi("Blob.toBase64", arguments, 0), Zi(), this.Hh.toBase64();
    }, t.prototype.toUint8Array = function() {
        return Oi("Blob.toUint8Array", arguments, 0), Yi(), this.Hh.toUint8Array();
    }, t.prototype.toString = function() {
        return "Blob(base64: " + this.toBase64() + ")";
    }, t.prototype.isEqual = function(t) {
        return this.Hh.isEqual(t.Hh);
    }, t;
}(), to = function(t) {
    !function(t, e, n, r) {
        if (!(e instanceof Array) || e.length < 1) throw new F(q.INVALID_ARGUMENT, "Function FieldPath() requires its fieldNames argument to be an array with at least " + Xi(1, "element") + ".");
    }(0, t);
    for (var e = 0; e < t.length; ++e) if (Ui("FieldPath", "string", e, t[e]), 0 === t[e].length) throw new F(q.INVALID_ARGUMENT, "Invalid field name at argument $(i + 1). Field names must not be empty.");
    this.Yh = new K(t);
}, eo = /** @class */ function(e) {
    /**
     * Creates a FieldPath from the provided field names. If more than one field
     * name is provided, the path will point to a nested field in a document.
     *
     * @param fieldNames A list of field names.
     */
    function n() {
        for (var t = [], n = 0; n < arguments.length; n++) t[n] = arguments[n];
        return e.call(this, t) || this;
    }
    return t(n, e), n.documentId = function() {
        /**
         * Internal Note: The backend doesn't technically support querying by
         * document ID. Instead it queries by the entire document name (full path
         * included), but in the cases we currently support documentId(), the net
         * effect is the same.
         */
        return new n(K.L().$());
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw Qi("isEqual", "FieldPath", 1, t);
        return this.Yh.isEqual(t.Yh);
    }, n;
}(to), no = new RegExp("[~\\*/\\[\\]]"), ro = function() {
    /** A pointer to the implementing class. */
    this.Jh = this;
}, io = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Xh = t, n;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        if (2 /* MergeSet */ !== t.ta) throw 1 /* Update */ === t.ta ? t.ea(this.Xh + "() can only appear at the top level of your update data") : t.ea(this.Xh + "() cannot be used with set() unless you pass {merge:true}");
        // No transform to add for a delete, but we need to add it to our
        // fieldMask so it gets deleted.
                return t.Le.push(t.path), null;
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(ro);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The objects that are a part of this API are exposed to third-parties as
// compiled javascript so we want to flag our private members with a leading
// underscore to discourage their use.
/**
 * A field class base class that is shared by the lite, full and legacy SDK,
 * which supports shared code that deals with FieldPaths.
 */
/**
 * Creates a child context for parsing SerializableFieldValues.
 *
 * This is different than calling `ParseContext.contextWith` because it keeps
 * the fieldTransforms and fieldMask separate.
 *
 * The created context has its `dataSource` set to `UserDataSource.Argument`.
 * Although these values are used with writes, any elements in these FieldValues
 * are not considered writes since they cannot contain any FieldValue sentinels,
 * etc.
 *
 * @param fieldValue The sentinel FieldValue for which to create a child
 *     context.
 * @param context The parent context.
 * @param arrayElement Whether or not the FieldValue has an array.
 */
function oo(t, e, n) {
    return new bo({
        ta: 3 /* Argument */ ,
        na: e.settings.na,
        methodName: t.Xh,
        sa: n
    }, e.s, e.serializer, e.ignoreUndefinedProperties);
}

var so = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Xh = t, n;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        return new ze(t.path, new Ve);
    }, n.prototype.isEqual = function(t) {
        return t instanceof n;
    }, n;
}(ro), uo = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).Xh = t, r.ia = n, r;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        var e = oo(this, t, 
        /*array=*/ !0), n = this.ia.map((function(t) {
            return _o(t, e);
        })), r = new Ue(n);
        return new ze(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(ro), ao = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).Xh = t, r.ia = n, r;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        var e = oo(this, t, 
        /*array=*/ !0), n = this.ia.map((function(t) {
            return _o(t, e);
        })), r = new Me(n);
        return new ze(t.path, r);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(ro), co = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).Xh = t, r.ra = n, r;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        var e = new Fe(t.serializer, oe(t.serializer, this.ra));
        return new ze(t.path, e);
    }, n.prototype.isEqual = function(t) {
        // TODO(mrschmidt): Implement isEquals
        return this === t;
    }, n;
}(ro), ho = /** @class */ function(e) {
    function n() {
        return e.call(this) || this;
    }
    return t(n, e), n.delete = function() {
        return Li("FieldValue.delete", arguments), new fo(new io("FieldValue.delete"));
    }, n.serverTimestamp = function() {
        return Li("FieldValue.serverTimestamp", arguments), new fo(new so("FieldValue.serverTimestamp"));
    }, n.arrayUnion = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        // NOTE: We don't actually parse the data until it's used in set() or
        // update() since we'd need the Firestore instance to do this.
                return Ri("FieldValue.arrayUnion", arguments, 1), new fo(new uo("FieldValue.arrayUnion", t));
    }, n.arrayRemove = function() {
        for (var t = [], e = 0; e < arguments.length; e++) t[e] = arguments[e];
        // NOTE: We don't actually parse the data until it's used in set() or
        // update() since we'd need the Firestore instance to do this.
                return Ri("FieldValue.arrayRemove", arguments, 1), new fo(new ao("FieldValue.arrayRemove", t));
    }, n.increment = function(t) {
        return Ui("FieldValue.increment", "number", 1, t), Oi("FieldValue.increment", arguments, 1), 
        new fo(new co("FieldValue.increment", t));
    }, n;
}(ro), fo = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Jh = t, n.Xh = t.Xh, n;
    }
    return t(n, e), n.prototype.Zh = function(t) {
        return this.Jh.Zh(t);
    }, n.prototype.isEqual = function(t) {
        return t instanceof n && this.Jh.isEqual(t.Jh);
    }, n;
}(ho), lo = /** @class */ function() {
    function t(t, e) {
        if (Oi("GeoPoint", arguments, 2), Ui("GeoPoint", "number", 1, t), Ui("GeoPoint", "number", 2, e), 
        !isFinite(t) || t < -90 || t > 90) throw new F(q.INVALID_ARGUMENT, "Latitude must be a number between -90 and 90, but was: " + t);
        if (!isFinite(e) || e < -180 || e > 180) throw new F(q.INVALID_ARGUMENT, "Longitude must be a number between -180 and 180, but was: " + e);
        this.oa = t, this.ha = e;
    }
    return Object.defineProperty(t.prototype, "latitude", {
        /**
         * Returns the latitude of this geo point, a number between -90 and 90.
         */
        get: function() {
            return this.oa;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "longitude", {
        /**
         * Returns the longitude of this geo point, a number between -180 and 180.
         */
        get: function() {
            return this.ha;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(t) {
        return this.oa === t.oa && this.ha === t.ha;
    }, 
    /**
     * Actually private to JS consumers of our API, so this function is prefixed
     * with an underscore.
     */
    t.prototype.T = function(t) {
        return k(this.oa, t.oa) || k(this.ha, t.ha);
    }, t;
}();

/**
 * @license
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function po(t) {
    return new ne(t, /* useProto3Json= */ !0);
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */ var yo = /^__.*__$/, vo = function(t, e, n) {
    this.aa = t, this.ua = e, this.ca = n;
}, mo = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.Le = e, this.fieldTransforms = n;
    }
    return t.prototype.la = function(t, e) {
        var n = [];
        return null !== this.Le ? n.push(new en(t, this.data, this.Le, e)) : n.push(new tn(t, this.data, e)), 
        this.fieldTransforms.length > 0 && n.push(new rn(t, this.fieldTransforms)), n;
    }, t;
}(), go = /** @class */ function() {
    function t(t, e, n) {
        this.data = t, this.Le = e, this.fieldTransforms = n;
    }
    return t.prototype.la = function(t, e) {
        var n = [ new en(t, this.data, this.Le, e) ];
        return this.fieldTransforms.length > 0 && n.push(new rn(t, this.fieldTransforms)), 
        n;
    }, t;
}();

/**
 * A reference to a document in a Firebase project.
 *
 * This class serves as a common base class for the public DocumentReferences
 * exposed in the lite, full and legacy SDK.
 */ function wo(t) {
    switch (t) {
      case 0 /* Set */ :
 // fall through
              case 2 /* MergeSet */ :
 // fall through
              case 1 /* Update */ :
        return !0;

      case 3 /* Argument */ :
      case 4 /* ArrayArgument */ :
        return !1;

      default:
        throw A();
    }
}

/** A "context" object passed around while parsing user data. */ var bo = /** @class */ function() {
    /**
     * Initializes a ParseContext with the given source and path.
     *
     * @param settings The settings for the parser.
     * @param databaseId The database ID of the Firestore instance.
     * @param serializer The serializer to use to generate the Value proto.
     * @param ignoreUndefinedProperties Whether to ignore undefined properties
     * rather than throw.
     * @param fieldTransforms A mutable list of field transforms encountered while
     *     parsing the data.
     * @param fieldMask A mutable list of field paths encountered while parsing
     *     the data.
     *
     * TODO(b/34871131): We don't support array paths right now, so path can be
     * null to indicate the context represents any location within an array (in
     * which case certain features will not work and errors will be somewhat
     * compromised).
     */
    function t(t, e, n, r, i, o) {
        this.settings = t, this.s = e, this.serializer = n, this.ignoreUndefinedProperties = r, 
        // Minor hack: If fieldTransforms is undefined, we assume this is an
        // external call and we need to validate the entire path.
        void 0 === i && this._a(), this.fieldTransforms = i || [], this.Le = o || [];
    }
    return Object.defineProperty(t.prototype, "path", {
        get: function() {
            return this.settings.path;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ta", {
        get: function() {
            return this.settings.ta;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /** Returns a new context with the specified settings overwritten. */ t.prototype.fa = function(e) {
        return new t(Object.assign(Object.assign({}, this.settings), e), this.s, this.serializer, this.ignoreUndefinedProperties, this.fieldTransforms, this.Le);
    }, t.prototype.da = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.fa({
            path: n,
            sa: !1
        });
        return r.wa(t), r;
    }, t.prototype.Ta = function(t) {
        var e, n = null === (e = this.path) || void 0 === e ? void 0 : e.child(t), r = this.fa({
            path: n,
            sa: !1
        });
        return r._a(), r;
    }, t.prototype.Ea = function(t) {
        // TODO(b/34871131): We don't support array paths right now; so make path
        // undefined.
        return this.fa({
            path: void 0,
            sa: !0
        });
    }, t.prototype.ea = function(t) {
        return Lo(t, this.settings.methodName, this.settings.Ia || !1, this.path, this.settings.na);
    }, 
    /** Returns 'true' if 'fieldPath' was traversed when creating this context. */ t.prototype.contains = function(t) {
        return void 0 !== this.Le.find((function(e) {
            return t.D(e);
        })) || void 0 !== this.fieldTransforms.find((function(e) {
            return t.D(e.field);
        }));
    }, t.prototype._a = function() {
        // TODO(b/34871131): Remove null check once we have proper paths for fields
        // within arrays.
        if (this.path) for (var t = 0; t < this.path.length; t++) this.wa(this.path.get(t));
    }, t.prototype.wa = function(t) {
        if (0 === t.length) throw this.ea("Document fields must not be empty");
        if (wo(this.ta) && yo.test(t)) throw this.ea('Document fields cannot begin and end with "__"');
    }, t;
}(), Io = /** @class */ function() {
    function t(t, e, n) {
        this.s = t, this.ignoreUndefinedProperties = e, this.serializer = n || po(t)
        /** Creates a new top-level parse context. */;
    }
    return t.prototype.ma = function(t, e, n, r) {
        return void 0 === r && (r = !1), new bo({
            ta: t,
            methodName: e,
            na: n,
            path: K.k(),
            sa: !1,
            Ia: r
        }, this.s, this.serializer, this.ignoreUndefinedProperties);
    }, t;
}();

/**
 * Helper for parsing raw user input (provided via the API) into internal model
 * classes.
 */
/** Parse document data from a set() call. */ function Eo(t, e, n, r, i, o) {
    void 0 === o && (o = {});
    var s = t.ma(o.merge || o.mergeFields ? 2 /* MergeSet */ : 0 /* Set */ , e, n, i);
    xo("Data must be an object, but it was:", s, r);
    var u, a, c = Do(r, s);
    if (o.merge) u = new Be(s.Le), a = s.fieldTransforms; else if (o.mergeFields) {
        for (var h = [], f = 0, l = o.mergeFields; f < l.length; f++) {
            var p = l[f], d = void 0;
            if (p instanceof to) d = p.Yh; else {
                if ("string" != typeof p) throw A();
                d = Po(e, p, n);
            }
            if (!s.contains(d)) throw new F(q.INVALID_ARGUMENT, "Field '" + d + "' is specified in your field mask but missing from your input data.");
            Oo(h, d) || h.push(d);
        }
        u = new Be(h), a = s.fieldTransforms.filter((function(t) {
            return u.je(t.field);
        }));
    } else u = null, a = s.fieldTransforms;
    return new mo(new cn(c), u, a);
}

/** Parse update data from an update() call. */ function To(t, e, n, r) {
    var i = t.ma(1 /* Update */ , e, n);
    xo("Data must be an object, but it was:", i, r);
    var o = [], s = new hn;
    U(r, (function(t, r) {
        var u = Po(e, t, n), a = i.Ta(u);
        if (r instanceof ro && r.Jh instanceof io) 
        // Add it to the field mask, but don't add anything to updateData.
        o.push(u); else {
            var c = _o(r, a);
            null != c && (o.push(u), s.set(u, c));
        }
    }));
    var u = new Be(o);
    return new go(s.Ge(), u, i.fieldTransforms);
}

/** Parse update data from a list of field/value arguments. */ function No(t, e, n, r, i, o) {
    var s = t.ma(1 /* Update */ , e, n), u = [ ko(e, r, n) ], a = [ i ];
    if (o.length % 2 != 0) throw new F(q.INVALID_ARGUMENT, "Function " + e + "() needs to be called with an even number of arguments that alternate between field names and values.");
    for (var c = 0; c < o.length; c += 2) u.push(ko(e, o[c])), a.push(o[c + 1]);
    // We iterate in reverse order to pick the last value for a field if the
    // user specified the field multiple times.
    for (var h = [], f = new hn, l = u.length - 1; l >= 0; --l) if (!Oo(h, u[l])) {
        var p = u[l], d = a[l], y = s.Ta(p);
        if (d instanceof ro && d.Jh instanceof io) 
        // Add it to the field mask, but don't add anything to updateData.
        h.push(p); else {
            var v = _o(d, y);
            null != v && (h.push(p), f.set(p, v));
        }
    }
    var m = new Be(h);
    return new go(f.Ge(), m, s.fieldTransforms);
}

/**
 * Parse a "query value" (e.g. value in a where filter or a value in a cursor
 * bound).
 *
 * @param allowArrays Whether the query value is an array that may directly
 * contain additional arrays (e.g. the operand of an `in` query).
 */ function Ao(t, e, n, r) {
    return void 0 === r && (r = !1), _o(n, t.ma(r ? 4 /* ArrayArgument */ : 3 /* Argument */ , e));
}

/**
 * Parses user data to Protobuf Values.
 *
 * @param input Data to be parsed.
 * @param context A context object representing the current path being parsed,
 * the source of the data being parsed, etc.
 * @return The parsed value, or null if the value was a FieldValue sentinel
 * that should not be included in the resulting parsed data.
 */ function _o(t, e) {
    if (So(t)) return xo("Unsupported field value:", e, t), Do(t, e);
    if (t instanceof ro) 
    // FieldValues usually parse into transforms (except FieldValue.delete())
    // in which case we do not want to include this field in our parsed data
    // (as doing so will overwrite the field directly prior to the transform
    // trying to transform it). So we don't add this location to
    // context.fieldMask and we return null as our parsing result.
    /**
     * "Parses" the provided FieldValueImpl, adding any necessary transforms to
     * context.fieldTransforms.
     */
    return function(t, e) {
        // Sentinels are only supported with writes, and not within arrays.
        if (!wo(e.ta)) throw e.ea(t.Xh + "() can only be used with update() and set()");
        if (!e.path) throw e.ea(t.Xh + "() is not currently supported inside arrays");
        var n = t.Zh(e);
        n && e.fieldTransforms.push(n);
    }(t, e), null;
    if (
    // If context.path is null we are inside an array and we don't support
    // field mask paths more granular than the top-level array.
    e.path && e.Le.push(e.path), t instanceof Array) {
        // TODO(b/34871131): Include the path containing the array in the error
        // message.
        // In the case of IN queries, the parsed data is an array (representing
        // the set of values to be included for the IN query) that may directly
        // contain additional arrays (each representing an individual field
        // value), so we disable this validation.
        if (e.settings.sa && 4 /* ArrayArgument */ !== e.ta) throw e.ea("Nested arrays are not supported");
        return function(t, e) {
            for (var n = [], r = 0, i = 0, o = t; i < o.length; i++) {
                var s = _o(o[i], e.Ea(r));
                null == s && (
                // Just include nulls in the array for fields being replaced with a
                // sentinel.
                s = {
                    nullValue: "NULL_VALUE"
                }), n.push(s), r++;
            }
            return {
                arrayValue: {
                    values: n
                }
            };
        }(t, e);
    }
    return function(t, e) {
        if (null === t) return {
            nullValue: "NULL_VALUE"
        };
        if ("number" == typeof t) return oe(e.serializer, t);
        if ("boolean" == typeof t) return {
            booleanValue: t
        };
        if ("string" == typeof t) return {
            stringValue: t
        };
        if (t instanceof Date) {
            var n = j.fromDate(t);
            return {
                timestampValue: se(e.serializer, n)
            };
        }
        if (t instanceof j) {
            // Firestore backend truncates precision down to microseconds. To ensure
            // offline mode works the same with regards to truncation, perform the
            // truncation immediately without waiting for the backend to do that.
            var r = new j(t.seconds, 1e3 * Math.floor(t.nanoseconds / 1e3));
            return {
                timestampValue: se(e.serializer, r)
            };
        }
        if (t instanceof lo) return {
            geoPointValue: {
                latitude: t.latitude,
                longitude: t.longitude
            }
        };
        if (t instanceof Ji) return {
            bytesValue: ue(e.serializer, t)
        };
        if (t instanceof vo) {
            var i = e.s, o = t.aa;
            if (!o.isEqual(i)) throw e.ea("Document reference is for database " + o.projectId + "/" + o.database + " but should be for database " + i.projectId + "/" + i.database);
            return {
                referenceValue: he(t.aa || e.s, t.ua.path)
            };
        }
        if (void 0 === t && e.ignoreUndefinedProperties) return null;
        throw e.ea("Unsupported field value: " + zi(t));
    }(t, e);
}

function Do(t, e) {
    var n = {};
    return C(t) ? 
    // If we encounter an empty object, we explicitly add it to the update
    // mask to ensure that the server creates a map entry.
    e.path && e.path.length > 0 && e.Le.push(e.path) : U(t, (function(t, r) {
        var i = _o(r, e.da(t));
        null != i && (n[t] = i);
    })), {
        mapValue: {
            fields: n
        }
    };
}

function So(t) {
    return !("object" != typeof t || null === t || t instanceof Array || t instanceof Date || t instanceof j || t instanceof lo || t instanceof Ji || t instanceof vo || t instanceof ro);
}

function xo(t, e, n) {
    if (!So(n) || !Bi(n)) {
        var r = zi(n);
        throw "an object" === r ? e.ea(t + " a custom object") : e.ea(t + " " + r);
    }
}

/**
 * Helper that calls fromDotSeparatedString() but wraps any error thrown.
 */ function ko(t, e, n) {
    if (e instanceof to) return e.Yh;
    if ("string" == typeof e) return Po(t, e);
    throw Lo("Field path arguments must be of type string or FieldPath.", t, 
    /* hasConverter= */ !1, 
    /* path= */ void 0, n);
}

/**
 * Wraps fromDotSeparatedString with an error message about the method that
 * was thrown.
 * @param methodName The publicly visible method name
 * @param path The dot-separated string form of a field path which will be split
 * on dots.
 * @param targetDoc The document against which the field path will be evaluated.
 */ function Po(t, e, n) {
    try {
        return function(t) {
            if (t.search(no) >= 0) throw new F(q.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not contain '~', '*', '/', '[', or ']'");
            try {
                return new (eo.bind.apply(eo, r([ void 0 ], t.split("."))));
            } catch (e) {
                throw new F(q.INVALID_ARGUMENT, "Invalid field path (" + t + "). Paths must not be empty, begin with '.', end with '.', or contain '..'");
            }
        }(e).Yh;
    } catch (e) {
        throw Lo((i = e) instanceof Error ? i.message : i.toString(), t, 
        /* hasConverter= */ !1, 
        /* path= */ void 0, n);
    }
    /**
 * Extracts the message from a caught exception, which should be an Error object
 * though JS doesn't guarantee that.
 */    var i;
    /** Checks `haystack` if FieldPath `needle` is present. Runs in O(n). */}

function Lo(t, e, n, r, i) {
    var o = r && !r._(), s = void 0 !== i, u = "Function " + e + "() called with invalid data";
    n && (u += " (via `toFirestore()`)");
    var a = "";
    return (o || s) && (a += " (found", o && (a += " in field " + r), s && (a += " in document " + i), 
    a += ")"), new F(q.INVALID_ARGUMENT, (u += ". ") + t + a);
}

function Oo(t, e) {
    return t.some((function(t) {
        return t.isEqual(e);
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Simple wrapper around a nullable UID. Mostly exists to make code more
 * readable.
 */ var Ro = /** @class */ function() {
    function t(t) {
        this.uid = t;
    }
    return t.prototype.Mr = function() {
        return null != this.uid;
    }, 
    /**
     * Returns a key representing this user, suitable for inclusion in a
     * dictionary.
     */
    t.prototype.Aa = function() {
        return this.Mr() ? "uid:" + this.uid : "anonymous-user";
    }, t.prototype.isEqual = function(t) {
        return t.uid === this.uid;
    }, t;
}();

/** A user with a null UID. */ Ro.UNAUTHENTICATED = new Ro(null), 
// TODO(mikelehen): Look into getting a proper uid-equivalent for
// non-FirebaseAuth providers.
Ro.Ra = new Ro("google-credentials-uid"), Ro.Pa = new Ro("first-party-uid");

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var Vo = function(t, e) {
    this.user = e, this.type = "OAuth", this.ga = {}, 
    // Set the headers using Object Literal notation to avoid minification
    this.ga.Authorization = "Bearer " + t;
}, Uo = /** @class */ function() {
    function t() {
        /**
         * Stores the listener registered with setChangeListener()
         * This isn't actually necessary since the UID never changes, but we use this
         * to verify the listen contract is adhered to in tests.
         */
        this.Va = null;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(null);
    }, t.prototype.ya = function() {}, t.prototype.pa = function(t) {
        this.Va = t, 
        // Fire with initial user.
        t(Ro.UNAUTHENTICATED);
    }, t.prototype.ba = function() {
        this.Va = null;
    }, t;
}(), Co = /** @class */ function() {
    function t(t) {
        var e = this;
        /**
         * The auth token listener registered with FirebaseApp, retained here so we
         * can unregister it.
         */        this.va = null, 
        /** Tracks the current User. */
        this.currentUser = Ro.UNAUTHENTICATED, this.Sa = !1, 
        /**
             * Counter used to detect if the token changed while a getToken request was
             * outstanding.
             */
        this.Da = 0, 
        /** The listener registered with setChangeListener(). */
        this.Va = null, this.forceRefresh = !1, this.va = function() {
            e.Da++, e.currentUser = e.Ca(), e.Sa = !0, e.Va && e.Va(e.currentUser);
        }, this.Da = 0, this.auth = t.getImmediate({
            optional: !0
        }), this.auth ? this.auth.addAuthTokenListener(this.va) : (
        // if auth is not available, invoke tokenListener once with null token
        this.va(null), t.get().then((function(t) {
            e.auth = t, e.va && 
            // tokenListener can be removed by removeChangeListener()
            e.auth.addAuthTokenListener(e.va);
        }), (function() {})));
    }
    return t.prototype.getToken = function() {
        var t = this, e = this.Da, n = this.forceRefresh;
        // Take note of the current value of the tokenCounter so that this method
        // can fail (with an ABORTED error) if there is a token change while the
        // request is outstanding.
                return this.forceRefresh = !1, this.auth ? this.auth.getToken(n).then((function(n) {
            // Cancel the request since the token changed while the request was
            // outstanding so the response is potentially for a previous user (which
            // user, we can't be sure).
            return t.Da !== e ? (E("FirebaseCredentialsProvider", "getToken aborted due to token change."), 
            t.getToken()) : n ? (_("string" == typeof n.accessToken), new Vo(n.accessToken, t.currentUser)) : null;
        })) : Promise.resolve(null);
    }, t.prototype.ya = function() {
        this.forceRefresh = !0;
    }, t.prototype.pa = function(t) {
        this.Va = t, 
        // Fire the initial event
        this.Sa && t(this.currentUser);
    }, t.prototype.ba = function() {
        this.auth && this.auth.removeAuthTokenListener(this.va), this.va = null, this.Va = null;
    }, 
    // Auth.getUid() can return null even with a user logged in. It is because
    // getUid() is synchronous, but the auth code populating Uid is asynchronous.
    // This method should only be called in the AuthTokenListener callback
    // to guarantee to get the actual user.
    t.prototype.Ca = function() {
        var t = this.auth && this.auth.getUid();
        return _(null === t || "string" == typeof t), new Ro(t);
    }, t;
}(), Mo = /** @class */ function() {
    function t(t, e) {
        this.Fa = t, this.$a = e, this.type = "FirstParty", this.user = Ro.Pa;
    }
    return Object.defineProperty(t.prototype, "ga", {
        get: function() {
            var t = {
                "X-Goog-AuthUser": this.$a
            }, e = this.Fa.auth.Na([]);
            return e && (t.Authorization = e), t;
        },
        enumerable: !1,
        configurable: !0
    }), t;
}(), qo = /** @class */ function() {
    function t(t, e) {
        this.Fa = t, this.$a = e;
    }
    return t.prototype.getToken = function() {
        return Promise.resolve(new Mo(this.Fa, this.$a));
    }, t.prototype.pa = function(t) {
        // Fire with initial uid.
        t(Ro.Pa);
    }, t.prototype.ba = function() {}, t.prototype.ya = function() {}, t;
}(), Fo = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.Ts = t, this.ka = n, this.xa = r, this.Ma = i, this.listener = o, this.state = 0 /* Initial */ , 
        /**
             * A close count that's incremented every time the stream is closed; used by
             * getCloseGuardedDispatcher() to invalidate callbacks that happen after
             * close.
             */
        this.Oa = 0, this.La = null, this.stream = null, this.Po = new tr(t, e)
        /**
     * Returns true if start() has been called and no error has occurred. True
     * indicates the stream is open or in the process of opening (which
     * encompasses respecting backoff, getting auth tokens, and starting the
     * actual RPC). Use isOpen() to determine if the stream is open and ready for
     * outbound requests.
     */;
    }
    return t.prototype.qa = function() {
        return 1 /* Starting */ === this.state || 2 /* Open */ === this.state || 4 /* Backoff */ === this.state;
    }, 
    /**
     * Returns true if the underlying RPC is open (the onOpen() listener has been
     * called) and the stream is ready for outbound requests.
     */
    t.prototype.Ba = function() {
        return 2 /* Open */ === this.state;
    }, 
    /**
     * Starts the RPC. Only allowed if isStarted() returns false. The stream is
     * not immediately ready for use: onOpen() will be invoked when the RPC is
     * ready for outbound requests, at which point isOpen() will return true.
     *
     * When start returns, isStarted() will return true.
     */
    t.prototype.start = function() {
        3 /* Error */ !== this.state ? this.auth() : this.Ua();
    }, 
    /**
     * Stops the RPC. This call is idempotent and allowed regardless of the
     * current isStarted() state.
     *
     * When stop returns, isStarted() and isOpen() will both return false.
     */
    t.prototype.stop = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.qa() ? [ 4 /*yield*/ , this.close(0 /* Initial */) ] : [ 3 /*break*/ , 2 ];

                  case 1:
                    t.sent(), t.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * After an error the stream will usually back off on the next attempt to
     * start it. If the error warrants an immediate restart of the stream, the
     * sender can use this to indicate that the receiver should not back off.
     *
     * Each error will call the onClose() listener. That function can decide to
     * inhibit backoff if required.
     */
    t.prototype.Wa = function() {
        this.state = 0 /* Initial */ , this.Po.reset();
    }, 
    /**
     * Marks this stream as idle. If no further actions are performed on the
     * stream for one minute, the stream will automatically close itself and
     * notify the stream's onClose() handler with Status.OK. The stream will then
     * be in a !isStarted() state, requiring the caller to start the stream again
     * before further use.
     *
     * Only streams that are in state 'Open' can be marked idle, as all other
     * states imply pending network operations.
     */
    t.prototype.Qa = function() {
        var t = this;
        // Starts the idle time if we are in state 'Open' and are not yet already
        // running a timer (in which case the previous idle timeout still applies).
                this.Ba() && null === this.La && (this.La = this.Ts.bs(this.ka, 6e4, (function() {
            return t.ja();
        })));
    }, 
    /** Sends a message to the underlying stream. */ t.prototype.Ka = function(t) {
        this.Ga(), this.stream.send(t);
    }, 
    /** Called by the idle timer when the stream should close due to inactivity. */ t.prototype.ja = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                return this.Ba() ? [ 2 /*return*/ , this.close(0 /* Initial */) ] : [ 2 /*return*/ ];
            }));
        }));
    }, 
    /** Marks the stream as active again. */ t.prototype.Ga = function() {
        this.La && (this.La.cancel(), this.La = null);
    }, 
    /**
     * Closes the stream and cleans up as necessary:
     *
     * * closes the underlying GRPC stream;
     * * calls the onClose handler with the given 'error';
     * * sets internal stream state to 'finalState';
     * * adjusts the backoff timer based on the error
     *
     * A new stream can be opened by calling start().
     *
     * @param finalState the intended state of the stream after closing.
     * @param error the error the connection was closed with.
     */
    t.prototype.close = function(t, r) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    // Notify the listener that the stream closed.
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    return this.Ga(), this.Po.cancel(), 
                    // Invalidates any stream-related callbacks (e.g. from auth or the
                    // underlying stream), guaranteeing they won't execute.
                    this.Oa++, 3 /* Error */ !== t ? 
                    // If this is an intentional close ensure we don't delay our next connection attempt.
                    this.Po.reset() : r && r.code === q.RESOURCE_EXHAUSTED ? (
                    // Log the error. (Probably either 'quota exceeded' or 'max queue length reached'.)
                    T(r.toString()), T("Using maximum backoff delay to prevent overloading the backend."), 
                    this.Po.Vs()) : r && r.code === q.UNAUTHENTICATED && 
                    // "unauthenticated" error means the token was rejected. Try force refreshing it in case it
                    // just expired.
                    this.Ma.ya(), 
                    // Clean up the underlying stream because we are no longer interested in events.
                    null !== this.stream && (this.za(), this.stream.close(), this.stream = null), 
                    // This state must be assigned before calling onClose() to allow the callback to
                    // inhibit backoff or otherwise manipulate the state in its non-started state.
                    this.state = t, [ 4 /*yield*/ , this.listener.Ha(r) ];

                  case 1:
                    // Cancel any outstanding timers (they're guaranteed not to execute).
                    // Notify the listener that the stream closed.
                    return e.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Can be overridden to perform additional cleanup before the stream is closed.
     * Calling super.tearDown() is not required.
     */
    t.prototype.za = function() {}, t.prototype.auth = function() {
        var t = this;
        this.state = 1 /* Starting */;
        var e = this.Ya(this.Oa), n = this.Oa;
        // TODO(mikelehen): Just use dispatchIfNotClosed, but see TODO below.
                this.Ma.getToken().then((function(e) {
            // Stream can be stopped while waiting for authentication.
            // TODO(mikelehen): We really should just use dispatchIfNotClosed
            // and let this dispatch onto the queue, but that opened a spec test can
            // of worms that I don't want to deal with in this PR.
            t.Oa === n && 
            // Normally we'd have to schedule the callback on the AsyncQueue.
            // However, the following calls are safe to be called outside the
            // AsyncQueue since they don't chain asynchronous calls
            t.Ja(e);
        }), (function(n) {
            e((function() {
                var e = new F(q.UNKNOWN, "Fetching auth token failed: " + n.message);
                return t.Xa(e);
            }));
        }));
    }, t.prototype.Ja = function(t) {
        var e = this, n = this.Ya(this.Oa);
        this.stream = this.Za(t), this.stream.tu((function() {
            n((function() {
                return e.state = 2 /* Open */ , e.listener.tu();
            }));
        })), this.stream.Ha((function(t) {
            n((function() {
                return e.Xa(t);
            }));
        })), this.stream.onMessage((function(t) {
            n((function() {
                return e.onMessage(t);
            }));
        }));
    }, t.prototype.Ua = function() {
        var t = this;
        this.state = 4 /* Backoff */ , this.Po.ys((function() {
            return e(t, void 0, void 0, (function() {
                return n(this, (function(t) {
                    return this.state = 0 /* Initial */ , this.start(), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, 
    // Visible for tests
    t.prototype.Xa = function(t) {
        // In theory the stream could close cleanly, however, in our current model
        // we never expect this to happen because if we stop a stream ourselves,
        // this callback will never be called. To prevent cases where we retry
        // without a backoff accidentally, we set the stream to error in all cases.
        return E("PersistentStream", "close with error: " + t), this.stream = null, this.close(3 /* Error */ , t);
    }, 
    /**
     * Returns a "dispatcher" function that dispatches operations onto the
     * AsyncQueue but only runs them if closeCount remains unchanged. This allows
     * us to turn auth / stream callbacks into no-ops if the stream is closed /
     * re-opened, etc.
     */
    t.prototype.Ya = function(t) {
        var e = this;
        return function(n) {
            e.Ts.Zi((function() {
                return e.Oa === t ? n() : (E("PersistentStream", "stream callback skipped by getCloseGuardedDispatcher."), 
                Promise.resolve());
            }));
        };
    }, t;
}(), jo = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "listen_stream_connection_backoff" /* ListenStreamConnectionBackoff */ , "listen_stream_idle" /* ListenStreamIdle */ , n, r, o) || this).serializer = i, 
        s;
    }
    return t(n, e), n.prototype.Za = function(t) {
        return this.xa.eu("Listen", t);
    }, n.prototype.onMessage = function(t) {
        // A successful response means the stream is healthy
        this.Po.reset();
        var e = function(t, e) {
            var n;
            if ("targetChange" in e) {
                e.targetChange;
                // proto3 default value is unset in JSON (undefined), so use 'NO_CHANGE'
                // if unset
                var r = function(t) {
                    return "NO_CHANGE" === t ? 0 /* NoChange */ : "ADD" === t ? 1 /* Added */ : "REMOVE" === t ? 2 /* Removed */ : "CURRENT" === t ? 3 /* Current */ : "RESET" === t ? 4 /* Reset */ : A();
                }(e.targetChange.targetChangeType || "NO_CHANGE"), i = e.targetChange.targetIds || [], o = function(t, e) {
                    return t.Oe ? (_(void 0 === e || "string" == typeof e), nt.fromBase64String(e || "")) : (_(void 0 === e || e instanceof Uint8Array), 
                    nt.fromUint8Array(e || new Uint8Array));
                }(t, e.targetChange.resumeToken), s = e.targetChange.cause, u = s && function(t) {
                    var e = void 0 === t.code ? q.UNKNOWN : at(t.code);
                    return new F(e, t.message || "");
                }(s);
                n = new Pt(r, i, o, u || null);
            } else if ("documentChange" in e) {
                e.documentChange;
                var a = e.documentChange;
                a.document, a.document.name, a.document.updateTime;
                var c = pe(t, a.document.name), h = ce(a.document.updateTime), f = new cn({
                    mapValue: {
                        fields: a.document.fields
                    }
                }), l = new pn(c, h, f, {}), p = a.targetIds || [], d = a.removedTargetIds || [];
                n = new xt(p, d, l.key, l);
            } else if ("documentDelete" in e) {
                e.documentDelete;
                var y = e.documentDelete;
                y.document;
                var v = pe(t, y.document), m = y.readTime ? ce(y.readTime) : G.min(), g = new dn(v, m), w = y.removedTargetIds || [];
                n = new xt([], w, g.key, g);
            } else if ("documentRemove" in e) {
                e.documentRemove;
                var b = e.documentRemove;
                b.document;
                var I = pe(t, b.document), E = b.removedTargetIds || [];
                n = new xt([], E, I, null);
            } else {
                if (!("filter" in e)) return A();
                e.filter;
                var T = e.filter;
                T.targetId;
                var N = T.count || 0, D = new st(N), S = T.targetId;
                n = new kt(S, D);
            }
            return n;
        }(this.serializer, t), n = function(t) {
            // We have only reached a consistent snapshot for the entire stream if there
            // is a read_time set and it applies to all targets (i.e. the list of
            // targets is empty). The backend is guaranteed to send such responses.
            if (!("targetChange" in t)) return G.min();
            var e = t.targetChange;
            return e.targetIds && e.targetIds.length ? G.min() : e.readTime ? ce(e.readTime) : G.min();
        }(t);
        return this.listener.nu(e, n);
    }, 
    /**
     * Registers interest in the results of the given target. If the target
     * includes a resumeToken it will be included in the request. Results that
     * affect the target will be streamed back as WatchChange messages that
     * reference the targetId.
     */
    n.prototype.su = function(t) {
        var e = {};
        e.database = ve(this.serializer), e.addTarget = function(t, e) {
            var n, r = e.target;
            return (n = et(r) ? {
                documents: Ie(t, r)
            } : {
                query: Ee(t, r)
            }).targetId = e.targetId, e.resumeToken.H() > 0 && (n.resumeToken = ue(t, e.resumeToken)), 
            n;
        }(this.serializer, t);
        var n = function(t, e) {
            var n = function(t, e) {
                switch (e) {
                  case 0 /* Listen */ :
                    return null;

                  case 1 /* ExistenceFilterMismatch */ :
                    return "existence-filter-mismatch";

                  case 2 /* LimboResolution */ :
                    return "limbo-document";

                  default:
                    return A();
                }
            }(0, e.J);
            return null == n ? null : {
                "goog-listen-tags": n
            };
        }(this.serializer, t);
        n && (e.labels = n), this.Ka(e);
    }, 
    /**
     * Unregisters interest in the results of the target associated with the
     * given targetId.
     */
    n.prototype.iu = function(t) {
        var e = {};
        e.database = ve(this.serializer), e.removeTarget = t, this.Ka(e);
    }, n;
}(Fo), Go = /** @class */ function(e) {
    function n(t, n, r, i, o) {
        var s = this;
        return (s = e.call(this, t, "write_stream_connection_backoff" /* WriteStreamConnectionBackoff */ , "write_stream_idle" /* WriteStreamIdle */ , n, r, o) || this).serializer = i, 
        s.ru = !1, s;
    }
    return t(n, e), Object.defineProperty(n.prototype, "ou", {
        /**
         * Tracks whether or not a handshake has been successfully exchanged and
         * the stream is ready to accept mutations.
         */
        get: function() {
            return this.ru;
        },
        enumerable: !1,
        configurable: !0
    }), 
    // Override of PersistentStream.start
    n.prototype.start = function() {
        this.ru = !1, this.lastStreamToken = void 0, e.prototype.start.call(this);
    }, n.prototype.za = function() {
        this.ru && this.hu([]);
    }, n.prototype.Za = function(t) {
        return this.xa.eu("Write", t);
    }, n.prototype.onMessage = function(t) {
        if (
        // Always capture the last stream token.
        _(!!t.streamToken), this.lastStreamToken = t.streamToken, this.ru) {
            // A successful first write response means the stream is healthy,
            // Note, that we could consider a successful handshake healthy, however,
            // the write itself might be causing an error we want to back off from.
            this.Po.reset();
            var e = function(t, e) {
                return t && t.length > 0 ? (_(void 0 !== e), t.map((function(t) {
                    return function(t, e) {
                        // NOTE: Deletes don't have an updateTime.
                        var n = t.updateTime ? ce(t.updateTime) : ce(e);
                        n.isEqual(G.min()) && (
                        // The Firestore Emulator currently returns an update time of 0 for
                        // deletes of non-existing documents (rather than null). This breaks the
                        // test "get deleted doc while offline with source=cache" as NoDocuments
                        // with version 0 are filtered by IndexedDb's RemoteDocumentCache.
                        // TODO(#2149): Remove this when Emulator is fixed
                        n = ce(e));
                        var r = null;
                        return t.transformResults && t.transformResults.length > 0 && (r = t.transformResults), 
                        new We(n, r);
                    }(t, e);
                }))) : [];
            }(t.writeResults, t.commitTime), n = ce(t.commitTime);
            return this.listener.au(n, e);
        }
        // The first response is always the handshake response
                return _(!t.writeResults || 0 === t.writeResults.length), this.ru = !0, 
        this.listener.uu();
    }, 
    /**
     * Sends an initial streamToken to the server, performing the handshake
     * required to make the StreamingWrite RPC work. Subsequent
     * calls should wait until onHandshakeComplete was called.
     */
    n.prototype.cu = function() {
        // TODO(dimond): Support stream resumption. We intentionally do not set the
        // stream token on the handshake, ignoring any stream token we might have.
        var t = {};
        t.database = ve(this.serializer), this.Ka(t);
    }, 
    /** Sends a group of mutations to the Firestore backend to apply. */ n.prototype.hu = function(t) {
        var e = this, n = {
            streamToken: this.lastStreamToken,
            writes: t.map((function(t) {
                return we(e.serializer, t);
            }))
        };
        this.Ka(n);
    }, n;
}(Fo), Bo = /** @class */ function(e) {
    function n(t, n) {
        var r = this;
        return (r = e.call(this) || this).credentials = t, r.serializer = n, r.lu = !1, 
        r;
    }
    return t(n, e), n.prototype._u = function() {
        if (this.lu) throw new F(q.FAILED_PRECONDITION, "The client has already been terminated.");
    }, n.prototype.start = function(t) {
        this.xa = t;
    }, 
    /** Gets an auth token and invokes the provided RPC. */ n.prototype.fu = function(t, e) {
        var n = this;
        return this._u(), this.credentials.getToken().then((function(r) {
            return n.xa.fu(t, e, r);
        })).catch((function(t) {
            throw t.code === q.UNAUTHENTICATED && n.credentials.ya(), t;
        }));
    }, 
    /** Gets an auth token and invokes the provided RPC with streamed results. */ n.prototype.du = function(t, e) {
        var n = this;
        return this._u(), this.credentials.getToken().then((function(r) {
            return n.xa.du(t, e, r);
        })).catch((function(t) {
            throw t.code === q.UNAUTHENTICATED && n.credentials.ya(), t;
        }));
    }, n;
}((function() {})), zo = /** @class */ function() {
    function t(t) {
        this.wu = t, 
        // The version of each document that was read during this transaction.
        this.Tu = new Map, this.mutations = [], this.Eu = !1, 
        /**
             * A deferred usage error that occurred previously in this transaction that
             * will cause the transaction to fail once it actually commits.
             */
        this.Iu = null, 
        /**
             * Set of documents that have been written in the transaction.
             *
             * When there's more than one write to the same key in a transaction, any
             * writes after the first are handled differently.
             */
        this.mu = new Set;
    }
    return t.prototype.Au = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    if (this.Ru(), this.mutations.length > 0) throw new F(q.INVALID_ARGUMENT, "Firestore transactions require all reads to be executed before all writes.");
                    return [ 4 /*yield*/ , function(t, r) {
                        return e(this, void 0, void 0, (function() {
                            var e, i, o, s, u;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = D(t), i = {
                                        database: ve(e.serializer),
                                        documents: r.map((function(t) {
                                            return le(e.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , e.du("BatchGetDocuments", i) ];

                                  case 1:
                                    return o = n.sent(), s = new Map, o.forEach((function(t) {
                                        var n = function(t, e) {
                                            return "found" in e ? function(t, e) {
                                                _(!!e.found), e.found.name, e.found.updateTime;
                                                var n = pe(t, e.found.name), r = ce(e.found.updateTime), i = new cn({
                                                    mapValue: {
                                                        fields: e.found.fields
                                                    }
                                                });
                                                return new pn(n, r, i, {});
                                            }(t, e) : "missing" in e ? function(t, e) {
                                                _(!!e.missing), _(!!e.readTime);
                                                var n = pe(t, e.missing), r = ce(e.readTime);
                                                return new dn(n, r);
                                            }(t, e) : A();
                                        }(e.serializer, t);
                                        s.set(n.key.toString(), n);
                                    })), u = [], [ 2 /*return*/ , (r.forEach((function(t) {
                                        var e = s.get(t.toString());
                                        _(!!e), u.push(e);
                                    })), u) ];
                                }
                            }));
                        }));
                    }(this.wu, t) ];

                  case 1:
                    return [ 2 /*return*/ , ((r = o.sent()).forEach((function(t) {
                        t instanceof dn || t instanceof pn ? i.Pu(t) : A();
                    })), r) ];
                }
            }));
        }));
    }, t.prototype.set = function(t, e) {
        this.write(e.la(t, this.Ue(t))), this.mu.add(t);
    }, t.prototype.update = function(t, e) {
        try {
            this.write(e.la(t, this.gu(t)));
        } catch (t) {
            this.Iu = t;
        }
        this.mu.add(t);
    }, t.prototype.delete = function(t) {
        this.write([ new un(t, this.Ue(t)) ]), this.mu.add(t);
    }, t.prototype.commit = function() {
        return e(this, void 0, void 0, (function() {
            var t, r = this;
            return n(this, (function(i) {
                switch (i.label) {
                  case 0:
                    if (this.Ru(), this.Iu) throw this.Iu;
                    return t = this.Tu, 
                    // For each mutation, note that the doc was written.
                    this.mutations.forEach((function(e) {
                        t.delete(e.key.toString());
                    })), 
                    // For each document that was read but not written to, we want to perform
                    // a `verify` operation.
                    t.forEach((function(t, e) {
                        var n = new Q(z.N(e));
                        r.mutations.push(new an(n, r.Ue(n)));
                    })), [ 4 /*yield*/ , function(t, r) {
                        return e(this, void 0, void 0, (function() {
                            var e, i;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return e = D(t), i = {
                                        database: ve(e.serializer),
                                        writes: r.map((function(t) {
                                            return we(e.serializer, t);
                                        }))
                                    }, [ 4 /*yield*/ , e.fu("Commit", i) ];

                                  case 1:
                                    return n.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    }(this.wu, this.mutations) ];

                  case 1:
                    // For each mutation, note that the doc was written.
                    return i.sent(), this.Eu = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Pu = function(t) {
        var e;
        if (t instanceof pn) e = t.version; else {
            if (!(t instanceof dn)) throw A();
            // For deleted docs, we must use baseVersion 0 when we overwrite them.
                        e = G.min();
        }
        var n = this.Tu.get(t.key.toString());
        if (n) {
            if (!e.isEqual(n)) 
            // This transaction will fail no matter what.
            throw new F(q.ABORTED, "Document version changed between two reads.");
        } else this.Tu.set(t.key.toString(), e);
    }, 
    /**
     * Returns the version of this document when it was read in this transaction,
     * as a precondition, or no precondition if it was not read.
     */
    t.prototype.Ue = function(t) {
        var e = this.Tu.get(t.toString());
        return !this.mu.has(t) && e ? Ke.updateTime(e) : Ke.We();
    }, 
    /**
     * Returns the precondition for a document if the operation is an update.
     */
    t.prototype.gu = function(t) {
        var e = this.Tu.get(t.toString());
        // The first time a document is written, we want to take into account the
        // read time and existence
                if (!this.mu.has(t) && e) {
            if (e.isEqual(G.min())) 
            // The document doesn't exist, so fail the transaction.
            // This has to be validated locally because you can't send a
            // precondition that a document does not exist without changing the
            // semantics of the backend write to be an insert. This is the reverse
            // of what we want, since we want to assert that the document doesn't
            // exist but then send the update and have it fail. Since we can't
            // express that to the backend, we have to validate locally.
            // Note: this can change once we can send separate verify writes in the
            // transaction.
            throw new F(q.INVALID_ARGUMENT, "Can't update a document that doesn't exist.");
            // Document exists, base precondition on document update time.
                        return Ke.updateTime(e);
        }
        // Document was not read, so we just use the preconditions for a blind
        // update.
                return Ke.exists(!0);
    }, t.prototype.write = function(t) {
        this.Ru(), this.mutations = this.mutations.concat(t);
    }, t.prototype.Ru = function() {}, t;
}(), Wo = /** @class */ function() {
    function t(t, e) {
        this.ao = t, this.Vu = e, 
        /** The current OnlineState. */
        this.state = "Unknown" /* Unknown */ , 
        /**
             * A count of consecutive failures to open the stream. If it reaches the
             * maximum defined by MAX_WATCH_STREAM_FAILURES, we'll set the OnlineState to
             * Offline.
             */
        this.yu = 0, 
        /**
             * A timer that elapses after ONLINE_STATE_TIMEOUT_MS, at which point we
             * transition from OnlineState.Unknown to OnlineState.Offline without waiting
             * for the stream to actually fail (MAX_WATCH_STREAM_FAILURES times).
             */
        this.pu = null, 
        /**
             * Whether the client should log a warning message if it fails to connect to
             * the backend (initially true, cleared after a successful stream, or if we've
             * logged the message already).
             */
        this.bu = !0
        /**
     * Called by RemoteStore when a watch stream is started (including on each
     * backoff attempt).
     *
     * If this is the first attempt, it sets the OnlineState to Unknown and starts
     * the onlineStateTimer.
     */;
    }
    return t.prototype.vu = function() {
        var t = this;
        0 === this.yu && (this.Su("Unknown" /* Unknown */), this.pu = this.ao.bs("online_state_timeout" /* OnlineStateTimeout */ , 1e4, (function() {
            return t.pu = null, t.Du("Backend didn't respond within 10 seconds."), t.Su("Offline" /* Offline */), 
            Promise.resolve();
        })));
    }, 
    /**
     * Updates our OnlineState as appropriate after the watch stream reports a
     * failure. The first failure moves us to the 'Unknown' state. We then may
     * allow multiple failures (based on MAX_WATCH_STREAM_FAILURES) before we
     * actually transition to the 'Offline' state.
     */
    t.prototype.Cu = function(t) {
        "Online" /* Online */ === this.state ? this.Su("Unknown" /* Unknown */) : (this.yu++, 
        this.yu >= 1 && (this.Fu(), this.Du("Connection failed 1 times. Most recent error: " + t.toString()), 
        this.Su("Offline" /* Offline */)));
    }, 
    /**
     * Explicitly sets the OnlineState to the specified state.
     *
     * Note that this resets our timers / failure counters, etc. used by our
     * Offline heuristics, so must not be used in place of
     * handleWatchStreamStart() and handleWatchStreamFailure().
     */
    t.prototype.set = function(t) {
        this.Fu(), this.yu = 0, "Online" /* Online */ === t && (
        // We've connected to watch at least once. Don't warn the developer
        // about being offline going forward.
        this.bu = !1), this.Su(t);
    }, t.prototype.Su = function(t) {
        t !== this.state && (this.state = t, this.Vu(t));
    }, t.prototype.Du = function(t) {
        var e = "Could not reach Cloud Firestore backend. " + t + "\nThis typically indicates that your device does not have a healthy Internet connection at the moment. The client will operate in offline mode until it is able to successfully connect to the backend.";
        this.bu ? (T(e), this.bu = !1) : E("OnlineStateTracker", e);
    }, t.prototype.Fu = function() {
        null !== this.pu && (this.pu.cancel(), this.pu = null);
    }, t;
}(), Ko = /** @class */ function() {
    function t(
    /**
     * The local store, used to fill the write pipeline with outbound mutations.
     */
    t, 
    /** The client-side proxy for interacting with the backend. */
    r, i, o, s) {
        var u = this;
        this.$u = t, this.wu = r, this.ao = i, 
        /**
             * A list of up to MAX_PENDING_WRITES writes that we have fetched from the
             * LocalStore via fillWritePipeline() and have or will send to the write
             * stream.
             *
             * Whenever writePipeline.length > 0 the RemoteStore will attempt to start or
             * restart the write stream. When the stream is established the writes in the
             * pipeline will be sent in order.
             *
             * Writes remain in writePipeline until they are acknowledged by the backend
             * and thus will automatically be re-sent if the stream is interrupted /
             * restarted before they're acknowledged.
             *
             * Write responses from the backend are linked to their originating request
             * purely based on order, and so we can just shift() writes from the front of
             * the writePipeline as we receive responses.
             */
        this.Nu = [], 
        /**
             * A mapping of watched targets that the client cares about tracking and the
             * user has explicitly called a 'listen' for this target.
             *
             * These targets may or may not have been sent to or acknowledged by the
             * server. On re-establishing the listen stream, these targets should be sent
             * to the server. The targets removed with unlistens are removed eagerly
             * without waiting for confirmation from the listen stream.
             */
        this.ku = new Map, this.xu = null, 
        /**
             * A set of reasons for why the RemoteStore may be offline. If empty, the
             * RemoteStore may start its network connections.
             */
        this.Mu = new Set, this.Ou = s, this.Ou.Lu((function(t) {
            i.Zi((function() {
                return e(u, void 0, void 0, (function() {
                    return n(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            return this.qu() ? (E("RemoteStore", "Restarting streams for network reachability change."), 
                            [ 4 /*yield*/ , this.Bu() ]) : [ 3 /*break*/ , 2 ];

                          case 1:
                            t.sent(), t.label = 2;

                          case 2:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }));
            }));
        })), this.Uu = new Wo(i, o), 
        // Create streams (but note they're not started yet).
        this.Wu = function(t, e, n) {
            var r = D(t);
            return r._u(), new jo(e, r.xa, r.credentials, r.serializer, n);
        }(this.wu, i, {
            tu: this.Qu.bind(this),
            Ha: this.ju.bind(this),
            nu: this.Ku.bind(this)
        }), this.Gu = function(t, e, n) {
            var r = D(t);
            return r._u(), new Go(e, r.xa, r.credentials, r.serializer, n);
        }(this.wu, i, {
            tu: this.zu.bind(this),
            Ha: this.Hu.bind(this),
            uu: this.Yu.bind(this),
            au: this.au.bind(this)
        });
    }
    /**
     * Starts up the remote store, creating streams, restoring state from
     * LocalStore, etc.
     */    return t.prototype.start = function() {
        return this.enableNetwork();
    }, 
    /** Re-enables the network. Idempotent. */ t.prototype.enableNetwork = function() {
        return this.Mu.delete(0 /* UserDisabled */), this.Ju();
    }, t.prototype.Ju = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.qu() ? (this.Xu() ? this.Zu() : this.Uu.set("Unknown" /* Unknown */), 
                    [ 4 /*yield*/ , this.tc() ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    // This will start the write stream if necessary.
                    t.sent(), t.label = 2;

                  case 2:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Temporarily disables the network. The network can be re-enabled using
     * enableNetwork().
     */
    t.prototype.disableNetwork = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.Mu.add(0 /* UserDisabled */), [ 4 /*yield*/ , this.ec() ];

                  case 1:
                    return t.sent(), 
                    // Set the OnlineState to Offline so get()s return from cache, etc.
                    this.Uu.set("Offline" /* Offline */), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.ec = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.Gu.stop() ];

                  case 1:
                    return t.sent(), [ 4 /*yield*/ , this.Wu.stop() ];

                  case 2:
                    return t.sent(), this.Nu.length > 0 && (E("RemoteStore", "Stopping write stream with " + this.Nu.length + " pending writes"), 
                    this.Nu = []), this.nc(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype._r = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return E("RemoteStore", "RemoteStore shutting down."), this.Mu.add(5 /* Shutdown */), 
                    [ 4 /*yield*/ , this.ec() ];

                  case 1:
                    return t.sent(), this.Ou._r(), 
                    // Set the OnlineState to Unknown (rather than Offline) to avoid potentially
                    // triggering spurious listener events with cached data, etc.
                    this.Uu.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Starts new listen for the given target. Uses resume token if provided. It
     * is a no-op if the target of given `TargetData` is already being listened to.
     */
    t.prototype.listen = function(t) {
        this.ku.has(t.targetId) || (
        // Mark this as something the client is currently listening for.
        this.ku.set(t.targetId, t), this.Xu() ? 
        // The listen will be sent in onWatchStreamOpen
        this.Zu() : this.Wu.Ba() && this.sc(t));
    }, 
    /**
     * Removes the listen from server. It is a no-op if the given target id is
     * not being listened to.
     */
    t.prototype.ic = function(t) {
        this.ku.delete(t), this.Wu.Ba() && this.rc(t), 0 === this.ku.size && (this.Wu.Ba() ? this.Wu.Qa() : this.qu() && 
        // Revert to OnlineState.Unknown if the watch stream is not open and we
        // have no listeners, since without any listens to send we cannot
        // confirm if the stream is healthy and upgrade to OnlineState.Online.
        this.Uu.set("Unknown" /* Unknown */));
    }, 
    /** {@link TargetMetadataProvider.getTargetDataForTarget} */ t.prototype.Me = function(t) {
        return this.ku.get(t) || null;
    }, 
    /** {@link TargetMetadataProvider.getRemoteKeysForTarget} */ t.prototype.xe = function(t) {
        return this.oc.xe(t);
    }, 
    /**
     * We need to increment the the expected number of pending responses we're due
     * from watch so we wait for the ack to process any messages from this target.
     */
    t.prototype.sc = function(t) {
        this.xu.de(t.targetId), this.Wu.su(t);
    }, 
    /**
     * We need to increment the expected number of pending responses we're due
     * from watch so we wait for the removal on the server before we process any
     * messages from this target.
     */
    t.prototype.rc = function(t) {
        this.xu.de(t), this.Wu.iu(t);
    }, t.prototype.Zu = function() {
        this.xu = new Ot(this), this.Wu.start(), this.Uu.vu();
    }, 
    /**
     * Returns whether the watch stream should be started because it's necessary
     * and has not yet been started.
     */
    t.prototype.Xu = function() {
        return this.qu() && !this.Wu.qa() && this.ku.size > 0;
    }, t.prototype.qu = function() {
        return 0 === this.Mu.size;
    }, t.prototype.nc = function() {
        this.xu = null;
    }, t.prototype.Qu = function() {
        return e(this, void 0, void 0, (function() {
            var t = this;
            return n(this, (function(e) {
                return this.ku.forEach((function(e, n) {
                    t.sc(e);
                })), [ 2 /*return*/ ];
            }));
        }));
    }, t.prototype.ju = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                return this.nc(), 
                // If we still need the watch stream, retry the connection.
                this.Xu() ? (this.Uu.Cu(t), this.Zu()) : 
                // No need to restart watch stream because there are no active targets.
                // The online state is set to unknown because there is no active attempt
                // at establishing a connection
                this.Uu.set("Unknown" /* Unknown */), [ 2 /*return*/ ];
            }));
        }));
    }, t.prototype.Ku = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (this.Uu.set("Online" /* Online */), !(t instanceof Pt && 2 /* Removed */ === t.state && t.cause)) 
                    // Mark the client as online since we got a message from the server
                    return [ 3 /*break*/ , 6 ];
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 5 ]), [ 4 /*yield*/ , this.hc(t) ];

                  case 2:
                    return n.sent(), [ 3 /*break*/ , 5 ];

                  case 3:
                    return e = n.sent(), E("RemoteStore", "Failed to remove targets %s: %s ", t.targetIds.join(","), e), 
                    [ 4 /*yield*/ , this.ac(e) ];

                  case 4:
                    return n.sent(), [ 3 /*break*/ , 5 ];

                  case 5:
                    return [ 3 /*break*/ , 13 ];

                  case 6:
                    if (t instanceof xt ? this.xu.Pe(t) : t instanceof kt ? this.xu.De(t) : this.xu.ye(t), 
                    r.isEqual(G.min())) return [ 3 /*break*/ , 13 ];
                    n.label = 7;

                  case 7:
                    return n.trys.push([ 7, 11, , 13 ]), [ 4 /*yield*/ , this.$u.ai() ];

                  case 8:
                    return i = n.sent(), r.o(i) >= 0 ? [ 4 /*yield*/ , this.uc(r) ] : [ 3 /*break*/ , 10 ];

                    // We have received a target change with a global snapshot if the snapshot
                    // version is not equal to SnapshotVersion.min().
                                      case 9:
                    // We have received a target change with a global snapshot if the snapshot
                    // version is not equal to SnapshotVersion.min().
                    n.sent(), n.label = 10;

                  case 10:
                    return [ 3 /*break*/ , 13 ];

                  case 11:
                    return E("RemoteStore", "Failed to raise snapshot:", o = n.sent()), [ 4 /*yield*/ , this.ac(o) ];

                  case 12:
                    return n.sent(), [ 3 /*break*/ , 13 ];

                  case 13:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Recovery logic for IndexedDB errors that takes the network offline until
     * `op` succeeds. Retries are scheduled with backoff using
     * `enqueueRetryable()`. If `op()` is not provided, IndexedDB access is
     * validated via a generic operation.
     *
     * The returned Promise is resolved once the network is disabled and before
     * any retry attempt.
     */
    t.prototype.ac = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    if (!hi(t)) throw t;
                    // Disable network and raise offline snapshots
                    return this.Mu.add(1 /* IndexedDbFailed */), [ 4 /*yield*/ , this.ec() ];

                  case 1:
                    // Disable network and raise offline snapshots
                    return o.sent(), this.Uu.set("Offline" /* Offline */), r || (
                    // Use a simple read operation to determine if IndexedDB recovered.
                    // Ideally, we would expose a health check directly on SimpleDb, but
                    // RemoteStore only has access to persistence through LocalStore.
                    r = function() {
                        return i.$u.ai();
                    }), 
                    // Probe IndexedDB periodically and re-enable network
                    this.ao.er((function() {
                        return e(i, void 0, void 0, (function() {
                            return n(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return E("RemoteStore", "Retrying IndexedDB access"), [ 4 /*yield*/ , r() ];

                                  case 1:
                                    return t.sent(), this.Mu.delete(1 /* IndexedDbFailed */), [ 4 /*yield*/ , this.Ju() ];

                                  case 2:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Executes `op`. If `op` fails, takes the network offline until `op`
     * succeeds. Returns after the first attempt.
     */
    t.prototype.cc = function(t) {
        var e = this;
        return t().catch((function(n) {
            return e.ac(n, t);
        }));
    }, 
    /**
     * Takes a batch of changes from the Datastore, repackages them as a
     * RemoteEvent, and passes that on to the listener, which is typically the
     * SyncEngine.
     */
    t.prototype.uc = function(t) {
        var e = this, n = this.xu.$e(t);
        // Update in-memory resume tokens. LocalStore will update the
        // persistent view of these when applying the completed RemoteEvent.
        // Finally raise remote event
        return n.Wt.forEach((function(n, r) {
            if (n.resumeToken.H() > 0) {
                var i = e.ku.get(r);
                // A watched target might have been removed already.
                                i && e.ku.set(r, i.tt(n.resumeToken, t));
            }
        })), 
        // Re-establish listens for the targets that have been invalidated by
        // existence filter mismatches.
        n.Qt.forEach((function(t) {
            var n = e.ku.get(t);
            if (n) {
                // Clear the resume token for the target, since we're in a known mismatch
                // state.
                e.ku.set(t, n.tt(nt.Y, n.X)), 
                // Cause a hard reset by unwatching and rewatching immediately, but
                // deliberately don't send a resume token so that we get a full update.
                e.rc(t);
                // Mark the target we send as being on behalf of an existence filter
                // mismatch, but don't actually retain that in listenTargets. This ensures
                // that we flag the first re-listen this way without impacting future
                // listens of this target (that might happen e.g. on reconnect).
                var r = new ot(n.target, t, 1 /* ExistenceFilterMismatch */ , n.sequenceNumber);
                e.sc(r);
            }
        })), this.oc.vh(n);
    }, 
    /** Handles an error on a target */ t.prototype.hc = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    e = t.cause, r = 0, i = t.targetIds, n.label = 1;

                  case 1:
                    return r < i.length ? (o = i[r], this.ku.has(o) ? [ 4 /*yield*/ , this.oc.lc(o, e) ] : [ 3 /*break*/ , 3 ]) : [ 3 /*break*/ , 5 ];

                  case 2:
                    n.sent(), this.ku.delete(o), this.xu.removeTarget(o), n.label = 3;

                  case 3:
                    n.label = 4;

                  case 4:
                    return r++, [ 3 /*break*/ , 1 ];

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Attempts to fill our write pipeline with writes from the LocalStore.
     *
     * Called internally to bootstrap or refill the write pipeline and by
     * SyncEngine whenever there are new mutations to process.
     *
     * Starts the write stream if necessary.
     */
    t.prototype.tc = function() {
        return e(this, void 0, void 0, (function() {
            var t, e, r;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    t = this.Nu.length > 0 ? this.Nu[this.Nu.length - 1].batchId : -1, n.label = 1;

                  case 1:
                    if (!this._c()) return [ 3 /*break*/ , 7 ];
                    n.label = 2;

                  case 2:
                    return n.trys.push([ 2, 4, , 6 ]), [ 4 /*yield*/ , this.$u.Fh(t) ];

                  case 3:
                    return null === (e = n.sent()) ? (0 === this.Nu.length && this.Gu.Qa(), [ 3 /*break*/ , 7 ]) : (t = e.batchId, 
                    this.fc(e), [ 3 /*break*/ , 6 ]);

                  case 4:
                    return r = n.sent(), [ 4 /*yield*/ , this.ac(r) ];

                  case 5:
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 6:
                    return [ 3 /*break*/ , 1 ];

                  case 7:
                    return this.dc() && this.wc(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Returns true if we can add to the write pipeline (i.e. the network is
     * enabled and the write pipeline is not full).
     */
    t.prototype._c = function() {
        return this.qu() && this.Nu.length < 10;
    }, 
    // For testing
    t.prototype.Tc = function() {
        return this.Nu.length;
    }, 
    /**
     * Queues additional writes to be sent to the write stream, sending them
     * immediately if the write stream is established.
     */
    t.prototype.fc = function(t) {
        this.Nu.push(t), this.Gu.Ba() && this.Gu.ou && this.Gu.hu(t.mutations);
    }, t.prototype.dc = function() {
        return this.qu() && !this.Gu.qa() && this.Nu.length > 0;
    }, t.prototype.wc = function() {
        this.Gu.start();
    }, t.prototype.zu = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                return this.Gu.cu(), [ 2 /*return*/ ];
            }));
        }));
    }, t.prototype.Yu = function() {
        return e(this, void 0, void 0, (function() {
            var t, e, r;
            return n(this, (function(n) {
                // Send the write pipeline now that the stream is established.
                for (t = 0, e = this.Nu; t < e.length; t++) r = e[t], this.Gu.hu(r.mutations);
                return [ 2 /*return*/ ];
            }));
        }));
    }, t.prototype.au = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return e = this.Nu.shift(), i = Wn.from(e, t, r), [ 4 /*yield*/ , this.cc((function() {
                        return o.oc.Ec(i);
                    })) ];

                  case 1:
                    // It's possible that with the completion of this mutation another
                    // slot has freed up.
                    return n.sent(), [ 4 /*yield*/ , this.tc() ];

                  case 2:
                    // It's possible that with the completion of this mutation another
                    // slot has freed up.
                    return n.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Hu = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return t && this.Gu.ou ? [ 4 /*yield*/ , this.Ic(t) ] : [ 3 /*break*/ , 2 ];

                    // This error affects the actual write.
                                      case 1:
                    // This error affects the actual write.
                    e.sent(), e.label = 2;

                  case 2:
                    // If the write stream closed after the write handshake completes, a write
                    // operation failed and we fail the pending operation.
                    // The write stream might have been started by refilling the write
                    // pipeline for failed writes
                    return this.dc() && this.wc(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Ic = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return ut(r = t.code) && r !== q.ABORTED ? (e = this.Nu.shift(), 
                    // In this case it's also unlikely that the server itself is melting
                    // down -- this was just a bad request so inhibit backoff on the next
                    // restart.
                    this.Gu.Wa(), [ 4 /*yield*/ , this.cc((function() {
                        return i.oc.mc(e.batchId, t);
                    })) ]) : [ 3 /*break*/ , 3 ];

                  case 1:
                    // It's possible that with the completion of this mutation
                    // another slot has freed up.
                    return n.sent(), [ 4 /*yield*/ , this.tc() ];

                  case 2:
                    // In this case it's also unlikely that the server itself is melting
                    // down -- this was just a bad request so inhibit backoff on the next
                    // restart.
                    // It's possible that with the completion of this mutation
                    // another slot has freed up.
                    n.sent(), n.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Ac = function() {
        return new zo(this.wu);
    }, t.prototype.Bu = function() {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(t) {
                switch (t.label) {
                  case 0:
                    return this.Mu.add(4 /* ConnectivityChange */), [ 4 /*yield*/ , this.ec() ];

                  case 1:
                    return t.sent(), this.Uu.set("Unknown" /* Unknown */), this.Gu.Wa(), this.Wu.Wa(), 
                    this.Mu.delete(4 /* ConnectivityChange */), [ 4 /*yield*/ , this.Ju() ];

                  case 2:
                    return t.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Rc = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                switch (e.label) {
                  case 0:
                    return this.ao.$o(), 
                    // Tear down and re-create our network streams. This will ensure we get a
                    // fresh auth token for the new user and re-fill the write pipeline with
                    // new mutations from the LocalStore (since mutations are per-user).
                    E("RemoteStore", "RemoteStore received new credentials"), this.Mu.add(3 /* CredentialChange */), 
                    [ 4 /*yield*/ , this.ec() ];

                  case 1:
                    return e.sent(), this.Uu.set("Unknown" /* Unknown */), [ 4 /*yield*/ , this.oc.Rc(t) ];

                  case 2:
                    return e.sent(), this.Mu.delete(3 /* CredentialChange */), [ 4 /*yield*/ , this.Ju() ];

                  case 3:
                    return e.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Toggles the network state when the client gains or loses its primary lease.
     */
    t.prototype.Pc = function(t) {
        return e(this, void 0, void 0, (function() {
            var e;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return t ? (this.Mu.delete(2 /* IsSecondary */), [ 4 /*yield*/ , this.Ju() ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    return n.sent(), [ 3 /*break*/ , 5 ];

                  case 2:
                    return (e = t) ? [ 3 /*break*/ , 4 ] : (this.Mu.add(2 /* IsSecondary */), [ 4 /*yield*/ , this.ec() ]);

                  case 3:
                    n.sent(), e = this.Uu.set("Unknown" /* Unknown */), n.label = 4;

                  case 4:
                    e, n.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t;
}();

/** A CredentialsProvider that always yields an empty token. */
/**
 * @license
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// The format of the LocalStorage key that stores the client state is:
//     firestore_clients_<persistence_prefix>_<instance_key>
/** Assembles the key for a client state in WebStorage */
function Qo(t, e) {
    return "firestore_clients_" + t + "_" + e;
}

// The format of the WebStorage key that stores the mutation state is:
//     firestore_mutations_<persistence_prefix>_<batch_id>
//     (for unauthenticated users)
// or: firestore_mutations_<persistence_prefix>_<batch_id>_<user_uid>
// 'user_uid' is last to avoid needing to escape '_' characters that it might
// contain.
/** Assembles the key for a mutation batch in WebStorage */ function $o(t, e, n) {
    var r = "firestore_mutations_" + t + "_" + n;
    return e.Mr() && (r += "_" + e.uid), r;
}

// The format of the WebStorage key that stores a query target's metadata is:
//     firestore_targets_<persistence_prefix>_<target_id>
/** Assembles the key for a query state in WebStorage */ function Ho(t, e) {
    return "firestore_targets_" + t + "_" + e;
}

// The WebStorage prefix that stores the primary tab's online state. The
// format of the key is:
//     firestore_online_state_<persistence_prefix>
/**
 * Holds the state of a mutation batch, including its user ID, batch ID and
 * whether the batch is 'pending', 'acknowledged' or 'rejected'.
 */
// Visible for testing
var Xo = /** @class */ function() {
    function t(t, e, n, r) {
        this.user = t, this.batchId = e, this.state = n, this.error = r
        /**
     * Parses a MutationMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.gc = function(e, n, r) {
        var i = JSON.parse(r), o = "object" == typeof i && -1 !== [ "pending", "acknowledged", "rejected" ].indexOf(i.state) && (void 0 === i.error || "object" == typeof i.error), s = void 0;
        return o && i.error && ((o = "string" == typeof i.error.message && "string" == typeof i.error.code) && (s = new F(i.error.code, i.error.message))), 
        o ? new t(e, n, i.state, s) : (T("SharedClientState", "Failed to parse mutation state for ID '" + n + "': " + r), 
        null);
    }, t.prototype.Vc = function() {
        var t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }, t;
}(), Yo = /** @class */ function() {
    function t(t, e, n) {
        this.targetId = t, this.state = e, this.error = n
        /**
     * Parses a QueryTargetMetadata from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.gc = function(e, n) {
        var r = JSON.parse(n), i = "object" == typeof r && -1 !== [ "not-current", "current", "rejected" ].indexOf(r.state) && (void 0 === r.error || "object" == typeof r.error), o = void 0;
        return i && r.error && ((i = "string" == typeof r.error.message && "string" == typeof r.error.code) && (o = new F(r.error.code, r.error.message))), 
        i ? new t(e, r.state, o) : (T("SharedClientState", "Failed to parse target state for ID '" + e + "': " + n), 
        null);
    }, t.prototype.Vc = function() {
        var t = {
            state: this.state,
            updateTimeMs: Date.now()
        };
        return this.error && (t.error = {
            code: this.error.code,
            message: this.error.message
        }), JSON.stringify(t);
    }, t;
}(), Zo = /** @class */ function() {
    function t(t, e) {
        this.clientId = t, this.activeTargetIds = e
        /**
     * Parses a RemoteClientState from the JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.gc = function(e, n) {
        for (var r = JSON.parse(n), i = "object" == typeof r && r.activeTargetIds instanceof Array, o = Tt(), s = 0; i && s < r.activeTargetIds.length; ++s) i = X(r.activeTargetIds[s]), 
        o = o.add(r.activeTargetIds[s]);
        return i ? new t(e, o) : (T("SharedClientState", "Failed to parse client data for instance '" + e + "': " + n), 
        null);
    }, t;
}(), Jo = /** @class */ function() {
    function t(t, e) {
        this.clientId = t, this.onlineState = e
        /**
     * Parses a SharedOnlineState from its JSON representation in WebStorage.
     * Logs a warning and returns null if the format of the data is not valid.
     */;
    }
    return t.gc = function(e) {
        var n = JSON.parse(e);
        return "object" == typeof n && -1 !== [ "Unknown", "Online", "Offline" ].indexOf(n.onlineState) && "string" == typeof n.clientId ? new t(n.clientId, n.onlineState) : (T("SharedClientState", "Failed to parse online state: " + e), 
        null);
    }, t;
}(), ts = /** @class */ function() {
    function t() {
        this.activeTargetIds = Tt();
    }
    return t.prototype.yc = function(t) {
        this.activeTargetIds = this.activeTargetIds.add(t);
    }, t.prototype.pc = function(t) {
        this.activeTargetIds = this.activeTargetIds.delete(t);
    }, 
    /**
     * Converts this entry into a JSON-encoded format we can use for WebStorage.
     * Does not encode `clientId` as it is part of the key in WebStorage.
     */
    t.prototype.Vc = function() {
        var t = {
            activeTargetIds: this.activeTargetIds.F(),
            updateTimeMs: Date.now()
        };
        return JSON.stringify(t);
    }, t;
}(), es = /** @class */ function() {
    function t(t, e, n, r, i) {
        this.window = t, this.Ts = e, this.persistenceKey = n, this.bc = r, this.oc = null, 
        this.Vu = null, this.ls = null, this.vc = this.Sc.bind(this), this.Dc = new ct(k), 
        this.Hi = !1, 
        /**
             * Captures WebStorage events that occur before `start()` is called. These
             * events are replayed once `WebStorageSharedClientState` is started.
             */
        this.Cc = [];
        // Escape the special characters mentioned here:
        // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Regular_Expressions
        var o = n.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
        this.storage = this.window.localStorage, this.currentUser = i, this.Fc = Qo(this.persistenceKey, this.bc), 
        this.$c = 
        /** Assembles the key for the current sequence number. */
        function(t) {
            return "firestore_sequence_number_" + t;
        }(this.persistenceKey), this.Dc = this.Dc.nt(this.bc, new ts), this.Nc = new RegExp("^firestore_clients_" + o + "_([^_]*)$"), 
        this.kc = new RegExp("^firestore_mutations_" + o + "_(\\d+)(?:_(.*))?$"), this.xc = new RegExp("^firestore_targets_" + o + "_(\\d+)$"), 
        this.Mc = 
        /** Assembles the key for the online state of the primary tab. */
        function(t) {
            return "firestore_online_state_" + t;
        }(this.persistenceKey), 
        // Rather than adding the storage observer during start(), we add the
        // storage observer during initialization. This ensures that we collect
        // events before other components populate their initial state (during their
        // respective start() calls). Otherwise, we might for example miss a
        // mutation that is added after LocalStore's start() processed the existing
        // mutations but before we observe WebStorage events.
        this.window.addEventListener("storage", this.vc);
    }
    /** Returns 'true' if WebStorage is available in the current environment. */    return t.Oi = function(t) {
        return !(!t || !t.localStorage);
    }, t.prototype.start = function() {
        return e(this, void 0, void 0, (function() {
            var t, e, r, i, o, s, u, a, c, h, f, l = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.oc.Ir() ];

                  case 1:
                    for (t = n.sent(), e = 0, r = t; e < r.length; e++) (i = r[e]) !== this.bc && (o = this.getItem(Qo(this.persistenceKey, i))) && (s = Zo.gc(i, o)) && (this.Dc = this.Dc.nt(s.clientId, s));
                    for (this.Oc(), (u = this.storage.getItem(this.Mc)) && (a = this.Lc(u)) && this.qc(a), 
                    c = 0, h = this.Cc; c < h.length; c++) f = h[c], this.Sc(f);
                    return this.Cc = [], 
                    // Register a window unload hook to remove the client metadata entry from
                    // WebStorage even if `shutdown()` was not called.
                    this.window.addEventListener("unload", (function() {
                        return l._r();
                    })), this.Hi = !0, [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.ds = function(t) {
        this.setItem(this.$c, JSON.stringify(t));
    }, t.prototype.Bc = function() {
        return this.Uc(this.Dc);
    }, t.prototype.Wc = function(t) {
        var e = !1;
        return this.Dc.forEach((function(n, r) {
            r.activeTargetIds.has(t) && (e = !0);
        })), e;
    }, t.prototype.Qc = function(t) {
        this.jc(t, "pending");
    }, t.prototype.Kc = function(t, e, n) {
        this.jc(t, e, n), 
        // Once a final mutation result is observed by other clients, they no longer
        // access the mutation's metadata entry. Since WebStorage replays events
        // in order, it is safe to delete the entry right after updating it.
        this.Gc(t);
    }, t.prototype.zc = function(t) {
        var e = "not-current";
        // Lookup an existing query state if the target ID was already registered
        // by another tab
                if (this.Wc(t)) {
            var n = this.storage.getItem(Ho(this.persistenceKey, t));
            if (n) {
                var r = Yo.gc(t, n);
                r && (e = r.state);
            }
        }
        return this.Hc.yc(t), this.Oc(), e;
    }, t.prototype.Yc = function(t) {
        this.Hc.pc(t), this.Oc();
    }, t.prototype.Jc = function(t) {
        return this.Hc.activeTargetIds.has(t);
    }, t.prototype.Xc = function(t) {
        this.removeItem(Ho(this.persistenceKey, t));
    }, t.prototype.Zc = function(t, e, n) {
        this.tl(t, e, n);
    }, t.prototype.Ah = function(t, e, n) {
        var r = this;
        e.forEach((function(t) {
            r.Gc(t);
        })), this.currentUser = t, n.forEach((function(t) {
            r.Qc(t);
        }));
    }, t.prototype.el = function(t) {
        this.nl(t);
    }, t.prototype._r = function() {
        this.Hi && (this.window.removeEventListener("storage", this.vc), this.removeItem(this.Fc), 
        this.Hi = !1);
    }, t.prototype.getItem = function(t) {
        var e = this.storage.getItem(t);
        return E("SharedClientState", "READ", t, e), e;
    }, t.prototype.setItem = function(t, e) {
        E("SharedClientState", "SET", t, e), this.storage.setItem(t, e);
    }, t.prototype.removeItem = function(t) {
        E("SharedClientState", "REMOVE", t), this.storage.removeItem(t);
    }, t.prototype.Sc = function(t) {
        var r = this, i = t;
        // Note: The function is typed to take Event to be interface-compatible with
        // `Window.addEventListener`.
                if (i.storageArea === this.storage) {
            if (E("SharedClientState", "EVENT", i.key, i.newValue), i.key === this.Fc) return void T("Received WebStorage notification for local change. Another client might have garbage-collected our state");
            this.Ts.er((function() {
                return e(r, void 0, void 0, (function() {
                    var t, e, r, o, s, u;
                    return n(this, (function(n) {
                        if (this.Hi) {
                            if (null !== i.key) if (this.Nc.test(i.key)) {
                                if (null == i.newValue) return t = this.sl(i.key), [ 2 /*return*/ , this.il(t, null) ];
                                if (e = this.rl(i.key, i.newValue)) return [ 2 /*return*/ , this.il(e.clientId, e) ];
                            } else if (this.kc.test(i.key)) {
                                if (null !== i.newValue && (r = this.ol(i.key, i.newValue))) return [ 2 /*return*/ , this.hl(r) ];
                            } else if (this.xc.test(i.key)) {
                                if (null !== i.newValue && (o = this.al(i.key, i.newValue))) return [ 2 /*return*/ , this.ul(o) ];
                            } else if (i.key === this.Mc) {
                                if (null !== i.newValue && (s = this.Lc(i.newValue))) return [ 2 /*return*/ , this.qc(s) ];
                            } else i.key === this.$c && (u = function(t) {
                                var e = Zn.ws;
                                if (null != t) try {
                                    var n = JSON.parse(t);
                                    _("number" == typeof n), e = n;
                                } catch (t) {
                                    T("SharedClientState", "Failed to read sequence number from WebStorage", t);
                                }
                                return e;
                            }(i.newValue)) !== Zn.ws && this.ls(u);
                        } else this.Cc.push(i);
                        return [ 2 /*return*/ ];
                    }));
                }));
            }));
        }
    }, Object.defineProperty(t.prototype, "Hc", {
        get: function() {
            return this.Dc.get(this.bc);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Oc = function() {
        this.setItem(this.Fc, this.Hc.Vc());
    }, t.prototype.jc = function(t, e, n) {
        var r = new Xo(this.currentUser, t, e, n), i = $o(this.persistenceKey, this.currentUser, t);
        this.setItem(i, r.Vc());
    }, t.prototype.Gc = function(t) {
        var e = $o(this.persistenceKey, this.currentUser, t);
        this.removeItem(e);
    }, t.prototype.nl = function(t) {
        var e = {
            clientId: this.bc,
            onlineState: t
        };
        this.storage.setItem(this.Mc, JSON.stringify(e));
    }, t.prototype.tl = function(t, e, n) {
        var r = Ho(this.persistenceKey, t), i = new Yo(t, e, n);
        this.setItem(r, i.Vc());
    }, 
    /**
     * Parses a client state key in WebStorage. Returns null if the key does not
     * match the expected key format.
     */
    t.prototype.sl = function(t) {
        var e = this.Nc.exec(t);
        return e ? e[1] : null;
    }, 
    /**
     * Parses a client state in WebStorage. Returns 'null' if the value could not
     * be parsed.
     */
    t.prototype.rl = function(t, e) {
        var n = this.sl(t);
        return Zo.gc(n, e);
    }, 
    /**
     * Parses a mutation batch state in WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.ol = function(t, e) {
        var n = this.kc.exec(t), r = Number(n[1]), i = void 0 !== n[2] ? n[2] : null;
        return Xo.gc(new Ro(i), r, e);
    }, 
    /**
     * Parses a query target state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.al = function(t, e) {
        var n = this.xc.exec(t), r = Number(n[1]);
        return Yo.gc(r, e);
    }, 
    /**
     * Parses an online state from WebStorage. Returns 'null' if the value
     * could not be parsed.
     */
    t.prototype.Lc = function(t) {
        return Jo.gc(t);
    }, t.prototype.hl = function(t) {
        return e(this, void 0, void 0, (function() {
            return n(this, (function(e) {
                return t.user.uid === this.currentUser.uid ? [ 2 /*return*/ , this.oc.cl(t.batchId, t.state, t.error) ] : (E("SharedClientState", "Ignoring mutation for non-active user " + t.user.uid), 
                [ 2 /*return*/ ]);
            }));
        }));
    }, t.prototype.ul = function(t) {
        return this.oc.ll(t.targetId, t.state, t.error);
    }, t.prototype.il = function(t, e) {
        var n = this, r = e ? this.Dc.nt(t, e) : this.Dc.remove(t), i = this.Uc(this.Dc), o = this.Uc(r), s = [], u = [];
        return o.forEach((function(t) {
            i.has(t) || s.push(t);
        })), i.forEach((function(t) {
            o.has(t) || u.push(t);
        })), this.oc._l(s, u).then((function() {
            n.Dc = r;
        }));
    }, t.prototype.qc = function(t) {
        // We check whether the client that wrote this online state is still active
        // by comparing its client ID to the list of clients kept active in
        // IndexedDb. If a client does not update their IndexedDb client state
        // within 5 seconds, it is considered inactive and we don't emit an online
        // state event.
        this.Dc.get(t.clientId) && this.Vu(t.onlineState);
    }, t.prototype.Uc = function(t) {
        var e = Tt();
        return t.forEach((function(t, n) {
            e = e.Ct(n.activeTargetIds);
        })), e;
    }, t;
}(), ns = /** @class */ function() {
    function t() {
        this.fl = new ts, this.dl = {}, this.Vu = null, this.ls = null;
    }
    return t.prototype.Qc = function(t) {
        // No op.
    }, t.prototype.Kc = function(t, e, n) {
        // No op.
    }, t.prototype.zc = function(t) {
        return this.fl.yc(t), this.dl[t] || "not-current";
    }, t.prototype.Zc = function(t, e, n) {
        this.dl[t] = e;
    }, t.prototype.Yc = function(t) {
        this.fl.pc(t);
    }, t.prototype.Jc = function(t) {
        return this.fl.activeTargetIds.has(t);
    }, t.prototype.Xc = function(t) {
        delete this.dl[t];
    }, t.prototype.Bc = function() {
        return this.fl.activeTargetIds;
    }, t.prototype.Wc = function(t) {
        return this.fl.activeTargetIds.has(t);
    }, t.prototype.start = function() {
        return this.fl = new ts, Promise.resolve();
    }, t.prototype.Ah = function(t, e, n) {
        // No op.
    }, t.prototype.el = function(t) {
        // No op.
    }, t.prototype._r = function() {}, t.prototype.ds = function(t) {}, t;
}(), rs = function(t) {
    this.key = t;
}, is = function(t) {
    this.key = t;
}, os = /** @class */ function() {
    function t(t, 
    /** Documents included in the remote target */
    e) {
        this.query = t, this.wl = e, this.Tl = null, 
        /**
             * A flag whether the view is current with the backend. A view is considered
             * current after it has seen the current flag from the backend and did not
             * lose consistency within the watch stream (e.g. because of an existence
             * filter mismatch).
             */
        this.Ht = !1, 
        /** Documents in the view but not in the remote target */
        this.El = It(), 
        /** Document Keys that have local changes */
        this.Lt = It(), this.Il = kn(t), this.ml = new Nt(this.Il);
    }
    return Object.defineProperty(t.prototype, "Al", {
        /**
         * The set of remote documents that the server has told us belongs to the target associated with
         * this view.
         */
        get: function() {
            return this.wl;
        },
        enumerable: !1,
        configurable: !0
    }), 
    /**
     * Iterates over a set of doc changes, applies the query limit, and computes
     * what the new results should be, what the changes were, and whether we may
     * need to go back to the local cache for more results. Does not make any
     * changes to the view.
     * @param docChanges The doc changes to apply to this view.
     * @param previousChanges If this is being called with a refill, then start
     *        with this set of docs and changes instead of the current view.
     * @return a new set of docs, changes, and refill flag.
     */
    t.prototype.Rl = function(t, e) {
        var n = this, r = e ? e.Pl : new At, i = e ? e.ml : this.ml, o = e ? e.Lt : this.Lt, s = i, u = !1, a = this.query.hn() && i.size === this.query.limit ? i.last() : null, c = this.query.an() && i.size === this.query.limit ? i.first() : null;
        // Drop documents out to meet limit/limitToLast requirement.
        if (t.ot((function(t, e) {
            var h = i.get(t), f = e instanceof pn ? e : null;
            f && (f = xn(n.query, f) ? f : null);
            var l = !!h && n.Lt.has(h.key), p = !!f && (f.Ke || 
            // We only consider committed mutations for documents that were
            // mutated during the lifetime of the view.
            n.Lt.has(f.key) && f.hasCommittedMutations), d = !1;
            // Calculate change
            h && f ? h.data().isEqual(f.data()) ? l !== p && (r.track({
                type: 3 /* Metadata */ ,
                doc: f
            }), d = !0) : n.gl(h, f) || (r.track({
                type: 2 /* Modified */ ,
                doc: f
            }), d = !0, (a && n.Il(f, a) > 0 || c && n.Il(f, c) < 0) && (
            // This doc moved from inside the limit to outside the limit.
            // That means there may be some other doc in the local cache
            // that should be included instead.
            u = !0)) : !h && f ? (r.track({
                type: 0 /* Added */ ,
                doc: f
            }), d = !0) : h && !f && (r.track({
                type: 1 /* Removed */ ,
                doc: h
            }), d = !0, (a || c) && (
            // A doc was removed from a full limit query. We'll need to
            // requery from the local cache to see if we know about some other
            // doc that should be in the results.
            u = !0)), d && (f ? (s = s.add(f), o = p ? o.add(t) : o.delete(t)) : (s = s.delete(t), 
            o = o.delete(t)));
        })), this.query.hn() || this.query.an()) for (;s.size > this.query.limit; ) {
            var h = this.query.hn() ? s.last() : s.first();
            s = s.delete(h.key), o = o.delete(h.key), r.track({
                type: 1 /* Removed */ ,
                doc: h
            });
        }
        return {
            ml: s,
            Pl: r,
            Vl: u,
            Lt: o
        };
    }, t.prototype.gl = function(t, e) {
        // We suppress the initial change event for documents that were modified as
        // part of a write acknowledgment (e.g. when the value of a server transform
        // is applied) as Watch will send us the same document again.
        // By suppressing the event, we only raise two user visible events (one with
        // `hasPendingWrites` and the final state of the document) instead of three
        // (one with `hasPendingWrites`, the modified document with
        // `hasPendingWrites` and the final state of the document).
        return t.Ke && e.hasCommittedMutations && !e.Ke;
    }, 
    /**
     * Updates the view with the given ViewDocumentChanges and optionally updates
     * limbo docs and sync state from the provided target change.
     * @param docChanges The set of changes to make to the view's docs.
     * @param updateLimboDocuments Whether to update limbo documents based on this
     *        change.
     * @param targetChange A target change to apply for computing limbo docs and
     *        sync state.
     * @return A new ViewChange with the given docs, changes, and sync state.
     */
    // PORTING NOTE: The iOS/Android clients always compute limbo document changes.
    t.prototype.qn = function(t, e, n) {
        var r = this, i = this.ml;
        this.ml = t.ml, this.Lt = t.Lt;
        // Sort changes based on type and query comparator
        var o = t.Pl.Mt();
        o.sort((function(t, e) {
            return function(t, e) {
                var n = function(t) {
                    switch (t) {
                      case 0 /* Added */ :
                        return 1;

                      case 2 /* Modified */ :
                      case 3 /* Metadata */ :
                        // A metadata change is converted to a modified change at the public
                        // api layer.  Since we sort by document key and then change type,
                        // metadata and modified changes must be sorted equivalently.
                        return 2;

                      case 1 /* Removed */ :
                        return 0;

                      default:
                        return A();
                    }
                };
                return n(t) - n(e);
            }(t.type, e.type) || r.Il(t.doc, e.doc);
        })), this.yl(n);
        var s = e ? this.pl() : [], u = 0 === this.El.size && this.Ht ? 1 /* Synced */ : 0 /* Local */ , a = u !== this.Tl;
        return this.Tl = u, 0 !== o.length || a ? {
            snapshot: new _t(this.query, t.ml, i, o, t.Lt, 0 /* Local */ === u, a, 
            /* excludesMetadataChanges= */ !1),
            bl: s
        } : {
            bl: s
        };
        // no changes
        }, 
    /**
     * Applies an OnlineState change to the view, potentially generating a
     * ViewChange if the view's syncState changes as a result.
     */
    t.prototype.vl = function(t) {
        return this.Ht && "Offline" /* Offline */ === t ? (
        // If we're offline, set `current` to false and then call applyChanges()
        // to refresh our syncState and generate a ViewChange as appropriate. We
        // are guaranteed to get a new TargetChange that sets `current` back to
        // true once the client is back online.
        this.Ht = !1, this.qn({
            ml: this.ml,
            Pl: new At,
            Lt: this.Lt,
            Vl: !1
        }, 
        /* updateLimboDocuments= */ !1)) : {
            bl: []
        };
    }, 
    /**
     * Returns whether the doc for the given key should be in limbo.
     */
    t.prototype.Sl = function(t) {
        // If the remote end says it's part of this query, it's not in limbo.
        return !this.wl.has(t) && 
        // The local store doesn't think it's a result, so it shouldn't be in limbo.
        !!this.ml.has(t) && !this.ml.get(t).Ke;
    }, 
    /**
     * Updates syncedDocuments, current, and limbo docs based on the given change.
     * Returns the list of changes to which docs are in limbo.
     */
    t.prototype.yl = function(t) {
        var e = this;
        t && (t.Yt.forEach((function(t) {
            return e.wl = e.wl.add(t);
        })), t.Jt.forEach((function(t) {})), t.Xt.forEach((function(t) {
            return e.wl = e.wl.delete(t);
        })), this.Ht = t.Ht);
    }, t.prototype.pl = function() {
        var t = this;
        // We can only determine limbo documents when we're in-sync with the server.
                if (!this.Ht) return [];
        // TODO(klimt): Do this incrementally so that it's not quadratic when
        // updating many documents.
                var e = this.El;
        this.El = It(), this.ml.forEach((function(e) {
            t.Sl(e.key) && (t.El = t.El.add(e.key));
        }));
        // Diff the new limbo docs with the old limbo docs.
        var n = [];
        return e.forEach((function(e) {
            t.El.has(e) || n.push(new is(e));
        })), this.El.forEach((function(t) {
            e.has(t) || n.push(new rs(t));
        })), n;
    }, 
    /**
     * Update the in-memory state of the current view with the state read from
     * persistence.
     *
     * We update the query view whenever a client's primary status changes:
     * - When a client transitions from primary to secondary, it can miss
     *   LocalStorage updates and its query views may temporarily not be
     *   synchronized with the state on disk.
     * - For secondary to primary transitions, the client needs to update the list
     *   of `syncedDocuments` since secondary clients update their query views
     *   based purely on synthesized RemoteEvents.
     *
     * @param queryResult.documents - The documents that match the query according
     * to the LocalStore.
     * @param queryResult.remoteKeys - The keys of the documents that match the
     * query according to the backend.
     *
     * @return The ViewChange that resulted from this synchronization.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Dl = function(t) {
        this.wl = t.Mh, this.El = It();
        var e = this.Rl(t.documents);
        return this.qn(e, /*updateLimboDocuments=*/ !0);
    }, 
    /**
     * Returns a view snapshot as if this query was just listened to. Contains
     * a document add for every existing document and the `fromCache` and
     * `hasPendingWrites` status of the already established view.
     */
    // PORTING NOTE: Multi-tab only.
    t.prototype.Cl = function() {
        return _t.Ut(this.query, this.ml, this.Lt, 0 /* Local */ === this.Tl);
    }, t;
}(), ss = /** @class */ function() {
    function t(t, e, n, r) {
        this.ao = t, this.wu = e, this.updateFunction = n, this.lo = r, this.Fl = 5, this.Po = new tr(this.ao, "transaction_retry" /* TransactionRetry */)
        /** Runs the transaction and sets the result on deferred. */;
    }
    return t.prototype.run = function() {
        this.$l();
    }, t.prototype.$l = function() {
        var t = this;
        this.Po.ys((function() {
            return e(t, void 0, void 0, (function() {
                var t, e, r = this;
                return n(this, (function(n) {
                    return t = new zo(this.wu), (e = this.Nl(t)) && e.then((function(e) {
                        r.ao.Zi((function() {
                            return t.commit().then((function() {
                                r.lo.resolve(e);
                            })).catch((function(t) {
                                r.kl(t);
                            }));
                        }));
                    })).catch((function(t) {
                        r.kl(t);
                    })), [ 2 /*return*/ ];
                }));
            }));
        }));
    }, t.prototype.Nl = function(t) {
        try {
            var e = this.updateFunction(t);
            return !$(e) && e.catch && e.then ? e : (this.lo.reject(Error("Transaction callback must return a Promise")), 
            null);
        } catch (t) {
            // Do not retry errors thrown by user provided updateFunction.
            return this.lo.reject(t), null;
        }
    }, t.prototype.kl = function(t) {
        var e = this;
        this.Fl > 0 && this.xl(t) ? (this.Fl -= 1, this.ao.Zi((function() {
            return e.$l(), Promise.resolve();
        }))) : this.lo.reject(t);
    }, t.prototype.xl = function(t) {
        if ("FirebaseError" === t.name) {
            // In transactions, the backend will fail outdated reads with FAILED_PRECONDITION and
            // non-matching document versions with ABORTED. These errors should be retried.
            var e = t.code;
            return "aborted" === e || "failed-precondition" === e || !ut(e);
        }
        return !1;
    }, t;
}(), us = function(
/**
     * The query itself.
     */
t, 
/**
     * The target number created by the client that is used in the watch
     * stream to identify this query.
     */
e, 
/**
     * The view is responsible for computing the final merged truth of what
     * docs are in the query. It gets notified of local and remote changes,
     * and applies the query filters and limits to determine the most correct
     * possible results.
     */
n) {
    this.query = t, this.targetId = e, this.view = n;
}, as = function(t) {
    this.key = t, 
    /**
             * Set to true once we've received a document. This is used in
             * getRemoteKeysForTarget() and ultimately used by WatchChangeAggregator to
             * decide whether it needs to manufacture a delete event for the target once
             * the target is CURRENT.
             */
    this.Ml = !1;
}, cs = /** @class */ function() {
    function t(t, e, n, 
    // PORTING NOTE: Manages state synchronization in multi-tab environments.
    r, i, o) {
        this.$u = t, this.Ol = e, this.wu = n, this.Ll = r, this.currentUser = i, this.ql = o, 
        this.Bl = null, this.Ul = new M((function(t) {
            return Dn(t);
        }), _n), this.Wl = new Map, 
        /**
             * The keys of documents that are in limbo for which we haven't yet started a
             * limbo resolution query.
             */
        this.Ql = [], 
        /**
             * Keeps track of the target ID for each document that is in limbo with an
             * active target.
             */
        this.jl = new ct(Q.P), 
        /**
             * Keeps track of the information about an active limbo resolution for each
             * active target ID that was started for the purpose of limbo resolution.
             */
        this.Kl = new Map, this.Gl = new ki, 
        /** Stores user completion handlers, indexed by User and BatchId. */
        this.zl = {}, 
        /** Stores user callbacks waiting for all pending writes to be acknowledged. */
        this.Hl = new Map, this.Yl = Nr.si(), this.onlineState = "Unknown" /* Unknown */ , 
        // The primary state is set to `true` or `false` immediately after Firestore
        // startup. In the interim, a client should only be considered primary if
        // `isPrimary` is true.
        this.Jl = void 0;
    }
    return Object.defineProperty(t.prototype, "Xl", {
        get: function() {
            return !0 === this.Jl;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.subscribe = function(t) {
        this.Bl = t;
    }, t.prototype.listen = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o, s;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.Zl("listen()"), (i = this.Ul.get(t)) ? (
                    // PORTING NOTE: With Multi-Tab Web, it is possible that a query view
                    // already exists when EventManager calls us for the first time. This
                    // happens when the primary tab is already listening to this query on
                    // behalf of another tab and the user of the primary also starts listening
                    // to the query. EventManager will not have an assigned target ID in this
                    // case and calls `listen` to obtain this ID.
                    e = i.targetId, this.Ll.zc(e), r = i.view.Cl(), [ 3 /*break*/ , 4 ]) : [ 3 /*break*/ , 1 ];

                  case 1:
                    return [ 4 /*yield*/ , this.$u.Nh(En(t)) ];

                  case 2:
                    return o = n.sent(), s = this.Ll.zc(o.targetId), e = o.targetId, [ 4 /*yield*/ , this.t_(t, e, "current" === s) ];

                  case 3:
                    r = n.sent(), this.Xl && this.Ol.listen(o), n.label = 4;

                  case 4:
                    return [ 2 /*return*/ , r ];
                }
            }));
        }));
    }, 
    /**
     * Registers a view for a previously unknown query and computes its initial
     * snapshot.
     */
    t.prototype.t_ = function(t, r, i) {
        return e(this, void 0, void 0, (function() {
            var e, o, s, u, a, c;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return [ 4 /*yield*/ , this.$u.xh(t, 
                    /* usePreviousResults= */ !0) ];

                  case 1:
                    return e = n.sent(), o = new os(t, e.Mh), s = o.Rl(e.documents), u = St.zt(r, i && "Offline" /* Offline */ !== this.onlineState), 
                    a = o.qn(s, 
                    /* updateLimboDocuments= */ this.Xl, u), this.e_(r, a.bl), c = new us(t, r, o), 
                    [ 2 /*return*/ , (this.Ul.set(t, c), this.Wl.has(r) ? this.Wl.get(r).push(t) : this.Wl.set(r, [ t ]), 
                    a.snapshot) ];
                }
            }));
        }));
    }, t.prototype.ic = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    // Only clean up the query view and target if this is the only query mapped
                    // to the target.
                    return this.Zl("unlisten()"), e = this.Ul.get(t), (r = this.Wl.get(e.targetId)).length > 1 ? [ 2 /*return*/ , (this.Wl.set(e.targetId, r.filter((function(e) {
                        return !_n(e, t);
                    }))), void this.Ul.delete(t)) ] : this.Xl ? (
                    // We need to remove the local query target first to allow us to verify
                    // whether any other client is still interested in this target.
                    this.Ll.Yc(e.targetId), this.Ll.Wc(e.targetId) ? [ 3 /*break*/ , 2 ] : [ 4 /*yield*/ , this.$u.kh(e.targetId, /*keepPersistedTargetData=*/ !1).then((function() {
                        i.Ll.Xc(e.targetId), i.Ol.ic(e.targetId), i.n_(e.targetId);
                    })).catch(xi) ]) : [ 3 /*break*/ , 3 ];

                  case 1:
                    n.sent(), n.label = 2;

                  case 2:
                    return [ 3 /*break*/ , 5 ];

                  case 3:
                    return this.n_(e.targetId), [ 4 /*yield*/ , this.$u.kh(e.targetId, 
                    /*keepPersistedTargetData=*/ !0) ];

                  case 4:
                    n.sent(), n.label = 5;

                  case 5:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.write = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    this.Zl("write()"), n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 5, , 6 ]), [ 4 /*yield*/ , this.$u.Vh(t) ];

                  case 2:
                    return e = n.sent(), this.Ll.Qc(e.batchId), this.s_(e.batchId, r), [ 4 /*yield*/ , this.i_(e.Cn) ];

                  case 3:
                    return n.sent(), [ 4 /*yield*/ , this.Ol.tc() ];

                  case 4:
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 5:
                    return i = n.sent(), o = wi(i, "Failed to persist write"), r.reject(o), [ 3 /*break*/ , 6 ];

                  case 6:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.runTransaction = function(t, e, n) {
        new ss(t, this.wu, e, n).run();
    }, t.prototype.vh = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    this.Zl("applyRemoteEvent()"), n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , this.$u.vh(t) ];

                  case 2:
                    return e = n.sent(), 
                    // Update `receivedDocument` as appropriate for any limbo targets.
                    t.Wt.forEach((function(t, e) {
                        var n = r.Kl.get(e);
                        n && (
                        // Since this is a limbo resolution lookup, it's for a single document
                        // and it could be added, modified, or removed, but not a combination.
                        _(t.Yt.size + t.Jt.size + t.Xt.size <= 1), t.Yt.size > 0 ? n.Ml = !0 : t.Jt.size > 0 ? _(n.Ml) : t.Xt.size > 0 && (_(n.Ml), 
                        n.Ml = !1));
                    })), [ 4 /*yield*/ , this.i_(e, t) ];

                  case 3:
                    // Update `receivedDocument` as appropriate for any limbo targets.
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 4:
                    return [ 4 /*yield*/ , xi(n.sent()) ];

                  case 5:
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 6:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.vl = function(t, e) {
        // If we are the secondary client, we explicitly ignore the remote store's
        // online state (the local client may go offline, even though the primary
        // tab remains online) and only apply the primary tab's online state from
        // SharedClientState.
        if (this.Xl && 0 /* RemoteStore */ === e || !this.Xl && 1 /* SharedClientState */ === e) {
            this.Zl("applyOnlineStateChange()");
            var n = [];
            this.Ul.forEach((function(e, r) {
                var i = r.view.vl(t);
                i.snapshot && n.push(i.snapshot);
            })), this.Bl.r_(t), this.Bl.nu(n), this.onlineState = t, this.Xl && this.Ll.el(t);
        }
    }, t.prototype.lc = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o, s, u, a = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.Zl("rejectListens()"), 
                    // PORTING NOTE: Multi-tab only.
                    this.Ll.Zc(t, "rejected", r), e = this.Kl.get(t), (i = e && e.key) ? (o = (o = new ct(Q.P)).nt(i, new dn(i, G.min())), 
                    s = It().add(i), u = new Dt(G.min(), 
                    /* targetChanges= */ new Map, 
                    /* targetMismatches= */ new lt(k), o, s), [ 4 /*yield*/ , this.vh(u) ]) : [ 3 /*break*/ , 2 ];

                  case 1:
                    return n.sent(), 
                    // Since this query failed, we won't want to manually unlisten to it.
                    // We only remove it from bookkeeping after we successfully applied the
                    // RemoteEvent. If `applyRemoteEvent()` throws, we want to re-listen to
                    // this query when the RemoteStore restarts the Watch stream, which should
                    // re-trigger the target failure.
                    this.jl = this.jl.remove(i), this.Kl.delete(t), this.o_(), [ 3 /*break*/ , 4 ];

                  case 2:
                    return [ 4 /*yield*/ , this.$u.kh(t, /* keepPersistedTargetData */ !1).then((function() {
                        return a.n_(t, r);
                    })).catch(xi) ];

                  case 3:
                    n.sent(), n.label = 4;

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Ec = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    this.Zl("applySuccessfulWrite()"), e = t.batch.batchId, n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , this.$u.yh(t) ];

                  case 2:
                    return r = n.sent(), 
                    // The local store may or may not be able to apply the write result and
                    // raise events immediately (depending on whether the watcher is caught
                    // up), so we raise user callbacks first so that they consistently happen
                    // before listen events.
                    this.h_(e, /*error=*/ null), this.a_(e), this.Ll.Kc(e, "acknowledged"), [ 4 /*yield*/ , this.i_(r) ];

                  case 3:
                    // The local store may or may not be able to apply the write result and
                    // raise events immediately (depending on whether the watcher is caught
                    // up), so we raise user callbacks first so that they consistently happen
                    // before listen events.
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 4:
                    return [ 4 /*yield*/ , xi(n.sent()) ];

                  case 5:
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 6:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.mc = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    this.Zl("rejectFailedWrite()"), n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 4, , 6 ]), [ 4 /*yield*/ , this.$u.bh(t) ];

                  case 2:
                    return e = n.sent(), 
                    // The local store may or may not be able to apply the write result and
                    // raise events immediately (depending on whether the watcher is caught up),
                    // so we raise user callbacks first so that they consistently happen before
                    // listen events.
                    this.h_(t, r), this.a_(t), this.Ll.Kc(t, "rejected", r), [ 4 /*yield*/ , this.i_(e) ];

                  case 3:
                    // The local store may or may not be able to apply the write result and
                    // raise events immediately (depending on whether the watcher is caught up),
                    // so we raise user callbacks first so that they consistently happen before
                    // listen events.
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 4:
                    return [ 4 /*yield*/ , xi(n.sent()) ];

                  case 5:
                    return n.sent(), [ 3 /*break*/ , 6 ];

                  case 6:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.u_ = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    this.Ol.qu() || E("SyncEngine", "The network is disabled. The task returned by 'awaitPendingWrites()' will not complete until the network is enabled."), 
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 4 ]), [ 4 /*yield*/ , this.$u.Wr() ];

                  case 2:
                    return -1 === (e = n.sent()) ? [ 2 /*return*/ , void t.resolve() ] : ((r = this.Hl.get(e) || []).push(t), 
                    this.Hl.set(e, r), [ 3 /*break*/ , 4 ]);

                  case 3:
                    return i = n.sent(), o = wi(i, "Initialization of waitForPendingWrites() operation failed"), 
                    t.reject(o), [ 3 /*break*/ , 4 ];

                  case 4:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Triggers the callbacks that are waiting for this batch id to get acknowledged by server,
     * if there are any.
     */
    t.prototype.a_ = function(t) {
        (this.Hl.get(t) || []).forEach((function(t) {
            t.resolve();
        })), this.Hl.delete(t);
    }, 
    /** Reject all outstanding callbacks waiting for pending writes to complete. */ t.prototype.c_ = function(t) {
        this.Hl.forEach((function(e) {
            e.forEach((function(e) {
                e.reject(new F(q.CANCELLED, t));
            }));
        })), this.Hl.clear();
    }, t.prototype.s_ = function(t, e) {
        var n = this.zl[this.currentUser.Aa()];
        n || (n = new ct(k)), n = n.nt(t, e), this.zl[this.currentUser.Aa()] = n;
    }, 
    /**
     * Resolves or rejects the user callback for the given batch and then discards
     * it.
     */
    t.prototype.h_ = function(t, e) {
        var n = this.zl[this.currentUser.Aa()];
        // NOTE: Mutations restored from persistence won't have callbacks, so it's
        // okay for there to be no callback for this ID.
                if (n) {
            var r = n.get(t);
            r && (e ? r.reject(e) : r.resolve(), n = n.remove(t)), this.zl[this.currentUser.Aa()] = n;
        }
    }, t.prototype.n_ = function(t, e) {
        var n = this;
        void 0 === e && (e = null), this.Ll.Yc(t);
        for (var r = 0, i = this.Wl.get(t); r < i.length; r++) {
            var o = i[r];
            this.Ul.delete(o), e && this.Bl.l_(o, e);
        }
        this.Wl.delete(t), this.Xl && this.Gl.jh(t).forEach((function(t) {
            n.Gl.pi(t) || 
            // We removed the last reference for this key
            n.__(t);
        }));
    }, t.prototype.__ = function(t) {
        // It's possible that the target already got removed because the query failed. In that case,
        // the key won't exist in `limboTargetsByKey`. Only do the cleanup if we still have the target.
        var e = this.jl.get(t);
        null !== e && (this.Ol.ic(e), this.jl = this.jl.remove(t), this.Kl.delete(e), this.o_());
    }, t.prototype.e_ = function(t, e) {
        for (var n = 0, r = e; n < r.length; n++) {
            var i = r[n];
            i instanceof rs ? (this.Gl.Ri(i.key, t), this.f_(i)) : i instanceof is ? (E("SyncEngine", "Document no longer in limbo: " + i.key), 
            this.Gl.gi(i.key, t), this.Gl.pi(i.key) || 
            // We removed the last reference for this key
            this.__(i.key)) : A();
        }
    }, t.prototype.f_ = function(t) {
        var e = t.key;
        this.jl.get(e) || (E("SyncEngine", "New document in limbo: " + e), this.Ql.push(e), 
        this.o_());
    }, 
    /**
     * Starts listens for documents in limbo that are enqueued for resolution,
     * subject to a maximum number of concurrent resolutions.
     *
     * Without bounding the number of concurrent resolutions, the server can fail
     * with "resource exhausted" errors which can lead to pathological client
     * behavior as seen in https://github.com/firebase/firebase-js-sdk/issues/2683.
     */
    t.prototype.o_ = function() {
        for (;this.Ql.length > 0 && this.jl.size < this.ql; ) {
            var t = this.Ql.shift(), e = this.Yl.next();
            this.Kl.set(e, new as(t)), this.jl = this.jl.nt(t, e), this.Ol.listen(new ot(En(wn(t.path)), e, 2 /* LimboResolution */ , Zn.ws));
        }
    }, 
    // Visible for testing
    t.prototype.d_ = function() {
        return this.jl;
    }, 
    // Visible for testing
    t.prototype.w_ = function() {
        return this.Ql;
    }, t.prototype.i_ = function(t, r) {
        return e(this, void 0, void 0, (function() {
            var e, i, o, s = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return e = [], i = [], o = [], this.Ul.forEach((function(n, u) {
                        o.push(Promise.resolve().then((function() {
                            var e = u.view.Rl(t);
                            return e.Vl ? s.$u.xh(u.query, /* usePreviousResults= */ !1).then((function(t) {
                                var n = t.documents;
                                return u.view.Rl(n, e);
                            })) : e;
                            // The query has a limit and some docs were removed, so we need
                            // to re-run the query against the local store to make sure we
                            // didn't lose any good docs that had been past the limit.
                                                })).then((function(t) {
                            var n = r && r.Wt.get(u.targetId), o = u.view.qn(t, 
                            /* updateLimboDocuments= */ s.Xl, n);
                            if (s.e_(u.targetId, o.bl), o.snapshot) {
                                s.Xl && s.Ll.Zc(u.targetId, o.snapshot.fromCache ? "not-current" : "current"), e.push(o.snapshot);
                                var a = Yn.cs(u.targetId, o.snapshot);
                                i.push(a);
                            }
                        })));
                    })), [ 4 /*yield*/ , Promise.all(o) ];

                  case 1:
                    return n.sent(), this.Bl.nu(e), [ 4 /*yield*/ , this.$u.Ch(i) ];

                  case 2:
                    return n.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.Zl = function(t) {}, t.prototype.Rc = function(t) {
        return e(this, void 0, void 0, (function() {
            var e;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.currentUser.isEqual(t) ? [ 3 /*break*/ , 3 ] : (E("SyncEngine", "User change. New user:", t.Aa()), 
                    [ 4 /*yield*/ , this.$u.Ah(t) ]);

                  case 1:
                    return e = n.sent(), this.currentUser = t, 
                    // Fails tasks waiting for pending writes requested by previous user.
                    this.c_("'waitForPendingWrites' promise is rejected due to a user change."), 
                    // TODO(b/114226417): Consider calling this only in the primary tab.
                    this.Ll.Ah(t, e.Ph, e.gh), [ 4 /*yield*/ , this.i_(e.Rh) ];

                  case 2:
                    n.sent(), n.label = 3;

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.xe = function(t) {
        var e = this.Kl.get(t);
        if (e && e.Ml) return It().add(e.key);
        var n = It(), r = this.Wl.get(t);
        if (!r) return n;
        for (var i = 0, o = r; i < o.length; i++) {
            var s = o[i], u = this.Ul.get(s);
            n = n.Ct(u.view.Al);
        }
        return n;
    }, t;
}();

/**
 * Holds the state of a query target, including its target ID and whether the
 * target is 'not-current', 'current' or 'rejected'.
 */
// Visible for testing
function hs(t, e, n, 
// PORTING NOTE: Manages state synchronization in multi-tab environments.
r, i, o, s) {
    var u = new cs(t, e, n, r, i, o);
    return s && (u.Jl = !0), u
    /**
 * Reconcile the list of synced documents in an existing view with those
 * from persistence.
 */;
}

function fs(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return [ 4 /*yield*/ , (e = D(t)).$u.xh(r.query, 
                /* usePreviousResults= */ !0) ];

              case 1:
                return i = n.sent(), o = r.view.Dl(i), [ 2 /*return*/ , (e.Xl && e.e_(r.targetId, o.bl), 
                o) ];
            }
        }));
    }));
}

/** Applies a mutation state to an existing batch.  */
// PORTING NOTE: Multi-Tab only.
function ls(t, r, i, o) {
    return e(this, void 0, void 0, (function() {
        var e, s;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return (e = D(t)).Zl("applyBatchState()"), [ 4 /*yield*/ , function(t, e) {
                    var n = D(t), r = D(n.jn);
                    return n.persistence.runTransaction("Lookup mutation documents", "readonly", (function(t) {
                        return r.Br(t, e).next((function(e) {
                            return e ? n.Ih.Jn(t, e) : Kn.resolve(null);
                        }));
                    }));
                }(e.$u, r) ];

              case 1:
                return null === (s = n.sent()) ? [ 3 /*break*/ , 6 ] : "pending" !== i ? [ 3 /*break*/ , 3 ] : [ 4 /*yield*/ , e.Ol.tc() ];

              case 2:
                // If we are the primary client, we need to send this write to the
                // backend. Secondary clients will ignore these writes since their remote
                // connection is disabled.
                return n.sent(), [ 3 /*break*/ , 4 ];

              case 3:
                "acknowledged" === i || "rejected" === i ? (
                // NOTE: Both these methods are no-ops for batches that originated from
                // other clients.
                e.h_(r, o || null), function(t, e) {
                    D(D(t).jn).Gr(e);
                }(e.$u, r)) : A(), n.label = 4;

              case 4:
                return [ 4 /*yield*/ , e.i_(s) ];

              case 5:
                return n.sent(), [ 3 /*break*/ , 7 ];

              case 6:
                // A throttled tab may not have seen the mutation before it was completed
                // and removed from the mutation queue, in which case we won't have cached
                // the affected documents. In this case we can safely ignore the update
                // since that means we didn't apply the mutation locally at all (if we
                // had, we would have cached the affected documents), and so we will just
                // see any resulting document changes via normal remote document updates
                // as applicable.
                E("SyncEngine", "Cannot apply mutation batch with id: " + r), n.label = 7;

              case 7:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
function ps(t, r) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a, c, h;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return e = D(t), !0 !== r || !0 === e.Jl ? [ 3 /*break*/ , 3 ] : (i = e.Ll.Bc(), 
                [ 4 /*yield*/ , ds(e, i.F()) ]);

              case 1:
                return o = n.sent(), e.Jl = !0, [ 4 /*yield*/ , e.Ol.Pc(!0) ];

              case 2:
                for (n.sent(), s = 0, u = o; s < u.length; s++) a = u[s], e.Ol.listen(a);
                return [ 3 /*break*/ , 7 ];

              case 3:
                return !1 !== r || !1 === e.Jl ? [ 3 /*break*/ , 7 ] : (c = [], h = Promise.resolve(), 
                e.Wl.forEach((function(t, n) {
                    e.Ll.Jc(n) ? c.push(n) : h = h.then((function() {
                        return e.n_(n), e.$u.kh(n, 
                        /*keepPersistedTargetData=*/ !0);
                    })), e.Ol.ic(n);
                })), [ 4 /*yield*/ , h ]);

              case 4:
                return n.sent(), [ 4 /*yield*/ , ds(e, c) ];

              case 5:
                return n.sent(), 
                // PORTING NOTE: Multi-Tab only.
                function(t) {
                    var e = D(t);
                    e.Kl.forEach((function(t, n) {
                        e.Ol.ic(n);
                    })), e.Gl.Kh(), e.Kl = new Map, e.jl = new ct(Q.P);
                }(e), e.Jl = !1, [ 4 /*yield*/ , e.Ol.Pc(!1) ];

              case 6:
                n.sent(), n.label = 7;

              case 7:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

function ds(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, i, o, s, u, a, c, h, f, l, p, d, y, v;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                e = D(t), i = [], o = [], s = 0, u = r, n.label = 1;

              case 1:
                return s < u.length ? (a = u[s], c = void 0, (h = e.Wl.get(a)) && 0 !== h.length ? [ 4 /*yield*/ , e.$u.Nh(En(h[0])) ] : [ 3 /*break*/ , 7 ]) : [ 3 /*break*/ , 13 ];

              case 2:
                // For queries that have a local View, we fetch their current state
                // from LocalStore (as the resume token and the snapshot version
                // might have changed) and reconcile their views with the persisted
                // state (the list of syncedDocuments may have gotten out of sync).
                c = n.sent(), f = 0, l = h, n.label = 3;

              case 3:
                return f < l.length ? (p = l[f], d = e.Ul.get(p), [ 4 /*yield*/ , fs(e, d) ]) : [ 3 /*break*/ , 6 ];

              case 4:
                (y = n.sent()).snapshot && o.push(y.snapshot), n.label = 5;

              case 5:
                return f++, [ 3 /*break*/ , 3 ];

              case 6:
                return [ 3 /*break*/ , 11 ];

              case 7:
                return [ 4 /*yield*/ , Si(e.$u, a) ];

              case 8:
                return v = n.sent(), [ 4 /*yield*/ , e.$u.Nh(v) ];

              case 9:
                return c = n.sent(), [ 4 /*yield*/ , e.t_(ys(v), a, 
                /*current=*/ !1) ];

              case 10:
                n.sent(), n.label = 11;

              case 11:
                i.push(c), n.label = 12;

              case 12:
                return s++, [ 3 /*break*/ , 1 ];

              case 13:
                return [ 2 /*return*/ , (e.Bl.nu(o), i) ];
            }
        }));
    }));
}

/**
 * Creates a `Query` object from the specified `Target`. There is no way to
 * obtain the original `Query`, so we synthesize a `Query` from the `Target`
 * object.
 *
 * The synthesized result might be different from the original `Query`, but
 * since the synthesized `Query` should return the same results as the
 * original one (only the presentation of results might differ), the potential
 * difference will not cause issues.
 */
// PORTING NOTE: Multi-Tab only.
function ys(t) {
    return gn(t.path, t.collectionGroup, t.orderBy, t.filters, t.limit, "F" /* First */ , t.startAt, t.endAt);
}

/** Returns the IDs of the clients that are currently active. */
// PORTING NOTE: Multi-Tab only.
function vs(t) {
    var e = D(t);
    return D(D(e.$u).persistence).Ir();
}

/** Applies a query target change from a different tab. */
// PORTING NOTE: Multi-Tab only.
function ms(t, r, i, o) {
    return e(this, void 0, void 0, (function() {
        var e, s, u;
        return n(this, (function(n) {
            switch (n.label) {
              case 0:
                return (e = D(t)).Jl ? (
                // If we receive a target state notification via WebStorage, we are
                // either already secondary or another tab has taken the primary lease.
                E("SyncEngine", "Ignoring unexpected query state notification."), [ 3 /*break*/ , 8 ]) : [ 3 /*break*/ , 1 ];

              case 1:
                if (!e.Wl.has(r)) return [ 3 /*break*/ , 8 ];
                switch (i) {
                  case "current":
                  case "not-current":
                    return [ 3 /*break*/ , 2 ];

                  case "rejected":
                    return [ 3 /*break*/ , 5 ];
                }
                return [ 3 /*break*/ , 7 ];

              case 2:
                return [ 4 /*yield*/ , function(t) {
                    var e = D(t), n = D(e.Eh);
                    return e.persistence.runTransaction("Get new document changes", "readonly", (function(t) {
                        return n.Ks(t, e.Th);
                    })).then((function(t) {
                        var n = t.Gs, r = t.readTime;
                        return e.Th = r, n;
                    }));
                }(e.$u) ];

              case 3:
                return s = n.sent(), u = Dt.Gt(r, "current" === i), [ 4 /*yield*/ , e.i_(s, u) ];

              case 4:
                return n.sent(), [ 3 /*break*/ , 8 ];

              case 5:
                return [ 4 /*yield*/ , e.$u.kh(r, 
                /* keepPersistedTargetData */ !0) ];

              case 6:
                return n.sent(), e.n_(r, o), [ 3 /*break*/ , 8 ];

              case 7:
                A(), n.label = 8;

              case 8:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/** Adds or removes Watch targets for queries from different tabs. */ function gs(t, r, i) {
    return e(this, void 0, void 0, (function() {
        var e, o, s, u, a, c, h, f, l, p;
        return n(this, (function(d) {
            switch (d.label) {
              case 0:
                if (!(e = D(t)).Jl) return [ 3 /*break*/ , 10 ];
                o = 0, s = r, d.label = 1;

              case 1:
                return o < s.length ? (u = s[o], e.Wl.has(u) ? (
                // A target might have been added in a previous attempt
                E("SyncEngine", "Adding an already active target " + u), [ 3 /*break*/ , 5 ]) : [ 4 /*yield*/ , Si(e.$u, u) ]) : [ 3 /*break*/ , 6 ];

              case 2:
                return a = d.sent(), [ 4 /*yield*/ , e.$u.Nh(a) ];

              case 3:
                return c = d.sent(), [ 4 /*yield*/ , e.t_(ys(a), c.targetId, 
                /*current=*/ !1) ];

              case 4:
                d.sent(), e.Ol.listen(c), d.label = 5;

              case 5:
                return o++, [ 3 /*break*/ , 1 ];

              case 6:
                h = function(t) {
                    return n(this, (function(n) {
                        switch (n.label) {
                          case 0:
                            return e.Wl.has(t) ? [ 4 /*yield*/ , e.$u.kh(t, /* keepPersistedTargetData */ !1).then((function() {
                                e.Ol.ic(t), e.n_(t);
                            })).catch(xi) ] : [ 3 /*break*/ , 2 ];

                            // Release queries that are still active.
                                                      case 1:
                            // Release queries that are still active.
                            n.sent(), n.label = 2;

                          case 2:
                            return [ 2 /*return*/ ];
                        }
                    }));
                }, f = 0, l = i, d.label = 7;

              case 7:
                return f < l.length ? (p = l[f], [ 5 /*yield**/ , h(p) ]) : [ 3 /*break*/ , 10 ];

              case 8:
                d.sent(), d.label = 9;

              case 9:
                return f++, [ 3 /*break*/ , 7 ];

              case 10:
                return [ 2 /*return*/ ];
            }
        }));
    }));
}

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Holds the listeners and the last received ViewSnapshot for a query being
 * tracked by EventManager.
 */ var ws = function() {
    this.T_ = void 0, this.listeners = [];
}, bs = /** @class */ function() {
    function t(t) {
        this.oc = t, this.E_ = new M((function(t) {
            return Dn(t);
        }), _n), this.onlineState = "Unknown" /* Unknown */ , this.I_ = new Set, this.oc.subscribe(this);
    }
    return t.prototype.listen = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o, s, u;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    if (e = t.query, r = !1, (i = this.E_.get(e)) || (r = !0, i = new ws), !r) return [ 3 /*break*/ , 4 ];
                    n.label = 1;

                  case 1:
                    return n.trys.push([ 1, 3, , 4 ]), o = i, [ 4 /*yield*/ , this.oc.listen(e) ];

                  case 2:
                    return o.T_ = n.sent(), [ 3 /*break*/ , 4 ];

                  case 3:
                    return s = n.sent(), u = wi(s, "Initialization of query '" + Sn(t.query) + "' failed"), 
                    [ 2 /*return*/ , void t.onError(u) ];

                  case 4:
                    return this.E_.set(e, i), i.listeners.push(t), 
                    // Run global snapshot listeners if a consistent snapshot has been emitted.
                    t.vl(this.onlineState), i.T_ && t.m_(i.T_) && this.A_(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.ic = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r, i, o;
            return n(this, (function(n) {
                return e = t.query, r = !1, (i = this.E_.get(e)) && (o = i.listeners.indexOf(t)) >= 0 && (i.listeners.splice(o, 1), 
                r = 0 === i.listeners.length), r ? [ 2 /*return*/ , (this.E_.delete(e), this.oc.ic(e)) ] : [ 2 /*return*/ ];
            }));
        }));
    }, t.prototype.nu = function(t) {
        for (var e = !1, n = 0, r = t; n < r.length; n++) {
            var i = r[n], o = i.query, s = this.E_.get(o);
            if (s) {
                for (var u = 0, a = s.listeners; u < a.length; u++) {
                    a[u].m_(i) && (e = !0);
                }
                s.T_ = i;
            }
        }
        e && this.A_();
    }, t.prototype.l_ = function(t, e) {
        var n = this.E_.get(t);
        if (n) for (var r = 0, i = n.listeners; r < i.length; r++) {
            i[r].onError(e);
        }
        // Remove all listeners. NOTE: We don't need to call syncEngine.unlisten()
        // after an error.
                this.E_.delete(t);
    }, t.prototype.r_ = function(t) {
        this.onlineState = t;
        var e = !1;
        this.E_.forEach((function(n, r) {
            for (var i = 0, o = r.listeners; i < o.length; i++) {
                // Run global snapshot listeners if a consistent snapshot has been emitted.
                o[i].vl(t) && (e = !0);
            }
        })), e && this.A_();
    }, t.prototype.R_ = function(t) {
        this.I_.add(t), 
        // Immediately fire an initial event, indicating all existing listeners
        // are in-sync.
        t.next();
    }, t.prototype.P_ = function(t) {
        this.I_.delete(t);
    }, 
    // Call all global snapshot listeners that have been set.
    t.prototype.A_ = function() {
        this.I_.forEach((function(t) {
            t.next();
        }));
    }, t;
}(), Is = /** @class */ function() {
    function t(t, e, n) {
        this.query = t, this.g_ = e, 
        /**
             * Initial snapshots (e.g. from cache) may not be propagated to the wrapped
             * observer. This flag is set to true once we've actually raised an event.
             */
        this.V_ = !1, this.y_ = null, this.onlineState = "Unknown" /* Unknown */ , this.options = n || {}
        /**
     * Applies the new ViewSnapshot to this listener, raising a user-facing event
     * if applicable (depending on what changed, whether the user has opted into
     * metadata-only changes, etc.). Returns true if a user-facing event was
     * indeed raised.
     */;
    }
    return t.prototype.m_ = function(t) {
        if (!this.options.includeMetadataChanges) {
            for (
            // Remove the metadata only changes.
            var e = [], n = 0, r = t.docChanges; n < r.length; n++) {
                var i = r[n];
                3 /* Metadata */ !== i.type && e.push(i);
            }
            t = new _t(t.query, t.docs, t.Ot, e, t.Lt, t.fromCache, t.qt, 
            /* excludesMetadataChanges= */ !0);
        }
        var o = !1;
        return this.V_ ? this.p_(t) && (this.g_.next(t), o = !0) : this.b_(t, this.onlineState) && (this.v_(t), 
        o = !0), this.y_ = t, o;
    }, t.prototype.onError = function(t) {
        this.g_.error(t);
    }, 
    /** Returns whether a snapshot was raised. */ t.prototype.vl = function(t) {
        this.onlineState = t;
        var e = !1;
        return this.y_ && !this.V_ && this.b_(this.y_, t) && (this.v_(this.y_), e = !0), 
        e;
    }, t.prototype.b_ = function(t, e) {
        // Always raise the first event when we're synced
        if (!t.fromCache) return !0;
        // NOTE: We consider OnlineState.Unknown as online (it should become Offline
        // or Online if we wait long enough).
                var n = "Offline" /* Offline */ !== e;
        // Don't raise the event if we're online, aren't synced yet (checked
        // above) and are waiting for a sync.
                return !(this.options.S_ && n || t.docs._() && "Offline" /* Offline */ !== e);
        // Raise data from cache if we have any documents or we are offline
        }, t.prototype.p_ = function(t) {
        // We don't need to handle includeDocumentMetadataChanges here because
        // the Metadata only changes have already been stripped out if needed.
        // At this point the only changes we will see are the ones we should
        // propagate.
        if (t.docChanges.length > 0) return !0;
        var e = this.y_ && this.y_.hasPendingWrites !== t.hasPendingWrites;
        return !(!t.qt && !e) && !0 === this.options.includeMetadataChanges;
        // Generally we should have hit one of the cases above, but it's possible
        // to get here if there were only metadata docChanges and they got
        // stripped out.
        }, t.prototype.v_ = function(t) {
        t = _t.Ut(t.query, t.docs, t.Lt, t.fromCache), this.V_ = !0, this.g_.next(t);
    }, t;
}(), Es = /** @class */ function() {
    function t() {}
    return t.prototype.mh = function(t) {
        this.D_ = t;
    }, t.prototype.ts = function(t, e, n, r) {
        var i = this;
        // Queries that match all documents don't benefit from using
        // IndexFreeQueries. It is more efficient to scan all documents in a
        // collection, rather than to perform individual lookups.
                return e.on() || n.isEqual(G.min()) ? this.C_(t, e) : this.D_.Jn(t, r).next((function(o) {
            var u = i.F_(e, o);
            return (e.hn() || e.an()) && i.Vl(e.en, u, r, n) ? i.C_(t, e) : (I() <= s.DEBUG && E("IndexFreeQueryEngine", "Re-using previous result from %s to execute query: %s", n.toString(), Sn(e)), 
            i.D_.ts(t, e, n).next((function(t) {
                // We merge `previousResults` into `updateResults`, since
                // `updateResults` is already a DocumentMap. If a document is
                // contained in both lists, then its contents are the same.
                return u.forEach((function(e) {
                    t = t.nt(e.key, e);
                })), t;
            })));
        }));
        // Queries that have never seen a snapshot without limbo free documents
        // should also be run as a full collection scan.
        }, 
    /** Applies the query filter and sorting to the provided documents.  */ t.prototype.F_ = function(t, e) {
        // Sort the documents and re-apply the query filter since previously
        // matching documents do not necessarily still match the query.
        var n = new lt(kn(t));
        return e.forEach((function(e, r) {
            r instanceof pn && xn(t, r) && (n = n.add(r));
        })), n;
    }, 
    /**
     * Determines if a limit query needs to be refilled from cache, making it
     * ineligible for index-free execution.
     *
     * @param sortedPreviousResults The documents that matched the query when it
     * was last synchronized, sorted by the query's comparator.
     * @param remoteKeys The document keys that matched the query at the last
     * snapshot.
     * @param limboFreeSnapshotVersion The version of the snapshot when the query
     * was last synchronized.
     */
    t.prototype.Vl = function(t, e, n, r) {
        // The query needs to be refilled if a previously matching document no
        // longer matches.
        if (n.size !== e.size) return !0;
        // Limit queries are not eligible for index-free query execution if there is
        // a potential that an older document from cache now sorts before a document
        // that was previously part of the limit. This, however, can only happen if
        // the document at the edge of the limit goes out of limit.
        // If a document that is not the limit boundary sorts differently,
        // the boundary of the limit itself did not change and documents from cache
        // will continue to be "rejected" by this boundary. Therefore, we can ignore
        // any modifications that don't affect the last document.
                var i = "F" /* First */ === t ? e.last() : e.first();
        return !!i && (i.hasPendingWrites || i.version.o(r) > 0);
    }, t.prototype.C_ = function(t, e) {
        return I() <= s.DEBUG && E("IndexFreeQueryEngine", "Using full collection scan to execute query:", Sn(e)), 
        this.D_.ts(t, e, G.min());
    }, t;
}(), Ts = /** @class */ function() {
    function t(t, e) {
        this.Kn = t, this.ii = e, 
        /**
             * The set of all mutations that have been sent but not yet been applied to
             * the backend.
             */
        this.jn = [], 
        /** Next value to use when assigning sequential IDs to each mutation batch. */
        this.N_ = 1, 
        /** An ordered mapping between documents and the mutations batch IDs. */
        this.k_ = new lt(Pi.Lh);
    }
    return t.prototype.Or = function(t) {
        return Kn.resolve(0 === this.jn.length);
    }, t.prototype.Lr = function(t, e, n, r) {
        var i = this.N_;
        this.N_++, this.jn.length > 0 && this.jn[this.jn.length - 1];
        var o = new zn(i, e, n, r);
        this.jn.push(o);
        // Track references by document key and index collection parents.
        for (var s = 0, u = r; s < u.length; s++) {
            var a = u[s];
            this.k_ = this.k_.add(new Pi(a.key, i)), this.Kn.Cs(t, a.key.path.p());
        }
        return Kn.resolve(o);
    }, t.prototype.qr = function(t, e) {
        return Kn.resolve(this.x_(e));
    }, t.prototype.Ur = function(t, e) {
        var n = e + 1, r = this.M_(n), i = r < 0 ? 0 : r;
        // The requested batchId may still be out of range so normalize it to the
        // start of the queue.
                return Kn.resolve(this.jn.length > i ? this.jn[i] : null);
    }, t.prototype.Wr = function() {
        return Kn.resolve(0 === this.jn.length ? -1 : this.N_ - 1);
    }, t.prototype.Qr = function(t) {
        return Kn.resolve(this.jn.slice());
    }, t.prototype.zn = function(t, e) {
        var n = this, r = new Pi(e, 0), i = new Pi(e, Number.POSITIVE_INFINITY), o = [];
        return this.k_.vt([ r, i ], (function(t) {
            var e = n.x_(t.zh);
            o.push(e);
        })), Kn.resolve(o);
    }, t.prototype.Zn = function(t, e) {
        var n = this, r = new lt(k);
        return e.forEach((function(t) {
            var e = new Pi(t, 0), i = new Pi(t, Number.POSITIVE_INFINITY);
            n.k_.vt([ e, i ], (function(t) {
                r = r.add(t.zh);
            }));
        })), Kn.resolve(this.O_(r));
    }, t.prototype.os = function(t, e) {
        // Use the query path as a prefix for testing if a document matches the
        // query.
        var n = e.path, r = n.length + 1, i = n;
        // Construct a document reference for actually scanning the index. Unlike
        // the prefix the document key in this reference must have an even number of
        // segments. The empty segment can be used a suffix of the query path
        // because it precedes all other segments in an ordered traversal.
                Q.W(i) || (i = i.child(""));
        var o = new Pi(new Q(i), 0), s = new lt(k);
        // Find unique batchIDs referenced by all documents potentially matching the
        // query.
                return this.k_.St((function(t) {
            var e = t.key.path;
            return !!n.D(e) && (
            // Rows with document keys more than one segment longer than the query
            // path can't be matches. For example, a query on 'rooms' can't match
            // the document /rooms/abc/messages/xyx.
            // TODO(mcg): we'll need a different scanner when we implement
            // ancestor queries.
            e.length === r && (s = s.add(t.zh)), !0);
        }), o), Kn.resolve(this.O_(s));
    }, t.prototype.O_ = function(t) {
        var e = this, n = [];
        // Construct an array of matching batches, sorted by batchID to ensure that
        // multiple mutations affecting the same document key are applied in order.
                return t.forEach((function(t) {
            var r = e.x_(t);
            null !== r && n.push(r);
        })), n;
    }, t.prototype.Kr = function(t, e) {
        var n = this;
        _(0 === this.L_(e.batchId, "removed")), this.jn.shift();
        var r = this.k_;
        return Kn.forEach(e.mutations, (function(i) {
            var o = new Pi(i.key, e.batchId);
            return r = r.delete(o), n.ii.Dr(t, i.key);
        })).next((function() {
            n.k_ = r;
        }));
    }, t.prototype.Gr = function(t) {
        // No-op since the memory mutation queue does not maintain a separate cache.
    }, t.prototype.pi = function(t, e) {
        var n = new Pi(e, 0), r = this.k_.Dt(n);
        return Kn.resolve(e.isEqual(r && r.key));
    }, t.prototype.zr = function(t) {
        return this.jn.length, Kn.resolve();
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue and asserts that
     * the resulting index is within the bounds of the queue.
     *
     * @param batchId The batchId to search for
     * @param action A description of what the caller is doing, phrased in passive
     * form (e.g. "acknowledged" in a routine that acknowledges batches).
     */
    t.prototype.L_ = function(t, e) {
        return this.M_(t);
    }, 
    /**
     * Finds the index of the given batchId in the mutation queue. This operation
     * is O(1).
     *
     * @return The computed index of the batch with the given batchId, based on
     * the state of the queue. Note this index can be negative if the requested
     * batchId has already been remvoed from the queue or past the end of the
     * queue if the batchId is larger than the last added batch.
     */
    t.prototype.M_ = function(t) {
        return 0 === this.jn.length ? 0 : t - this.jn[0].batchId;
        // Examine the front of the queue to figure out the difference between the
        // batchId and indexes in the array. Note that since the queue is ordered
        // by batchId, if the first batch has a larger batchId then the requested
        // batchId doesn't exist in the queue.
        }, 
    /**
     * A version of lookupMutationBatch that doesn't return a promise, this makes
     * other functions that uses this code easier to read and more efficent.
     */
    t.prototype.x_ = function(t) {
        var e = this.M_(t);
        return e < 0 || e >= this.jn.length ? null : this.jn[e];
    }, t;
}(), Ns = /** @class */ function() {
    /**
     * @param sizer Used to assess the size of a document. For eager GC, this is expected to just
     * return 0 to avoid unnecessarily doing the work of calculating the size.
     */
    function t(t, e) {
        this.Kn = t, this.q_ = e, 
        /** Underlying cache of documents and their read times. */
        this.docs = new ct(Q.P), 
        /** Size of all cached documents. */
        this.size = 0
        /**
     * Adds the supplied entry to the cache and updates the cache size as appropriate.
     *
     * All calls of `addEntry`  are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */;
    }
    return t.prototype.Nn = function(t, e, n) {
        var r = e.key, i = this.docs.get(r), o = i ? i.size : 0, s = this.q_(e);
        return this.docs = this.docs.nt(r, {
            Ls: e,
            size: s,
            readTime: n
        }), this.size += s - o, this.Kn.Cs(t, r.path.p());
    }, 
    /**
     * Removes the specified entry from the cache and updates the cache size as appropriate.
     *
     * All calls of `removeEntry` are required to go through the RemoteDocumentChangeBuffer
     * returned by `newChangeBuffer()`.
     */
    t.prototype.xn = function(t) {
        var e = this.docs.get(t);
        e && (this.docs = this.docs.remove(t), this.size -= e.size);
    }, t.prototype.Mn = function(t, e) {
        var n = this.docs.get(e);
        return Kn.resolve(n ? n.Ls : null);
    }, t.prototype.getEntries = function(t, e) {
        var n = this, r = vt();
        return e.forEach((function(t) {
            var e = n.docs.get(t);
            r = r.nt(t, e ? e.Ls : null);
        })), Kn.resolve(r);
    }, t.prototype.ts = function(t, e, n) {
        for (var r = gt(), i = new Q(e.path.child("")), o = this.docs.ut(i)
        // Documents are ordered by key, so we can use a prefix scan to narrow down
        // the documents we need to match the query against.
        ; o.wt(); ) {
            var s = o.dt(), u = s.key, a = s.value, c = a.Ls, h = a.readTime;
            if (!e.path.D(u.path)) break;
            h.o(n) <= 0 || c instanceof pn && xn(e, c) && (r = r.nt(c.key, c));
        }
        return Kn.resolve(r);
    }, t.prototype.B_ = function(t, e) {
        return Kn.forEach(this.docs, (function(t) {
            return e(t);
        }));
    }, t.prototype.Hs = function(e) {
        // `trackRemovals` is ignores since the MemoryRemoteDocumentCache keeps
        // a separate changelog and does not need special handling for removals.
        return new t.Ys(this);
    }, t.prototype.Xs = function(t) {
        return Kn.resolve(this.size);
    }, t;
}();

/**
 * EventManager is responsible for mapping queries to query event emitters.
 * It handles "fan-out". -- Identical queries will re-use the same watch on the
 * backend.
 */
/**
 * Handles the details of adding and updating documents in the MemoryRemoteDocumentCache.
 */
Ns.Ys = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).Zs = t, n;
    }
    return t(n, e), n.prototype.qn = function(t) {
        var e = this, n = [];
        return this.Cn.forEach((function(r, i) {
            i ? n.push(e.Zs.Nn(t, i, e.readTime)) : e.Zs.xn(r);
        })), Kn.Sn(n);
    }, n.prototype.On = function(t, e) {
        return this.Zs.Mn(t, e);
    }, n.prototype.Ln = function(t, e) {
        return this.Zs.getEntries(t, e);
    }, n;
}(Qn);

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var As = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /**
             * Maps a target to the data about that target
             */
        this.U_ = new M((function(t) {
            return J(t);
        }), tt), 
        /** The last received snapshot version. */
        this.lastRemoteSnapshotVersion = G.min(), 
        /** The highest numbered target ID encountered. */
        this.highestTargetId = 0, 
        /** The highest sequence number encountered. */
        this.W_ = 0, 
        /**
             * A ordered bidirectional mapping between documents and the remote target
             * IDs.
             */
        this.Q_ = new ki, this.targetCount = 0, this.j_ = Nr.ni();
    }
    return t.prototype.pe = function(t, e) {
        return this.U_.forEach((function(t, n) {
            return e(n);
        })), Kn.resolve();
    }, t.prototype.ai = function(t) {
        return Kn.resolve(this.lastRemoteSnapshotVersion);
    }, t.prototype.ui = function(t) {
        return Kn.resolve(this.W_);
    }, t.prototype.ri = function(t) {
        return this.highestTargetId = this.j_.next(), Kn.resolve(this.highestTargetId);
    }, t.prototype.ci = function(t, e, n) {
        return n && (this.lastRemoteSnapshotVersion = n), e > this.W_ && (this.W_ = e), 
        Kn.resolve();
    }, t.prototype._i = function(t) {
        this.U_.set(t.target, t);
        var e = t.targetId;
        e > this.highestTargetId && (this.j_ = new Nr(e), this.highestTargetId = e), t.sequenceNumber > this.W_ && (this.W_ = t.sequenceNumber);
    }, t.prototype.li = function(t, e) {
        return this._i(e), this.targetCount += 1, Kn.resolve();
    }, t.prototype.di = function(t, e) {
        return this._i(e), Kn.resolve();
    }, t.prototype.wi = function(t, e) {
        return this.U_.delete(e.target), this.Q_.jh(e.targetId), this.targetCount -= 1, 
        Kn.resolve();
    }, t.prototype.Ei = function(t, e, n) {
        var r = this, i = 0, o = [];
        return this.U_.forEach((function(s, u) {
            u.sequenceNumber <= e && null === n.get(u.targetId) && (r.U_.delete(s), o.push(r.Ti(t, u.targetId)), 
            i++);
        })), Kn.Sn(o).next((function() {
            return i;
        }));
    }, t.prototype.Ii = function(t) {
        return Kn.resolve(this.targetCount);
    }, t.prototype.mi = function(t, e) {
        var n = this.U_.get(e) || null;
        return Kn.resolve(n);
    }, t.prototype.Ai = function(t, e, n) {
        return this.Q_.Uh(e, n), Kn.resolve();
    }, t.prototype.Pi = function(t, e, n) {
        this.Q_.Qh(e, n);
        var r = this.persistence.ii, i = [];
        return r && e.forEach((function(e) {
            i.push(r.Dr(t, e));
        })), Kn.Sn(i);
    }, t.prototype.Ti = function(t, e) {
        return this.Q_.jh(e), Kn.resolve();
    }, t.prototype.Vi = function(t, e) {
        var n = this.Q_.Gh(e);
        return Kn.resolve(n);
    }, t.prototype.pi = function(t, e) {
        return Kn.resolve(this.Q_.pi(e));
    }, t;
}(), _s = /** @class */ function() {
    /**
     * The constructor accepts a factory for creating a reference delegate. This
     * allows both the delegate and this instance to have strong references to
     * each other without having nullable fields that would then need to be
     * checked or asserted on every access.
     */
    function t(t) {
        var e = this;
        this.K_ = {}, this.Ci = new Zn(0), this.Fi = !1, this.Fi = !0, this.ii = t(this), 
        this.qi = new As(this), this.Kn = new or, this.Qn = new Ns(this.Kn, (function(t) {
            return e.ii.G_(t);
        }));
    }
    return t.prototype.start = function() {
        return Promise.resolve();
    }, t.prototype._r = function() {
        // No durable state to ensure is closed on shutdown.
        return this.Fi = !1, Promise.resolve();
    }, Object.defineProperty(t.prototype, "Hi", {
        get: function() {
            return this.Fi;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Yi = function() {
        // No op.
    }, t.prototype.Xi = function() {
        // No op.
    }, t.prototype.gr = function() {
        return this.Kn;
    }, t.prototype.mr = function(t) {
        var e = this.K_[t.Aa()];
        return e || (e = new Ts(this.Kn, this.ii), this.K_[t.Aa()] = e), e;
    }, t.prototype.Rr = function() {
        return this.qi;
    }, t.prototype.Pr = function() {
        return this.Qn;
    }, t.prototype.runTransaction = function(t, e, n) {
        var r = this;
        E("MemoryPersistence", "Starting transaction:", t);
        var i = new Ds(this.Ci.next());
        return this.ii.z_(), n(i).next((function(t) {
            return r.ii.H_(i).next((function() {
                return t;
            }));
        })).bn().then((function(t) {
            return i.Wn(), t;
        }));
    }, t.prototype.Y_ = function(t, e) {
        return Kn.Dn(Object.values(this.K_).map((function(n) {
            return function() {
                return n.pi(t, e);
            };
        })));
    }, t;
}(), Ds = /** @class */ function(e) {
    function n(t) {
        var n = this;
        return (n = e.call(this) || this).vi = t, n;
    }
    return t(n, e), n;
}(Hn), Ss = /** @class */ function() {
    function t(t) {
        this.persistence = t, 
        /** Tracks all documents that are active in Query views. */
        this.J_ = new ki, 
        /** The list of documents that are potentially GCed after each transaction. */
        this.X_ = null;
    }
    return t.Z_ = function(e) {
        return new t(e);
    }, Object.defineProperty(t.prototype, "tf", {
        get: function() {
            if (this.X_) return this.X_;
            throw A();
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.Ri = function(t, e, n) {
        return this.J_.Ri(n, e), this.tf.delete(n), Kn.resolve();
    }, t.prototype.gi = function(t, e, n) {
        return this.J_.gi(n, e), this.tf.add(n), Kn.resolve();
    }, t.prototype.Dr = function(t, e) {
        return this.tf.add(e), Kn.resolve();
    }, t.prototype.removeTarget = function(t, e) {
        var n = this;
        this.J_.jh(e.targetId).forEach((function(t) {
            return n.tf.add(t);
        }));
        var r = this.persistence.Rr();
        return r.Vi(t, e.targetId).next((function(t) {
            t.forEach((function(t) {
                return n.tf.add(t);
            }));
        })).next((function() {
            return r.wi(t, e);
        }));
    }, t.prototype.z_ = function() {
        this.X_ = new Set;
    }, t.prototype.H_ = function(t) {
        var e = this, n = this.persistence.Pr().Hs();
        // Remove newly orphaned documents.
                return Kn.forEach(this.tf, (function(r) {
            return e.ef(t, r).next((function(t) {
                t || n.xn(r);
            }));
        })).next((function() {
            return e.X_ = null, n.apply(t);
        }));
    }, t.prototype.Nr = function(t, e) {
        var n = this;
        return this.ef(t, e).next((function(t) {
            t ? n.tf.delete(e) : n.tf.add(e);
        }));
    }, t.prototype.G_ = function(t) {
        // For eager GC, we don't care about the document size, there are no size thresholds.
        return 0;
    }, t.prototype.ef = function(t, e) {
        var n = this;
        return Kn.Dn([ function() {
            return Kn.resolve(n.J_.pi(e));
        }, function() {
            return n.persistence.Rr().pi(t, e);
        }, function() {
            return n.persistence.Y_(t, e);
        } ]);
    }, t;
}(), xs = /** @class */ function() {
    function t(t) {
        this.nf = t.nf, this.sf = t.sf;
    }
    return t.prototype.tu = function(t) {
        this.if = t;
    }, t.prototype.Ha = function(t) {
        this.rf = t;
    }, t.prototype.onMessage = function(t) {
        this.hf = t;
    }, t.prototype.close = function() {
        this.sf();
    }, t.prototype.send = function(t) {
        this.nf(t);
    }, t.prototype.af = function() {
        this.if();
    }, t.prototype.uf = function(t) {
        this.rf(t);
    }, t.prototype.cf = function(t) {
        this.hf(t);
    }, t;
}(), ks = {
    BatchGetDocuments: "batchGet",
    Commit: "commit",
    RunQuery: "runQuery"
}, Ps = /** @class */ function() {
    function t(t) {
        this.s = t.s;
        var e = t.ssl ? "https" : "http";
        this.lf = e + "://" + t.host, this.forceLongPolling = t.forceLongPolling;
    }
    /**
     * Modifies the headers for a request, adding any authorization token if
     * present and any additional headers for the request.
     */    return t.prototype._f = function(t, e) {
        if (e) for (var n in e.ga) e.ga.hasOwnProperty(n) && (t[n] = e.ga[n]);
        t["X-Goog-Api-Client"] = "gl-js/ fire/7.17.1";
    }, t.prototype.fu = function(t, e, n) {
        var r = this, i = this.ff(t);
        return new Promise((function(o, s) {
            var u = new d;
            u.listenOnce(y.COMPLETE, (function() {
                try {
                    switch (u.getLastErrorCode()) {
                      case v.NO_ERROR:
                        var e = u.getResponseJson();
                        E("Connection", "XHR received:", JSON.stringify(e)), o(e);
                        break;

                      case v.TIMEOUT:
                        E("Connection", 'RPC "' + t + '" timed out'), s(new F(q.DEADLINE_EXCEEDED, "Request time out"));
                        break;

                      case v.HTTP_ERROR:
                        var n = u.getStatus();
                        if (E("Connection", 'RPC "' + t + '" failed with status:', n, "response text:", u.getResponseText()), 
                        n > 0) {
                            var r = u.getResponseJson().error;
                            if (r && r.status && r.message) {
                                var i = function(t) {
                                    var e = t.toLowerCase().replace("_", "-");
                                    return Object.values(q).indexOf(e) >= 0 ? e : q.UNKNOWN;
                                }(r.status);
                                s(new F(i, r.message));
                            } else s(new F(q.UNKNOWN, "Server responded with status " + u.getStatus()));
                        } else 
                        // If we received an HTTP_ERROR but there's no status code,
                        // it's most probably a connection issue
                        E("Connection", 'RPC "' + t + '" failed'), s(new F(q.UNAVAILABLE, "Connection failed."));
                        break;

                      default:
                        A();
                    }
                } finally {
                    E("Connection", 'RPC "' + t + '" completed.');
                }
            }));
            // The database field is already encoded in URL. Specifying it again in
            // the body is not necessary in production, and will cause duplicate field
            // errors in the Firestore Emulator. Let's remove it.
            var a = Object.assign({}, e);
            delete a.database;
            var c = JSON.stringify(a);
            E("Connection", "XHR sending: ", i + " " + c);
            // Content-Type: text/plain will avoid preflight requests which might
            // mess with CORS and redirects by proxies. If we add custom headers
            // we will need to change this code to potentially use the
            // $httpOverwrite parameter supported by ESF to avoid
            // triggering preflight requests.
            var h = {
                "Content-Type": "text/plain"
            };
            r._f(h, n), u.send(i, "POST", c, h, 15);
        }));
    }, t.prototype.du = function(t, e, n) {
        // The REST API automatically aggregates all of the streamed results, so we
        // can just use the normal invoke() method.
        return this.fu(t, e, n);
    }, t.prototype.eu = function(t, e) {
        var n = [ this.lf, "/", "google.firestore.v1.Firestore", "/", t, "/channel" ], i = m(), o = {
            // Required for backend stickiness, routing behavior is based on this
            // parameter.
            httpSessionIdParam: "gsessionid",
            initMessageHeaders: {},
            messageUrlParams: {
                // This param is used to improve routing and project isolation by the
                // backend and must be included in every request.
                database: "projects/" + this.s.projectId + "/databases/" + this.s.database
            },
            sendRawJson: !0,
            supportsCrossDomainXhr: !0,
            internalChannelParams: {
                // Override the default timeout (randomized between 10-20 seconds) since
                // a large write batch on a slow internet connection may take a long
                // time to send to the backend. Rather than have WebChannel impose a
                // tight timeout which could lead to infinite timeouts and retries, we
                // set it very large (5-10 minutes) and rely on the browser's builtin
                // timeouts to kick in if the request isn't working.
                forwardChannelRequestTimeoutMs: 6e5
            },
            forceLongPolling: this.forceLongPolling
        };
        this._f(o.initMessageHeaders, e), 
        // Sending the custom headers we just added to request.initMessageHeaders
        // (Authorization, etc.) will trigger the browser to make a CORS preflight
        // request because the XHR will no longer meet the criteria for a "simple"
        // CORS request:
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS#Simple_requests
        // Therefore to avoid the CORS preflight request (an extra network
        // roundtrip), we use the httpHeadersOverwriteParam option to specify that
        // the headers should instead be encoded into a special "$httpHeaders" query
        // parameter, which is recognized by the webchannel backend. This is
        // formally defined here:
        // https://github.com/google/closure-library/blob/b0e1815b13fb92a46d7c9b3c30de5d6a396a3245/closure/goog/net/rpc/httpcors.js#L32
        // TODO(b/145624756): There is a backend bug where $httpHeaders isn't respected if the request
        // doesn't have an Origin header. So we have to exclude a few browser environments that are
        // known to (sometimes) not include an Origin. See
        // https://github.com/firebase/firebase-js-sdk/issues/1491.
        a() || c() || h() || f() || l() || p() || (o.httpHeadersOverwriteParam = "$httpHeaders");
        var u = n.join("");
        E("Connection", "Creating WebChannel: " + u + " " + o);
        var d = i.createWebChannel(u, o), y = !1, v = !1, w = new xs({
            nf: function(t) {
                v ? E("Connection", "Not sending because WebChannel is closed:", t) : (y || (E("Connection", "Opening WebChannel transport."), 
                d.open(), y = !0), E("Connection", "WebChannel sending:", t), d.send(t));
            },
            sf: function() {
                return d.close();
            }
        }), I = function(t, e) {
            // TODO(dimond): closure typing seems broken because WebChannel does
            // not implement goog.events.Listenable
            d.listen(t, (function(t) {
                try {
                    e(t);
                } catch (t) {
                    setTimeout((function() {
                        throw t;
                    }), 0);
                }
            }));
        };
        // WebChannel supports sending the first message with the handshake - saving
        // a network round trip. However, it will have to call send in the same
        // JS event loop as open. In order to enforce this, we delay actually
        // opening the WebChannel until send is called. Whether we have called
        // open is tracked with this variable.
                // Closure events are guarded and exceptions are swallowed, so catch any
        // exception and rethrow using a setTimeout so they become visible again.
        // Note that eventually this function could go away if we are confident
        // enough the code is exception free.
        return I(g.EventType.OPEN, (function() {
            v || E("Connection", "WebChannel transport opened.");
        })), I(g.EventType.CLOSE, (function() {
            v || (v = !0, E("Connection", "WebChannel transport closed"), w.uf());
        })), I(g.EventType.ERROR, (function(t) {
            v || (v = !0, function(t) {
                for (var e = [], n = 1; n < arguments.length; n++) e[n - 1] = arguments[n];
                if (b.logLevel <= s.WARN) {
                    var i = e.map(N);
                    b.warn.apply(b, r([ "Firestore (7.17.1): " + t ], i));
                }
            }("Connection", "WebChannel transport errored:", t), w.uf(new F(q.UNAVAILABLE, "The operation could not be completed")));
        })), I(g.EventType.MESSAGE, (function(t) {
            var e;
            if (!v) {
                var n = t.data[0];
                _(!!n);
                // TODO(b/35143891): There is a bug in One Platform that caused errors
                // (and only errors) to be wrapped in an extra array. To be forward
                // compatible with the bug we need to check either condition. The latter
                // can be removed once the fix has been rolled out.
                // Use any because msgData.error is not typed.
                var r = n, i = r.error || (null === (e = r[0]) || void 0 === e ? void 0 : e.error);
                if (i) {
                    E("Connection", "WebChannel received error:", i);
                    // error.status will be a string like 'OK' or 'NOT_FOUND'.
                    var o = i.status, s = function(t) {
                        // lookup by string
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        var e = rt[t];
                        if (void 0 !== e) return at(e);
                    }(o), u = i.message;
                    void 0 === s && (s = q.INTERNAL, u = "Unknown error status: " + o + " with message " + i.message), 
                    // Mark closed so no further events are propagated
                    v = !0, w.uf(new F(s, u)), d.close();
                } else E("Connection", "WebChannel received:", n), w.cf(n);
            }
        })), setTimeout((function() {
            // Technically we could/should wait for the WebChannel opened event,
            // but because we want to send the first message with the WebChannel
            // handshake we pretend the channel opened here (asynchronously), and
            // then delay the actual open until the first message is sent.
            w.af();
        }), 0), w;
    }, 
    // visible for testing
    t.prototype.ff = function(t) {
        var e = ks[t];
        return this.lf + "/v1/projects/" + this.s.projectId + "/databases/" + this.s.database + "/documents:" + e;
    }, t;
}(), Ls = /** @class */ function() {
    function t() {
        var t = this;
        this.df = function() {
            return t.wf();
        }, this.Tf = function() {
            return t.Ef();
        }, this.If = [], this.mf();
    }
    return t.prototype.Lu = function(t) {
        this.If.push(t);
    }, t.prototype._r = function() {
        window.removeEventListener("online", this.df), window.removeEventListener("offline", this.Tf);
    }, t.prototype.mf = function() {
        window.addEventListener("online", this.df), window.addEventListener("offline", this.Tf);
    }, t.prototype.wf = function() {
        E("ConnectivityMonitor", "Network connectivity changed: AVAILABLE");
        for (var t = 0, e = this.If; t < e.length; t++) {
            (0, e[t])(0 /* AVAILABLE */);
        }
    }, t.prototype.Ef = function() {
        E("ConnectivityMonitor", "Network connectivity changed: UNAVAILABLE");
        for (var t = 0, e = this.If; t < e.length; t++) {
            (0, e[t])(1 /* UNAVAILABLE */);
        }
    }, 
    // TODO(chenbrian): Consider passing in window either into this component or
    // here for testing via FakeWindow.
    /** Checks that all used attributes of window are available. */
    t.Oi = function() {
        return "undefined" != typeof window && void 0 !== window.addEventListener && void 0 !== window.removeEventListener;
    }, t;
}(), Os = /** @class */ function() {
    function t() {}
    return t.prototype.Lu = function(t) {
        // No-op.
    }, t.prototype._r = function() {
        // No-op.
    }, t;
}(), Rs = "You are using the memory-only build of Firestore. Persistence support is only available via the @firebase/firestore bundle or the firebase-firestore.js build.", Vs = /** @class */ function() {
    function t() {}
    return t.prototype.initialize = function(t) {
        return e(this, void 0, void 0, (function() {
            var e, r = this;
            return n(this, (function(n) {
                switch (n.label) {
                  case 0:
                    return this.Ll = this.Af(t), this.persistence = this.Rf(t), [ 4 /*yield*/ , this.persistence.start() ];

                  case 1:
                    return n.sent(), this.Pf = this.gf(t), this.$u = this.Vf(t), this.wu = this.yf(t), 
                    [ 4 /*yield*/ , this.pf(t) ];

                  case 2:
                    return e = n.sent(), this.wu.start(e), this.Ol = this.bf(t), this.oc = this.vf(t), 
                    this.Sf = this.Df(t), this.Ll.Vu = function(t) {
                        return r.oc.vl(t, 1 /* SharedClientState */);
                    }, this.Ol.oc = this.oc, [ 4 /*yield*/ , this.Ll.start() ];

                  case 3:
                    return n.sent(), [ 4 /*yield*/ , this.Ol.start() ];

                  case 4:
                    return n.sent(), [ 4 /*yield*/ , this.Ol.Pc(this.oc.Xl) ];

                  case 5:
                    return n.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, t.prototype.pf = function(t) {
        return e = t.Cf, Promise.resolve(new Ps(e));
        var e;
        /** Return the Platform-specific connectivity monitor. */    }, t.prototype.Df = function(t) {
        return new bs(this.oc);
    }, t.prototype.gf = function(t) {
        return null;
    }, t.prototype.Vf = function(t) {
        return Di(this.persistence, new Es, t.Ff);
    }, t.prototype.Rf = function(t) {
        if (t.Nf.$f) throw new F(q.FAILED_PRECONDITION, Rs);
        return new _s(Ss.Z_);
    }, t.prototype.yf = function(t) {
        var e = po(t.Cf.s);
        return function(t, e) {
            return new Bo(t, e);
        }(t.credentials, e);
    }, t.prototype.bf = function(t) {
        var e = this;
        return new Ko(this.$u, this.wu, t.ao, (function(t) {
            return e.oc.vl(t, 0 /* RemoteStore */);
        }), Ls.Oi() ? new Ls : new Os);
    }, t.prototype.Af = function(t) {
        return new ns;
    }, t.prototype.vf = function(t) {
        return hs(this.$u, this.Ol, this.wu, this.Ll, t.Ff, t.ql, 
        /* isPrimary= */ !0);
    }, t.prototype.clearPersistence = function(t, e) {
        throw new F(q.FAILED_PRECONDITION, Rs);
    }, t;
}(), Us = /** @class */ function(r) {
    function i() {
        return null !== r && r.apply(this, arguments) || this;
    }
    return t(i, r), i.prototype.initialize = function(t) {
        return e(this, void 0, void 0, (function() {
            var i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return [ 4 /*yield*/ , r.prototype.initialize.call(this, t) ];

                  case 1:
                    // NOTE: This will immediately call the listener, so we make sure to
                    // set it after localStore / remoteStore are started.
                    return o.sent(), [ 4 /*yield*/ , this.persistence.zi((function(t) {
                        return e(i, void 0, void 0, (function() {
                            return n(this, (function(e) {
                                switch (e.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , ps(this.oc, t) ];

                                  case 1:
                                    return e.sent(), this.Pf && (t && !this.Pf.Hi ? this.Pf.start(this.$u) : t || this.Pf.stop()), 
                                    [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })) ];

                  case 2:
                    // In multi-tab mode, we need to read the last document change marker from
                    // persistence once during client initialization. The next call to
                    // `getNewDocumentChanges()` will then only read changes that were persisted
                    // since client startup.
                    // NOTE: This will immediately call the listener, so we make sure to
                    // set it after localStore / remoteStore are started.
                    return o.sent(), [ 4 /*yield*/ , function(t) {
                        return e(this, void 0, void 0, (function() {
                            var e, r;
                            return n(this, (function(n) {
                                return e = D(t), r = D(e.Eh), [ 2 /*return*/ , e.persistence.runTransaction("Synchronize last document change read time", "readonly", (function(t) {
                                    return r.zs(t);
                                })).then((function(t) {
                                    e.Th = t;
                                })) ];
                            }));
                        }));
                    }(this.$u) ];

                  case 3:
                    // In multi-tab mode, we need to read the last document change marker from
                    // persistence once during client initialization. The next call to
                    // `getNewDocumentChanges()` will then only read changes that were persisted
                    // since client startup.
                    return o.sent(), [ 2 /*return*/ ];
                }
            }));
        }));
    }, i.prototype.vf = function(t) {
        var e = !t.Nf.$f || !t.Nf.synchronizeTabs, n = hs(this.$u, this.Ol, this.wu, this.Ll, t.Ff, t.ql, e);
        return this.Ll instanceof es && (this.Ll.oc = {
            cl: ls.bind(null, n),
            ll: ms.bind(null, n),
            _l: gs.bind(null, n),
            Ir: vs.bind(null, n)
        }), n;
    }, i.prototype.Af = function(t) {
        if (t.Nf.$f && t.Nf.synchronizeTabs) {
            var e = vi();
            if (!es.Oi(e)) throw new F(q.UNIMPLEMENTED, "IndexedDB persistence is only available on platforms that support LocalStorage.");
            var n = Ur(t.Cf.s, t.Cf.persistenceKey);
            return new es(e, t.ao, n, t.clientId, t.Ff);
        }
        return new ns;
    }, i;
}(/** @class */ function(r) {
    function i() {
        return null !== r && r.apply(this, arguments) || this;
    }
    return t(i, r), i.prototype.Vf = function(t) {
        return Di(this.persistence, new Es, t.Ff);
    }, i.prototype.gf = function(t) {
        var e = this.persistence.ii.yr;
        return new Ni(e, t.ao);
    }, i.prototype.Rf = function(t) {
        var e = Ur(t.Cf.s, t.Cf.persistenceKey), n = po(t.Cf.s);
        return new Pr(t.Nf.synchronizeTabs, e, t.clientId, Ti.Ho(t.Nf.cacheSizeBytes), t.ao, vi(), "undefined" != typeof document ? document : null, n, this.Ll, t.Nf.Di);
    }, i.prototype.Af = function(t) {
        return new ns;
    }, i.prototype.clearPersistence = function(t, r) {
        return function(t) {
            return e(this, void 0, void 0, (function() {
                var e;
                return n(this, (function(n) {
                    switch (n.label) {
                      case 0:
                        return ui.Oi() ? (e = t + "main", [ 4 /*yield*/ , ui.delete(e) ]) : [ 2 /*return*/ , Promise.resolve() ];

                      case 1:
                        return n.sent(), [ 2 /*return*/ ];
                    }
                }));
            }));
        }(Ur(t, r));
    }, i;
}(Vs)), Cs = /** @class */ function() {
    function t(t, 
    /**
     * Asynchronous queue responsible for all of our internal processing. When
     * we get incoming work from the user (via public API) or the network
     * (incoming GRPC messages), we should always schedule onto this queue.
     * This ensures all of our work is properly serialized (e.g. we don't
     * start processing a new operation while the previous one is waiting for
     * an async I/O to complete).
     */
    e) {
        this.credentials = t, this.ao = e, this.clientId = x.t()
        /**
     * Starts up the FirestoreClient, returning only whether or not enabling
     * persistence succeeded.
     *
     * The intent here is to "do the right thing" as far as users are concerned.
     * Namely, in cases where offline persistence is requested and possible,
     * enable it, but otherwise fall back to persistence disabled. For the most
     * part we expect this to succeed one way or the other so we don't expect our
     * users to actually wait on the firestore.enablePersistence Promise since
     * they generally won't care.
     *
     * Of course some users actually do care about whether or not persistence
     * was successfully enabled, so the Promise returned from this method
     * indicates this outcome.
     *
     * This presents a problem though: even before enablePersistence resolves or
     * rejects, users may have made calls to e.g. firestore.collection() which
     * means that the FirestoreClient in there will be available and will be
     * enqueuing actions on the async queue.
     *
     * Meanwhile any failure of an operation on the async queue causes it to
     * panic and reject any further work, on the premise that unhandled errors
     * are fatal.
     *
     * Consequently the fallback is handled internally here in start, and if the
     * fallback succeeds we signal success to the async queue even though the
     * start() itself signals failure.
     *
     * @param databaseInfo The connection information for the current instance.
     * @param componentProvider Provider that returns all core components.
     * @param persistenceSettings Settings object to configure offline
     *     persistence.
     * @returns A deferred result indicating the user-visible result of enabling
     *     offline persistence. This method will reject this if IndexedDB fails to
     *     start for any reason. If usePersistence is false this is
     *     unconditionally resolved.
     */;
    }
    return t.prototype.start = function(t, e, n) {
        var r = this;
        this.kf(), this.Cf = t;
        // We defer our initialization until we get the current user from
        // setChangeListener(). We block the async queue until we got the initial
        // user and the initialization is completed. This will prevent any scheduled
        // work from happening before initialization is completed.
        // If initializationDone resolved then the FirestoreClient is in a usable
        // state.
        var i = new Jn, o = new Jn, s = !1;
        // If usePersistence is true, certain classes of errors while starting are
        // recoverable but only by falling back to persistence disabled.
        // If there's an error in the first case but not in recovery we cannot
        // reject the promise blocking the async queue because this will cause the
        // async queue to panic.
                // Return only the result of enabling persistence. Note that this does not
        // need to await the completion of initializationDone because the result of
        // this method should not reflect any other kind of failure to start.
        return this.credentials.pa((function(t) {
            if (!s) return s = !0, E("FirestoreClient", "Initializing. user=", t.uid), r.xf(e, n, t, o).then(i.resolve, i.reject);
            r.ao.er((function() {
                return r.Ol.Rc(t);
            }));
        })), 
        // Block the async queue until initialization is done
        this.ao.Zi((function() {
            return i.promise;
        })), o.promise;
    }, 
    /** Enables the network connection and requeues all pending operations. */ t.prototype.enableNetwork = function() {
        var t = this;
        return this.kf(), this.ao.enqueue((function() {
            return t.persistence.Xi(!0), t.Ol.enableNetwork();
        }));
    }, 
    /**
     * Initializes persistent storage, attempting to use IndexedDB if
     * usePersistence is true or memory-only if false.
     *
     * If IndexedDB fails because it's already open in another tab or because the
     * platform can't possibly support our implementation then this method rejects
     * the persistenceResult and falls back on memory-only persistence.
     *
     * @param componentProvider The provider that provides all core componennts
     *     for IndexedDB or memory-backed persistence
     * @param persistenceSettings Settings object to configure offline persistence
     * @param user The initial user
     * @param persistenceResult A deferred result indicating the user-visible
     *     result of enabling offline persistence. This method will reject this if
     *     IndexedDB fails to start for any reason. If usePersistence is false
     *     this is unconditionally resolved.
     * @returns a Promise indicating whether or not initialization should
     *     continue, i.e. that one of the persistence implementations actually
     *     succeeded.
     */
    t.prototype.xf = function(t, r, i, o) {
        return e(this, void 0, void 0, (function() {
            var s, u = this;
            return n(this, (function(a) {
                switch (a.label) {
                  case 0:
                    return a.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , t.initialize({
                        ao: this.ao,
                        Cf: this.Cf,
                        clientId: this.clientId,
                        credentials: this.credentials,
                        Ff: i,
                        ql: 100,
                        Nf: r
                    }) ];

                  case 1:
                    return a.sent(), this.persistence = t.persistence, this.Ll = t.Ll, this.$u = t.$u, 
                    this.Ol = t.Ol, this.oc = t.oc, this.Pf = t.Pf, this.Mf = t.Sf, 
                    // When a user calls clearPersistence() in one client, all other clients
                    // need to be terminated to allow the delete to succeed.
                    this.persistence.Yi((function() {
                        return e(u, void 0, void 0, (function() {
                            return n(this, (function(t) {
                                switch (t.label) {
                                  case 0:
                                    return [ 4 /*yield*/ , this.terminate() ];

                                  case 1:
                                    return t.sent(), [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })), o.resolve(), [ 3 /*break*/ , 3 ];

                  case 2:
                    // An unknown failure on the first stage shuts everything down.
                    if (s = a.sent(), 
                    // Regardless of whether or not the retry succeeds, from an user
                    // perspective, offline persistence has failed.
                    o.reject(s), !this.Of(s)) throw s;
                    return [ 2 /*return*/ , (console.warn("Error enabling offline persistence. Falling back to persistence disabled: " + s), 
                    this.xf(new Vs, {
                        $f: !1
                    }, i, o)) ];

                  case 3:
                    return [ 2 /*return*/ ];
                }
            }));
        }));
    }, 
    /**
     * Decides whether the provided error allows us to gracefully disable
     * persistence (as opposed to crashing the client).
     */
    t.prototype.Of = function(t) {
        return "FirebaseError" === t.name ? t.code === q.FAILED_PRECONDITION || t.code === q.UNIMPLEMENTED : !("undefined" != typeof DOMException && t instanceof DOMException) || 
        // When the browser is out of quota we could get either quota exceeded
        // or an aborted error depending on whether the error happened during
        // schema migration.
        22 === t.code || 20 === t.code || 
        // Firefox Private Browsing mode disables IndexedDb and returns
        // INVALID_STATE for any usage.
        11 === t.code;
    }, 
    /**
     * Checks that the client has not been terminated. Ensures that other methods on
     * this class cannot be called after the client is terminated.
     */
    t.prototype.kf = function() {
        if (this.ao.yo) throw new F(q.FAILED_PRECONDITION, "The client has already been terminated.");
    }, 
    /** Disables the network connection. Pending operations will not complete. */ t.prototype.disableNetwork = function() {
        var t = this;
        return this.kf(), this.ao.enqueue((function() {
            return t.persistence.Xi(!1), t.Ol.disableNetwork();
        }));
    }, t.prototype.terminate = function() {
        var t = this;
        return this.ao.Do((function() {
            return e(t, void 0, void 0, (function() {
                return n(this, (function(t) {
                    switch (t.label) {
                      case 0:
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        return this.Pf && this.Pf.stop(), [ 4 /*yield*/ , this.Ol._r() ];

                      case 1:
                        return t.sent(), [ 4 /*yield*/ , this.Ll._r() ];

                      case 2:
                        return t.sent(), [ 4 /*yield*/ , this.persistence._r() ];

                      case 3:
                        // PORTING NOTE: LocalStore does not need an explicit shutdown on web.
                        return t.sent(), 
                        // `removeChangeListener` must be called after shutting down the
                        // RemoteStore as it will prevent the RemoteStore from retrieving
                        // auth tokens.
                        this.credentials.ba(), [ 2 /*return*/ ];
                    }
                }));
            }));
        }));
    }, 
    /**
     * Returns a Promise that resolves when all writes that were pending at the time this
     * method was called received server acknowledgement. An acknowledgement can be either acceptance
     * or rejection.
     */
    t.prototype.waitForPendingWrites = function() {
        var t = this;
        this.kf();
        var e = new Jn;
        return this.ao.Zi((function() {
            return t.oc.u_(e);
        })), e.promise;
    }, t.prototype.listen = function(t, e, n) {
        var r = this;
        this.kf();
        var i = new Is(t, e, n);
        return this.ao.Zi((function() {
            return r.Mf.listen(i);
        })), i;
    }, t.prototype.ic = function(t) {
        var e = this;
        // Checks for termination but does not raise error, allowing unlisten after
        // termination to be a no-op.
                this.Lf || this.ao.Zi((function() {
            return e.Mf.ic(t);
        }));
    }, t.prototype.qf = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return this.kf(), r = new Jn, [ 4 /*yield*/ , this.ao.enqueue((function() {
                        return e(i, void 0, void 0, (function() {
                            var e, i, o;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.$u.$h(t) ];

                                  case 1:
                                    return (e = n.sent()) instanceof pn ? r.resolve(e) : e instanceof dn ? r.resolve(null) : r.reject(new F(q.UNAVAILABLE, "Failed to get document from cache. (However, this document may exist on the server. Run again without setting 'source' in the GetOptions to attempt to retrieve the document from the server.)")), 
                                    [ 3 /*break*/ , 3 ];

                                  case 2:
                                    return i = n.sent(), o = wi(i, "Failed to get document '" + t + " from cache"), 
                                    r.reject(o), [ 3 /*break*/ , 3 ];

                                  case 3:
                                    return [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })) ];

                  case 1:
                    return [ 2 /*return*/ , (o.sent(), r.promise) ];
                }
            }));
        }));
    }, t.prototype.Bf = function(t) {
        return e(this, void 0, void 0, (function() {
            var r, i = this;
            return n(this, (function(o) {
                switch (o.label) {
                  case 0:
                    return this.kf(), r = new Jn, [ 4 /*yield*/ , this.ao.enqueue((function() {
                        return e(i, void 0, void 0, (function() {
                            var e, i, o, s, u, a;
                            return n(this, (function(n) {
                                switch (n.label) {
                                  case 0:
                                    return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.$u.xh(t, 
                                    /* usePreviousResults= */ !0) ];

                                  case 1:
                                    return e = n.sent(), i = new os(t, e.Mh), o = i.Rl(e.documents), s = i.qn(o, 
                                    /* updateLimboDocuments= */ !1), r.resolve(s.snapshot), [ 3 /*break*/ , 3 ];

                                  case 2:
                                    return u = n.sent(), a = wi(u, "Failed to execute query '" + t + " against cache"), 
                                    r.reject(a), [ 3 /*break*/ , 3 ];

                                  case 3:
                                    return [ 2 /*return*/ ];
                                }
                            }));
                        }));
                    })) ];

                  case 1:
                    return [ 2 /*return*/ , (o.sent(), r.promise) ];
                }
            }));
        }));
    }, t.prototype.write = function(t) {
        var e = this;
        this.kf();
        var n = new Jn;
        return this.ao.Zi((function() {
            return e.oc.write(t, n);
        })), n.promise;
    }, t.prototype.s = function() {
        return this.Cf.s;
    }, t.prototype.R_ = function(t) {
        var e = this;
        this.kf(), this.ao.Zi((function() {
            return e.Mf.R_(t), Promise.resolve();
        }));
    }, t.prototype.P_ = function(t) {
        var e = this;
        // Checks for shutdown but does not raise error, allowing remove after
        // shutdown to be a no-op.
                this.Lf || this.ao.Zi((function() {
            return e.Mf.P_(t), Promise.resolve();
        }));
    }, Object.defineProperty(t.prototype, "Lf", {
        get: function() {
            // Technically, the asyncQueue is still running, but only accepting operations
            // related to termination or supposed to be run after termination. It is effectively
            // terminated to the eyes of users.
            return this.ao.yo;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.transaction = function(t) {
        var e = this;
        this.kf();
        var n = new Jn;
        return this.ao.Zi((function() {
            return e.oc.runTransaction(e.ao, t, n), Promise.resolve();
        })), n.promise;
    }, t;
}(), Ms = /** @class */ function() {
    function t(t) {
        this.observer = t, 
        /**
             * When set to true, will not raise future events. Necessary to deal with
             * async detachment of listener.
             */
        this.muted = !1;
    }
    return t.prototype.next = function(t) {
        this.Uf(this.observer.next, t);
    }, t.prototype.error = function(t) {
        this.Uf(this.observer.error, t);
    }, t.prototype.Wf = function() {
        this.muted = !0;
    }, t.prototype.Uf = function(t, e) {
        var n = this;
        this.muted || setTimeout((function() {
            n.muted || t(e);
        }), 0);
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A memory-backed instance of Persistence. Data is stored only in RAM and
 * not persisted across sessions.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function qs(t) {
    /**
 * Returns true if obj is an object and contains at least one of the specified
 * methods.
 */
    return function(t, e) {
        if ("object" != typeof t || null === t) return !1;
        for (var n = t, r = 0, i = [ "next", "error", "complete" ]; r < i.length; r++) {
            var o = i[r];
            if (o in n && "function" == typeof n[o]) return !0;
        }
        return !1;
    }(t);
}

var Fs = /** @class */ function() {
    function t(t, e, n, r) {
        this.s = t, this.timestampsInSnapshots = e, this.Qf = n, this.jf = r;
    }
    return t.prototype.Kf = function(t) {
        switch (qt(t)) {
          case 0 /* NullValue */ :
            return null;

          case 1 /* BooleanValue */ :
            return t.booleanValue;

          case 2 /* NumberValue */ :
            return Kt(t.integerValue || t.doubleValue);

          case 3 /* TimestampValue */ :
            return this.Gf(t.timestampValue);

          case 4 /* ServerTimestampValue */ :
            return this.zf(t);

          case 5 /* StringValue */ :
            return t.stringValue;

          case 6 /* BlobValue */ :
            return new Ji(Qt(t.bytesValue));

          case 7 /* RefValue */ :
            return this.Hf(t.referenceValue);

          case 8 /* GeoPointValue */ :
            return this.Yf(t.geoPointValue);

          case 9 /* ArrayValue */ :
            return this.Jf(t.arrayValue);

          case 10 /* ObjectValue */ :
            return this.Xf(t.mapValue);

          default:
            throw A();
        }
    }, t.prototype.Xf = function(t) {
        var e = this, n = {};
        return U(t.fields || {}, (function(t, r) {
            n[t] = e.Kf(r);
        })), n;
    }, t.prototype.Yf = function(t) {
        return new lo(Kt(t.latitude), Kt(t.longitude));
    }, t.prototype.Jf = function(t) {
        var e = this;
        return (t.values || []).map((function(t) {
            return e.Kf(t);
        }));
    }, t.prototype.zf = function(t) {
        switch (this.Qf) {
          case "previous":
            var e = function t(e) {
                var n = e.mapValue.fields.__previous_value__;
                return Ut(n) ? t(n) : n;
            }(t);
            return null == e ? null : this.Kf(e);

          case "estimate":
            return this.Gf(Ct(t));

          default:
            return null;
        }
    }, t.prototype.Gf = function(t) {
        var e = Wt(t), n = new j(e.seconds, e.nanos);
        return this.timestampsInSnapshots ? n : n.toDate();
    }, t.prototype.Hf = function(t) {
        var e = z.N(t);
        _(ke(e));
        var n = new R(e.get(1), e.get(3)), r = new Q(e.V(5));
        return n.isEqual(this.s) || 
        // TODO(b/64130202): Somehow support foreign references.
        T("Document " + r + " contains a document reference within a different database (" + n.projectId + "/" + n.database + ") which is not supported. It will be treated as a reference in the current database (" + this.s.projectId + "/" + this.s.database + ") instead."), 
        this.jf(r);
    }, t;
}(), js = Ti.Xo, Gs = /** @class */ function() {
    function t(t) {
        var e, n, r, i;
        if (void 0 === t.host) {
            if (void 0 !== t.ssl) throw new F(q.INVALID_ARGUMENT, "Can't provide ssl option if host option is not set");
            this.host = "firestore.googleapis.com", this.ssl = !0;
        } else Mi("settings", "non-empty string", "host", t.host), this.host = t.host, qi("settings", "boolean", "ssl", t.ssl), 
        this.ssl = null === (e = t.ssl) || void 0 === e || e;
        if (Ki("settings", t, [ "host", "ssl", "credentials", "timestampsInSnapshots", "cacheSizeBytes", "experimentalForceLongPolling", "ignoreUndefinedProperties" ]), 
        qi("settings", "object", "credentials", t.credentials), this.credentials = t.credentials, 
        qi("settings", "boolean", "timestampsInSnapshots", t.timestampsInSnapshots), qi("settings", "boolean", "ignoreUndefinedProperties", t.ignoreUndefinedProperties), 
        // Nobody should set timestampsInSnapshots anymore, but the error depends on
        // whether they set it to true or false...
        !0 === t.timestampsInSnapshots ? T("The setting 'timestampsInSnapshots: true' is no longer required and should be removed.") : !1 === t.timestampsInSnapshots && T("Support for 'timestampsInSnapshots: false' will be removed soon. You must update your code to handle Timestamp objects."), 
        this.timestampsInSnapshots = null === (n = t.timestampsInSnapshots) || void 0 === n || n, 
        this.ignoreUndefinedProperties = null !== (r = t.ignoreUndefinedProperties) && void 0 !== r && r, 
        qi("settings", "number", "cacheSizeBytes", t.cacheSizeBytes), void 0 === t.cacheSizeBytes) this.cacheSizeBytes = Ti.th; else {
            if (t.cacheSizeBytes !== js && t.cacheSizeBytes < Ti.Zo) throw new F(q.INVALID_ARGUMENT, "cacheSizeBytes must be at least " + Ti.Zo);
            this.cacheSizeBytes = t.cacheSizeBytes;
        }
        qi("settings", "boolean", "experimentalForceLongPolling", t.experimentalForceLongPolling), 
        this.forceLongPolling = null !== (i = t.experimentalForceLongPolling) && void 0 !== i && i;
    }
    return t.prototype.isEqual = function(t) {
        return this.host === t.host && this.ssl === t.ssl && this.timestampsInSnapshots === t.timestampsInSnapshots && this.credentials === t.credentials && this.cacheSizeBytes === t.cacheSizeBytes && this.forceLongPolling === t.forceLongPolling && this.ignoreUndefinedProperties === t.ignoreUndefinedProperties;
    }, t;
}(), Bs = /** @class */ function() {
    // Note: We are using `MemoryComponentProvider` as a default
    // ComponentProvider to ensure backwards compatibility with the format
    // expected by the console build.
    function t(r, i, o) {
        var s = this;
        if (void 0 === o && (o = new Vs), this.Zf = null, 
        // Public for use in tests.
        // TODO(mikelehen): Use modularized initialization instead.
        this.td = new gi, this.INTERNAL = {
            delete: function() {
                return e(s, void 0, void 0, (function() {
                    return n(this, (function(t) {
                        switch (t.label) {
                          case 0:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return this.ed(), [ 4 /*yield*/ , this.nd.terminate() ];

                          case 1:
                            // The client must be initalized to ensure that all subsequent API usage
                            // throws an exception.
                            return t.sent(), [ 2 /*return*/ ];
                        }
                    }));
                }));
            }
        }, "object" == typeof r.options) {
            // This is very likely a Firebase app object
            // TODO(b/34177605): Can we somehow use instanceof?
            var u = r;
            this.Zf = u, this.aa = t.sd(u), this.rd = u.name, this.od = new Co(i);
        } else {
            var a = r;
            if (!a.projectId) throw new F(q.INVALID_ARGUMENT, "Must provide projectId");
            this.aa = new R(a.projectId, a.database), 
            // Use a default persistenceKey that lines up with FirebaseApp.
            this.rd = "[DEFAULT]", this.od = new Uo;
        }
        this.hd = o, this.ad = new Gs({});
    }
    return Object.defineProperty(t.prototype, "ud", {
        get: function() {
            return this.ld || (
            // Lazy initialize UserDataReader once the settings are frozen
            this.ld = new Io(this.aa, this.ad.ignoreUndefinedProperties)), this.ld;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.settings = function(t) {
        Oi("Firestore.settings", arguments, 1), Ui("Firestore.settings", "object", 1, t);
        var e = new Gs(t);
        if (this.nd && !this.ad.isEqual(e)) throw new F(q.FAILED_PRECONDITION, "Firestore has already been started and its settings can no longer be changed. You can only call settings() before calling any other methods on a Firestore object.");
        this.ad = e, void 0 !== e.credentials && (this.od = function(t) {
            if (!t) return new Uo;
            switch (t.type) {
              case "gapi":
                var e = t._d;
                // Make sure this really is a Gapi client.
                                return _(!("object" != typeof e || null === e || !e.auth || !e.auth.getAuthHeaderValueForFirstParty)), 
                new qo(e, t.$a || "0");

              case "provider":
                return t._d;

              default:
                throw new F(q.INVALID_ARGUMENT, "makeCredentialsProvider failed due to invalid credential type");
            }
        }(e.credentials));
    }, t.prototype.enableNetwork = function() {
        return this.ed(), this.nd.enableNetwork();
    }, t.prototype.disableNetwork = function() {
        return this.ed(), this.nd.disableNetwork();
    }, t.prototype.enablePersistence = function(t) {
        var e, n;
        if (this.nd) throw new F(q.FAILED_PRECONDITION, "Firestore has already been started and persistence can no longer be enabled. You can only call enablePersistence() before calling any other methods on a Firestore object.");
        var r = !1, i = !1;
        if (t && (void 0 !== t.experimentalTabSynchronization && T("The 'experimentalTabSynchronization' setting will be removed. Use 'synchronizeTabs' instead."), 
        r = null !== (n = null !== (e = t.synchronizeTabs) && void 0 !== e ? e : t.experimentalTabSynchronization) && void 0 !== n && n, 
        i = !!t.experimentalForceOwningTab && t.experimentalForceOwningTab, r && i)) throw new F(q.INVALID_ARGUMENT, "The 'experimentalForceOwningTab' setting cannot be used with 'synchronizeTabs'.");
        return this.fd(this.hd, {
            $f: !0,
            cacheSizeBytes: this.ad.cacheSizeBytes,
            synchronizeTabs: r,
            Di: i
        });
    }, t.prototype.clearPersistence = function() {
        return e(this, void 0, void 0, (function() {
            var t, r = this;
            return n(this, (function(i) {
                if (void 0 !== this.nd && !this.nd.Lf) throw new F(q.FAILED_PRECONDITION, "Persistence can only be cleared before a Firestore instance is initialized or after it is terminated.");
                return t = new Jn, [ 2 /*return*/ , (this.td.po((function() {
                    return e(r, void 0, void 0, (function() {
                        var e;
                        return n(this, (function(n) {
                            switch (n.label) {
                              case 0:
                                return n.trys.push([ 0, 2, , 3 ]), [ 4 /*yield*/ , this.hd.clearPersistence(this.aa, this.rd) ];

                              case 1:
                                return n.sent(), t.resolve(), [ 3 /*break*/ , 3 ];

                              case 2:
                                return e = n.sent(), t.reject(e), [ 3 /*break*/ , 3 ];

                              case 3:
                                return [ 2 /*return*/ ];
                            }
                        }));
                    }));
                })), t.promise) ];
            }));
        }));
    }, t.prototype.terminate = function() {
        return this.app._removeServiceInstance("firestore"), this.INTERNAL.delete();
    }, Object.defineProperty(t.prototype, "dd", {
        get: function() {
            return this.ed(), this.nd.Lf;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.waitForPendingWrites = function() {
        return this.ed(), this.nd.waitForPendingWrites();
    }, t.prototype.onSnapshotsInSync = function(t) {
        if (this.ed(), qs(t)) return zs(this.nd, t);
        Ui("Firestore.onSnapshotsInSync", "function", 1, t);
        var e = {
            next: t
        };
        return zs(this.nd, e);
    }, t.prototype.ed = function() {
        return this.nd || 
        // Kick off starting the client but don't actually wait for it.
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        this.fd(new Vs, {
            $f: !1
        }), this.nd;
    }, t.prototype.wd = function() {
        return new O(this.aa, this.rd, this.ad.host, this.ad.ssl, this.ad.forceLongPolling);
    }, t.prototype.fd = function(t, e) {
        var n = this.wd();
        return this.nd = new Cs(this.od, this.td), this.nd.start(n, t, e);
    }, t.sd = function(t) {
        if (e = t.options, "projectId", !Object.prototype.hasOwnProperty.call(e, "projectId")) throw new F(q.INVALID_ARGUMENT, '"projectId" not provided in firebase.initializeApp.');
        var e, n = t.options.projectId;
        /**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */        if (!n || "string" != typeof n) throw new F(q.INVALID_ARGUMENT, "projectId must be a string in FirebaseApp.options");
        return new R(n);
    }, Object.defineProperty(t.prototype, "app", {
        get: function() {
            if (!this.Zf) throw new F(q.FAILED_PRECONDITION, "Firestore was not initialized using the Firebase SDK. 'app' is not available");
            return this.Zf;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.collection = function(t) {
        return Oi("Firestore.collection", arguments, 1), Ui("Firestore.collection", "non-empty string", 1, t), 
        this.ed(), new uu(z.N(t), this, 
        /* converter= */ null);
    }, t.prototype.doc = function(t) {
        return Oi("Firestore.doc", arguments, 1), Ui("Firestore.doc", "non-empty string", 1, t), 
        this.ed(), Qs.Td(z.N(t), this, 
        /* converter= */ null);
    }, t.prototype.collectionGroup = function(t) {
        if (Oi("Firestore.collectionGroup", arguments, 1), Ui("Firestore.collectionGroup", "non-empty string", 1, t), 
        t.indexOf("/") >= 0) throw new F(q.INVALID_ARGUMENT, "Invalid collection ID '" + t + "' passed to function Firestore.collectionGroup(). Collection IDs must not contain '/'.");
        return this.ed(), new iu(function(t) {
            return new mn(z.k(), t);
        }(t), this, 
        /* converter= */ null);
    }, t.prototype.runTransaction = function(t) {
        var e = this;
        return Oi("Firestore.runTransaction", arguments, 1), Ui("Firestore.runTransaction", "function", 1, t), 
        this.ed().transaction((function(n) {
            return t(new Ws(e, n));
        }));
    }, t.prototype.batch = function() {
        return this.ed(), new Ks(this);
    }, Object.defineProperty(t, "logLevel", {
        get: function() {
            switch (I()) {
              case s.DEBUG:
                return "debug";

              case s.ERROR:
                return "error";

              case s.SILENT:
                return "silent";

              case s.WARN:
                return "warn";

              case s.INFO:
                return "info";

              case s.VERBOSE:
                return "verbose";

              default:
                // The default log level is error
                return "error";
            }
        },
        enumerable: !1,
        configurable: !0
    }), t.setLogLevel = function(t) {
        var e;
        Oi("Firestore.setLogLevel", arguments, 1), ji("setLogLevel", [ "debug", "error", "silent", "warn", "info", "verbose" ], 1, t), 
        e = t, b.setLogLevel(e);
    }, 
    // Note: this is not a property because the minifier can't work correctly with
    // the way TypeScript compiler outputs properties.
    t.prototype.Ed = function() {
        return this.ad.timestampsInSnapshots;
    }, t;
}();

/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// settings() defaults:
/** Registers the listener for onSnapshotsInSync() */ function zs(t, e) {
    var n = new Ms({
        next: function() {
            e.next && e.next();
        },
        error: function(t) {
            throw A();
        }
    });
    return t.R_(n), function() {
        n.Wf(), t.P_(n);
    }
    /**
 * A reference to a transaction.
 */;
}

var Ws = /** @class */ function() {
    function t(t, e) {
        this.Id = t, this.md = e;
    }
    return t.prototype.get = function(t) {
        var e = this;
        Oi("Transaction.get", arguments, 1);
        var n = fu("Transaction.get", t, this.Id);
        return this.md.Au([ n.ua ]).then((function(t) {
            if (!t || 1 !== t.length) return A();
            var r = t[0];
            if (r instanceof dn) return new Xs(e.Id, n.ua, null, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.ca);
            if (r instanceof pn) return new Xs(e.Id, n.ua, r, 
            /* fromCache= */ !1, 
            /* hasPendingWrites= */ !1, n.ca);
            throw A();
        }));
    }, t.prototype.set = function(t, e, n) {
        Vi("Transaction.set", arguments, 2, 3);
        var r = fu("Transaction.set", t, this.Id);
        n = au("Transaction.set", n);
        var i = pu(r.ca, e, n), o = Eo(this.Id.ud, "Transaction.set", r.ua, i, null !== r.ca, n);
        return this.md.set(r.ua, o), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return "string" == typeof e || e instanceof eo ? (Ri("Transaction.update", arguments, 3), 
        r = fu("Transaction.update", t, this.Id), i = No(this.Id.ud, "Transaction.update", r.ua, e, n, o)) : (Oi("Transaction.update", arguments, 2), 
        r = fu("Transaction.update", t, this.Id), i = To(this.Id.ud, "Transaction.update", r.ua, e)), 
        this.md.update(r.ua, i), this;
    }, t.prototype.delete = function(t) {
        Oi("Transaction.delete", arguments, 1);
        var e = fu("Transaction.delete", t, this.Id);
        return this.md.delete(e.ua), this;
    }, t;
}(), Ks = /** @class */ function() {
    function t(t) {
        this.Id = t, this.Ad = [], this.Rd = !1;
    }
    return t.prototype.set = function(t, e, n) {
        Vi("WriteBatch.set", arguments, 2, 3), this.Pd();
        var r = fu("WriteBatch.set", t, this.Id);
        n = au("WriteBatch.set", n);
        var i = pu(r.ca, e, n), o = Eo(this.Id.ud, "WriteBatch.set", r.ua, i, null !== r.ca, n);
        return this.Ad = this.Ad.concat(o.la(r.ua, Ke.We())), this;
    }, t.prototype.update = function(t, e, n) {
        for (var r, i, o = [], s = 3; s < arguments.length; s++) o[s - 3] = arguments[s];
        return this.Pd(), "string" == typeof e || e instanceof eo ? (Ri("WriteBatch.update", arguments, 3), 
        r = fu("WriteBatch.update", t, this.Id), i = No(this.Id.ud, "WriteBatch.update", r.ua, e, n, o)) : (Oi("WriteBatch.update", arguments, 2), 
        r = fu("WriteBatch.update", t, this.Id), i = To(this.Id.ud, "WriteBatch.update", r.ua, e)), 
        this.Ad = this.Ad.concat(i.la(r.ua, Ke.exists(!0))), this;
    }, t.prototype.delete = function(t) {
        Oi("WriteBatch.delete", arguments, 1), this.Pd();
        var e = fu("WriteBatch.delete", t, this.Id);
        return this.Ad = this.Ad.concat(new un(e.ua, Ke.We())), this;
    }, t.prototype.commit = function() {
        return this.Pd(), this.Rd = !0, this.Ad.length > 0 ? this.Id.ed().write(this.Ad) : Promise.resolve();
    }, t.prototype.Pd = function() {
        if (this.Rd) throw new F(q.FAILED_PRECONDITION, "A write batch can no longer be used after commit() has been called.");
    }, t;
}(), Qs = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        return (i = e.call(this, n.aa, t, r) || this).ua = t, i.firestore = n, i.ca = r, 
        i.nd = i.firestore.ed(), i;
    }
    return t(n, e), n.Td = function(t, e, r) {
        if (t.length % 2 != 0) throw new F(q.INVALID_ARGUMENT, "Invalid document reference. Document references must have an even number of segments, but " + t.$() + " has " + t.length);
        return new n(new Q(t), e, r);
    }, Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.ua.path.S();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            return new uu(this.ua.path.p(), this.firestore, this.ca);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.ua.path.$();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.collection = function(t) {
        if (Oi("DocumentReference.collection", arguments, 1), Ui("DocumentReference.collection", "non-empty string", 1, t), 
        !t) throw new F(q.INVALID_ARGUMENT, "Must provide a non-empty collection name to collection()");
        var e = z.N(t);
        return new uu(this.ua.path.child(e), this.firestore, 
        /* converter= */ null);
    }, n.prototype.isEqual = function(t) {
        if (!(t instanceof n)) throw Qi("isEqual", "DocumentReference", 1, t);
        return this.firestore === t.firestore && this.ua.isEqual(t.ua) && this.ca === t.ca;
    }, n.prototype.set = function(t, e) {
        Vi("DocumentReference.set", arguments, 1, 2), e = au("DocumentReference.set", e);
        var n = pu(this.ca, t, e), r = Eo(this.firestore.ud, "DocumentReference.set", this.ua, n, null !== this.ca, e);
        return this.nd.write(r.la(this.ua, Ke.We()));
    }, n.prototype.update = function(t, e) {
        for (var n, r = [], i = 2; i < arguments.length; i++) r[i - 2] = arguments[i];
        return "string" == typeof t || t instanceof eo ? (Ri("DocumentReference.update", arguments, 2), 
        n = No(this.firestore.ud, "DocumentReference.update", this.ua, t, e, r)) : (Oi("DocumentReference.update", arguments, 1), 
        n = To(this.firestore.ud, "DocumentReference.update", this.ua, t)), this.nd.write(n.la(this.ua, Ke.exists(!0)));
    }, n.prototype.delete = function() {
        return Oi("DocumentReference.delete", arguments, 0), this.nd.write([ new un(this.ua, Ke.We()) ]);
    }, n.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        Vi("DocumentReference.onSnapshot", arguments, 1, 4);
        var s = {
            includeMetadataChanges: !1
        }, u = 0;
        "object" != typeof i[u] || qs(i[u]) || (Ki("DocumentReference.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        qi("DocumentReference.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++);
        var a = {
            includeMetadataChanges: s.includeMetadataChanges
        };
        if (qs(i[u])) {
            var c = i[u];
            i[u] = null === (t = c.next) || void 0 === t ? void 0 : t.bind(c), i[u + 1] = null === (e = c.error) || void 0 === e ? void 0 : e.bind(c), 
            i[u + 2] = null === (n = c.complete) || void 0 === n ? void 0 : n.bind(c);
        } else Ui("DocumentReference.onSnapshot", "function", u, i[u]), Ci("DocumentReference.onSnapshot", "function", u + 1, i[u + 1]), 
        Ci("DocumentReference.onSnapshot", "function", u + 2, i[u + 2]);
        var h = {
            next: function(t) {
                i[u] && i[u](r.gd(t));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return $s(this.nd, this.ua, a, h);
    }, n.prototype.get = function(t) {
        var e = this;
        return Vi("DocumentReference.get", arguments, 0, 1), hu("DocumentReference.get", t), 
        t && "cache" === t.source ? this.firestore.ed().qf(this.ua).then((function(t) {
            return new Xs(e.firestore, e.ua, t, 
            /*fromCache=*/ !0, t instanceof pn && t.Ke, e.ca);
        })) : 
        /**
         * Retrieves a latency-compensated document from the backend via a
         * SnapshotListener.
         */
        function(t, e, n) {
            var r = new Jn, i = $s(t, e, {
                includeMetadataChanges: !0,
                S_: !0
            }, {
                next: function(t) {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    i();
                    var o = t.docs.has(e);
                    !o && t.fromCache ? 
                    // TODO(dimond): If we're online and the document doesn't
                    // exist then we resolve with a doc.exists set to false. If
                    // we're offline however, we reject the Promise in this
                    // case. Two options: 1) Cache the negative response from
                    // the server so we can deliver that even when you're
                    // offline 2) Actually reject the Promise in the online case
                    // if the document doesn't exist.
                    r.reject(new F(q.UNAVAILABLE, "Failed to get document because the client is offline.")) : o && t.fromCache && n && "server" === n.source ? r.reject(new F(q.UNAVAILABLE, 'Failed to get document from server. (However, this document does exist in the local cache. Run again without setting source to "server" to retrieve the cached document.)')) : r.resolve(t);
                },
                error: function(t) {
                    return r.reject(t);
                }
            });
            return r.promise;
        }(this.nd, this.ua, t).then((function(t) {
            return e.gd(t);
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.ua, this.firestore, t);
    }, 
    /**
     * Converts a ViewSnapshot that contains the current document to a
     * DocumentSnapshot.
     */
    n.prototype.gd = function(t) {
        var e = t.docs.get(this.ua);
        return new Xs(this.firestore, this.ua, e, t.fromCache, t.hasPendingWrites, this.ca);
    }, n;
}(vo);

/** Registers an internal snapshot listener for `ref`. */ function $s(t, e, n, r) {
    var i = function(t) {
        console.error("Uncaught Error in onSnapshot:", t);
    };
    r.error && (i = r.error.bind(r));
    var o = new Ms({
        next: function(t) {
            r.next && r.next(t);
        },
        error: i
    }), s = t.listen(wn(e.path), o, n);
    return function() {
        o.Wf(), t.ic(s);
    };
}

var Hs = /** @class */ function() {
    function t(t, e) {
        this.hasPendingWrites = t, this.fromCache = e;
    }
    return t.prototype.isEqual = function(t) {
        return this.hasPendingWrites === t.hasPendingWrites && this.fromCache === t.fromCache;
    }, t;
}(), Xs = /** @class */ function() {
    function t(t, e, n, r, i, o) {
        this.Id = t, this.ua = e, this.Vd = n, this.yd = r, this.pd = i, this.ca = o;
    }
    return t.prototype.data = function(t) {
        var e = this;
        if (Vi("DocumentSnapshot.data", arguments, 0, 1), t = cu("DocumentSnapshot.data", t), 
        this.Vd) {
            // We only want to use the converter and create a new DocumentSnapshot
            // if a converter has been provided.
            if (this.ca) {
                var n = new Ys(this.Id, this.ua, this.Vd, this.yd, this.pd, 
                /* converter= */ null);
                return this.ca.fromFirestore(n, t);
            }
            return new Fs(this.Id.aa, this.Id.Ed(), t.serverTimestamps || "none", (function(t) {
                return new Qs(t, e.Id, /* converter= */ null);
            })).Kf(this.Vd.Ze());
        }
    }, t.prototype.get = function(t, e) {
        var n = this;
        if (Vi("DocumentSnapshot.get", arguments, 1, 2), e = cu("DocumentSnapshot.get", e), 
        this.Vd) {
            var r = this.Vd.data().field(ko("DocumentSnapshot.get", t, this.ua));
            if (null !== r) return new Fs(this.Id.aa, this.Id.Ed(), e.serverTimestamps || "none", (function(t) {
                return new Qs(t, n.Id, n.ca);
            })).Kf(r);
        }
    }, Object.defineProperty(t.prototype, "id", {
        get: function() {
            return this.ua.path.S();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "ref", {
        get: function() {
            return new Qs(this.ua, this.Id, this.ca);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "exists", {
        get: function() {
            return null !== this.Vd;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "metadata", {
        get: function() {
            return new Hs(this.pd, this.yd);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw Qi("isEqual", "DocumentSnapshot", 1, e);
        return this.Id === e.Id && this.yd === e.yd && this.ua.isEqual(e.ua) && (null === this.Vd ? null === e.Vd : this.Vd.isEqual(e.Vd)) && this.ca === e.ca;
    }, t;
}(), Ys = /** @class */ function(e) {
    function n() {
        return null !== e && e.apply(this, arguments) || this;
    }
    return t(n, e), n.prototype.data = function(t) {
        return e.prototype.data.call(this, t);
    }, n;
}(Xs);

function Zs(t, e, n, r, i, o, s) {
    var u;
    if (i.O()) {
        if ("array-contains" /* ARRAY_CONTAINS */ === o || "array-contains-any" /* ARRAY_CONTAINS_ANY */ === o) throw new F(q.INVALID_ARGUMENT, "Invalid Query. You can't perform '" + o + "' queries on FieldPath.documentId().");
        if ("in" /* IN */ === o) {
            eu(s, o);
            for (var a = [], c = 0, h = s; c < h.length; c++) {
                var f = h[c];
                a.push(tu(r, t, f));
            }
            u = {
                arrayValue: {
                    values: a
                }
            };
        } else u = tu(r, t, s);
    } else "in" /* IN */ !== o && "array-contains-any" /* ARRAY_CONTAINS_ANY */ !== o || eu(s, o), 
    u = Ao(n, e, s, "in" /* IN */ === o);
    var l = Pn.create(i, o, u);
    return function(t, e) {
        if (e instanceof Pn) {
            var n = [ "array-contains" /* ARRAY_CONTAINS */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ ], r = [ "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ ], i = n.indexOf(e.op) >= 0, o = r.indexOf(e.op) >= 0;
            if (e.ln()) {
                var s = t.cn();
                if (null !== s && !s.isEqual(e.field)) throw new F(q.INVALID_ARGUMENT, "Invalid query. All where filters with an inequality (<, <=, >, or >=) must be on the same field. But you have inequality filters on '" + s.toString() + "' and '" + e.field.toString() + "'");
                var u = t.un();
                null !== u && nu(t, e.field, u);
            } else if (o || i) {
                // You can have at most 1 disjunctive filter and 1 array filter. Check if
                // the new filter conflicts with an existing one.
                var a = null;
                if (o && (a = t._n(r)), null === a && i && (a = t._n(n)), null !== a) 
                // We special case when it's a duplicate op to give a slightly clearer error message.
                throw a === e.op ? new F(q.INVALID_ARGUMENT, "Invalid query. You cannot use more than one '" + e.op.toString() + "' filter.") : new F(q.INVALID_ARGUMENT, "Invalid query. You cannot use '" + e.op.toString() + "' filters with '" + a.toString() + "' filters.");
            }
        }
    }(t, l), l;
}

function Js(t, e, n) {
    if (null !== t.startAt) throw new F(q.INVALID_ARGUMENT, "Invalid query. You must not call startAt() or startAfter() before calling orderBy().");
    if (null !== t.endAt) throw new F(q.INVALID_ARGUMENT, "Invalid query. You must not call endAt() or endBefore() before calling orderBy().");
    var r = new jn(e, n);
    return function(t, e) {
        if (null === t.un()) {
            // This is the first order by. It must match any inequality.
            var n = t.cn();
            null !== n && nu(t, n, e.field);
        }
    }(t, r), r
    /**
 * Create a Bound from a query and a document.
 *
 * Note that the Bound will always include the key of the document
 * and so only the provided document will compare equal to the returned
 * position.
 *
 * Will throw if the document does not contain all fields of the order by
 * of the query or if any of the fields in the order by are an uncommitted
 * server timestamp.
 */
    /**
 * Parses the given documentIdValue into a ReferenceValue, throwing
 * appropriate errors if the value is anything other than a DocumentReference
 * or String, or if the string is malformed.
 */;
}

function tu(t, e, n) {
    if ("string" == typeof n) {
        if ("" === n) throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid document ID, but it was an empty string.");
        if (!bn(e) && -1 !== n.indexOf("/")) throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying a collection by FieldPath.documentId(), you must provide a plain document ID, but '" + n + "' contains a '/' character.");
        var r = e.path.child(z.N(n));
        if (!Q.W(r)) throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying a collection group by FieldPath.documentId(), the value provided must result in a valid document path, but '" + r + "' is not because it has an odd number of segments (" + r.length + ").");
        return $t(t, new Q(r));
    }
    if (n instanceof vo) return $t(t, n.ua);
    throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying with FieldPath.documentId(), you must provide a valid string or a DocumentReference, but it was: " + zi(n) + ".");
}

/**
 * Validates that the value passed into a disjunctrive filter satisfies all
 * array requirements.
 */ function eu(t, e) {
    if (!Array.isArray(t) || 0 === t.length) throw new F(q.INVALID_ARGUMENT, "Invalid Query. A non-empty array is required for '" + e.toString() + "' filters.");
    if (t.length > 10) throw new F(q.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters support a maximum of 10 elements in the value array.");
    if (t.indexOf(null) >= 0) throw new F(q.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'null' in the value array.");
    if (t.filter((function(t) {
        return Number.isNaN(t);
    })).length > 0) throw new F(q.INVALID_ARGUMENT, "Invalid Query. '" + e.toString() + "' filters cannot contain 'NaN' in the value array.");
}

function nu(t, e, n) {
    if (!n.isEqual(e)) throw new F(q.INVALID_ARGUMENT, "Invalid query. You have a where filter with an inequality (<, <=, >, or >=) on field '" + e.toString() + "' and so you must also use '" + e.toString() + "' as your first orderBy(), but your first orderBy() is on field '" + n.toString() + "' instead.");
}

function ru(t) {
    if (t.an() && 0 === t.tn.length) throw new F(q.UNIMPLEMENTED, "limitToLast() queries require specifying at least one orderBy() clause");
}

var iu = /** @class */ function() {
    function t(t, e, n) {
        this.bd = t, this.firestore = e, this.ca = n;
    }
    return t.prototype.where = function(e, n, r) {
        Oi("Query.where", arguments, 3), Wi("Query.where", 3, r);
        // Enumerated from the WhereFilterOp type in index.d.ts.
        var i = ji("Query.where", [ "<" /* LESS_THAN */ , "<=" /* LESS_THAN_OR_EQUAL */ , "==" /* EQUAL */ , ">=" /* GREATER_THAN_OR_EQUAL */ , ">" /* GREATER_THAN */ , "array-contains" /* ARRAY_CONTAINS */ , "in" /* IN */ , "array-contains-any" /* ARRAY_CONTAINS_ANY */ ], 2, n), o = ko("Query.where", e), s = Zs(this.bd, "Query.where", this.firestore.ud, this.firestore.aa, o, i, r);
        return new t(function(t, e) {
            var n = t.filters.concat([ e ]);
            return new mn(t.path, t.collectionGroup, t.tn.slice(), n, t.limit, t.en, t.startAt, t.endAt);
        }(this.bd, s), this.firestore, this.ca);
    }, t.prototype.orderBy = function(e, n) {
        var r;
        if (Vi("Query.orderBy", arguments, 1, 2), Ci("Query.orderBy", "non-empty string", 2, n), 
        void 0 === n || "asc" === n) r = "asc" /* ASCENDING */; else {
            if ("desc" !== n) throw new F(q.INVALID_ARGUMENT, "Function Query.orderBy() has unknown direction '" + n + "', expected 'asc' or 'desc'.");
            r = "desc" /* DESCENDING */;
        }
        var i = ko("Query.orderBy", e), o = Js(this.bd, i, r);
        return new t(function(t, e) {
            // TODO(dimond): validate that orderBy does not list the same key twice.
            var n = t.tn.concat([ e ]);
            return new mn(t.path, t.collectionGroup, n, t.filters.slice(), t.limit, t.en, t.startAt, t.endAt);
        }(this.bd, o), this.firestore, this.ca);
    }, t.prototype.limit = function(e) {
        return Oi("Query.limit", arguments, 1), Ui("Query.limit", "number", 1, e), $i("Query.limit", 1, e), 
        new t(Tn(this.bd, e, "F" /* First */), this.firestore, this.ca);
    }, t.prototype.limitToLast = function(e) {
        return Oi("Query.limitToLast", arguments, 1), Ui("Query.limitToLast", "number", 1, e), 
        $i("Query.limitToLast", 1, e), new t(Tn(this.bd, e, "L" /* Last */), this.firestore, this.ca);
    }, t.prototype.startAt = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        Ri("Query.startAt", arguments, 1);
        var i = this.vd("Query.startAt", e, n, 
        /*before=*/ !0);
        return new t(Nn(this.bd, i), this.firestore, this.ca);
    }, t.prototype.startAfter = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        Ri("Query.startAfter", arguments, 1);
        var i = this.vd("Query.startAfter", e, n, 
        /*before=*/ !1);
        return new t(Nn(this.bd, i), this.firestore, this.ca);
    }, t.prototype.endBefore = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        Ri("Query.endBefore", arguments, 1);
        var i = this.vd("Query.endBefore", e, n, 
        /*before=*/ !0);
        return new t(An(this.bd, i), this.firestore, this.ca);
    }, t.prototype.endAt = function(e) {
        for (var n = [], r = 1; r < arguments.length; r++) n[r - 1] = arguments[r];
        Ri("Query.endAt", arguments, 1);
        var i = this.vd("Query.endAt", e, n, 
        /*before=*/ !1);
        return new t(An(this.bd, i), this.firestore, this.ca);
    }, t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw Qi("isEqual", "Query", 1, e);
        return this.firestore === e.firestore && _n(this.bd, e.bd) && this.ca === e.ca;
    }, t.prototype.withConverter = function(e) {
        return new t(this.bd, this.firestore, e);
    }, 
    /** Helper function to create a bound from a document or fields */ t.prototype.vd = function(t, e, n, i) {
        if (Wi(t, 1, e), e instanceof Xs) return Oi(t, r([ e ], n), 1), function(t, e, n, r, i) {
            if (!r) throw new F(q.NOT_FOUND, "Can't use a DocumentSnapshot that doesn't exist for " + n + "().");
            // Because people expect to continue/end a query at the exact document
            // provided, we need to use the implicit sort order rather than the explicit
            // sort order, because it's guaranteed to contain the document key. That way
            // the position becomes unambiguous and the query continues/ends exactly at
            // the provided document. Without the key (by using the explicit sort
            // orders), multiple documents could match the position, yielding duplicate
            // results.
            for (var o = [], s = 0, u = In(t); s < u.length; s++) {
                var a = u[s];
                if (a.field.O()) o.push($t(e, r.key)); else {
                    var c = r.field(a.field);
                    if (Ut(c)) throw new F(q.INVALID_ARGUMENT, 'Invalid query. You are trying to start or end a query using a document for which the field "' + a.field + '" is an uncommitted server timestamp. (Since the value of this field is unknown, you cannot start/end a query with it.)');
                    if (null === c) {
                        var h = a.field.$();
                        throw new F(q.INVALID_ARGUMENT, "Invalid query. You are trying to start or end a query using a document for which the field '" + h + "' (used as the orderBy) does not exist.");
                    }
                    o.push(c);
                }
            }
            return new Cn(o, i);
        }(this.bd, this.firestore.aa, t, e.Vd, i);
        var o = [ e ].concat(n);
        return function(t, e, n, r, i, o) {
            // Use explicit order by's because it has to match the query the user made
            var s = t.tn;
            if (i.length > s.length) throw new F(q.INVALID_ARGUMENT, "Too many arguments provided to " + r + "(). The number of arguments must be less than or equal to the number of orderBy() clauses");
            for (var u = [], a = 0; a < i.length; a++) {
                var c = i[a];
                if (s[a].field.O()) {
                    if ("string" != typeof c) throw new F(q.INVALID_ARGUMENT, "Invalid query. Expected a string for document ID in " + r + "(), but got a " + typeof c);
                    if (!bn(t) && -1 !== c.indexOf("/")) throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying a collection and ordering by FieldPath.documentId(), the value passed to " + r + "() must be a plain document ID, but '" + c + "' contains a slash.");
                    var h = t.path.child(z.N(c));
                    if (!Q.W(h)) throw new F(q.INVALID_ARGUMENT, "Invalid query. When querying a collection group and ordering by FieldPath.documentId(), the value passed to " + r + "() must result in a valid document path, but '" + h + "' is not because it contains an odd number of segments.");
                    var f = new Q(h);
                    u.push($t(e, f));
                } else {
                    var l = Ao(n, r, c);
                    u.push(l);
                }
            }
            return new Cn(u, o);
        }(this.bd, this.firestore.aa, this.firestore.ud, t, o, i);
    }, t.prototype.onSnapshot = function() {
        for (var t, e, n, r = this, i = [], o = 0; o < arguments.length; o++) i[o] = arguments[o];
        Vi("Query.onSnapshot", arguments, 1, 4);
        var s = {}, u = 0;
        if ("object" != typeof i[u] || qs(i[u]) || (Ki("Query.onSnapshot", s = i[u], [ "includeMetadataChanges" ]), 
        qi("Query.onSnapshot", "boolean", "includeMetadataChanges", s.includeMetadataChanges), 
        u++), qs(i[u])) {
            var a = i[u];
            i[u] = null === (t = a.next) || void 0 === t ? void 0 : t.bind(a), i[u + 1] = null === (e = a.error) || void 0 === e ? void 0 : e.bind(a), 
            i[u + 2] = null === (n = a.complete) || void 0 === n ? void 0 : n.bind(a);
        } else Ui("Query.onSnapshot", "function", u, i[u]), Ci("Query.onSnapshot", "function", u + 1, i[u + 1]), 
        Ci("Query.onSnapshot", "function", u + 2, i[u + 2]);
        var c = {
            next: function(t) {
                i[u] && i[u](new su(r.firestore, r.bd, t, r.ca));
            },
            error: i[u + 1],
            complete: i[u + 2]
        };
        return ru(this.bd), ou(this.firestore.ed(), this.bd, s, c);
    }, t.prototype.get = function(t) {
        var e = this;
        Vi("Query.get", arguments, 0, 1), hu("Query.get", t), ru(this.bd);
        var n = this.firestore.ed();
        return (t && "cache" === t.source ? n.Bf(this.bd) : 
        /**
     * Retrieves a latency-compensated query snapshot from the backend via a
     * SnapshotListener.
     */
        function(t, e, n) {
            var r = new Jn, i = ou(t, e, {
                includeMetadataChanges: !0,
                S_: !0
            }, {
                next: function(t) {
                    // Remove query first before passing event to user to avoid
                    // user actions affecting the now stale query.
                    i(), t.fromCache && n && "server" === n.source ? r.reject(new F(q.UNAVAILABLE, 'Failed to get documents from server. (However, these documents may exist in the local cache. Run again without setting source to "server" to retrieve the cached documents.)')) : r.resolve(t);
                },
                error: function(t) {
                    return r.reject(t);
                }
            });
            return r.promise;
        }(n, this.bd, t)).then((function(t) {
            return new su(e.firestore, e.bd, t, e.ca);
        }));
    }, t;
}();

function ou(t, e, n, r) {
    var i = function(t) {
        console.error("Uncaught Error in onSnapshot:", t);
    };
    r.error && (i = r.error.bind(r));
    var o = new Ms({
        next: function(t) {
            r.next && r.next(t);
        },
        error: i
    }), s = t.listen(e, o, n);
    return function() {
        o.Wf(), t.ic(s);
    };
}

var su = /** @class */ function() {
    function t(t, e, n, r) {
        this.Id = t, this.Sd = e, this.Dd = n, this.ca = r, this.Cd = null, this.Fd = null, 
        this.metadata = new Hs(n.hasPendingWrites, n.fromCache);
    }
    return Object.defineProperty(t.prototype, "docs", {
        get: function() {
            var t = [];
            return this.forEach((function(e) {
                return t.push(e);
            })), t;
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "empty", {
        get: function() {
            return this.Dd.docs._();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(t.prototype, "size", {
        get: function() {
            return this.Dd.docs.size;
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.forEach = function(t, e) {
        var n = this;
        Vi("QuerySnapshot.forEach", arguments, 1, 2), Ui("QuerySnapshot.forEach", "function", 1, t), 
        this.Dd.docs.forEach((function(r) {
            t.call(e, n.$d(r, n.metadata.fromCache, n.Dd.Lt.has(r.key)));
        }));
    }, Object.defineProperty(t.prototype, "query", {
        get: function() {
            return new iu(this.Sd, this.Id, this.ca);
        },
        enumerable: !1,
        configurable: !0
    }), t.prototype.docChanges = function(t) {
        t && (Ki("QuerySnapshot.docChanges", t, [ "includeMetadataChanges" ]), qi("QuerySnapshot.docChanges", "boolean", "includeMetadataChanges", t.includeMetadataChanges));
        var e = !(!t || !t.includeMetadataChanges);
        if (e && this.Dd.Bt) throw new F(q.INVALID_ARGUMENT, "To include metadata changes with your document changes, you must also pass { includeMetadataChanges:true } to onSnapshot().");
        return this.Cd && this.Fd === e || (this.Cd = 
        /**
     * Calculates the array of firestore.DocumentChange's for a given ViewSnapshot.
     *
     * Exported for testing.
     *
     * @param snapshot The ViewSnapshot that represents the expected state.
     * @param includeMetadataChanges Whether to include metadata changes.
     * @param converter A factory function that returns a QueryDocumentSnapshot.
     * @return An objecyt that matches the firestore.DocumentChange API.
     */
        function(t, e, n) {
            if (t.Ot._()) {
                // Special case the first snapshot because index calculation is easy and
                // fast
                var r = 0;
                return t.docChanges.map((function(e) {
                    var i = n(e.doc, t.fromCache, t.Lt.has(e.doc.key));
                    return e.doc, {
                        type: "added",
                        doc: i,
                        oldIndex: -1,
                        newIndex: r++
                    };
                }));
            }
            // A DocumentSet that is updated incrementally as changes are applied to use
            // to lookup the index of a document.
            var i = t.Ot;
            return t.docChanges.filter((function(t) {
                return e || 3 /* Metadata */ !== t.type;
            })).map((function(e) {
                var r = n(e.doc, t.fromCache, t.Lt.has(e.doc.key)), o = -1, s = -1;
                return 0 /* Added */ !== e.type && (o = i.indexOf(e.doc.key), i = i.delete(e.doc.key)), 
                1 /* Removed */ !== e.type && (s = (i = i.add(e.doc)).indexOf(e.doc.key)), {
                    type: lu(e.type),
                    doc: r,
                    oldIndex: o,
                    newIndex: s
                };
            }));
        }(this.Dd, e, this.$d.bind(this)), this.Fd = e), this.Cd;
    }, 
    /** Check the equality. The call can be very expensive. */ t.prototype.isEqual = function(e) {
        if (!(e instanceof t)) throw Qi("isEqual", "QuerySnapshot", 1, e);
        return this.Id === e.Id && _n(this.Sd, e.Sd) && this.Dd.isEqual(e.Dd) && this.ca === e.ca;
    }, t.prototype.$d = function(t, e, n) {
        return new Ys(this.Id, t.key, t, e, n, this.ca);
    }, t;
}(), uu = /** @class */ function(e) {
    function n(t, n, r) {
        var i = this;
        if ((i = e.call(this, wn(t), n, r) || this).Nd = t, t.length % 2 != 1) throw new F(q.INVALID_ARGUMENT, "Invalid collection reference. Collection references must have an odd number of segments, but " + t.$() + " has " + t.length);
        return i;
    }
    return t(n, e), Object.defineProperty(n.prototype, "id", {
        get: function() {
            return this.bd.path.S();
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "parent", {
        get: function() {
            var t = this.bd.path.p();
            return t._() ? null : new Qs(new Q(t), this.firestore, 
            /* converter= */ null);
        },
        enumerable: !1,
        configurable: !0
    }), Object.defineProperty(n.prototype, "path", {
        get: function() {
            return this.bd.path.$();
        },
        enumerable: !1,
        configurable: !0
    }), n.prototype.doc = function(t) {
        Vi("CollectionReference.doc", arguments, 0, 1), 
        // We allow omission of 'pathString' but explicitly prohibit passing in both
        // 'undefined' and 'null'.
        0 === arguments.length && (t = x.t()), Ui("CollectionReference.doc", "non-empty string", 1, t);
        var e = z.N(t);
        return Qs.Td(this.bd.path.child(e), this.firestore, this.ca);
    }, n.prototype.add = function(t) {
        Oi("CollectionReference.add", arguments, 1), Ui("CollectionReference.add", "object", 1, this.ca ? this.ca.toFirestore(t) : t);
        var e = this.doc();
        return e.set(t).then((function() {
            return e;
        }));
    }, n.prototype.withConverter = function(t) {
        return new n(this.Nd, this.firestore, t);
    }, n;
}(iu);

function au(t, e) {
    if (void 0 === e) return {
        merge: !1
    };
    if (Ki(t, e, [ "merge", "mergeFields" ]), qi(t, "boolean", "merge", e.merge), function(t, e, n, r, i) {
        void 0 !== r && function(t, e, n, r, i) {
            if (!(r instanceof Array)) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires its " + e + " option to be an array, but it was: " + zi(r));
            for (var o = 0; o < r.length; ++o) if (!i(r[o])) throw new F(q.INVALID_ARGUMENT, "Function " + t + "() requires all " + e + " elements to be " + n + ", but the value at index " + o + " was: " + zi(r[o]));
        }(t, e, n, r, i);
    }(t, "mergeFields", "a string or a FieldPath", e.mergeFields, (function(t) {
        return "string" == typeof t || t instanceof eo;
    })), void 0 !== e.mergeFields && void 0 !== e.merge) throw new F(q.INVALID_ARGUMENT, "Invalid options passed to function " + t + '(): You cannot specify both "merge" and "mergeFields".');
    return e;
}

function cu(t, e) {
    return void 0 === e ? {} : (Ki(t, e, [ "serverTimestamps" ]), Fi(t, 0, "serverTimestamps", e.serverTimestamps, [ "estimate", "previous", "none" ]), 
    e);
}

function hu(t, e) {
    Ci(t, "object", 1, e), e && (Ki(t, e, [ "source" ]), Fi(t, 0, "source", e.source, [ "default", "server", "cache" ]));
}

function fu(t, e, n) {
    if (e instanceof vo) {
        if (e.firestore !== n) throw new F(q.INVALID_ARGUMENT, "Provided document reference is from a different Firestore instance.");
        return e;
    }
    throw Qi(t, "DocumentReference", 1, e);
}

function lu(t) {
    switch (t) {
      case 0 /* Added */ :
        return "added";

      case 2 /* Modified */ :
      case 3 /* Metadata */ :
        return "modified";

      case 1 /* Removed */ :
        return "removed";

      default:
        return A();
    }
}

/**
 * Converts custom model object of type T into DocumentData by applying the
 * converter if it exists.
 *
 * This function is used when converting user objects to DocumentData
 * because we want to provide the user with a more specific error message if
 * their set() or fails due to invalid data originating from a toFirestore()
 * call.
 */ function pu(t, e, n) {
    // Cast to `any` in order to satisfy the union type constraint on
    // toFirestore().
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return t ? n && (n.merge || n.mergeFields) ? t.toFirestore(e, n) : t.toFirestore(e) : e;
}

var du = {
    Firestore: Bs,
    GeoPoint: lo,
    Timestamp: j,
    Blob: Ji,
    Transaction: Ws,
    WriteBatch: Ks,
    DocumentReference: Qs,
    DocumentSnapshot: Xs,
    Query: iu,
    QueryDocumentSnapshot: Ys,
    QuerySnapshot: su,
    CollectionReference: uu,
    FieldPath: eo,
    FieldValue: ho,
    setLogLevel: Bs.setLogLevel,
    CACHE_SIZE_UNLIMITED: js
};

/**
 * Configures Firestore as part of the Firebase SDK by calling registerService.
 *
 * @param firebase The FirebaseNamespace to register Firestore with
 * @param firestoreFactory A factory function that returns a new Firestore
 *    instance.
 */
/**
 * @license
 * Copyright 2017 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Registers the main Firestore build with the components framework.
 * Persistence can be enabled via `firebase.firestore().enablePersistence()`.
 */ function yu(t) {
    !function(t, e) {
        t.INTERNAL.registerComponent(new w("firestore", (function(t) {
            return function(t, e) {
                return new Bs(t, e, new Us);
            }(t.getProvider("app").getImmediate(), t.getProvider("auth-internal"));
        }), "PUBLIC" /* PUBLIC */).setServiceProps(Object.assign({}, du)));
    }(t), t.registerVersion("@firebase/firestore", "1.16.2");
}

yu(i);

export { yu as __PRIVATE_registerFirestore };
//# sourceMappingURL=index.esm.js.map
