import { Event, Integration, StackFrame } from '@sentry/types';
/** Internal */
interface SentryGlobal {
    Sentry?: {
        Integrations?: Integration[];
    };
    SENTRY_ENVIRONMENT?: string;
    SENTRY_DSN?: string;
    SENTRY_RELEASE?: {
        id?: string;
    };
    __SENTRY__: {
        globalEventProcessors: any;
        hub: any;
        logger: any;
    };
}
/**
 * Requires a module which is protected against bundler minification.
 *
 * @param request The module path to resolve
 */
export declare function dynamicRequire(mod: any, request: string): any;
/**
 * Checks whether we're in the Node.js or Browser environment
 *
 * @returns Answer to given question
 */
export declare function isNodeEnv(): boolean;
/**
 * Safely get global scope object
 *
 * @returns Global scope object
 */
export declare function getGlobalObject<T>(): T & SentryGlobal;
/**
 * UUID4 generator
 *
 * @returns string Generated UUID4.
 */
export declare function uuid4(): string;
/**
 * Parses string form of URL into an object
 * // borrowed from https://tools.ietf.org/html/rfc3986#appendix-B
 * // intentionally using regex and not <a/> href parsing trick because React Native and other
 * // environments where DOM might not be available
 * @returns parsed URL object
 */
export declare function parseUrl(url: string): {
    host?: string;
    path?: string;
    protocol?: string;
    relative?: string;
};
/**
 * Extracts either message or type+value from an event that can be used for user-facing logs
 * @returns event's description
 */
export declare function getEventDescription(event: Event): string;
/** JSDoc */
export declare function consoleSandbox(callback: () => any): any;
/**
 * Adds exception values, type and value to an synthetic Exception.
 * @param event The event to modify.
 * @param value Value of the exception.
 * @param type Type of the exception.
 * @hidden
 */
export declare function addExceptionTypeValue(event: Event, value?: string, type?: string): void;
/**
 * Adds exception mechanism to a given event.
 * @param event The event to modify.
 * @param mechanism Mechanism of the mechanism.
 * @hidden
 */
export declare function addExceptionMechanism(event: Event, mechanism?: {
    [key: string]: any;
}): void;
/**
 * A safe form of location.href
 */
export declare function getLocationHref(): string;
/**
 * Given a child DOM element, returns a query-selector statement describing that
 * and its ancestors
 * e.g. [HTMLElement] => body > div > input#foo.btn[name=baz]
 * @returns generated DOM path
 */
export declare function htmlTreeAsString(elem: unknown): string;
/**
 * Cross platform compatible partial performance implementation
 */
interface CrossPlatformPerformance {
    /**
     * Returns the current timestamp in ms
     */
    now(): number;
    timeOrigin: number;
}
export declare const crossPlatformPerformance: CrossPlatformPerformance;
/**
 * Returns a timestamp in seconds with milliseconds precision since the UNIX epoch calculated with the monotonic clock.
 */
export declare function timestampWithMs(): number;
/**
 * Represents Semantic Versioning object
 */
interface SemVer {
    major?: number;
    minor?: number;
    patch?: number;
    prerelease?: string;
    buildmetadata?: string;
}
/**
 * Parses input into a SemVer interface
 * @param input string representation of a semver version
 */
export declare function parseSemver(input: string): SemVer;
/**
 * Extracts Retry-After value from the request header or returns default value
 * @param now current unix timestamp
 * @param header string representation of 'Retry-After' header
 */
export declare function parseRetryAfterHeader(now: number, header?: string | number | null): number;
/**
 * Safely extract function name from itself
 */
export declare function getFunctionName(fn: unknown): string;
/**
 * This function adds context (pre/post/line) lines to the provided frame
 *
 * @param lines string[] containing all lines
 * @param frame StackFrame that will be mutated
 * @param linesOfContext number of context lines we want to add pre/post
 */
export declare function addContextToFrame(lines: string[], frame: StackFrame, linesOfContext?: number): void;
export {};
//# sourceMappingURL=misc.d.ts.map