'use strict';

exports.__esModule = true;
exports.default = createAttrExpression;
function createAttrExpression(match, vars, composes, t) {
  var placeholderRegex = /xxx(\d+)xxx/gm;
  var propNameMatch = placeholderRegex.exec(match.propName);
  var propName = t.identifier(match.propName);
  if (propNameMatch) {
    var varsIndex = propNameMatch[1] - composes;
    propName = vars[varsIndex];
  }

  var valueTypeMatch = placeholderRegex.exec(match.valueType);
  var valueType = t.stringLiteral(match.valueType || '');
  if (valueTypeMatch) {
    var _varsIndex = valueTypeMatch[1] - composes;
    valueType = vars[_varsIndex];
  }

  var defaultValueMatch = placeholderRegex.exec(match.defaultValue);
  var defaultValue = t.stringLiteral(match.defaultValue || '');
  if (defaultValueMatch) {
    var _varsIndex2 = defaultValueMatch[1] - composes;
    defaultValue = vars[_varsIndex2];
  }

  var createMemberExpression = function createMemberExpression() {
    return t.memberExpression(t.identifier('props'), propName, !!propNameMatch);
  };

  var returnValue = createMemberExpression();

  if (match.valueType) {
    returnValue = t.binaryExpression('+', createMemberExpression(), valueType);
  }

  if (match.defaultValue) {
    returnValue = t.binaryExpression('+', t.conditionalExpression(createMemberExpression(), createMemberExpression(), defaultValue), valueType);
  }

  var body = t.blockStatement([t.returnStatement(returnValue)]);

  var expr = t.functionExpression(t.identifier('get' + (propNameMatch ? 'Prop' : match.propName.charAt(0).toUpperCase() + match.propName.slice(1))), [t.identifier('props')], body);
  return expr;
}