'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderToSheetList;

var _felaUtils = require('fela-utils');

var sheetMap = {
  fontFaces: _felaUtils.FONT_TYPE,
  statics: _felaUtils.STATIC_TYPE,
  keyframes: _felaUtils.KEYFRAME_TYPE,
  rules: _felaUtils.RULE_TYPE
};
function renderToSheetList(renderer) {
  var sheetList = [];

  for (var style in sheetMap) {
    if (renderer[style].length > 0) {
      sheetList.push({
        css: renderer[style],
        type: sheetMap[style]
      });
    }
  }

  for (var _media in renderer.mediaRules) {
    var mediaCSS = renderer.mediaRules[_media];

    if (mediaCSS.length > 0) {
      sheetList.push({
        css: mediaCSS,
        type: _felaUtils.RULE_TYPE,
        media: _media
      });
    }
  }

  return sheetList;
}