import warning from './warning';
import isBase64 from './isBase64';

var formats = {
  '.woff': 'woff',
  '.eot': 'embedded-opentype',
  '.ttf': 'truetype',
  '.otf': 'opentype',
  '.svg': 'svg',
  '.svgz': 'svg'
};

var base64Formats = {
  'image/svg+xml': 'svg',
  'application/x-font-woff': 'woff',
  'application/font-woff': 'woff',
  'application/x-font-woff2': 'woff2',
  'application/font-woff2': 'woff2',
  'font/woff2': 'woff2',
  'application/octet-stream': 'truetype',
  'application/x-font-ttf': 'truetype',
  'application/x-font-truetype': 'truetype',
  'application/x-font-opentype': 'opentype',
  'application/vnd.ms-fontobject': 'embedded-opentype',
  'application/font-sfnt': 'sfnt'
};

export default function checkFontFormat(src) {
  if (isBase64(src)) {
    var mime = '';
    for (var i = 5;; i++) {
      // 'data:'.length === 5
      var c = src.charAt(i);

      if (c === ';' || c === ',') {
        break;
      }

      mime += c;
    }

    var fmt = base64Formats[mime];
    if (fmt) {
      return fmt;
    }

    process.env.NODE_ENV !== "production" ? warning(true, 'A invalid base64 font was used. Please use one of the following mime type: ' + Object.keys(base64Formats).join(', ') + '.') : void 0;
  } else {
    var extension = '';
    for (var _i = src.length - 1;; _i--) {
      var _c = src.charAt(_i);

      if (_c === '.') {
        extension = _c + extension;
        break;
      }

      extension = _c + extension;
    }

    var _fmt = formats[extension];
    if (_fmt) {
      return _fmt;
    }

    process.env.NODE_ENV !== "production" ? warning(true, 'A invalid font-format was used in "' + src + '". Use one of these: ' + Object.keys(formats).join(', ') + '.') : void 0;
  }
  return '';
}