import objectReduce from './objectReduce';

export default function resolveUsedProps(props, src) {
  return objectReduce(src, function (output, value, key) {
    if (props.indexOf(key) === -1) output.push(key);
    return output;
  }, []).filter(function (prop) {
    return prop !== 'innerRef' && prop !== 'is';
  });
}