'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = generateClassName;
var chars = 'abcdefghijklmnopqrstuvwxyz';
var charLength = chars.length;

function generateClassName(id) {
  var className = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  var filterClassName = arguments[2];

  if (id <= charLength) {
    var generatedClassName = chars[id - 1] + className;
    var hasFilter = typeof filterClassName === 'function';

    if (hasFilter && !filterClassName(generatedClassName)) {
      return generateClassName(id + 1, className, filterClassName);
    }

    return generatedClassName;
  }

  // Bitwise floor as safari performs much faster
  // https://jsperf.com/math-floor-vs-math-round-vs-parseint/55
  return generateClassName(id / charLength | 0, chars[id % charLength] + className, filterClassName);
}