import { SVGAttributes } from 'react'
import { CSSProperties } from './css-properties'
import {
  HtmlStyledFunction,
  SvgStyledFunction,
} from './styled-function'

export interface HTMLGlamorousInterface {
  a: HtmlStyledFunction<HTMLAnchorElement, CSSProperties>
  abbr: HtmlStyledFunction<HTMLElement, CSSProperties>
  address: HtmlStyledFunction<HTMLElement, CSSProperties>
  area: HtmlStyledFunction<HTMLAreaElement, CSSProperties>
  article: HtmlStyledFunction<HTMLElement, CSSProperties>
  aside: HtmlStyledFunction<HTMLElement, CSSProperties>
  audio: HtmlStyledFunction<HTMLAudioElement, CSSProperties>
  b: HtmlStyledFunction<HTMLElement, CSSProperties>
  base: HtmlStyledFunction<HTMLBaseElement, CSSProperties>
  bdi: HtmlStyledFunction<HTMLElement, CSSProperties>
  bdo: HtmlStyledFunction<HTMLElement, CSSProperties>
  big: HtmlStyledFunction<HTMLElement, CSSProperties>
  blockquote: HtmlStyledFunction<HTMLElement, CSSProperties>
  body: HtmlStyledFunction<HTMLBodyElement, CSSProperties>
  br: HtmlStyledFunction<HTMLBRElement, CSSProperties>
  button: HtmlStyledFunction<HTMLButtonElement, CSSProperties>
  canvas: HtmlStyledFunction<HTMLCanvasElement, CSSProperties>
  caption: HtmlStyledFunction<HTMLElement, CSSProperties>
  cite: HtmlStyledFunction<HTMLElement, CSSProperties>
  code: HtmlStyledFunction<HTMLElement, CSSProperties>
  col: HtmlStyledFunction<HTMLTableColElement, CSSProperties>
  colgroup: HtmlStyledFunction<HTMLTableColElement, CSSProperties>
  data: HtmlStyledFunction<HTMLElement, CSSProperties>
  datalist: HtmlStyledFunction<HTMLDataListElement, CSSProperties>
  dd: HtmlStyledFunction<HTMLElement, CSSProperties>
  del: HtmlStyledFunction<HTMLElement, CSSProperties>
  details: HtmlStyledFunction<HTMLElement, CSSProperties>
  dfn: HtmlStyledFunction<HTMLElement, CSSProperties>
  dialog: HtmlStyledFunction<HTMLElement, CSSProperties>
  div: HtmlStyledFunction<HTMLDivElement, CSSProperties>
  dl: HtmlStyledFunction<HTMLDListElement, CSSProperties>
  dt: HtmlStyledFunction<HTMLElement, CSSProperties>
  em: HtmlStyledFunction<HTMLElement, CSSProperties>
  embed: HtmlStyledFunction<HTMLEmbedElement, CSSProperties>
  fieldset: HtmlStyledFunction<HTMLFieldSetElement, CSSProperties>
  figcaption: HtmlStyledFunction<HTMLElement, CSSProperties>
  figure: HtmlStyledFunction<HTMLElement, CSSProperties>
  footer: HtmlStyledFunction<HTMLElement, CSSProperties>
  form: HtmlStyledFunction<HTMLFormElement, CSSProperties>
  h1: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  h2: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  h3: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  h4: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  h5: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  h6: HtmlStyledFunction<HTMLHeadingElement, CSSProperties>
  head: HtmlStyledFunction<HTMLHeadElement, CSSProperties>
  header: HtmlStyledFunction<HTMLElement, CSSProperties>
  hgroup: HtmlStyledFunction<HTMLElement, CSSProperties>
  hr: HtmlStyledFunction<HTMLHRElement, CSSProperties>
  html: HtmlStyledFunction<HTMLHtmlElement, CSSProperties>
  i: HtmlStyledFunction<HTMLElement, CSSProperties>
  iframe: HtmlStyledFunction<HTMLIFrameElement, CSSProperties>
  img: HtmlStyledFunction<HTMLImageElement, CSSProperties>
  input: HtmlStyledFunction<HTMLInputElement, CSSProperties>
  ins: HtmlStyledFunction<HTMLModElement, CSSProperties>
  kbd: HtmlStyledFunction<HTMLElement, CSSProperties>
  keygen: HtmlStyledFunction<HTMLElement, CSSProperties>
  label: HtmlStyledFunction<HTMLLabelElement, CSSProperties>
  legend: HtmlStyledFunction<HTMLLegendElement, CSSProperties>
  li: HtmlStyledFunction<HTMLLIElement, CSSProperties>
  link: HtmlStyledFunction<HTMLLinkElement, CSSProperties>
  main: HtmlStyledFunction<HTMLElement, CSSProperties>
  map: HtmlStyledFunction<HTMLMapElement, CSSProperties>
  mark: HtmlStyledFunction<HTMLElement, CSSProperties>
  menu: HtmlStyledFunction<HTMLElement, CSSProperties>
  menuitem: HtmlStyledFunction<HTMLElement, CSSProperties>
  meta: HtmlStyledFunction<HTMLMetaElement, CSSProperties>
  meter: HtmlStyledFunction<HTMLElement, CSSProperties>
  nav: HtmlStyledFunction<HTMLElement, CSSProperties>
  noscript: HtmlStyledFunction<HTMLElement, CSSProperties>
  object: HtmlStyledFunction<HTMLObjectElement, CSSProperties>
  ol: HtmlStyledFunction<HTMLOListElement, CSSProperties>
  optgroup: HtmlStyledFunction<HTMLOptGroupElement, CSSProperties>
  option: HtmlStyledFunction<HTMLOptionElement, CSSProperties>
  output: HtmlStyledFunction<HTMLElement, CSSProperties>
  p: HtmlStyledFunction<HTMLParagraphElement, CSSProperties>
  param: HtmlStyledFunction<HTMLParamElement, CSSProperties>
  picture: HtmlStyledFunction<HTMLElement, CSSProperties>
  pre: HtmlStyledFunction<HTMLPreElement, CSSProperties>
  progress: HtmlStyledFunction<HTMLProgressElement, CSSProperties>
  q: HtmlStyledFunction<HTMLQuoteElement, CSSProperties>
  rp: HtmlStyledFunction<HTMLElement, CSSProperties>
  rt: HtmlStyledFunction<HTMLElement, CSSProperties>
  ruby: HtmlStyledFunction<HTMLElement, CSSProperties>
  s: HtmlStyledFunction<HTMLElement, CSSProperties>
  samp: HtmlStyledFunction<HTMLElement, CSSProperties>
  script: HtmlStyledFunction<HTMLElement, CSSProperties>
  section: HtmlStyledFunction<HTMLElement, CSSProperties>
  select: HtmlStyledFunction<HTMLSelectElement, CSSProperties>
  small: HtmlStyledFunction<HTMLElement, CSSProperties>
  source: HtmlStyledFunction<HTMLSourceElement, CSSProperties>
  span: HtmlStyledFunction<HTMLSpanElement, CSSProperties>
  strong: HtmlStyledFunction<HTMLElement, CSSProperties>
  style: HtmlStyledFunction<HTMLStyleElement, CSSProperties>
  sub: HtmlStyledFunction<HTMLElement, CSSProperties>
  summary: HtmlStyledFunction<HTMLElement, CSSProperties>
  sup: HtmlStyledFunction<HTMLElement, CSSProperties>
  table: HtmlStyledFunction<HTMLTableElement, CSSProperties>
  tbody: HtmlStyledFunction<HTMLTableSectionElement, CSSProperties>
  td: HtmlStyledFunction<HTMLTableDataCellElement, CSSProperties>
  textarea: HtmlStyledFunction<HTMLTextAreaElement, CSSProperties>
  tfoot: HtmlStyledFunction<HTMLTableSectionElement, CSSProperties>
  th: HtmlStyledFunction<HTMLTableHeaderCellElement, CSSProperties>
  thead: HtmlStyledFunction<HTMLTableSectionElement, CSSProperties>
  time: HtmlStyledFunction<HTMLElement, CSSProperties>
  title: HtmlStyledFunction<HTMLTitleElement, CSSProperties>
  tr: HtmlStyledFunction<HTMLTableRowElement, CSSProperties>
  track: HtmlStyledFunction<HTMLTrackElement, CSSProperties>
  u: HtmlStyledFunction<HTMLElement, CSSProperties>
  ul: HtmlStyledFunction<HTMLUListElement, CSSProperties>
  "var": HtmlStyledFunction<HTMLElement, CSSProperties>
  video: HtmlStyledFunction<HTMLVideoElement, CSSProperties>
  wbr: HtmlStyledFunction<HTMLElement, CSSProperties>
}


export interface SVGGlamorousInterface {
  circle: SvgStyledFunction<SVGCircleElement, SVGAttributes<any>>
  clipPath: SvgStyledFunction<SVGClipPathElement, SVGAttributes<any>>
  defs: SvgStyledFunction<SVGDefsElement, SVGAttributes<any>>
  ellipse: SvgStyledFunction<SVGEllipseElement, SVGAttributes<any>>
  g: SvgStyledFunction<SVGGElement, SVGAttributes<any>>
  image: SvgStyledFunction<SVGImageElement, SVGAttributes<any>>
  line: SvgStyledFunction<SVGLineElement, SVGAttributes<any>>
  linearGradient: SvgStyledFunction<SVGLinearGradientElement, SVGAttributes<any>>
  mask: SvgStyledFunction<SVGMaskElement, SVGAttributes<any>>
  path: SvgStyledFunction<SVGPathElement, SVGAttributes<any>>
  pattern: SvgStyledFunction<SVGPatternElement, SVGAttributes<any>>
  polygon: SvgStyledFunction<SVGPolygonElement, SVGAttributes<any>>
  polyline: SvgStyledFunction<SVGPolylineElement, SVGAttributes<any>>
  radialGradient: SvgStyledFunction<SVGRadialGradientElement, SVGAttributes<any>>
  rect: SvgStyledFunction<SVGRectElement, SVGAttributes<any>>
  stop: SvgStyledFunction<SVGStopElement, SVGAttributes<any>>
  svg: SvgStyledFunction<SVGSVGElement, SVGAttributes<any>>
  text: SvgStyledFunction<SVGTextElement, SVGAttributes<any>>
  tspan: SvgStyledFunction<SVGTSpanElement, SVGAttributes<any>>
}
